/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.rack.frame;

import de.hannse.netobjects.util.Babel;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import mausoleum.cage.colors.CageColorManager;
import mausoleum.gui.WindowMinimalSizer;
import mausoleum.helper.MausoleumImageStore;
import mausoleum.helper.WindowUtils;
import mausoleum.inspector.Inspector;
import mausoleum.main.MausoleumClient;
import mausoleum.rack.frame.RackOverviewList;
import mausoleum.ui.UIDef;

public class RackOverview
extends JFrame {
    private static final long serialVersionUID = -1656589514222400206L;
    private static final int MIN_WIDTH = UIDef.getScaled(80);
    private static final int MIN_HEIGHT = UIDef.getScaled(200);
    private static final int DEFAULT_WIDTH = UIDef.getScaled(160);
    private static final int DEFAULT_HEIGHT = UIDef.getScaled(500);
    private static RackOverview cvInstance = null;
    private final RackOverviewList ivList = new RackOverviewList();
    private boolean ivReactToChange = true;
    private ItemListener ivItemListener = new ItemListener(){

        public void itemStateChanged(ItemEvent e) {
            if (RackOverview.this.ivReactToChange && e.getStateChange() == 1) {
                RackOverview.this.ivReactToChange = false;
                CageColorManager.modeSelected(false);
                RackOverview.this.ivReactToChange = true;
            }
        }
    };

    public static void showIt() {
        if (cvInstance == null) {
            cvInstance = new RackOverview();
            Inspector insp = Inspector.getInspector();
            if (insp != null) {
                Rectangle rect = insp.getBounds();
                cvInstance.setBounds(rect.x - DEFAULT_WIDTH, rect.y, DEFAULT_WIDTH, rect.height);
            } else {
                cvInstance.setBounds(0, 0, DEFAULT_WIDTH, DEFAULT_HEIGHT);
            }
        }
        WindowUtils.bringUpFrame(cvInstance);
    }

    public static void hideIt() {
        if (cvInstance != null) {
            cvInstance.setVisible(false);
        }
    }

    public static void destroyIt() {
        if (cvInstance != null) {
            cvInstance.setVisible(false);
            RackOverview.cvInstance.ivList.dispose();
            cvInstance.getContentPane().removeAll();
            CageColorManager.cvColormodeComboOverview.removeItemListener(RackOverview.cvInstance.ivItemListener);
            cvInstance.dispose();
            cvInstance = null;
        }
    }

    public static void cageColorModeChanged() {
        if ((MausoleumClient.isRegularOrTGService() || MausoleumClient.isServiceCaretaker()) && cvInstance != null) {
            if (cvInstance.isShowing()) {
                RackOverview.cvInstance.ivList.cageColorModeChanged();
            }
            RackOverview.cvInstance.ivReactToChange = false;
            CageColorManager.cvColormodeComboOverview.setSelectedIndex(CageColorManager.getIndexOfMainMode());
            RackOverview.cvInstance.ivReactToChange = true;
        }
    }

    private RackOverview() {
        super(Babel.get("RACK_OVERVIEW"));
        this.setIconImage(MausoleumImageStore.getLogo());
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add("Center", new JScrollPane(this.ivList));
        CageColorManager.cvColormodeComboOverview.setPreferredSize(new Dimension(24, 24));
        CageColorManager.cvColormodeComboOverview.setSelectedIndex(CageColorManager.getIndexOfMainMode());
        CageColorManager.cvColormodeComboOverview.addItemListener(this.ivItemListener);
        this.getContentPane().add("North", CageColorManager.cvColormodeComboOverview);
        new WindowMinimalSizer(this, MIN_WIDTH, MIN_HEIGHT, true);
    }
}

