/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.rack.frame;

import de.hannse.netobjects.objectstore.IDObject;
import de.hannse.netobjects.objectstore.ObjectConsumer;
import de.hannse.netobjects.objectstore.ObjectStoreClient;
import java.awt.Component;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import javax.sound.sampled.Line;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import mausoleum.cage.Cage;
import mausoleum.inspector.actions.room.RoomAction;
import mausoleum.mouse.Mouse;
import mausoleum.rack.Rack;
import mausoleum.rack.frame.RackComboBox;
import mausoleum.rack.frame.RackFrame;
import mausoleum.room.Room;
import mausoleum.room.RoomStatusListener;

public class RackOverviewList
extends JList
implements ObjectConsumer,
RoomStatusListener {
    private static final long serialVersionUID = -7733588215189793795L;
    private static final int[] CONSUMERTYPES = new int[]{3, 10, 1, 2, 7};
    private final Vector ivRacks = new Vector();
    private final Vector ivRacksInRoom = new Vector();
    private final Vector ivRacksOutside = new Vector();
    private long ivLastMMRackID = -1L;

    public RackOverviewList() {
        this.adjust();
        this.redrawRacks();
        super.setModel(new ListModel(){

            public void addListDataListener(ListDataListener l) {
            }

            public Object getElementAt(int index) {
                if (index < RackOverviewList.this.ivRacks.size()) {
                    return RackOverviewList.this.ivRacks.elementAt(index);
                }
                return null;
            }

            public int getSize() {
                return RackOverviewList.this.ivRacks.size();
            }

            public void removeListDataListener(ListDataListener l) {
            }
        });
        super.setCellRenderer(new ListCellRenderer(){

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Rack r = (Rack)value;
                JLabel label = r.getThumbLabel();
                label.setBackground(null);
                return label;
            }
        });
        super.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                RackFrame.showRack((Rack)RackOverviewList.this.getSelectedValue());
            }
        });
        super.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent e) {
                RackOverviewList.this.adjust();
                RackOverviewList.this.redrawRacks();
            }
        });
        super.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseMoved(MouseEvent arg0) {
                int index = RackOverviewList.this.locationToIndex(arg0.getPoint());
                if (index != -1 && index < RackOverviewList.this.ivRacks.size()) {
                    Rack rack = (Rack)RackOverviewList.this.ivRacks.elementAt(index);
                    if (rack.getID() != RackOverviewList.this.ivLastMMRackID) {
                        RackOverviewList.this.ivLastMMRackID = rack.getID();
                        RackOverviewList.this.setToolTipText(rack.getTaskTooltip());
                    }
                } else {
                    RackOverviewList.this.ivLastMMRackID = -1L;
                    RackOverviewList.this.setToolTipText(null);
                }
            }
        });
        ObjectStoreClient.addConsumer((ObjectConsumer)this, CONSUMERTYPES);
        RoomAction.addListener(this);
    }

    public void cageColorModeChanged() {
        this.redrawRacks();
        this.repaint();
    }

    public void dispose() {
        this.setListData(new Vector());
        this.ivRacks.clear();
        this.ivRacksInRoom.clear();
        this.ivRacksOutside.clear();
    }

    private void redrawRacks() {
        int i = 0;
        while (i < this.ivRacks.size()) {
            Rack rack = (Rack)this.ivRacks.elementAt(i);
            rack.ensurePresenceOfThumb();
            rack.prepareImage();
            ++i;
        }
    }

    private void adjust() {
        this.ivRacks.clear();
        RackComboBox.getDisplayableRacks(this.ivRacksInRoom, this.ivRacksOutside);
        this.ivRacks.addAll(this.ivRacksInRoom);
        this.ivRacks.addAll(this.ivRacksOutside);
        Collections.sort(this.ivRacks, RackComboBox.RACK_EMPTY_COMPARER);
    }

    public void roomStatusChanged() {
        this.adjust();
        this.repaint();
    }

    public void objectLeftServiceRoom(int objectTyp, String group, HashSet objectIDs) {
    }

    public void handleNewObjects(Vector idObjects) {
        Iterator iterator = idObjects.iterator();
        while (iterator.hasNext()) {
            this.handleNewObject((IDObject)iterator.next());
        }
    }

    public void handleNewObject(IDObject obj) {
        if (this.isShowing()) {
            if (obj instanceof Room) {
                this.adjust();
                this.repaint();
            } else if (obj instanceof Rack) {
                Rack rack = (Rack)obj;
                rack.prepareImage();
                this.repaint();
            } else if (obj instanceof Cage) {
                Cage cage = (Cage)obj;
                Rack rack = cage.getRack();
                if (rack != null && this.ivRacks.contains(rack)) {
                    rack.prepareImage();
                    this.repaint();
                }
            } else if (obj instanceof Mouse) {
                Mouse mouse = (Mouse)obj;
                Rack rack = mouse.getRack();
                if (rack != null && this.ivRacks.contains(rack)) {
                    rack.prepareImage();
                    this.repaint();
                }
            } else if (obj instanceof Line) {
                this.redrawRacks();
                this.repaint();
            }
        }
    }
}

