/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.rack.frame;

import de.hannse.netobjects.util.Babel;
import java.awt.Color;
import java.util.Iterator;
import java.util.TreeSet;
import mausoleum.main.MausoleumClient;
import mausoleum.mouse.TaskExtended;
import mausoleum.task.standards.StandardTask;

public class TriangleRestrictor
implements Comparable {
    public int ivProcType;
    public String ivGroup;
    public String ivDescription;
    public String ivDisplay;
    public Color ivCol;
    public boolean ivDescMissing;

    public static boolean isPresent(TaskExtended task, TreeSet restrictors) {
        Iterator iterator = restrictors.iterator();
        while (iterator.hasNext()) {
            TriangleRestrictor restr = (TriangleRestrictor)iterator.next();
            if (!restr.match(task)) continue;
            return true;
        }
        return false;
    }

    public TriangleRestrictor(TaskExtended task) {
        this.ivDisplay = this.ivDescription = task.getDescription(task.ivGroup, true, task.ivExtraObject);
        this.ivProcType = task.ivProcType;
        if (this.ivDescription == null || this.ivDescription.trim().length() == 0) {
            this.ivDisplay = "<" + Babel.get("DESCRIPTION_MISSING") + ">";
            this.ivDescMissing = true;
        }
        if (MausoleumClient.isServiceCaretaker() && this.ivProcType != 0 && this.ivProcType != -1 && StandardTask.isGroupTask(this.ivProcType)) {
            this.ivGroup = task.ivGroup;
            this.ivDisplay = String.valueOf(this.ivDisplay) + " (" + task.ivGroup + ")";
        }
        this.ivCol = task.getColor(task.ivGroup);
    }

    public boolean match(TaskExtended task) {
        if (task.ivProcType == this.ivProcType) {
            if (MausoleumClient.isServiceCaretaker() && this.ivProcType != 0 && this.ivProcType != -1 && StandardTask.isGroupTask(this.ivProcType) && task.ivGroup != this.ivGroup) {
                return false;
            }
            return this.ivDescription.equals(task.getDescription(task.ivGroup, true, task.ivExtraObject));
        }
        return false;
    }

    public String toString() {
        return this.ivDisplay;
    }

    public boolean equals(Object obj) {
        return obj instanceof TriangleRestrictor && ((TriangleRestrictor)obj).ivDisplay.equals(this.ivDisplay);
    }

    public int compareTo(Object o) {
        if (o instanceof TriangleRestrictor) {
            TriangleRestrictor tr = (TriangleRestrictor)o;
            if (this.ivDescMissing) {
                return 1;
            }
            if (tr.ivDescMissing) {
                return -1;
            }
            return this.ivDisplay.compareToIgnoreCase(tr.ivDisplay);
        }
        return 0;
    }
}

