/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.rack.frame.cagecard;

import de.hannse.netobjects.util.Babel;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import mausoleum.gui.KomfortTextField;
import mausoleum.gui.MGButton;
import mausoleum.gui.NULLLayoutManager;
import mausoleum.gui.RequesterPane;
import mausoleum.helper.FontManager;
import mausoleum.helper.WindowUtils;
import mausoleum.main.DefaultManager;
import mausoleum.printing.util.CPPageFormat;
import mausoleum.printing.util.Papierformat;
import mausoleum.rack.frame.cagecard.CCVPageFormat;
import mausoleum.rack.frame.cagecard.CageCardPrinterScaler;
import mausoleum.rack.frame.cagecard.CageCardViewPrinter;
import mausoleum.rack.frame.cagecard.RackCageCardComponent;
import mausoleum.ui.UIDef;
import mausoleum.util.InstallationType;

public class CCVPageFormatDialog
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = -1628146097620816181L;
    private static final int ABSTAND = 5;
    private static final int LINE_HEIGHT = 20;
    private static final int BUTTON_HEIGHT = 35;
    private static final int LABEL_WIDTH = 100;
    private static final int LABEL_WIDTH_2 = 80;
    private static final int DOUBLEFIELD_WIDTH = 80;
    private static final int MM_WIDTH = 30;
    private static final int FIELD_WIDTH = 200;
    private static final int FIELD_START = 2 * UIDef.RAND + 100;
    private static final int INNER_BREITE = UIDef.RAND + 100 + 200;
    private static final int BREITE = 2 * UIDef.RAND + INNER_BREITE;
    private static CCVPageFormat cvLastSelectedPageFormat;
    private JComboBox ivPaperSizeCombo = new JComboBox<String>(Papierformat.NAMES);
    private JComboBox ivOrientationCombo = null;
    private KomfortTextField ivLeftMarginField = new KomfortTextField(10.0);
    private KomfortTextField ivRightMarginField = new KomfortTextField(10.0);
    private KomfortTextField ivTopMarginField = new KomfortTextField(10.0);
    private KomfortTextField ivBottomMarginField = new KomfortTextField(10.0);
    private JCheckBox ivWithHeaderBox = new JCheckBox(Babel.get("WITH_HEADER"), true);
    private JCheckBox ivWithFooterBox = new JCheckBox(Babel.get("WITH_FOOTER"), true);
    private JComboBox ivScalerBox = new JComboBox();
    private final Dimension ivCardDim;
    private final Dimension ivCards;
    private final RackCageCardComponent ivRackCageCardComponent;
    private final ActionListener ivScaleChecker = new ActionListener(){

        public void actionPerformed(ActionEvent arg0) {
            CCVPageFormatDialog.this.adjustScalers();
        }
    };
    private final FocusListener ivScaleChecker2 = new FocusAdapter(){

        public void focusLost(FocusEvent arg0) {
            CCVPageFormatDialog.this.adjustScalers();
        }
    };
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("mausoleum.rack.frame.cagecard.CCVPageFormat");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        cvLastSelectedPageFormat = (CCVPageFormat)DefaultManager.getLastUsedObject(clazz);
    }

    private static String getNormalText(double wert) {
        StringBuffer msb = new StringBuffer();
        int iwert = (int)wert;
        double rest = wert - (double)iwert;
        if (rest > 0.999) {
            ++iwert;
            rest = 0.0;
        } else if (rest < 1.0E-4) {
            rest = 0.0;
        }
        msb.append(iwert);
        if (rest != 0.0) {
            msb.append(".");
            rest = (rest + 0.05) * 10.0;
            msb.append((int)rest);
        }
        return msb.toString();
    }

    public CCVPageFormatDialog(Frame sender, RackCageCardComponent rccc) {
        super(sender, true);
        String pfname;
        this.ivCardDim = rccc.getSingleCardDimension();
        this.ivCards = rccc.getRackDimension();
        this.ivRackCageCardComponent = rccc;
        this.setTitle(Babel.get("PAGEFORMAT"));
        int y = UIDef.RAND;
        y += 225;
        y += 20;
        this.setContentPane(new RequesterPane(new NULLLayoutManager(BREITE, y += 35 + UIDef.RAND)));
        this.getContentPane().setLayout(null);
        y = UIDef.RAND;
        CCVPageFormat pf = cvLastSelectedPageFormat;
        double links = 10.0;
        double oben = 10.0;
        double rechts = 10.0;
        double unten = 10.0;
        if (pf != null) {
            links = pf.getPaper().getImageableX() / 2.834645669291339;
            oben = pf.getPaper().getImageableY() / 2.834645669291339;
            rechts = (pf.getPaper().getWidth() - pf.getPaper().getImageableWidth() - pf.getPaper().getImageableX()) / 2.834645669291339;
            unten = (pf.getPaper().getHeight() - pf.getPaper().getImageableHeight() - pf.getPaper().getImageableY()) / 2.834645669291339;
        }
        JLabel lab = new JLabel(Babel.get("PAPERSIZE"));
        lab.setFont(FontManager.getFont("SSB11"));
        lab.setBounds(UIDef.RAND, y, 100, 20);
        this.getContentPane().add(lab);
        if (pf != null && (pfname = Papierformat.getPaperFormat(pf.getPaper().getWidth(), pf.getPaper().getHeight())) != null) {
            this.ivPaperSizeCombo.setSelectedItem(pfname);
        }
        this.ivPaperSizeCombo.addActionListener(this.ivScaleChecker);
        this.ivPaperSizeCombo.setBounds(2 * UIDef.RAND + 100, y, 200, 20);
        this.getContentPane().add(this.ivPaperSizeCombo);
        lab = new JLabel(Babel.get("ORIENTATION"));
        lab.setFont(FontManager.getFont("SSB11"));
        lab.setBounds(UIDef.RAND, y += 25, 100, 20);
        this.getContentPane().add(lab);
        this.ivOrientationCombo = new JComboBox<String>(CPPageFormat.getOrientations());
        if (pf != null) {
            int ori = pf.getOrientation();
            int i = 0;
            while (i < CPPageFormat.PAGE_ORIENTATION_INTS.length) {
                if (CPPageFormat.PAGE_ORIENTATION_INTS[i] == ori) {
                    this.ivOrientationCombo.setSelectedIndex(i);
                }
                ++i;
            }
        }
        this.ivOrientationCombo.addActionListener(this.ivScaleChecker);
        this.ivOrientationCombo.setBounds(FIELD_START, y, 200, 20);
        this.getContentPane().add(this.ivOrientationCombo);
        lab = new JLabel(Babel.get("RAND"));
        lab.setFont(FontManager.getFont("SSB11"));
        lab.setBounds(UIDef.RAND, y += 25, 100, 20);
        this.getContentPane().add(lab);
        lab = new JLabel(Babel.get("OBEN"));
        lab.setFont(FontManager.getFont("SSB11"));
        lab.setBounds(FIELD_START, y, 80, 20);
        this.getContentPane().add(lab);
        this.ivTopMarginField.setText(CCVPageFormatDialog.getNormalText(oben));
        this.ivTopMarginField.addFocusListener(this.ivScaleChecker2);
        this.ivTopMarginField.setBounds(FIELD_START + 5 + 80, y, 80, 20);
        this.getContentPane().add(this.ivTopMarginField);
        lab = new JLabel("mm");
        lab.setFont(FontManager.getFont("SSB11"));
        lab.setBounds(FIELD_START + 10 + 80 + 80, y, 30, 20);
        this.getContentPane().add(lab);
        lab = new JLabel(Babel.get("LINKS"));
        lab.setFont(FontManager.getFont("SSB11"));
        lab.setBounds(FIELD_START, y += 25, 80, 20);
        this.getContentPane().add(lab);
        this.ivLeftMarginField.setText(CCVPageFormatDialog.getNormalText(links));
        this.ivLeftMarginField.addFocusListener(this.ivScaleChecker2);
        this.ivLeftMarginField.setBounds(FIELD_START + 5 + 80, y, 80, 20);
        this.getContentPane().add(this.ivLeftMarginField);
        lab = new JLabel("mm");
        lab.setFont(FontManager.getFont("SSB11"));
        lab.setBounds(FIELD_START + 10 + 80 + 80, y, 30, 20);
        this.getContentPane().add(lab);
        lab = new JLabel(Babel.get("RECHTS"));
        lab.setFont(FontManager.getFont("SSB11"));
        lab.setBounds(FIELD_START, y += 25, 80, 20);
        this.getContentPane().add(lab);
        this.ivRightMarginField.setText(CCVPageFormatDialog.getNormalText(rechts));
        this.ivRightMarginField.addFocusListener(this.ivScaleChecker2);
        this.ivRightMarginField.setBounds(FIELD_START + 5 + 80, y, 80, 20);
        this.getContentPane().add(this.ivRightMarginField);
        lab = new JLabel("mm");
        lab.setFont(FontManager.getFont("SSB11"));
        lab.setBounds(FIELD_START + 10 + 80 + 80, y, 30, 20);
        this.getContentPane().add(lab);
        lab = new JLabel(Babel.get("UNTEN"));
        lab.setFont(FontManager.getFont("SSB11"));
        lab.setBounds(FIELD_START, y += 25, 80, 20);
        this.getContentPane().add(lab);
        this.ivBottomMarginField.setText(CCVPageFormatDialog.getNormalText(unten));
        this.ivBottomMarginField.addFocusListener(this.ivScaleChecker2);
        this.ivBottomMarginField.setBounds(FIELD_START + 5 + 80, y, 80, 20);
        this.getContentPane().add(this.ivBottomMarginField);
        lab = new JLabel("mm");
        lab.setFont(FontManager.getFont("SSB11"));
        lab.setBounds(FIELD_START + 10 + 80 + 80, y, 30, 20);
        this.getContentPane().add(lab);
        y += 25;
        if (pf != null) {
            this.ivWithHeaderBox.setSelected(pf.ivWithHeader);
        }
        this.ivWithHeaderBox.setOpaque(false);
        this.ivWithHeaderBox.setBounds(FIELD_START, y, 200, 20);
        this.ivWithHeaderBox.addActionListener(this.ivScaleChecker);
        this.getContentPane().add(this.ivWithHeaderBox);
        y += 25;
        if (pf != null) {
            this.ivWithFooterBox.setSelected(pf.ivWithFooter);
        }
        this.ivWithFooterBox.setOpaque(false);
        this.ivWithFooterBox.setBounds(FIELD_START, y, 200, 20);
        this.ivWithFooterBox.addActionListener(this.ivScaleChecker);
        this.getContentPane().add(this.ivWithFooterBox);
        lab = new JLabel(Babel.get("TILING"));
        lab.setFont(FontManager.getFont("SSB11"));
        lab.setBounds(UIDef.RAND, y += 25, 100, 20);
        this.getContentPane().add(lab);
        this.ivScalerBox.setBounds(FIELD_START, y, 200, 20);
        this.getContentPane().add(this.ivScalerBox);
        y += 25;
        y += 20;
        int lbw = (INNER_BREITE - UIDef.INNER_RAND) / 2;
        int rbw = INNER_BREITE - UIDef.INNER_RAND - lbw;
        int x = UIDef.RAND;
        MGButton but = MGButton.getRequesterButton(Babel.get("PREVIEW"));
        but.setActionCommand("PREV");
        but.addActionListener(this);
        but.setBounds(x, y, lbw, 35);
        this.getContentPane().add(but);
        but = MGButton.getRequesterButton(Babel.get("PRINT"));
        but.setActionCommand("PRINT");
        but.addActionListener(this);
        but.setBounds(x += lbw + UIDef.INNER_RAND, y, rbw, 35);
        this.getContentPane().add(but);
        x += rbw + UIDef.INNER_RAND;
        y += 35 + UIDef.RAND;
        this.adjustScalers();
        if (pf != null) {
            this.ivScalerBox.setSelectedItem(pf.ivScaler);
        }
        WindowUtils.bringUpCenteredDialog(this, BREITE, y, true);
    }

    private void adjustScalers() {
        Vector v = new Vector();
        Dimension pageDim = this.getPrintablePageDim();
        if (pageDim != null) {
            v = CageCardPrinterScaler.getScalers(this.ivCardDim, pageDim, this.ivCards);
        }
        CageCardPrinterScaler sclToSelect = null;
        CageCardPrinterScaler scaler = (CageCardPrinterScaler)this.ivScalerBox.getSelectedItem();
        if (scaler != null) {
            double scaleVorher = scaler.ivScale;
            double diff = Double.MAX_VALUE;
            Iterator iter = v.iterator();
            while (iter.hasNext()) {
                CageCardPrinterScaler scl = (CageCardPrinterScaler)iter.next();
                double tdiff = Math.abs(scaleVorher - scl.ivScale);
                if (!(tdiff < diff)) continue;
                diff = tdiff;
                sclToSelect = scl;
            }
        }
        this.ivScalerBox.setModel(new DefaultComboBoxModel(v));
        this.ivScalerBox.repaint();
        if (sclToSelect != null) {
            this.ivScalerBox.setSelectedItem(sclToSelect);
        }
    }

    private Dimension getPrintablePageDim() {
        try {
            CPPageFormat cpf = new CPPageFormat(Papierformat.NAMES[this.ivPaperSizeCombo.getSelectedIndex()], CPPageFormat.PAGE_ORIENTATION_INTS[this.ivOrientationCombo.getSelectedIndex()], this.ivLeftMarginField.getDouble(0.0) * 2.834645669291339, this.ivTopMarginField.getDouble(0.0) * 2.834645669291339, this.ivRightMarginField.getDouble(0.0) * 2.834645669291339, this.ivBottomMarginField.getDouble(0.0) * 2.834645669291339);
            Dimension d = new Dimension((int)cpf.getImageableWidth(), (int)cpf.getImageableHeight());
            if (this.ivWithHeaderBox.isSelected()) {
                d.height -= 34;
            }
            if (this.ivWithFooterBox.isSelected()) {
                d.height -= 34;
            }
            return d;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private CCVPageFormat createFormat() {
        return new CCVPageFormat(Papierformat.NAMES[this.ivPaperSizeCombo.getSelectedIndex()], CPPageFormat.PAGE_ORIENTATION_INTS[this.ivOrientationCombo.getSelectedIndex()], this.ivLeftMarginField.getDouble(0.0) * 2.834645669291339, this.ivTopMarginField.getDouble(0.0) * 2.834645669291339, this.ivRightMarginField.getDouble(0.0) * 2.834645669291339, this.ivBottomMarginField.getDouble(0.0) * 2.834645669291339, (CageCardPrinterScaler)this.ivScalerBox.getSelectedItem(), this.ivWithHeaderBox.isSelected(), this.ivWithFooterBox.isSelected());
    }

    public void actionPerformed(ActionEvent e) {
        String comm = e.getActionCommand();
        if (comm.equals("PREV") || comm.equals("PRINT")) {
            this.adjustScalers();
            String header = String.valueOf(InstallationType.getNormalProgramName()) + " " + Babel.get("RACK_CAGE_CARDS") + "  - " + this.ivRackCageCardComponent.getRackInfo() + " / " + this.ivRackCageCardComponent.getSideInfo() + " - " + this.ivRackCageCardComponent.getPrinterName();
            cvLastSelectedPageFormat = this.createFormat();
            DefaultManager.saveLastUsedObject(cvLastSelectedPageFormat);
            CageCardViewPrinter ccvp = new CageCardViewPrinter(this.ivRackCageCardComponent.getCagesByRaster(), this.ivRackCageCardComponent.getRackDimension(), cvLastSelectedPageFormat, this.ivRackCageCardComponent.getPrinterName(), header);
            this.dispose();
            if (comm.equals("PREV")) {
                ccvp.previewIt();
            } else {
                ccvp.printIt();
            }
        }
    }
}

