/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.rack.frame.cagecard;

import de.hannse.netobjects.objectstore.NULLObject;
import de.hannse.netobjects.util.Babel;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Stroke;
import java.awt.print.PageFormat;
import java.util.HashMap;
import java.util.Vector;
import mausoleum.cage.BlockingCage;
import mausoleum.cage.Cage;
import mausoleum.helper.FontManager;
import mausoleum.printing.MausoleumPrinter;
import mausoleum.printing.labelprinters.LabelPrinter;
import mausoleum.rack.frame.cagecard.CCVPageFormat;

public class CageCardViewPrinter
extends MausoleumPrinter {
    private static final int HEAD_SPACE = 14;
    private static final int FOOT_SPACE = 14;
    private static final int INTER_SPACE = 20;
    public static final int ABOVE_SPACE = 34;
    public static final int BELOW_SPACE = 34;
    private static final Stroke STROKE = new BasicStroke(0.5f);
    private final Dimension ivScaledCageCardDim;
    private final Dimension ivCards;
    private final Dimension ivRackDim;
    private final String ivHeader;
    private final String ivPrinterName;
    private final double ivScale;

    public CageCardViewPrinter(HashMap cagesByRaster, Dimension rackDim, CCVPageFormat pageFormat, String printerName, String header) {
        this.ivPageFormat = pageFormat;
        this.ivScaledCageCardDim = pageFormat.ivScaler.ivScaledCardDim;
        this.ivCards = pageFormat.ivScaler.ivCardsPerPage;
        this.ivHeader = header;
        this.ivPrinterName = printerName;
        this.ivScale = pageFormat.ivScaler.ivScale;
        this.ivRackDim = new Dimension(rackDim);
        this.ivDocument.clear();
        int row = 0;
        while (row < rackDim.height) {
            int col = 0;
            while (col < rackDim.width) {
                int maxy;
                int maxx = pageFormat.ivScaler.ivCardsPerPage.width;
                if (col + maxx > rackDim.width) {
                    maxx = rackDim.width - col;
                }
                if (row + (maxy = pageFormat.ivScaler.ivCardsPerPage.height) > rackDim.height) {
                    maxy = rackDim.height - row;
                }
                this.ivDocument.add(new CageCardViewPrintPage(col, row, maxx, maxy, pageFormat.ivScaler.ivScale, cagesByRaster, LabelPrinter.get(this.ivPrinterName, true)));
                col += pageFormat.ivScaler.ivCardsPerPage.width;
            }
            row += pageFormat.ivScaler.ivCardsPerPage.height;
        }
    }

    public int print(Graphics graphics, PageFormat n, int pageIndex) {
        Graphics2D g2d = (Graphics2D)graphics;
        if (pageIndex >= this.ivDocument.size()) {
            return 1;
        }
        CageCardViewPrintPage page = (CageCardViewPrintPage)this.ivDocument.elementAt(pageIndex);
        int ox = (int)this.ivPageFormat.getImageableX();
        int oy = (int)this.ivPageFormat.getImageableY();
        if (this.ivPageFormat instanceof CCVPageFormat) {
            CCVPageFormat ccpf = (CCVPageFormat)this.ivPageFormat;
            if (ccpf.ivWithHeader) {
                g2d.setColor(Color.black);
                g2d.setFont(FontManager.getFont("SSP11"));
                int sw = g2d.getFontMetrics().stringWidth(this.ivHeader);
                int hx = (int)this.ivPageFormat.getImageableX() + ((int)this.ivPageFormat.getImageableWidth() - sw) / 2;
                int y = oy + g2d.getFontMetrics().getMaxAscent();
                g2d.drawString(this.ivHeader, hx, y);
                oy += 34;
            }
            if (ccpf.ivWithFooter) {
                g2d.setColor(Color.black);
                g2d.setFont(FontManager.getFont("SSP11"));
                String footer = " - " + Babel.get("CCV_PAGE") + " " + (pageIndex + 1) + " / " + this.ivDocument.size() + " - ";
                int sw = g2d.getFontMetrics().stringWidth(footer);
                int hx = (int)this.ivPageFormat.getImageableX() + ((int)this.ivPageFormat.getImageableWidth() - sw) / 2;
                int y = (int)this.ivPageFormat.getImageableY() + (int)this.ivPageFormat.getImageableHeight() - g2d.getFontMetrics().getMaxDescent();
                g2d.drawString(footer, hx, y);
            }
        }
        LabelPrinter lp = LabelPrinter.get(this.ivPrinterName, true);
        int sy = oy;
        Point raster = new Point();
        raster.y = 0;
        while (raster.y < this.ivCards.height) {
            int sx = ox;
            raster.x = 0;
            while (raster.x < this.ivCards.width) {
                Object ooo = page.ivCagesByRaster.get(raster);
                if (ooo != null) {
                    g2d.translate(sx, sy);
                    if (this.ivScale != 1.0) {
                        g2d.scale(this.ivScale, this.ivScale);
                    }
                    if (ooo instanceof Cage) {
                        lp.simplePrint((Cage)ooo, (Graphics)g2d);
                    } else if (ooo instanceof Vector) {
                        lp.simplePrint((Vector)ooo, (Graphics)g2d);
                    }
                    if (this.ivScale != 1.0) {
                        g2d.scale(1.0 / this.ivScale, 1.0 / this.ivScale);
                    }
                    g2d.translate(-sx, -sy);
                }
                sx += this.ivScaledCageCardDim.width;
                ++raster.x;
            }
            sy += this.ivScaledCageCardDim.height;
            ++raster.y;
        }
        int cHeight = this.ivCards.height;
        int cWidth = this.ivCards.width;
        if (page.ivStartPoint.x + cWidth > this.ivRackDim.width) {
            cWidth = this.ivRackDim.width - page.ivStartPoint.x;
        }
        if (page.ivStartPoint.y + cHeight > this.ivRackDim.height) {
            cHeight = this.ivRackDim.height - page.ivStartPoint.y;
        }
        int oben = oy + 1;
        int unten = oy + cHeight * this.ivScaledCageCardDim.height - 2;
        int links = ox + 1;
        int rechts = ox + cWidth * this.ivScaledCageCardDim.width - 2;
        g2d.setColor(Color.black);
        g2d.setStroke(STROKE);
        int y = oben;
        while (y < unten) {
            g2d.drawLine(links, y, rechts, y);
            y += this.ivScaledCageCardDim.height;
        }
        g2d.drawLine(links, unten, rechts, unten);
        int x = links;
        while (x < rechts) {
            g2d.drawLine(x, oben, x, unten);
            x += this.ivScaledCageCardDim.width;
        }
        g2d.drawLine(rechts, oben, rechts, unten);
        return 0;
    }

    class CageCardViewPrintPage {
        public HashMap ivCagesByRaster = new HashMap(40);
        public Point ivStartPoint = null;

        public CageCardViewPrintPage(int startx, int starty, int maxx, int maxy, double scale, HashMap cagesByRaster, LabelPrinter lp) {
            this.ivStartPoint = new Point(startx, starty);
            if (lp != null) {
                Point getKey = new Point();
                Vector<Cage> cages = new Vector<Cage>();
                int y = 0;
                while (y < maxy) {
                    int x = 0;
                    while (x < maxx) {
                        Point key = new Point(x, y);
                        this.ivCagesByRaster.put(key, NULLObject.INSTANCE);
                        getKey.x = x + startx;
                        getKey.y = y + starty;
                        Cage cage = (Cage)cagesByRaster.get(getKey);
                        if (cage != null && !(cage instanceof BlockingCage)) {
                            cages.clear();
                            cages.add(cage);
                            lp.distributeCageLabels(cages);
                            Object ooo = lp.getPage(0);
                            if (ooo != null) {
                                this.ivCagesByRaster.put(key, ooo);
                            }
                        }
                        ++x;
                    }
                    ++y;
                }
            }
        }
    }
}

