/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.reports;

import de.hannse.netobjects.datalayer.dfa.IntermediaerHelfer;
import de.hannse.netobjects.objectstore.IDObject;
import de.hannse.netobjects.objectstore.IDObjectXMLHandler;
import de.hannse.netobjects.objectstore.ObjectStore;
import de.hannse.netobjects.objectstore.ObjectStoreServer;
import de.hannse.netobjects.tools.Base64Manager;
import de.hannse.netobjects.util.Babel;
import java.awt.Color;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.Vector;
import mausoleum.helper.Zeile;
import mausoleum.helper.ZeileAbstr;
import mausoleum.line.Line;
import mausoleum.main.ProcessDefinition;
import mausoleum.mouse.Mouse;
import mausoleum.mouse.tierschutz.TierSchutzReportD2;
import mausoleum.objectstore.IndexChecker;
import mausoleum.result.MResult;

public class LineEvaluationReportDeutschland1 {
    public static final String CLIENT_HOL_TAG = "#";
    public static final String SUM_OTHER_TAG = "##++SO++##";
    public static final String SUM_TAG = "##++SUM++##";
    public static final int POS_RES_WURF_TIERE = 0;
    public static final int POS_RES_ABSETZEN_TIERE = 1;
    public static final int POS_RES_EINZELTIER_TIERE = 2;
    public static final int POS_RES_WURF_REPORTS = 3;
    public static final int POS_RES_ABSETZEN_REPORTS = 4;
    public static final int POS_RES_EINZELTIER_REPORTS = 5;
    public static final int ANZ_PLAIN_RESULTS = 3;
    public static final int ANZ_RESULTS = 6;
    public final String ivUrGroup;
    public final long ivUrLineID;
    public final TreeMap ivBinsByGroup = new TreeMap();

    public static String getLineEvaluationReport(String group, long[] lineIDs) {
        if (ProcessDefinition.isServer()) {
            HashSet groupsToCheck = new HashSet();
            Vector<LineEvaluationReportDeutschland1> reports = new Vector<LineEvaluationReportDeutschland1>(lineIDs.length);
            int i = 0;
            while (i < lineIDs.length) {
                reports.add(new LineEvaluationReportDeutschland1(group, lineIDs[i], groupsToCheck));
                ++i;
            }
            new LERIndexChecker().doCheck(groupsToCheck, reports);
            StringBuilder msb = new StringBuilder();
            Iterator iterator = reports.iterator();
            while (iterator.hasNext()) {
                LineEvaluationReportDeutschland1 lr = (LineEvaluationReportDeutschland1)iterator.next();
                lr.appendTransport(msb);
            }
            return msb.toString();
        }
        return null;
    }

    public LineEvaluationReportDeutschland1(String transport) {
        Zeile z = new Zeile(transport, '|');
        this.ivUrLineID = z.getLong(0, 0L);
        this.ivUrGroup = z.getStringB64(1, "?");
        Vector<SimpleLineEvaluationLine> zeilen = new Vector<SimpleLineEvaluationLine>();
        int i = 2;
        while (i < z.size()) {
            SimpleLineEvaluationLine slul = new SimpleLineEvaluationLine(z.getStringNONEmpty(i, null));
            if (slul.ivGroup != null && slul.ivCounts != null) {
                zeilen.add(slul);
            }
            ++i;
        }
        this.ivBinsByGroup.put(CLIENT_HOL_TAG, zeilen);
    }

    private LineEvaluationReportDeutschland1(String group, long lineID, HashSet groupsToCheck) {
        this.ivUrGroup = group;
        this.ivUrLineID = lineID;
        Line urLine = (Line)ObjectStore.getObjectDeadOrAlive(7, lineID, group, null, false);
        if (urLine != null) {
            if (urLine.isSharedWithOtherGroups() || urLine.getGroup().equals("service")) {
                HashMap hm;
                Line serviceLine;
                Line line = serviceLine = urLine.isSharedWithOtherGroups() ? (Line)urLine.getServiceGroupObject(null) : urLine;
                if (serviceLine != null && (hm = serviceLine.getSubObjectsByGroupOnServer(null)) != null && !hm.isEmpty()) {
                    Iterator iter = hm.keySet().iterator();
                    while (iter.hasNext()) {
                        String sgroup = (String)iter.next();
                        Line line2 = (Line)hm.get(sgroup);
                        this.ivBinsByGroup.put(sgroup, new LineEvalRepBin(sgroup, 7, line2.getID()));
                    }
                }
            } else {
                this.ivBinsByGroup.put(this.ivUrGroup, new LineEvalRepBin(this.ivUrGroup, 7, this.ivUrLineID));
            }
        }
        groupsToCheck.addAll(this.ivBinsByGroup.keySet());
    }

    public void addInterestedBin(String group, Vector target) {
        LineEvalRepBin lrp = (LineEvalRepBin)this.ivBinsByGroup.get(group);
        if (lrp != null) {
            target.add(lrp);
        }
    }

    public void appendTransport(StringBuilder msb) {
        msb.append(this.ivUrLineID).append("|").append(Base64Manager.encodeBase64(this.ivUrGroup));
        int[] sum = new int[6];
        if ("service".equals(this.ivUrGroup)) {
            Iterator iterator = this.ivBinsByGroup.keySet().iterator();
            while (iterator.hasNext()) {
                String group = (String)iterator.next();
                LineEvalRepBin lrb = (LineEvalRepBin)this.ivBinsByGroup.get(group);
                msb.append("|").append(Base64Manager.encodeBase64(group)).append(";").append(IDObjectXMLHandler.getTransport(lrb.ivCount, true, true));
                int i = 0;
                while (i < lrb.ivCount.length) {
                    sum[i] = lrb.ivCount[i];
                    ++i;
                }
            }
        } else {
            int[] sumOther = new int[6];
            Iterator iterator = this.ivBinsByGroup.keySet().iterator();
            while (iterator.hasNext()) {
                int i;
                String group = (String)iterator.next();
                LineEvalRepBin lrb = (LineEvalRepBin)this.ivBinsByGroup.get(group);
                if (group.equalsIgnoreCase(this.ivUrGroup)) {
                    msb.append("|").append(Base64Manager.encodeBase64(group)).append(";").append(IDObjectXMLHandler.getTransport(lrb.ivCount, true, true));
                    i = 0;
                    while (i < lrb.ivCount.length) {
                        sum[i] = lrb.ivCount[i];
                        ++i;
                    }
                    continue;
                }
                i = 0;
                while (i < lrb.ivCount.length) {
                    sumOther[i] = lrb.ivCount[i];
                    ++i;
                }
            }
            msb.append("|").append(SUM_OTHER_TAG).append(";").append(IDObjectXMLHandler.getTransport(sumOther, true, true));
        }
        msb.append("|").append(SUM_TAG).append(";").append(IDObjectXMLHandler.getTransport(sum, true, true));
        msb.append("\n");
    }

    public static class LERIndexChecker
    implements IndexChecker {
        private transient Vector ivInteresteds = new Vector();

        public void doCheck(HashSet groupsToCheck, Vector reports) {
            Iterator iterator = groupsToCheck.iterator();
            while (iterator.hasNext()) {
                String lgroup = (String)iterator.next();
                this.ivInteresteds.clear();
                Iterator iterator2 = reports.iterator();
                while (iterator2.hasNext()) {
                    ((LineEvaluationReportDeutschland1)iterator2.next()).addInterestedBin(lgroup, this.ivInteresteds);
                }
                IntermediaerHelfer.giveIndicesToChecker(this, lgroup);
            }
            this.ivInteresteds.clear();
            this.ivInteresteds = null;
        }

        public void checkIndex(Long id, String index) {
            if (index != null && index.length() != 0) {
                String lineIndex = ZeileAbstr.getStringNONEmpty(index, IntermediaerHelfer.getIndexSeparator(), IntermediaerHelfer.getLineCol(), null);
                String resultsIndex = ZeileAbstr.getStringNONEmpty(index, IntermediaerHelfer.getIndexSeparator(), IntermediaerHelfer.getResultsCol(), null);
                if (lineIndex != null && resultsIndex != null) {
                    Iterator iterator2 = this.ivInteresteds.iterator();
                    while (iterator2.hasNext()) {
                        LineEvalRepBin lrp = (LineEvalRepBin)iterator2.next();
                        lrp.check(id, lineIndex, resultsIndex);
                    }
                }
            }
        }
    }

    public static class LineEvalRepBin {
        private static final String[][] EXP_CHECK_STRINGS = new String[6][4];
        public final String ivGroup;
        public final int ivObjectType;
        public final long ivID;
        public final String ivIdentifierString;
        private final String ivLineString;
        public int[] ivZArr;
        public int[] ivZArr2;
        public int[] ivCount = new int[6];

        static {
            LineEvalRepBin.makeCheckStrings(-43L, 0);
            LineEvalRepBin.makeCheckStrings(-44L, 1);
            LineEvalRepBin.makeCheckStrings(-45L, 2);
        }

        private static void makeCheckStrings(long id, int ePos) {
            LineEvalRepBin.EXP_CHECK_STRINGS[ePos][0] = String.valueOf(id);
            LineEvalRepBin.EXP_CHECK_STRINGS[ePos][1] = String.valueOf(id) + "|";
            LineEvalRepBin.EXP_CHECK_STRINGS[ePos][2] = "|" + id + "|";
            LineEvalRepBin.EXP_CHECK_STRINGS[ePos][3] = "|" + id;
        }

        public LineEvalRepBin(String group, int objectType, long objectID) {
            this.ivGroup = group;
            this.ivObjectType = objectType;
            this.ivID = objectID;
            this.ivLineString = String.valueOf(objectID);
            this.ivIdentifierString = IDObject.getIdentifierString(group, objectType, objectID);
        }

        public boolean equals(Object obj) {
            if (obj instanceof LineEvalRepBin) {
                LineEvalRepBin lrp = (LineEvalRepBin)obj;
                return this.ivIdentifierString.equals(lrp.ivIdentifierString);
            }
            return false;
        }

        public int hashCode() {
            return this.ivIdentifierString.hashCode();
        }

        public void check(Long id, String lineIndex, String resultIndex) {
            if (resultIndex != null && resultIndex.trim().length() != 0) {
                boolean embryoTransferDa = TierSchutzReportD2.checkResultForSpec(resultIndex, TierSchutzReportD2.EMBRYO_TRANSFER_ARR);
                boolean wurfDa = TierSchutzReportD2.checkResultForSpec(resultIndex, TierSchutzReportD2.WURF_ARR);
                boolean wurfAlreadyDone = false;
                if (embryoTransferDa && wurfDa) {
                    Vector v;
                    Mouse mouse = (Mouse)ObjectStoreServer.getObjectDeadOrAlive(1, id, this.ivGroup, null, false, false);
                    if (mouse != null && (v = (Vector)mouse.get("MOS_MRESULTS")) != null) {
                        int count = 0;
                        Iterator iter = v.iterator();
                        while (iter.hasNext()) {
                            MResult mresult = (MResult)iter.next();
                            long expID = mresult.getExperimentID();
                            if (-43L != expID) continue;
                            String resRep = (String)mresult.ivResult;
                            this.ivZArr2 = Zeile.getTrenner(resRep, '|', '\u0000', this.ivZArr2);
                            if (!this.ivLineString.equals(Zeile.getString(resRep, 0, "", this.ivZArr2, '\u0000'))) continue;
                            ++count;
                        }
                        if (count > 0) {
                            this.ivCount[0] = this.ivCount[0] + 1;
                            this.ivCount[3] = this.ivCount[3] + count;
                        }
                    }
                    wurfAlreadyDone = true;
                } else {
                    wurfAlreadyDone = false;
                }
                if (this.ivLineString.equals(lineIndex)) {
                    boolean einzeltierDa = TierSchutzReportD2.checkResultForSpec(resultIndex, TierSchutzReportD2.EINZELTIER_ARR);
                    boolean absetzDa = TierSchutzReportD2.checkResultForSpec(resultIndex, TierSchutzReportD2.ABSETZ_ARR);
                    if (einzeltierDa) {
                        this.ivCount[2] = this.ivCount[2] + 1;
                    }
                    if (absetzDa) {
                        this.ivCount[1] = this.ivCount[1] + 1;
                    }
                    if (wurfDa && !wurfAlreadyDone) {
                        this.ivCount[0] = this.ivCount[0] + 1;
                    }
                    if (einzeltierDa || wurfDa || absetzDa) {
                        Zeile z = new Zeile(resultIndex, '|');
                        int i = 0;
                        while (i < z.size()) {
                            String s = z.getString(i, "");
                            if (TierSchutzReportD2.EINZELTIER_ARR[0].equals(s)) {
                                this.ivCount[5] = this.ivCount[5] + 1;
                            } else if (!wurfAlreadyDone && TierSchutzReportD2.WURF_ARR[0].equals(s)) {
                                this.ivCount[3] = this.ivCount[3] + 1;
                            } else if (TierSchutzReportD2.ABSETZ_ARR[0].equals(s)) {
                                this.ivCount[4] = this.ivCount[4] + 1;
                            }
                            ++i;
                        }
                    }
                }
            }
        }
    }

    public static class LineEvaluationReportSammlerD1 {
        public final Vector ivReports = new Vector();
    }

    public static class SimpleLineEvaluationLine {
        public final String ivGroup;
        public final int[] ivCounts;
        public boolean ivBold = false;
        public boolean ivIsSum = false;
        public Color ivBackGround = null;

        public SimpleLineEvaluationLine(String s) {
            int ind;
            String group = null;
            int[] anz = null;
            if (s != null && (ind = s.indexOf(";")) != -1) {
                group = s.substring(0, ind);
                if (LineEvaluationReportDeutschland1.SUM_OTHER_TAG.equals(group)) {
                    group = Babel.get("OTHER_GROUPS");
                } else if (LineEvaluationReportDeutschland1.SUM_TAG.equals(group)) {
                    group = Babel.get("SUM");
                    this.ivBold = true;
                    this.ivIsSum = true;
                } else {
                    group = Base64Manager.getDecodedString(group);
                }
                anz = (int[])IDObjectXMLHandler.getObject(s.substring(ind + 1, s.length()), null, true);
            }
            this.ivGroup = group;
            this.ivCounts = anz;
        }
    }
}

