/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.requester;

import de.hannse.netobjects.util.Babel;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import mausoleum.locus.Locus;
import mausoleum.requester.BasicRequester;
import mausoleum.ui.UIDef;

public class AddAllelRequester
extends BasicRequester {
    private static final long serialVersionUID = 146835135L;
    private static final int RAND = UIDef.getScaled(10);
    private static final int LABEL_HEIGHT = UIDef.getScaled(24);
    private static final int LABEL_WIDTH = UIDef.getScaled(60);
    private static final int COMBO_HEIGHT = UIDef.getScaled(24);
    private static final int BUTTON_HEIGHT = UIDef.getScaled(40);
    private static final int BREITE = UIDef.getScaled(400);
    private static final int HOEHE = 5 * RAND + LABEL_HEIGHT + 2 * COMBO_HEIGHT + BUTTON_HEIGHT;
    private final JComboBox ivLocusComboBox;
    private final JComboBox ivAllelComboBox = new JComboBox();
    private final Hashtable ivAllelesByLocus;
    private final Vector ivLoci;
    private final Vector ivLocusNames;
    private Vector ivAktAlelles = null;
    private final Vector ivAktAlellAliases = new Vector();

    public AddAllelRequester(Frame sender, String meldung, Hashtable allelesByLocus) {
        super(sender, BREITE, HOEHE);
        this.ivAllelesByLocus = allelesByLocus;
        this.ivLoci = new Vector(allelesByLocus.size());
        this.ivLocusNames = new Vector(allelesByLocus.size());
        Enumeration en = allelesByLocus.keys();
        while (en.hasMoreElements()) {
            Locus locus = (Locus)en.nextElement();
            this.ivLoci.addElement(locus);
            this.ivLocusNames.addElement(locus.getString("LOC_NAME", ""));
        }
        this.ivLocusComboBox = new JComboBox(this.ivLocusNames);
        this.ivLocusComboBox.setSelectedIndex(0);
        this.locusSelected((Locus)this.ivLoci.firstElement());
        this.addPermanentLabel(meldung, RAND, RAND, UIDef.getScaled(14));
        int y = LABEL_HEIGHT + RAND;
        int w = BREITE - 2 * RAND - LABEL_WIDTH;
        this.addPermanentLabel(Babel.get("LOCUS"), RAND, y, COMBO_HEIGHT);
        this.addAndApplyBounds(this.ivLocusComboBox, RAND + LABEL_WIDTH, y, w, COMBO_HEIGHT);
        this.ivLocusComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                int index = AddAllelRequester.this.ivLocusComboBox.getSelectedIndex();
                if (index != -1) {
                    AddAllelRequester.this.locusSelected((Locus)AddAllelRequester.this.ivLoci.elementAt(index));
                }
            }
        });
        this.addPermanentLabel(Babel.get("ALLEL"), RAND, y += COMBO_HEIGHT + RAND, COMBO_HEIGHT);
        this.addAndApplyBounds(this.ivAllelComboBox, RAND + LABEL_WIDTH, y, w, COMBO_HEIGHT);
        w = BREITE - 2 * RAND;
        int rbw = (w - RAND) / 2;
        int lbw = w - RAND - rbw;
        this.applyBounds(this.ivOkButton, RAND, y += COMBO_HEIGHT + RAND, lbw, BUTTON_HEIGHT);
        this.applyBounds(this.ivNoButton, 2 * RAND + lbw, y, rbw, BUTTON_HEIGHT);
    }

    private void locusSelected(Locus locus) {
        this.ivAktAlelles = (Vector)this.ivAllelesByLocus.get(locus);
        this.ivAktAlellAliases.clear();
        if (this.ivAktAlelles != null && !this.ivAktAlelles.isEmpty()) {
            Iterator iterator = this.ivAktAlelles.iterator();
            while (iterator.hasNext()) {
                this.ivAktAlellAliases.add(locus.getAlias((String)iterator.next()));
            }
        }
        this.ivAllelComboBox.setModel(new DefaultComboBoxModel(this.ivAktAlellAliases));
        this.ivAllelComboBox.setSelectedIndex(0);
    }

    public long getLocusID() {
        int index = this.ivLocusComboBox.getSelectedIndex();
        if (index != -1) {
            Locus locus = (Locus)this.ivLoci.elementAt(index);
            return locus.getID();
        }
        return -1L;
    }

    public String getAllel() {
        int ind = this.ivAllelComboBox.getSelectedIndex();
        return ind == -1 ? null : (String)this.ivAktAlelles.elementAt(ind);
    }
}

