/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.requester;

import de.hannse.netobjects.util.Babel;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import mausoleum.gui.MGButton;
import mausoleum.gui.NULLLayoutManager;
import mausoleum.gui.PermanentLabel;
import mausoleum.gui.RequesterPane;
import mausoleum.helper.WindowUtils;
import mausoleum.ui.UIDef;

public class BasicRequester
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 1L;
    public boolean ivWarOK = false;
    public MGButton ivOkButton;
    public MGButton ivNoButton;
    protected RequesterPane ivRequesterPane;

    public BasicRequester(Frame sender, int w, int h) {
        this(sender, w, h, Babel.get("REQUEST"));
    }

    public BasicRequester(Frame sender, int w, int h, String titel) {
        super(sender, titel == null ? Babel.get("REQUEST") : titel, true);
        this.init(w, h);
    }

    public BasicRequester(JDialog sender, int w, int h) {
        super(sender, Babel.get("REQUEST"), true);
        this.init(w, h);
    }

    private void init(int w, int h) {
        this.ivRequesterPane = new RequesterPane(new NULLLayoutManager(w, h));
        this.setContentPane(this.ivRequesterPane);
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                BasicRequester.this.ivWarOK = false;
                BasicRequester.this.dispose();
            }
        });
        if (this.okAndNoWanted()) {
            this.ivOkButton = MGButton.getRequesterButton(Babel.get("YES"));
            this.ivOkButton.setActionCommand("OK");
            this.ivOkButton.addActionListener(this);
            this.ivRequesterPane.add(this.ivOkButton);
            this.ivNoButton = MGButton.getRequesterButton(Babel.get("NO"));
            this.ivNoButton.addActionListener(this);
            this.ivNoButton.setActionCommand("CANCEL");
            this.ivRequesterPane.add(this.ivNoButton);
        } else if (this.onlyOKWanted()) {
            this.ivOkButton = MGButton.getRequesterButton(Babel.get("YES"));
            this.ivOkButton.setActionCommand("OK");
            this.ivOkButton.addActionListener(this);
            this.ivRequesterPane.add(this.ivOkButton);
        }
        this.pack();
        if (w != -1 && h != -1) {
            this.setInnerSize(w, h);
        }
    }

    public void setInnerSize(int breite, int hoehe) {
        WindowUtils.bringUpCenteredDialog(this, breite, hoehe, false);
    }

    public void addAndApplyScaledBounds(Component c, int x, int y, int w, int h) {
        this.addAndApplyBounds(c, UIDef.getScaled(x), UIDef.getScaled(y), UIDef.getScaled(w), UIDef.getScaled(h));
    }

    public void addAndApplyBounds(Component c, int x, int y, int w, int h) {
        this.ivRequesterPane.add(c);
        c.setBounds(x, y, w, h);
    }

    public void addAndApplyBounds(Component c, Rectangle r) {
        this.ivRequesterPane.add(c);
        c.setBounds(r.x, r.y, r.width, r.height);
    }

    public void applyScaledBounds(Component c, int x, int y, int w, int h) {
        this.applyBounds(c, UIDef.getScaled(x), UIDef.getScaled(y), UIDef.getScaled(w), UIDef.getScaled(h));
    }

    public void applyBounds(Component c, int x, int y, int w, int h) {
        c.setBounds(x, y, w, h);
    }

    public PermanentLabel addScaledPermanentLabel(String s, int x, int y, int height) {
        return this.ivRequesterPane.addPermanentLabel(s, UIDef.getScaled(x), UIDef.getScaled(y), UIDef.getScaled(height));
    }

    public PermanentLabel addPermanentLabel(String s, int x, int y, int height) {
        return this.ivRequesterPane.addPermanentLabel(s, x, y, height);
    }

    public boolean okAndNoWanted() {
        return true;
    }

    public boolean onlyOKWanted() {
        return false;
    }

    public void addReturnEqualsOKKeyListener(JTextField tf) {
        tf.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                BasicRequester.this.OKPressed();
            }
        });
    }

    public void addReturnEqualsOKKeyListener(JComponent tf) {
        tf.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.getKeyChar() == '\n') {
                    e.consume();
                    BasicRequester.this.OKPressed();
                }
            }
        });
    }

    public void addReturnEqualsOKKeyListener(JTextArea tf) {
        tf.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.getKeyChar() == '\n') {
                    e.consume();
                    BasicRequester.this.OKPressed();
                }
            }
        });
    }

    public int getWidth(String[] arr, Font f) {
        FontMetrics fm = this.getFontMetrics(f);
        int max = 0;
        int i = 0;
        while (i < arr.length) {
            int w = fm.stringWidth(arr[i]);
            if (w > max) {
                max = w;
            }
            ++i;
        }
        return max;
    }

    public void OKPressed() {
        this.ivWarOK = true;
        this.dispose();
    }

    public void actionPerformed(ActionEvent e) {
        String comm = e.getActionCommand();
        if (comm.equals("OK")) {
            this.OKPressed();
        } else if (comm.equals("CANCEL")) {
            this.ivWarOK = false;
            this.dispose();
        }
    }
}

