/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.requester;

import de.hannse.netobjects.util.Babel;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.util.Collections;
import java.util.Comparator;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.SwingUtilities;
import mausoleum.cage.Cage;
import mausoleum.gui.MGButton;
import mausoleum.inspector.Inspector;
import mausoleum.main.DefaultManager;
import mausoleum.printing.labelprinters.LabelPrinter;
import mausoleum.rack.RackPos;
import mausoleum.requester.BasicRequester;
import mausoleum.ui.UIDef;

public class LabelPrintRequester
extends BasicRequester {
    private static final long serialVersionUID = 1456451385L;
    private static final int BREITE = UIDef.getScaled(250);
    private static final int HOEHE = UIDef.getScaled(130);
    private static final Comparator CAGE_COMPARER = new Comparator(){

        public int compare(Object arg0, Object arg1) {
            if (arg0 instanceof Cage && arg1 instanceof Cage) {
                int rpi1;
                RackPos rp = (RackPos)((Cage)arg0).get("CAG_POS");
                int rpi0 = rp == null ? -1 : rp.getSortValue();
                rp = (RackPos)((Cage)arg1).get("CAG_POS");
                int n = rpi1 = rp == null ? -1 : rp.getSortValue();
                if (rpi0 < rpi1) {
                    return -1;
                }
                if (rpi0 > rpi1) {
                    return 1;
                }
            }
            return 0;
        }
    };
    private static String cvLastSelectedName = DefaultManager.getLabelPrinter();
    private static String cvLastSelectedMausName = null;
    private JComboBox ivComboBox;
    private Vector ivIDObjects;
    private final boolean ivObjectsAreCages;

    public static String getLastUsedLabelPrinter() {
        return cvLastSelectedName;
    }

    public static void setLastUsedLablePrinter(String s) {
        if (s != null) {
            cvLastSelectedName = s;
        }
    }

    public LabelPrintRequester(Vector idObjects, boolean objectsAreCages) {
        super((Frame)Inspector.getInspector(), BREITE, HOEHE);
        this.ivIDObjects = idObjects;
        Collections.sort(this.ivIDObjects, CAGE_COMPARER);
        this.ivObjectsAreCages = objectsAreCages;
        this.ivComboBox = new JComboBox<String>(LabelPrinter.getNames(objectsAreCages));
        if (objectsAreCages) {
            if (cvLastSelectedName != null) {
                this.ivComboBox.setSelectedItem(cvLastSelectedName);
            } else {
                this.ivComboBox.setSelectedItem(DefaultManager.getLabelPrinter());
            }
        } else if (cvLastSelectedMausName != null) {
            this.ivComboBox.setSelectedItem(cvLastSelectedMausName);
        }
        this.addAndApplyScaledBounds(this.ivComboBox, 10, 10, 230, 30);
        this.applyScaledBounds(this.ivOkButton, 10, 50, 160, 30);
        this.ivOkButton.setText(Babel.get("PRINT"));
        this.ivOkButton.setActionCommand("PRINT");
        this.applyScaledBounds(this.ivNoButton, 180, 50, 60, 70);
        MGButton but = MGButton.getRequesterButton(Babel.get("PREVIEW"));
        but.setActionCommand("PREVIEW");
        but.addActionListener(this);
        this.addAndApplyScaledBounds(but, 10, 90, 160, 30);
        this.setVisible(true);
    }

    public void actionPerformed(ActionEvent e) {
        String comm = e.getActionCommand();
        if (comm.equals("PRINT") || comm.equals("PREVIEW")) {
            String name = (String)this.ivComboBox.getSelectedItem();
            if (name != null) {
                if (this.ivObjectsAreCages) {
                    cvLastSelectedName = name;
                } else {
                    cvLastSelectedMausName = name;
                }
                SwingUtilities.invokeLater(new LabelPrintInvoker(name, this.ivIDObjects, comm.equals("PRINT")));
            }
            this.dispose();
        } else if (comm.equals("CANCEL")) {
            this.dispose();
        }
    }

    private static class LabelPrintInvoker
    implements Runnable {
        private final String ivName;
        private final Vector ivIDObjects;
        private final boolean ivPrintIt;

        public LabelPrintInvoker(String name, Vector idObjects, boolean print) {
            this.ivIDObjects = idObjects;
            this.ivPrintIt = print;
            this.ivName = name;
        }

        public void run() {
            if (this.ivPrintIt) {
                LabelPrinter.printIt(this.ivIDObjects, this.ivName);
            } else {
                LabelPrinter.previewIt(this.ivIDObjects, this.ivName);
            }
        }
    }
}

