/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.requester;

import de.hannse.netobjects.network.client.ClientCommunicator;
import de.hannse.netobjects.objectstore.ObjectRequest;
import de.hannse.netobjects.tools.StringHelper;
import de.hannse.netobjects.user.User;
import de.hannse.netobjects.user.UserManager;
import de.hannse.netobjects.user.UserRoomRestriction;
import de.hannse.netobjects.util.Log;
import de.hannse.netobjects.util.MilliSpender;
import de.hannse.netobjects.util.RequestManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.HashMap;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import mausoleum.alert.Alert;
import mausoleum.cage.CageManager;
import mausoleum.cage.colors.CageColorManager;
import mausoleum.gui.TextWrapComponent;
import mausoleum.helper.FocusHoler;
import mausoleum.helper.FontManager;
import mausoleum.inspector.Inspector;
import mausoleum.main.DefaultManager;
import mausoleum.mouse.MouseManager;
import mausoleum.rack.frame.RackFrame;
import mausoleum.requester.BasicRequester;
import mausoleum.requester.InitializationProgress;
import mausoleum.tables.MausoleumTableFrame;
import mausoleum.tables.TableFrameTasks;
import mausoleum.task.DisplayTask;
import mausoleum.ui.UIDef;
import mausoleum.util.HelloMessage;

public class LoginRequester
extends BasicRequester {
    private static final long serialVersionUID = 1L;
    private static final int BREITE = UIDef.getScaled(320);
    private static final int BREITE_INNER_HELLO = UIDef.getScaled(420);
    private static final int BREITE_GANZ_HELLO = BREITE_INNER_HELLO + 3 * UIDef.INNER_RAND;
    private static final int BREITE_MIT_HELLO = BREITE_GANZ_HELLO + 2 * UIDef.RAND;
    private static final int LINE_HEIGHT = UIDef.getScaled(28);
    private static final int BUT_WIDTH = UIDef.getScaled(80);
    private static final int LABEL_WIDTH = UIDef.getScaled(80);
    private static final int HOEHE = 2 * UIDef.RAND + 3 * LINE_HEIGHT + 2 * UIDef.INNER_RAND;
    private static final long MAX_IDLE_TIME = 600000L;
    private JTextField ivUsernameField = new JTextField("", 5);
    private JPasswordField ivPasswordField = new JPasswordField("", 5);
    private JTextField ivGroupnameField = new JTextField("", 5);
    private boolean ivLogChange = false;
    private User ivUser = null;
    private long ivLastActionMillis = MilliSpender.getMillis();
    private boolean ivCheckIdleTime = false;
    private CaretListener ivCaretListener = new CaretListener(){

        public void caretUpdate(CaretEvent e) {
            LoginRequester.this.ivLastActionMillis = MilliSpender.getMillis();
        }
    };

    public static User login() {
        LoginRequester lir = new LoginRequester(new Frame(), false, true, LoginRequester.getHelloComp());
        if (lir.ivWarOK) {
            return lir.ivUser;
        }
        return null;
    }

    public static User login(String user, String group, String password) {
        LoginRequester lir = new LoginRequester(new Frame(), false, false, null);
        if (user != null && user.length() != 0) {
            lir.ivUsernameField.setText(user);
        }
        if (group != null && group.length() != 0) {
            lir.ivGroupnameField.setText(group);
        }
        if (password != null && password.length() != 0) {
            lir.ivPasswordField.setText(password);
        }
        lir.OKPressed();
        if (lir.ivWarOK) {
            return lir.ivUser;
        }
        lir.showUp();
        if (lir.ivWarOK) {
            return lir.ivUser;
        }
        return null;
    }

    public static void changeLogin(Frame sender) {
        new LoginRequester(sender, true, true, LoginRequester.getHelloComp());
    }

    private static TextWrapComponent getHelloComp() {
        String hello = HelloMessage.getSystemMessage(1, null);
        return hello == null ? null : new TextWrapComponent(hello, FontManager.getFont("SSB14"), BREITE_INNER_HELLO, 2);
    }

    private LoginRequester(Frame sender, boolean logchange, boolean showup, TextWrapComponent helloMessageComp) {
        super(sender, helloMessageComp == null ? BREITE : BREITE_MIT_HELLO, helloMessageComp == null ? HOEHE : HOEHE + UIDef.INNER_RAND + helloMessageComp.getNecessaryHeight() + 10);
        int breite = helloMessageComp == null ? BREITE : BREITE_MIT_HELLO;
        this.setTitle("The Mausoleum Login");
        this.ivLogChange = logchange;
        this.addReturnEqualsOKKeyListener(this.ivPasswordField);
        this.ivPasswordField.setEchoChar('*');
        int ins = UIDef.getScaled(2);
        this.ivUsernameField.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                LoginRequester.this.ivUsernameField.selectAll();
            }
        });
        this.ivUsernameField.setMargin(new Insets(ins, ins, ins, ins));
        this.ivGroupnameField.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                LoginRequester.this.ivGroupnameField.selectAll();
            }
        });
        this.ivGroupnameField.setMargin(new Insets(ins, ins, ins, ins));
        this.ivPasswordField.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                LoginRequester.this.ivPasswordField.selectAll();
            }
        });
        this.ivPasswordField.setMargin(new Insets(ins, ins, ins, ins));
        this.ivUsernameField.setFont(FontManager.getFont("SSB14"));
        this.ivGroupnameField.setFont(FontManager.getFont("SSB14"));
        this.ivPasswordField.setFont(FontManager.getFont("SSB14"));
        int y = UIDef.RAND;
        if (helloMessageComp != null) {
            int h = helloMessageComp.getNecessaryHeight();
            helloMessageComp.setPreferredSize(new Dimension(BREITE_INNER_HELLO, h));
            JPanel pan = new JPanel(new BorderLayout());
            pan.setBackground(new Color(240, 240, 240, 128));
            pan.setOpaque(true);
            pan.setBorder(new CompoundBorder(new LineBorder(Color.black), new EmptyBorder(UIDef.INNER_RAND, UIDef.INNER_RAND, UIDef.INNER_RAND, UIDef.INNER_RAND)));
            pan.add("Center", helloMessageComp);
            this.addAndApplyBounds(pan, UIDef.RAND, y, BREITE_GANZ_HELLO, h + 2 + 2 * UIDef.INNER_RAND);
            y += h + 10 + UIDef.INNER_RAND;
        }
        int obenY = y;
        int fieldWidth = breite - 2 * UIDef.RAND - 2 * UIDef.INNER_RAND - LABEL_WIDTH - BUT_WIDTH;
        int labX = UIDef.RAND;
        int fieldX = labX + LABEL_WIDTH + UIDef.INNER_RAND;
        int butX = fieldX + fieldWidth + UIDef.INNER_RAND;
        JLabel lab = new JLabel("Username");
        lab.setFont(FontManager.getFont("SSB14"));
        this.addAndApplyBounds(lab, labX, y, LABEL_WIDTH, LINE_HEIGHT);
        this.addAndApplyBounds(this.ivUsernameField, fieldX, y, fieldWidth, LINE_HEIGHT);
        lab = new JLabel("Group");
        lab.setFont(FontManager.getFont("SSB14"));
        this.addAndApplyBounds(lab, labX, y += LINE_HEIGHT + UIDef.INNER_RAND, LABEL_WIDTH, LINE_HEIGHT);
        this.addAndApplyBounds(this.ivGroupnameField, fieldX, y, fieldWidth, LINE_HEIGHT);
        lab = new JLabel("Password");
        lab.setFont(FontManager.getFont("SSB14"));
        this.addAndApplyBounds(lab, labX, y += LINE_HEIGHT + UIDef.INNER_RAND, LABEL_WIDTH, LINE_HEIGHT);
        this.addAndApplyBounds(this.ivPasswordField, fieldX, y, fieldWidth, LINE_HEIGHT);
        int totFH = 3 * LINE_HEIGHT + 2 * UIDef.INNER_RAND;
        int oh = (totFH - UIDef.INNER_RAND) / 2;
        int uh = totFH - UIDef.INNER_RAND - oh;
        this.applyBounds(this.ivOkButton, butX, obenY, BUT_WIDTH, oh);
        this.applyBounds(this.ivNoButton, butX, obenY + oh + UIDef.INNER_RAND, BUT_WIDTH, uh);
        if (this.ivLogChange) {
            this.ivGroupnameField.setText(UserManager.getFirstGroup());
            this.ivGroupnameField.setEnabled(false);
        } else {
            this.ivUsernameField.setText(DefaultManager.getUserName());
            this.ivGroupnameField.setText(DefaultManager.getGroupName());
            this.ivUsernameField.addCaretListener(this.ivCaretListener);
            this.ivGroupnameField.addCaretListener(this.ivCaretListener);
            this.ivPasswordField.addCaretListener(this.ivCaretListener);
            this.ivCheckIdleTime = true;
            new Thread(new Runnable(){

                public void run() {
                    while (!LoginRequester.this.ivLogChange && LoginRequester.this.ivCheckIdleTime) {
                        try {
                            Thread.sleep(600000L);
                            if (MilliSpender.getMillis() - LoginRequester.this.ivLastActionMillis <= 600000L || LoginRequester.this.ivLogChange || !LoginRequester.this.ivCheckIdleTime) continue;
                            LoginRequester.this.ivUser = null;
                            LoginRequester.this.ivCheckIdleTime = false;
                            LoginRequester.this.dispose();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            }).start();
        }
        if (showup) {
            this.showUp();
        }
    }

    public void OKPressed() {
        String groupName = this.ivGroupnameField.getText().trim();
        this.ivLastActionMillis = MilliSpender.getMillis();
        HashMap<String, String> resultHashMap = new HashMap<String, String>(5);
        resultHashMap.put("USR_NAME", this.ivUsernameField.getText());
        resultHashMap.put("IDO_GROUP", groupName);
        char[] passwordChars = this.ivPasswordField.getPassword();
        String password = new String(passwordChars);
        int i = 0;
        while (i < passwordChars.length) {
            passwordChars[i] = '\u0000';
            ++i;
        }
        resultHashMap.put("USR_PASSWORD", StringHelper.encrypt(password));
        if (this.ivLogChange) {
            User usi = UserManager.findUserByName((String)resultHashMap.get("USR_NAME"), groupName);
            if (usi != null && usi.getString("USR_PASSWORD").equalsIgnoreCase((String)resultHashMap.get("USR_PASSWORD"))) {
                UserManager.setUser(usi);
                UserRoomRestriction.resetRoomRestriction();
                DefaultManager.reinitWithUser(false);
                this.ivWarOK = true;
                this.setCursor(Cursor.getDefaultCursor());
                this.dispose();
                MausoleumTableFrame.removeAllTables(false);
                MausoleumTableFrame.initMainTables();
                RackFrame.reinit();
                TableFrameTasks.restAlertWindowMarker();
                CageManager.performWeanControl(false);
                CageColorManager.createCageColorsForLogChange();
                MouseManager.performPlugAlertControl(false);
                DisplayTask.init();
                Inspector.setAppropriateTitle();
                Inspector.userChanged();
                TableFrameTasks.showWindowIfNecessary();
                Object[] arr = new Object[]{usi.get("IDO_ID"), usi.getString("USR_NAME", "unknown")};
                RequestManager.sendObjectRequestAndForget(new ObjectRequest(39, arr, null, null));
                return;
            }
            this.ivPasswordField.setText(null);
            this.ivPasswordField.setEnabled(true);
            this.repaint();
            this.setCursor(Cursor.getDefaultCursor());
            return;
        }
        this.ivUsernameField.setEnabled(false);
        this.ivGroupnameField.setEnabled(false);
        this.ivPasswordField.setEnabled(false);
        this.setCursor(Cursor.getPredefinedCursor(3));
        ObjectRequest mor = RequestManager.createSendAndGetAnswer((byte)3, resultHashMap, null);
        if (mor.isDenied()) {
            if (mor.ivObject instanceof String) {
                if ("#licex".equals(mor.ivObject)) {
                    InitializationProgress.dismiss();
                    ClientCommunicator.getCommunicator().commitSuicide();
                    Alert.showAlert("The license pool is exhausted. Try again later...", null, null, true);
                    System.exit(0);
                } else {
                    Alert.showAlert((String)mor.ivObject, true);
                }
            }
            this.ivUsernameField.setEnabled(true);
            this.ivGroupnameField.setEnabled(true);
            this.ivPasswordField.setText(null);
            this.ivPasswordField.setEnabled(true);
            this.repaint();
            this.setCursor(Cursor.getDefaultCursor());
        } else if (mor.isFinished()) {
            this.ivUser = new User();
            this.ivUser.setValues((HashMap)mor.ivObject);
            UserManager.setGroup(this.ivUser.getGroup());
            this.ivWarOK = true;
            this.setCursor(Cursor.getDefaultCursor());
            this.ivCheckIdleTime = false;
            this.dispose();
        }
    }

    private void showUp() {
        try {
            if (this.ivUsernameField.getText().trim().length() > 0 && this.ivGroupnameField.getText().trim().length() > 0) {
                new FocusHoler(this.ivPasswordField);
            }
        }
        catch (Throwable e) {
            Log.error("Problem while showing LoginReqester", e, this);
        }
        this.toFront();
        this.setVisible(true);
    }
}

