/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.requester;

import java.awt.Font;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import mausoleum.helper.FontManager;
import mausoleum.requester.BasicRequester;
import mausoleum.ui.UIDef;

public class MoreTextRequester
extends BasicRequester {
    private static final long serialVersionUID = 1L;
    private static final int RAND = UIDef.getScaled(10);
    private static final int DEFAULT_BREITE = UIDef.getScaled(600);
    private static final int DEFAULT_HOEHE = UIDef.getScaled(300);
    private static final int KNOPF_HOEHE = UIDef.getScaled(30);
    private static final int LABEL_HOEHE = UIDef.getScaled(20);
    private JTextArea ivTextArea = new JTextArea("", 5, 40);

    public static String getText(Frame sender, String meldung) {
        return MoreTextRequester.getText(sender, meldung, DEFAULT_BREITE, DEFAULT_HOEHE, null, false, null, true);
    }

    public static String getText(Frame sender, String meldung, boolean eingabeZwang) {
        return MoreTextRequester.getText(sender, meldung, DEFAULT_BREITE, DEFAULT_HOEHE, null, eingabeZwang, null, true);
    }

    public static String getText(Frame sender, String meldung, int breite, int hoehe, Font font, boolean eingabeZwang, String textSoFar, boolean retEqualsOK) {
        MoreTextRequester mmr = new MoreTextRequester(sender, meldung, breite, hoehe, font, eingabeZwang, textSoFar, retEqualsOK);
        if (mmr.ivWarOK) {
            return mmr.ivTextArea.getText();
        }
        return null;
    }

    private MoreTextRequester(Frame sender, String labelText, int breite, int hoehe, Font font, boolean eingabeZwang, String textSoFar, boolean retEqualsOK) {
        super(sender, breite, hoehe);
        if (font != null) {
            this.ivTextArea.setFont(font);
        }
        if (textSoFar != null) {
            this.ivTextArea.setText(textSoFar);
            this.ivTextArea.setCaretPosition(0);
        }
        if (retEqualsOK) {
            this.addReturnEqualsOKKeyListener(this.ivTextArea);
        }
        int lbr = (breite - 3 * RAND) / 2;
        int rbr = breite - 3 * RAND - lbr;
        this.applyBounds(this.ivOkButton, RAND, hoehe - KNOPF_HOEHE - RAND, lbr, KNOPF_HOEHE);
        this.applyBounds(this.ivNoButton, 2 * RAND + lbr, hoehe - KNOPF_HOEHE - RAND, rbr, KNOPF_HOEHE);
        this.addAndApplyBounds(new JScrollPane(this.ivTextArea), RAND, LABEL_HOEHE + 2 * RAND, breite - 2 * RAND, hoehe - LABEL_HOEHE - KNOPF_HOEHE - 4 * RAND);
        this.addPermanentLabel(labelText, RAND, RAND, UIDef.getScaled(14));
        this.ivTextArea.setLineWrap(true);
        this.ivTextArea.setWrapStyleWord(true);
        this.ivTextArea.setFont(FontManager.getFont("SSB12"));
        int im = UIDef.getScaled(4);
        this.ivTextArea.setMargin(new Insets(im, im, im, im));
        this.addWindowListener(new WindowAdapter(){

            public void windowOpened(WindowEvent e) {
                MoreTextRequester.this.ivTextArea.requestFocus();
            }
        });
        if (eingabeZwang) {
            this.ivTextArea.addCaretListener(new CaretListener(){

                public void caretUpdate(CaretEvent arg0) {
                    MoreTextRequester.this.checkOKBut();
                }
            });
            this.checkOKBut();
        }
        this.setVisible(true);
    }

    private void checkOKBut() {
        this.ivOkButton.setEnabled(this.ivTextArea.getText().trim().length() != 0);
    }
}

