/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.requester;

import de.hannse.netobjects.util.Babel;
import java.awt.Frame;
import javax.swing.JTextField;
import mausoleum.alert.Alert;
import mausoleum.gui.KomfortTextField;
import mausoleum.gui.documents.DoubleDocument;
import mausoleum.gui.documents.IntegerDocument;
import mausoleum.helper.FontManager;
import mausoleum.requester.BasicRequester;
import mausoleum.ui.UIDef;

public class NewExperimentLimitRequester
extends BasicRequester {
    private static final long serialVersionUID = 1L;
    private static final int BREITE = UIDef.getScaled(250);
    private static final int FIELD_HEIGHT = UIDef.getScaled(30);
    private static final int FIELD_WIDTH = UIDef.getScaled(100);
    private static final int LOWERFIELD_Y = UIDef.RAND;
    private static final int UPPERFIELD_Y = LOWERFIELD_Y + FIELD_HEIGHT + UIDef.INNER_RAND;
    private static final int UNITFIELD_Y = UPPERFIELD_Y + FIELD_HEIGHT + UIDef.INNER_RAND;
    private static final int OKBUT_Y = UNITFIELD_Y + FIELD_HEIGHT + UIDef.INNER_RAND;
    private static final int OKBUT_HEIGHT = UIDef.getScaled(40);
    private static final int OKBUT_WIDTH = BREITE - 2 * UIDef.RAND;
    private static final int OKBUT_X = UIDef.RAND;
    private static final int HOEHE = OKBUT_Y + OKBUT_HEIGHT + UIDef.RAND;
    private KomfortTextField ivLowerField = new KomfortTextField();
    private KomfortTextField ivUpperField = new KomfortTextField();
    private JTextField ivUnitField = new JTextField();
    private boolean ivIsInteger = true;
    protected Object ivUpperLimit = null;
    protected Object ivLowerLimit = null;
    protected String ivUnit = null;

    public static void main(String[] args) {
        NewExperimentLimitRequester nmr = new NewExperimentLimitRequester(new Frame(), true);
        nmr.setVisible(true);
        System.exit(0);
    }

    public NewExperimentLimitRequester(Frame sender, boolean isInteger) {
        super(sender, BREITE, HOEHE);
        this.setTitle(Babel.get("SETLIMITS"));
        this.ivIsInteger = isInteger;
        this.ivLowerField = new KomfortTextField();
        this.ivUpperField = new KomfortTextField();
        if (this.ivIsInteger) {
            this.ivLowerField.setDocument(new IntegerDocument(this.ivLowerField));
            this.ivUpperField.setDocument(new IntegerDocument(this.ivUpperField));
        } else {
            this.ivLowerField.setDocument(new DoubleDocument(this.ivLowerField));
            this.ivUpperField.setDocument(new DoubleDocument(this.ivUpperField));
        }
        this.ivLowerField.setFont(FontManager.getFont("SSB16"));
        this.addPermanentLabel(Babel.get("LOWERLIMIT"), UIDef.RAND, LOWERFIELD_Y, FIELD_HEIGHT);
        this.addAndApplyBounds(this.ivLowerField, BREITE - UIDef.RAND - FIELD_WIDTH, LOWERFIELD_Y, FIELD_WIDTH, FIELD_HEIGHT);
        this.ivUpperField.setFont(FontManager.getFont("SSB16"));
        this.addPermanentLabel(Babel.get("UPPERLIMIT"), UIDef.RAND, UPPERFIELD_Y, FIELD_HEIGHT);
        this.addAndApplyBounds(this.ivUpperField, BREITE - UIDef.RAND - FIELD_WIDTH, UPPERFIELD_Y, FIELD_WIDTH, FIELD_HEIGHT);
        this.ivUnitField.setFont(FontManager.getFont("SSB16"));
        this.addPermanentLabel(Babel.get("UNIT"), UIDef.RAND, UNITFIELD_Y, FIELD_HEIGHT);
        this.addAndApplyBounds(this.ivUnitField, BREITE - UIDef.RAND - FIELD_WIDTH, UNITFIELD_Y, FIELD_WIDTH, FIELD_HEIGHT);
        this.applyBounds(this.ivOkButton, OKBUT_X, OKBUT_Y, OKBUT_WIDTH, OKBUT_HEIGHT);
    }

    public boolean okAndNoWanted() {
        return false;
    }

    public boolean onlyOKWanted() {
        return true;
    }

    public void OKPressed() {
        if (this.ivIsInteger) {
            try {
                int low = Integer.parseInt(this.ivLowerField.getText());
                int high = Integer.parseInt(this.ivUpperField.getText());
                if (low >= high) {
                    Alert.showAlert("Lower limit must be lower than upper limit!", true);
                    return;
                }
                this.ivLowerLimit = new Integer(low);
                this.ivUpperLimit = new Integer(high);
            }
            catch (Exception e) {
                Alert.showAlert("Input for lower/upper limit is incorrect!", true);
                return;
            }
        }
        try {
            double low = this.ivLowerField.getDouble(Double.NaN);
            double high = this.ivUpperField.getDouble(Double.NaN);
            if (Double.isNaN(low) || Double.isNaN(high)) {
                Alert.showAlert("Please specify Limits!", true);
                return;
            }
            if (low >= high) {
                Alert.showAlert("Lower limit must be lower than upper limit!", true);
                return;
            }
            this.ivLowerLimit = new Double(low);
            this.ivUpperLimit = new Double(high);
        }
        catch (Exception e) {
            Alert.showAlert("Input for lower/upper limit is incorrect!", true);
            return;
        }
        this.ivUnit = this.ivUnitField.getText();
        this.ivWarOK = true;
        super.dispose();
    }
}

