/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.requester;

import de.hannse.netobjects.objectstore.IDObject;
import de.hannse.netobjects.user.User;
import de.hannse.netobjects.util.Babel;
import java.awt.Frame;
import java.util.Vector;
import mausoleum.line.Line;
import mausoleum.requester.BasicRequester;
import mausoleum.strain.Strain;
import mausoleum.tables.MausoleumTable;
import mausoleum.tables.MausoleumTableModel;
import mausoleum.tables.MausoleumTableSelectionListener;
import mausoleum.tables.models.MTLineSel;
import mausoleum.tables.models.MTStrainSel;
import mausoleum.tables.models.MTUserSel;
import mausoleum.ui.UIDef;

public class SelectIDObjectRequester
extends BasicRequester
implements MausoleumTableSelectionListener {
    private static final long serialVersionUID = 1L;
    public static final int BREITE = UIDef.getScaled(650);
    public static final int HOEHE = UIDef.getScaled(420);
    public final MausoleumTable ivLineTable;

    public static IDObject getSelectedIDObject(Frame sender, Vector choosableIDObjects, boolean adjustInspector) {
        if (choosableIDObjects != null && !choosableIDObjects.isEmpty()) {
            IDObject ido = (IDObject)choosableIDObjects.firstElement();
            if (ido instanceof Line) {
                return SelectIDObjectRequester.getSelectedLine(sender, choosableIDObjects, adjustInspector);
            }
            if (ido instanceof Strain) {
                return SelectIDObjectRequester.getSelectedStrain(sender, choosableIDObjects, adjustInspector);
            }
            if (ido instanceof User) {
                return SelectIDObjectRequester.getSelectedUser(sender, choosableIDObjects, adjustInspector);
            }
        }
        return null;
    }

    public static Line getSelectedLine(Frame sender, Vector choosableLines, boolean adjustInspector) {
        return (Line)SelectIDObjectRequester.getSelectedIDObject(sender, choosableLines, new MTLineSel(), Babel.get("SELECT_LINE"), adjustInspector);
    }

    public static Strain getSelectedStrain(Frame sender, Vector choosableStrains, boolean adjustInspector) {
        return (Strain)SelectIDObjectRequester.getSelectedIDObject(sender, choosableStrains, new MTStrainSel(), Babel.get("SELECT_STRAIN"), adjustInspector);
    }

    public static User getSelectedUser(Frame sender, Vector choosableUsers, boolean adjustInspector) {
        return (User)SelectIDObjectRequester.getSelectedIDObject(sender, choosableUsers, new MTUserSel(), Babel.get("SELECT_USER"), adjustInspector);
    }

    public static IDObject getSelectedIDObject(Frame sender, Vector choosableIDObjects, MausoleumTableModel model, String title, boolean adjustInspector) {
        Vector selectedIDObjects;
        SelectIDObjectRequester smr = new SelectIDObjectRequester(sender, choosableIDObjects, model, title, adjustInspector);
        smr.setVisible(true);
        if (smr.ivWarOK && (selectedIDObjects = smr.ivLineTable.getSelectedObjects()).size() == 1) {
            return (IDObject)selectedIDObjects.elementAt(0);
        }
        return null;
    }

    private SelectIDObjectRequester(Frame sender, Vector choosableLines, MausoleumTableModel model, String title, boolean adjustInspector) {
        super(sender, BREITE, HOEHE);
        this.setTitle(title);
        int ibr = BREITE - 2 * UIDef.RAND;
        int oh = HOEHE - 2 * UIDef.RAND - UIDef.BUT_HEIGHT - UIDef.INNER_RAND;
        int y = UIDef.RAND;
        model.addSelectionListener(this);
        model.setToNonExecutable();
        model.ivAdjustInspector = adjustInspector;
        this.ivLineTable = new MausoleumTable(model, false);
        this.ivLineTable.setIsSubdisplay();
        this.ivLineTable.ivModel.setTable(choosableLines);
        this.addAndApplyBounds(this.ivLineTable, UIDef.RAND, y, ibr, oh);
        int lbw = (ibr - UIDef.INNER_RAND) / 2;
        int rbw = BREITE - 3 * UIDef.RAND - lbw;
        this.applyBounds(this.ivOkButton, UIDef.RAND, y += oh + UIDef.INNER_RAND, lbw, UIDef.BUT_HEIGHT);
        this.applyBounds(this.ivNoButton, UIDef.RAND + lbw + UIDef.INNER_RAND, y, rbw, UIDef.BUT_HEIGHT);
        this.ivOkButton.setEnabled(false);
    }

    public void selectionChanged(MausoleumTableModel mt) {
        this.ivOkButton.setEnabled(mt.ivSelectedRows.size() == 1);
    }
}

