/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.requester;

import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.JTextField;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import mausoleum.gui.PermanentLabel;
import mausoleum.helper.FocusHoler;
import mausoleum.helper.FontManager;
import mausoleum.requester.BasicRequester;
import mausoleum.ui.UIDef;

public class TextRequester
extends BasicRequester {
    private static final long serialVersionUID = 1L;
    private static final int BREITE = UIDef.getScaled(340);
    private static final int HOEHE = UIDef.getScaled(250);
    protected JTextField ivTextField = new JTextField();
    private final boolean ivEmptyAllowed;

    public static String displayTextRequester(Frame sender, String meldung) {
        return TextRequester.displayTextRequester(sender, meldung, "", true);
    }

    public static String displayTextRequester(Frame sender, String meldung, String vorher) {
        return TextRequester.displayTextRequester(sender, meldung, vorher, true);
    }

    public static String displayTextRequester(Frame sender, String meldung, String vorher, boolean emptyAllowed) {
        TextRequester tr = new TextRequester(sender, meldung, vorher, emptyAllowed);
        tr.setVisible(true);
        if (tr.ivWarOK) {
            return tr.ivTextField.getText();
        }
        return null;
    }

    protected TextRequester(Frame sender, String meldung, String vorher, boolean emptyAllowed) {
        super(sender, BREITE, HOEHE);
        this.ivEmptyAllowed = emptyAllowed;
        int tfw = UIDef.getScaled(300);
        int lineHeight = UIDef.getScaled(24);
        int butHeight = UIDef.getScaled(30);
        int pw = PermanentLabel.preferredWidth(meldung, FontManager.getFont("SSB14"));
        int innerWidth = pw + UIDef.INNER_RAND + tfw;
        int width = UIDef.RAND + innerWidth + UIDef.RAND;
        int y = UIDef.RAND;
        int x = UIDef.RAND;
        this.addPermanentLabel(meldung, x, y, lineHeight);
        x += pw + UIDef.RAND;
        this.ivTextField.setFont(FontManager.getFont("SSB12"));
        int im = UIDef.getScaled(2);
        this.ivTextField.setMargin(new Insets(im, im, im, im));
        this.ivTextField.setText(vorher);
        this.ivTextField.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent arg0) {
                TextRequester.this.ivTextField.selectAll();
            }
        });
        if (!this.ivEmptyAllowed) {
            this.ivTextField.addCaretListener(new CaretListener(){

                public void caretUpdate(CaretEvent arg0) {
                    TextRequester.this.checkBut();
                }
            });
        }
        this.addReturnEqualsOKKeyListener(this.ivTextField);
        this.addAndApplyBounds(this.ivTextField, x, y, tfw, lineHeight);
        int lbw = (innerWidth - UIDef.INNER_RAND) / 2;
        int rbw = innerWidth - UIDef.INNER_RAND - lbw;
        x = UIDef.RAND;
        this.applyBounds(this.ivOkButton, x, y += lineHeight + UIDef.RAND, lbw, butHeight);
        this.applyBounds(this.ivNoButton, x += lbw + UIDef.INNER_RAND, y, rbw, butHeight);
        this.setInnerSize(width, y += butHeight + UIDef.RAND);
        new FocusHoler(this.ivTextField, 300);
        this.checkBut();
    }

    private void checkBut() {
        boolean okEnabled = true;
        if (!this.ivEmptyAllowed && this.ivTextField.getText().trim().length() == 0) {
            okEnabled = false;
        }
        this.ivOkButton.setEnabled(okEnabled);
    }

    public void OKPressed() {
        if (!this.ivEmptyAllowed && this.ivTextField.getText().trim().length() == 0) {
            return;
        }
        super.OKPressed();
    }
}

