/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.requester.cage;

import de.hannse.netobjects.objectstore.ObjectStore;
import de.hannse.netobjects.user.UserManager;
import de.hannse.netobjects.util.Babel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import mausoleum.alert.Alert;
import mausoleum.cage.Cage;
import mausoleum.cage.CageManager;
import mausoleum.gui.MGButton;
import mausoleum.gui.MToggleButton;
import mausoleum.helper.FontManager;
import mausoleum.inspector.Inspector;
import mausoleum.main.MausoleumClient;
import mausoleum.rack.frame.RackFrame;
import mausoleum.requester.BasicRequester;
import mausoleum.requester.Requester;
import mausoleum.requester.cage.HighlightCageBeutel;
import mausoleum.tables.TableFrameCage;
import mausoleum.tables.models.MTCage;
import mausoleum.tables.models.MTCageAfterCageNumberSearch;
import mausoleum.ui.UIDef;
import mausoleum.util.InstallationType;

public class HighlightCageRequester
extends BasicRequester
implements ActionListener,
ListCellRenderer,
ListSelectionListener {
    private static final long serialVersionUID = 1L;
    private static final int OBUT_WIDTH = UIDef.getScaled(350);
    private static final int LIST_WIDTH = UIDef.getScaled(250);
    private static final int OBUT_HEIGHT = UIDef.getScaled(35);
    private static final int SHOWBUT_HEIGHT = UIDef.getScaled(24);
    private static final int ANZ_KNOEPFE_OBEN = InstallationType.useMatings() ? 5 : 4;
    private static final int OHEIGHT = ANZ_KNOEPFE_OBEN * OBUT_HEIGHT + (ANZ_KNOEPFE_OBEN - 1) * UIDef.INNER_RAND;
    private static final int LIST_HEIGHT = OHEIGHT - UIDef.INNER_RAND - SHOWBUT_HEIGHT;
    private static final int IBREITE = OBUT_WIDTH + UIDef.INNER_RAND + LIST_WIDTH;
    private static final int BREITE = UIDef.RAND + IBREITE + UIDef.RAND;
    private static final int ANZ_KNOEPFE_UNTEN_REG_SCT = 3;
    private static final int ANZ_KNOEPFE_UNTEN_SONST = 2;
    private static final int UHEIGHT_REG_SCT = 3 * OBUT_HEIGHT + 2 * UIDef.INNER_RAND;
    private static final int UHEIGHT_SONST = 2 * OBUT_HEIGHT + 1 * UIDef.INNER_RAND;
    private static final int HOEHE_REG_SCT = UIDef.RAND + OHEIGHT + UIDef.INNER_RAND + UHEIGHT_REG_SCT + UIDef.RAND;
    private static final int HOEHE_SONST = UIDef.RAND + OHEIGHT + UIDef.INNER_RAND + UHEIGHT_SONST + UIDef.RAND;
    private static final String HIGHLIGHT_CAGES__WITH_NUMBER = "NUM ";
    private static final String SHOW_CAGES = "SHOW";
    private static final String SEARCH_CAGE_BY_SYSTEM_ID = "SAC_SYSID";
    private static final String SEARCH_CAGE_BY_FOREIGN_ID = "SAC_FORID";
    private static final String SEARCH_CAGE_BY_NUMBER = "SACGE";
    private static final String HIGHLIGHT_MARKED_CAGES = "HLMARK";
    private static final String HIGHLIGHT_MATING_CAGES = "HLWED";
    private static final String HIGHLIGHT_CAGES_WITH_UNTAGGED_MICE_NO_BREEDER = "HLUNTAGNB";
    private static final String HIGHLIGHT_CAGES_WITH_UNTAGGED_MICE_WITH_BREEDER = "HLUNTAG";
    private static final String HIGHLIGHT_CAGES_WITH_TASKS = "HLCAGESWITHTASKS";
    private final JLabel ivLabel = new JLabel();
    private final JList ivList = new JList();
    private final MGButton ivShowButton = new MGButton(Babel.get("SHOWRACK"), "SHOW");
    private MToggleButton ivLastPressedButton = null;
    private Vector ivActSelection;

    public HighlightCageRequester(Frame sender) {
        super(sender, BREITE, MausoleumClient.isRegularOrTGService() || MausoleumClient.isServiceCaretaker() ? HOEHE_REG_SCT : HOEHE_SONST);
        this.setTitle(Babel.get("HIGHLIGHTCAGES"));
        this.ivLabel.setOpaque(true);
        this.ivLabel.setForeground(Color.black);
        int x = UIDef.RAND;
        int y = UIDef.RAND;
        this.addAndApplyBounds(new MToggleButton(Babel.get("CAGE_WITH_TASKS"), HIGHLIGHT_CAGES_WITH_TASKS, this, FontManager.getFont("SSB14")), x, y, OBUT_WIDTH, OBUT_HEIGHT);
        this.addAndApplyBounds(new MToggleButton(Babel.get("CAGUNTAG"), HIGHLIGHT_CAGES_WITH_UNTAGGED_MICE_WITH_BREEDER, this, FontManager.getFont("SSB14")), x, y += OBUT_HEIGHT + UIDef.INNER_RAND, OBUT_WIDTH, OBUT_HEIGHT);
        this.addAndApplyBounds(new MToggleButton(Babel.get("CAGUNTAGNOBR"), HIGHLIGHT_CAGES_WITH_UNTAGGED_MICE_NO_BREEDER, this, FontManager.getFont("SSB14")), x, y += OBUT_HEIGHT + UIDef.INNER_RAND, OBUT_WIDTH, OBUT_HEIGHT);
        y += OBUT_HEIGHT + UIDef.INNER_RAND;
        if (InstallationType.useMatings()) {
            this.addAndApplyBounds(new MToggleButton(Babel.get("WEDDINGCAG"), HIGHLIGHT_MATING_CAGES, this, FontManager.getFont("SSB14")), x, y, OBUT_WIDTH, OBUT_HEIGHT);
            y += OBUT_HEIGHT + UIDef.INNER_RAND;
        }
        this.addAndApplyBounds(new MToggleButton(Babel.get("MARKCAG"), HIGHLIGHT_MARKED_CAGES, this, FontManager.getFont("SSB14")), x, y, OBUT_WIDTH, OBUT_HEIGHT);
        y += OBUT_HEIGHT + UIDef.INNER_RAND;
        x += OBUT_WIDTH + UIDef.INNER_RAND;
        y = UIDef.RAND;
        this.ivList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    HighlightCageRequester.this.highlightAndDispose();
                }
            }
        });
        this.ivList.setCellRenderer(this);
        this.ivList.addListSelectionListener(this);
        this.ivList.setSelectionMode(0);
        JScrollPane jsp = new JScrollPane(this.ivList);
        this.addAndApplyBounds(jsp, x, y, LIST_WIDTH, LIST_HEIGHT);
        this.ivShowButton.setEnabled(false);
        this.ivShowButton.addActionListener(this);
        this.ivShowButton.setFont(FontManager.getFont("SSB14"));
        this.addAndApplyBounds(this.ivShowButton, x, y += LIST_HEIGHT + UIDef.INNER_RAND, LIST_WIDTH, SHOWBUT_HEIGHT);
        x = UIDef.RAND;
        y = UIDef.RAND + OHEIGHT + UIDef.INNER_RAND;
        if (MausoleumClient.isRegularOrTGService() || MausoleumClient.isServiceCaretaker()) {
            String suchTitel = Babel.get(MausoleumClient.isRegularOrTGService() ? "SEARCHALLCAGESWITHNUMBER" : "SEARCHACTIVECAGESWITHNUMBER");
            MGButton allcageBut = new MGButton(suchTitel, SEARCH_CAGE_BY_NUMBER, this, FontManager.getFont("SSB14"));
            allcageBut.setEnabled(true);
            this.addAndApplyBounds(allcageBut, x, y, IBREITE, OBUT_HEIGHT);
            y += OBUT_HEIGHT + UIDef.INNER_RAND;
        }
        this.addAndApplyBounds(new MGButton(Babel.get("SEARCCAGEBYSYSTEMID"), SEARCH_CAGE_BY_SYSTEM_ID, this, FontManager.getFont("SSB14")), x, y, IBREITE, OBUT_HEIGHT);
        this.addAndApplyBounds(new MGButton(Babel.get("SEARCH_CAGES_BY_FOREIGN_ID"), SEARCH_CAGE_BY_FOREIGN_ID, this, FontManager.getFont("SSB14")), x, y += OBUT_HEIGHT + UIDef.INNER_RAND, IBREITE, OBUT_HEIGHT);
        y += OBUT_HEIGHT + UIDef.INNER_RAND;
    }

    public boolean okAndNoWanted() {
        return false;
    }

    public void actionPerformed(ActionEvent e) {
        String foreignID;
        String comm;
        if (e.getSource() instanceof MToggleButton) {
            MToggleButton mtb = (MToggleButton)e.getSource();
            if (mtb == this.ivLastPressedButton) {
                return;
            }
            if (this.ivLastPressedButton != null) {
                this.ivLastPressedButton.setPressed(false);
                this.ivLastPressedButton.repaint();
            }
            this.ivLastPressedButton = mtb;
        }
        if ((comm = e.getActionCommand()).equals(HIGHLIGHT_MARKED_CAGES) || comm.equals(HIGHLIGHT_CAGES_WITH_UNTAGGED_MICE_WITH_BREEDER) || comm.equals(HIGHLIGHT_CAGES_WITH_UNTAGGED_MICE_NO_BREEDER) || comm.equals(HIGHLIGHT_MATING_CAGES) || comm.equals(HIGHLIGHT_CAGES_WITH_TASKS)) {
            this.selectCages(comm);
        } else if (comm.equals(SHOW_CAGES)) {
            this.highlightAndDispose();
        } else if (comm.equals(SEARCH_CAGE_BY_NUMBER)) {
            int cagnum;
            if ((MausoleumClient.isRegularOrTGService() || MausoleumClient.isServiceCaretaker()) && (cagnum = Requester.getInt(Inspector.getInspector(), Babel.get("CAGENUMBER"), 0, false, -1, false, null)) != -1) {
                if (MausoleumClient.isRegularOrTGService()) {
                    this.dispose();
                    MTCageAfterCageNumberSearch mtcacns = new MTCageAfterCageNumberSearch(cagnum, UserManager.getFirstGroup());
                    new Thread(mtcacns).start();
                    TableFrameCage.showCageTable(mtcacns, Babel.get("SEARCH_CAGES"), Babel.get("FOUNDCAGES"));
                } else if (MausoleumClient.isServiceCaretaker()) {
                    this.selectCages(HIGHLIGHT_CAGES__WITH_NUMBER + cagnum);
                }
            }
        } else if (comm.equals(SEARCH_CAGE_BY_SYSTEM_ID)) {
            long sysID = Requester.getLong(Inspector.getInspector(), Babel.get("SYSTEM_ID"), 0L, false, -1L, false);
            if (sysID > 0L) {
                this.dispose();
                Vector<Cage> v = new Vector<Cage>();
                Enumeration en = UserManager.getGroupsEnumeration();
                while (en.hasMoreElements()) {
                    Cage cage = (Cage)ObjectStore.getClientObject(2, sysID, (String)en.nextElement());
                    if (cage == null) continue;
                    v.add(cage);
                }
                if (!v.isEmpty()) {
                    TableFrameCage.showCageTable(new MTCage(v), Babel.get("FOUNDCAGES"), Babel.get("FOUNDCAGES"));
                } else {
                    Alert.showAlert(Babel.get("CAGE_NOT_FOUND"), true);
                }
            }
        } else if (comm.equals(SEARCH_CAGE_BY_FOREIGN_ID) && (foreignID = Requester.getString(Inspector.getInspector(), Babel.get("FKEY"))) != null && foreignID.trim().length() != 0) {
            this.dispose();
            Vector<Cage> v = new Vector<Cage>();
            foreignID = foreignID.toLowerCase().trim();
            Vector allCages = CageManager.cvInstance.getActualObjectVectorAllGroups();
            Iterator iterator = allCages.iterator();
            while (iterator.hasNext()) {
                Cage cage = (Cage)iterator.next();
                System.out.println(cage.getString("IDO_FKEY"));
                if (!foreignID.equalsIgnoreCase(cage.getString("IDO_FKEY", null))) continue;
                v.add(cage);
            }
            if (!v.isEmpty()) {
                TableFrameCage.showCageTable(new MTCage(v), Babel.get("FOUNDCAGES"), Babel.get("FOUNDCAGES"));
            } else {
                Alert.showAlert(Babel.get("CAGE_NOT_FOUND"), true);
            }
        }
    }

    private void selectCages(String comm) {
        Vector<Cage> erg = new Vector<Cage>();
        Vector v = CageManager.cvInstance.getActualObjectVectorAllGroups();
        if (comm.equals(HIGHLIGHT_MARKED_CAGES)) {
            Iterator iter = v.iterator();
            while (iter.hasNext()) {
                Cage c = (Cage)iter.next();
                if (c.getChar("CAG_FLAG") == '\u0000') continue;
                erg.add(c);
            }
        } else if (comm.equals(HIGHLIGHT_CAGES_WITH_UNTAGGED_MICE_WITH_BREEDER)) {
            Iterator iter = v.iterator();
            while (iter.hasNext()) {
                Cage c = (Cage)iter.next();
                if (!c.hasUntaggedMice(true, c.getActualMice())) continue;
                erg.add(c);
            }
        } else if (comm.equals(HIGHLIGHT_CAGES_WITH_UNTAGGED_MICE_NO_BREEDER)) {
            Iterator iter = v.iterator();
            while (iter.hasNext()) {
                Cage c = (Cage)iter.next();
                if (!c.hasUntaggedMice(false, c.getActualMice())) continue;
                erg.add(c);
            }
        } else if (comm.equals(HIGHLIGHT_MATING_CAGES)) {
            Iterator iter = v.iterator();
            while (iter.hasNext()) {
                Cage c = (Cage)iter.next();
                if (!c.isMatingCage()) continue;
                erg.add(c);
            }
        } else if (comm.equals(HIGHLIGHT_CAGES_WITH_TASKS)) {
            Iterator iter = v.iterator();
            while (iter.hasNext()) {
                Cage c = (Cage)iter.next();
                if (c.getTaskCount() <= 0) continue;
                erg.add(c);
            }
        } else if (comm.startsWith(HIGHLIGHT_CAGES__WITH_NUMBER)) {
            int num = Integer.parseInt(comm.substring(HIGHLIGHT_CAGES__WITH_NUMBER.length(), comm.length()).trim());
            Iterator iter = v.iterator();
            while (iter.hasNext()) {
                Cage c = (Cage)iter.next();
                if (c.getIntNumber() != num) continue;
                erg.add(c);
            }
        }
        this.digestFoundCages(erg);
    }

    private void digestFoundCages(Vector v) {
        this.ivActSelection = HighlightCageBeutel.digestFoundCages(v);
        this.ivShowButton.setEnabled(false);
        this.ivList.setListData(this.ivActSelection);
    }

    private void highlightAndDispose() {
        HighlightCageBeutel hcb = (HighlightCageBeutel)this.ivList.getSelectedValue();
        if (hcb != null && hcb.ivClickable && !hcb.ivTransferArea) {
            Vector erg = new Vector();
            erg.addAll(hcb.ivCages);
            Iterator iterator = this.ivActSelection.iterator();
            while (iterator.hasNext()) {
                hcb = (HighlightCageBeutel)iterator.next();
                if (!hcb.ivTransferArea) continue;
                erg.addAll(hcb.ivCages);
            }
            RackFrame.showCagePosition(erg);
            this.dispose();
        }
    }

    public void valueChanged(ListSelectionEvent e) {
        HighlightCageBeutel hcb = (HighlightCageBeutel)this.ivList.getSelectedValue();
        if (hcb == null) {
            this.ivShowButton.setEnabled(false);
        } else if (hcb.ivClickable) {
            this.ivShowButton.setEnabled(true);
        } else {
            this.ivShowButton.setEnabled(false);
        }
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        HighlightCageBeutel hcb = (HighlightCageBeutel)value;
        if (hcb.ivClickable && isSelected) {
            this.ivLabel.setBackground(Color.orange);
        } else if (hcb.ivClickable) {
            this.ivLabel.setBackground(Color.white);
        } else {
            this.ivLabel.setBackground(Color.lightGray);
        }
        if (hcb.ivVisible) {
            this.ivLabel.setFont(FontManager.getFont("SSB12"));
        } else {
            this.ivLabel.setFont(FontManager.getFont("SSI12"));
        }
        this.ivLabel.setText(" " + hcb.ivRackName + " (" + hcb.ivCages.size() + " " + Babel.get(hcb.ivCages.size() == 1 ? "CAGE_FHCR" : "CAGES_FHCR") + ") ");
        return this.ivLabel;
    }
}

