/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.requester.calendar;

import de.hannse.netobjects.network.client.TimeMachine;
import de.hannse.netobjects.util.Babel;
import de.hannse.netobjects.util.MyDate;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.TreeMap;
import javax.swing.JPanel;
import mausoleum.gui.MToggleButton;
import mausoleum.gui.ScrollBarButton;
import mausoleum.helper.FontManager;
import mausoleum.ui.UIDef;
import mausoleum.util.calendar.InstituteHolidays;

public class CalendarPanel
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private static final int MARGIN = UIDef.getScaled(10);
    private static final int YEARWIDTH = UIDef.getScaled(50);
    private static final int MONTHWIDTH = UIDef.getScaled(80);
    private static final int DAYWIDTH = UIDef.getScaled(32);
    private static final int DAYHEIGHT = UIDef.getScaled(32);
    private static final int MONTHHEIGHT = DAYHEIGHT / 2;
    private static final int DAYSTART = 0;
    private static final int MONTHSTART = 0 + 7 * DAYWIDTH + MARGIN;
    private static final int YEARSTART = MONTHSTART + MONTHWIDTH + MARGIN;
    public static final int BREITE = YEARSTART + YEARWIDTH;
    public static final int HOEHE = 6 * DAYHEIGHT;
    public static final Dimension MY_DIM = new Dimension(BREITE, HOEHE);
    private static final int ANZ_JAHRE = 7;
    private static final int YEAR_HEIGHT = HOEHE / 8;
    private static String[] cvMonthNames = new String[]{Babel.get("JANUARY"), Babel.get("FEBRUARY"), Babel.get("MARCH"), Babel.get("APRIL"), Babel.get("MAY"), Babel.get("JUNE"), Babel.get("JULY"), Babel.get("AUGUST"), Babel.get("SEPTEMBER"), Babel.get("OCTOBER"), Babel.get("NOVEMBER"), Babel.get("DECEMBER")};
    private MToggleButton[] ivYearButtons = new MToggleButton[7];
    private MToggleButton[] ivMonthButtons = new MToggleButton[12];
    private MToggleButton[] ivDayButtons;
    private MyDate ivMyDate = MyDate.getMyDate(TimeMachine.getCurrentMillis());
    private MyDate ivMinimum = null;
    private MyDate ivMaximum = null;
    private JPanel ivDayPanel = new JPanel(null);
    private int ivStartYear = 0;
    private HashSet ivAllowedDays = null;

    public CalendarPanel(MyDate minimum, MyDate maximum) {
        this(minimum, maximum, null);
    }

    public CalendarPanel(MyDate minimum, MyDate maximum, MyDate selectedDate) {
        this.setOpaque(false);
        this.setLayout(null);
        if (selectedDate != null) {
            this.ivMyDate = selectedDate;
        }
        this.ivMinimum = minimum;
        this.ivMaximum = maximum;
        if (this.ivMinimum != null && this.ivMaximum != null && this.ivMinimum.getTime() > this.ivMaximum.getTime()) {
            throw new IllegalArgumentException();
        }
        this.checkBoundaries();
        this.ivDayPanel.setBounds(0, 0, 7 * DAYWIDTH, 6 * DAYHEIGHT);
        this.ivDayPanel.setOpaque(false);
        this.add(this.ivDayPanel);
        if (this.ivMinimum == null && this.ivMaximum == null) {
            this.addYearButtons(this.ivMyDate.ivJahr - 3);
        } else if (this.ivMinimum != null && this.ivMaximum == null) {
            this.addYearButtons(this.ivMyDate.ivJahr - 1);
        } else if (this.ivMinimum == null && this.ivMaximum != null) {
            this.addYearButtons(this.ivMyDate.ivJahr - 5);
        } else if (this.ivMinimum != null && this.ivMaximum != null) {
            this.addYearButtons(this.ivMyDate.ivJahr - 3);
        }
        this.addMonthButtons();
        this.adjustMonthButtons();
        this.createDayMask();
    }

    public Date getSelectedDate() {
        GregorianCalendar greg = new GregorianCalendar();
        greg.set(this.ivMyDate.ivJahr, this.ivMyDate.ivMonat - 1, this.ivMyDate.ivTag);
        return new Date(greg.getTimeInMillis());
    }

    public MyDate getSelectedMyDate() {
        return this.ivMyDate;
    }

    public int getSelectedDatumInt() {
        return MyDate.getTage(this.ivMyDate.ivTag, this.ivMyDate.ivMonat, this.ivMyDate.ivJahr);
    }

    public void setAllowedDays(HashSet allowedDays) {
        this.ivAllowedDays = allowedDays;
        this.createDayMask();
    }

    private void addYearButtons(int startYear) {
        this.ivStartYear = startYear;
        int ysbw = YEAR_HEIGHT / 2;
        ScrollBarButton yearUpButton = new ScrollBarButton(3);
        yearUpButton.setBounds(YEARSTART + (YEARWIDTH - ysbw) / 2, 0, ysbw, ysbw);
        yearUpButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                CalendarPanel calendarPanel = CalendarPanel.this;
                calendarPanel.ivStartYear = calendarPanel.ivStartYear - 1;
                CalendarPanel.this.adjustYearButtons();
                CalendarPanel.this.repaint();
            }
        });
        this.add(yearUpButton);
        int y = ysbw;
        int i = 0;
        while (i < 7) {
            this.ivYearButtons[i] = new MToggleButton("");
            this.ivYearButtons[i].addActionListener(this);
            this.ivYearButtons[i].setBounds(YEARSTART, y, YEARWIDTH, YEAR_HEIGHT);
            this.add(this.ivYearButtons[i]);
            y += YEAR_HEIGHT;
            ++i;
        }
        ScrollBarButton ivYearDownButton = new ScrollBarButton(4);
        ivYearDownButton.setBounds(YEARSTART + (YEARWIDTH - ysbw) / 2, y, ysbw, ysbw);
        ivYearDownButton.addActionListener(this);
        ivYearDownButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                CalendarPanel calendarPanel = CalendarPanel.this;
                calendarPanel.ivStartYear = calendarPanel.ivStartYear + 1;
                CalendarPanel.this.adjustYearButtons();
                CalendarPanel.this.repaint();
            }
        });
        this.add(ivYearDownButton);
        this.adjustYearButtons();
    }

    private void adjustYearButtons() {
        int i = 0;
        while (i < this.ivYearButtons.length) {
            this.ivYearButtons[i].setText(Integer.toString(this.ivStartYear + i));
            this.ivYearButtons[i].setActionCommand("YEAR" + i);
            this.ivYearButtons[i].ivReactsInPressedState = false;
            boolean enabled = true;
            if (this.ivMinimum != null && this.ivStartYear + i < this.ivMinimum.ivJahr) {
                enabled = false;
            }
            if (this.ivMaximum != null && this.ivStartYear + i > this.ivMaximum.ivJahr) {
                enabled = false;
            }
            this.ivYearButtons[i].setEnabled(enabled);
            this.ivYearButtons[i].setPressed(this.ivStartYear + i == this.ivMyDate.ivJahr);
            ++i;
        }
    }

    private void addMonthButtons() {
        int i = 0;
        while (i < 12) {
            MToggleButton mb = new MToggleButton(cvMonthNames[i]);
            mb.ivReactsInPressedState = false;
            mb.setActionCommand("MONTH" + i);
            mb.setFont(FontManager.getFont("SSB11"));
            this.ivMonthButtons[i] = mb;
            mb.addActionListener(this);
            mb.setBounds(MONTHSTART, MONTHHEIGHT * i, MONTHWIDTH, MONTHHEIGHT);
            this.add(mb);
            ++i;
        }
    }

    private void adjustMonthButtons() {
        int[] state = new int[12];
        int i = 0;
        while (i < 12) {
            state[i] = 1;
            ++i;
        }
        if (this.ivMinimum != null && this.ivMyDate.ivJahr == this.ivMinimum.ivJahr) {
            i = 0;
            while (i < 12) {
                if (i + 1 < this.ivMinimum.ivMonat) {
                    state[i] = 0;
                }
                ++i;
            }
        }
        if (this.ivMaximum != null && this.ivMyDate.ivJahr == this.ivMaximum.ivJahr) {
            i = 0;
            while (i < 12) {
                if (i + 1 > this.ivMaximum.ivMonat) {
                    state[i] = 0;
                }
                ++i;
            }
        }
        state[this.ivMyDate.ivMonat - 1] = 3;
        i = 0;
        while (i < 12) {
            this.ivMonthButtons[i].adjustToState(state[i]);
            ++i;
        }
    }

    private boolean isDayPresent(int day) {
        if (this.ivMinimum != null && this.ivMyDate.ivJahr == this.ivMinimum.ivJahr && this.ivMyDate.ivMonat == this.ivMinimum.ivMonat && day < this.ivMinimum.ivTag) {
            return false;
        }
        if (this.ivMaximum != null && this.ivMyDate.ivJahr == this.ivMaximum.ivJahr && this.ivMyDate.ivMonat == this.ivMaximum.ivMonat && day > this.ivMaximum.ivTag) {
            return false;
        }
        if (this.ivAllowedDays != null) {
            return this.ivAllowedDays.contains(new Integer(MyDate.getTage(day, this.ivMyDate.ivMonat, this.ivMyDate.ivJahr)));
        }
        return true;
    }

    private void createDayMask() {
        if (this.ivDayButtons != null) {
            int i = 0;
            while (i < this.ivDayButtons.length) {
                this.ivDayButtons[i].removeActionListener(this);
                this.ivDayButtons[i] = null;
                ++i;
            }
        }
        this.ivDayPanel.removeAll();
        int start = MyDate.getWochentag(1, this.ivMyDate.ivMonat, this.ivMyDate.ivJahr);
        int anz = MyDate.getTageImMonat(this.ivMyDate.ivMonat, this.ivMyDate.ivJahr);
        this.ivDayButtons = new MToggleButton[anz];
        TreeMap holidays = InstituteHolidays.getHolidayNamesByDate(this.ivMyDate.ivJahr);
        int bcol = start;
        int brow = 0;
        int absStartDate = MyDate.getTage(1, this.ivMyDate.ivMonat, this.ivMyDate.ivJahr);
        int i = 0;
        while (i < anz) {
            this.ivDayButtons[i] = new MToggleButton(Integer.toString(i + 1));
            this.ivDayButtons[i].ivReactsInPressedState = false;
            this.ivDayButtons[i].setActionCommand("DAY" + Integer.toString(i + 1));
            this.ivDayButtons[i].addActionListener(this);
            this.ivDayButtons[i].setFont(FontManager.getFont("SSB16"));
            this.ivDayButtons[i].setBounds(bcol * DAYWIDTH, brow * DAYHEIGHT, DAYWIDTH, DAYHEIGHT);
            this.ivDayPanel.add(this.ivDayButtons[i]);
            if (i + 1 == this.ivMyDate.ivTag) {
                this.ivDayButtons[i].setPressed(true);
            }
            this.ivDayButtons[i].setEnabled(this.isDayPresent(i + 1));
            Integer key = new Integer(absStartDate + i);
            String bez = (String)holidays.get(key);
            if (bez != null) {
                this.ivDayButtons[i].setImageKey("redButton");
                this.ivDayButtons[i].setToolTipText(bez);
            } else if (InstituteHolidays.isWeeklyDayOff(bcol)) {
                this.ivDayButtons[i].setImageKey("yellowButton");
            }
            if (++bcol > 6) {
                ++brow;
                bcol = 0;
            }
            ++i;
        }
        this.ivDayPanel.repaint();
    }

    private void checkBoundaries() {
        int numdd;
        if (this.ivMinimum != null && this.ivMyDate.ivJahr == this.ivMinimum.ivJahr) {
            if (this.ivMyDate.ivMonat < this.ivMinimum.ivMonat) {
                this.ivMyDate.ivMonat = this.ivMinimum.ivMonat;
            }
            if (this.ivMyDate.ivMonat == this.ivMinimum.ivMonat && this.ivMyDate.ivTag < this.ivMinimum.ivTag) {
                this.ivMyDate.ivTag = this.ivMinimum.ivTag;
            }
        }
        if (this.ivMaximum != null && this.ivMyDate.ivJahr == this.ivMaximum.ivJahr) {
            if (this.ivMyDate.ivMonat > this.ivMaximum.ivMonat) {
                this.ivMyDate.ivMonat = this.ivMaximum.ivMonat;
            }
            if (this.ivMyDate.ivMonat == this.ivMaximum.ivMonat && this.ivMyDate.ivTag > this.ivMaximum.ivTag) {
                this.ivMyDate.ivTag = this.ivMaximum.ivTag;
            }
        }
        if ((numdd = MyDate.getTageImMonat(this.ivMyDate.ivMonat, this.ivMyDate.ivJahr)) < this.ivMyDate.ivTag) {
            this.ivMyDate.ivTag = numdd;
        }
    }

    public void actionPerformed(ActionEvent e) {
        String nr;
        int d;
        String comm = e.getActionCommand();
        if (comm.startsWith("YEAR")) {
            MToggleButton mtb = (MToggleButton)e.getSource();
            this.ivMyDate.ivJahr = Integer.parseInt(mtb.getLabel());
            int i = 0;
            while (i < this.ivYearButtons.length) {
                if (this.ivYearButtons[i] != mtb) {
                    this.ivYearButtons[i].setPressed(false);
                    this.ivYearButtons[i].repaint();
                }
                ++i;
            }
            this.checkBoundaries();
            this.adjustMonthButtons();
            this.createDayMask();
        } else if (comm.startsWith("MONTH")) {
            MToggleButton mtb = (MToggleButton)e.getSource();
            int i = 0;
            while (i < this.ivMonthButtons.length) {
                if (this.ivMonthButtons[i] != mtb) {
                    this.ivMonthButtons[i].setPressed(false);
                    this.ivMonthButtons[i].repaint();
                } else {
                    this.ivMyDate.ivMonat = i + 1;
                }
                ++i;
            }
            this.checkBoundaries();
            this.createDayMask();
        } else if (comm.startsWith("DAY") && (d = Integer.parseInt(nr = comm.substring(3, comm.length()))) != this.ivMyDate.ivTag) {
            try {
                this.ivDayButtons[this.ivMyDate.ivTag - 1].setPressed(false);
                this.ivDayButtons[this.ivMyDate.ivTag - 1].repaint();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.ivMyDate.ivTag = d;
        }
    }

    public Dimension getPreferredSize() {
        return MY_DIM;
    }
}

