/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.requester.massmating;

import de.hannse.netobjects.util.Babel;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collections;
import java.util.Comparator;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import mausoleum.helper.WindowUtils;
import mausoleum.mouse.Mouse;
import mausoleum.requester.massmating.MassMatingRequester;
import mausoleum.ui.UIDef;
import mausoleum.ui.table.NiceRegularTable;

public class MassMatingMouseTable
implements TableModel {
    private static final int SORT_ET_UP = 1;
    private static final int SORT_ET_DOWN = -1;
    private static final int SORT_POS_UP = 2;
    private static final int SORT_POS_DOWN = -2;
    public final MassMatingRequester ivRequester;
    public final NiceRegularTable ivTable;
    public final Vector ivMice;
    public final String ivBasicTitle;
    private final JLabel ivJLabel = new JLabel();
    private int ivSort = 2;
    private Comparator ivComparator = new Comparator(){

        public int compare(Object o1, Object o2) {
            int res = 0;
            if (o1 instanceof Mouse && o2 instanceof Mouse) {
                Mouse mouse1 = (Mouse)o1;
                Mouse mouse2 = (Mouse)o2;
                if (MassMatingMouseTable.this.ivSort == 1 || MassMatingMouseTable.this.ivSort == -1) {
                    res = mouse1.getCLLWEartagString().compareToIgnoreCase(mouse2.getCLLWEartagString());
                } else {
                    String s1 = (String)MassMatingMouseTable.this.ivRequester.ivPosStringsByMouse.get(mouse1);
                    String s2 = (String)MassMatingMouseTable.this.ivRequester.ivPosStringsByMouse.get(mouse2);
                    res = s1.compareToIgnoreCase(s2);
                }
            }
            if (MassMatingMouseTable.this.ivSort < 0) {
                res = -res;
            }
            return res;
        }
    };
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public MassMatingMouseTable(Vector mice, MassMatingRequester req, boolean multiSelect, String basicTitle) {
        this.ivMice = mice;
        this.ivRequester = req;
        Collections.sort(this.ivMice, this.ivComparator);
        this.ivTable = new NiceRegularTable(this);
        this.ivTable.getSelectionModel().setSelectionMode(multiSelect ? 2 : 0);
        this.ivTable.getColumnModel().getColumn(0).setPreferredWidth(50);
        this.ivTable.getColumnModel().getColumn(1).setPreferredWidth(100);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("mausoleum.mouse.Mouse");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.ivTable.setDefaultRenderer(clazz, new TableCellRenderer(){

            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Mouse mouse = (Mouse)value;
                JComponent comp = null;
                if (column == 0) {
                    MassMatingMouseTable.this.ivJLabel.setText(" " + mouse.getCLLWSexString("") + " " + mouse.getCLLWEartagString() + " ");
                    comp = MassMatingMouseTable.this.ivJLabel;
                } else {
                    comp = (JComponent)MassMatingMouseTable.this.ivRequester.ivPosLabelsByMouse.get(mouse);
                }
                if (comp != null) {
                    comp.setOpaque(isSelected);
                    comp.setBackground(isSelected ? UIDef.SELECTED_BACKGROUND : null);
                }
                return comp;
            }
        });
        this.ivTable.getTableHeader().addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                int col = MassMatingMouseTable.this.ivTable.getTableHeader().columnAtPoint(e.getPoint());
                if (col == 0) {
                    MassMatingMouseTable.this.ivSort = MassMatingMouseTable.this.ivSort == 1 ? -1 : 1;
                    MassMatingMouseTable.this.miceChanged();
                } else if (col == 1) {
                    MassMatingMouseTable.this.ivSort = MassMatingMouseTable.this.ivSort == 2 ? -2 : 2;
                    MassMatingMouseTable.this.miceChanged();
                }
            }
        });
        this.ivBasicTitle = basicTitle;
    }

    public void addMouse(Mouse mm) {
        this.ivMice.add(mm);
        this.miceChanged();
    }

    public void addMice(Vector v) {
        this.ivMice.addAll(v);
        this.miceChanged();
    }

    public void removeMouse(Mouse mm) {
        this.ivMice.remove(mm);
        this.miceChanged();
    }

    public void removeMice(Vector mice) {
        this.ivMice.removeAll(mice);
        this.miceChanged();
    }

    public Mouse popMouse() {
        if (!this.ivMice.isEmpty()) {
            Mouse res = (Mouse)this.ivMice.firstElement();
            this.ivMice.removeElementAt(0);
            return res;
        }
        return null;
    }

    public void miceChanged() {
        if (this.ivMice.size() > 1) {
            Collections.sort(this.ivMice, this.ivComparator);
        }
        this.ivTable.tableChanged(new TableModelEvent(this));
        this.arrangeRowHeights();
    }

    public void arrangeRowHeights() {
        Border border;
        JPanel panel;
        int row = 0;
        while (row < this.ivMice.size()) {
            Mouse mouse = (Mouse)this.ivMice.elementAt(row);
            int rh = 16;
            JComponent lab = (JComponent)this.ivRequester.ivPosLabelsByMouse.get(mouse);
            if (lab != null) {
                int wrh = lab.getPreferredSize().height;
                int n = rh = wrh > rh ? wrh : rh;
            }
            if (this.ivTable.getRowHeight(row) != rh) {
                this.ivTable.setRowHeight(row, rh);
            }
            ++row;
        }
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("javax.swing.JPanel");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((panel = (JPanel)WindowUtils.getParent(this.ivTable, clazz)) != null && (border = panel.getBorder()) != null && border instanceof TitledBorder) {
            TitledBorder tb = (TitledBorder)border;
            StringBuilder msb = new StringBuilder();
            msb.append(" ").append(this.ivBasicTitle).append(" ");
            if (!this.ivMice.isEmpty()) {
                msb.append("[").append(this.ivMice.size()).append("] ");
            }
            tb.setTitle(msb.toString());
            panel.repaint();
        }
    }

    public int getRowCount() {
        return this.ivMice.size();
    }

    public int getColumnCount() {
        return 2;
    }

    public String getColumnName(int columnIndex) {
        return Babel.get(columnIndex == 0 ? "MOUSE" : "RACK_POS");
    }

    public Class getColumnClass(int columnIndex) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("mausoleum.mouse.Mouse");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        return this.ivMice.elementAt(rowIndex);
    }

    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
    }

    public void addTableModelListener(TableModelListener l) {
    }

    public void removeTableModelListener(TableModelListener l) {
    }
}

