/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.requester.massmating;

import de.hannse.netobjects.objectstore.IDObject;
import de.hannse.netobjects.objectstore.ObjectStore;
import de.hannse.netobjects.tools.StringHelper;
import de.hannse.netobjects.util.Babel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import mausoleum.cage.Cage;
import mausoleum.gui.MGButton;
import mausoleum.gui.RequesterPane;
import mausoleum.gui.SimpleLayoutManager;
import mausoleum.helper.FontManager;
import mausoleum.helper.WindowUtils;
import mausoleum.inspector.Inspector;
import mausoleum.inspector.actions.mouse.MATransfer;
import mausoleum.mouse.Mouse;
import mausoleum.mouse.TaskRudelBums;
import mausoleum.rack.Rack;
import mausoleum.rack.RackPos;
import mausoleum.requester.AllgChoiceRequester;
import mausoleum.requester.massmating.MassMating;
import mausoleum.requester.massmating.MassMatingMatingTable;
import mausoleum.requester.massmating.MassMatingMouseTable;
import mausoleum.room.Room;
import mausoleum.tables.MausoleumTable;
import mausoleum.tables.MausoleumTableModel;
import mausoleum.tables.models.MTMouseMMR;
import mausoleum.tables.models.MTRoomMMR;
import mausoleum.task.DisplayTask;
import mausoleum.ui.UIDef;

public class MassMatingRequester
extends JDialog {
    private static final long serialVersionUID = 1234234234L;
    private static final String[] AUTO_LIMITS = new String[]{Babel.get("MMR_AUTO_NO_LIMIT"), Babel.get("MMR_AUTO_LIMIT_1_1"), Babel.get("MMR_AUTO_LIMIT_1_2"), Babel.get("MMR_AUTO_LIMIT_1_3"), Babel.get("MMR_AUTO_LIMIT_1_4")};
    private static final int[] AUTO_LIMIT_INTS = new int[]{Integer.MAX_VALUE, 1, 2, 3, 4};
    public final HashMap ivPosLabelsByMouse;
    public final HashMap ivPosStringsByMouse;
    private MassMatingMouseTable ivFemalesTable;
    private MassMatingMouseTable ivMalesTable;
    private MassMatingMatingTable ivMatingsTable;
    private JPanel ivFemalesPane = new JPanel(new BorderLayout());
    private JPanel ivMalesPane = new JPanel(new BorderLayout());
    private JPanel ivMatingsPane = new JPanel(new BorderLayout());
    private MGButton ivMatingButton = new MGButton(Babel.get("MMR_MARK_FOR_MATING"));
    private MGButton ivAutoButton = new MGButton(Babel.get("MMR_AUTO_MATING_MARK"));
    private MGButton ivDivorceButton = new MGButton(Babel.get("MMR_SPLIT_MATING"));
    private MGButton ivFinishButton = new MGButton(Babel.get("MMR_FINISH_MATINGS"));
    private final String ivCommonGroup;
    private final DisplayTask ivModelTask;

    public static void arrangeMassMating(Vector displayTasks, String commonGroup) {
        boolean doit;
        Vector<Mouse> females = new Vector<Mouse>();
        Vector<Mouse> males = new Vector<Mouse>();
        HashMap<Mouse, JComponent> labelsByMouse = new HashMap<Mouse, JComponent>();
        HashMap<Mouse, String> stringsByMouse = new HashMap<Mouse, String>();
        Vector<Mouse> noSex = new Vector<Mouse>();
        Vector<Mouse> noCage = new Vector<Mouse>();
        Vector<Mouse> notAlone = new Vector<Mouse>();
        HashSet<Long> roomIDs = new HashSet<Long>();
        Vector<Room> inaccesibleRooms = new Vector<Room>();
        Vector<Mouse> actualMice = new Vector<Mouse>();
        Iterator iterator = displayTasks.iterator();
        while (iterator.hasNext()) {
            DisplayTask dt = (DisplayTask)iterator.next();
            Mouse mouse = (Mouse)dt.getUnderlying();
            boolean takeit = false;
            int sex = mouse.getSex();
            if (sex != 0) {
                Rack rack;
                if (sex == 1) {
                    Cage cage = mouse.getActCage();
                    if (cage != null) {
                        actualMice.clear();
                        cage.addActualMice(actualMice);
                        if (actualMice.size() != 1) {
                            notAlone.add(mouse);
                        } else {
                            males.add(mouse);
                            takeit = true;
                        }
                    } else {
                        noCage.add(mouse);
                    }
                } else if (sex == 2) {
                    females.add(mouse);
                    takeit = true;
                }
                if (!takeit) continue;
                Long roomID = null;
                JComponent bild = null;
                String posString = null;
                int cagnr = -1;
                Cage cage = mouse.getActCage();
                if (cage != null) {
                    cagnr = cage.getIntNumber();
                }
                if ((rack = mouse.getRack()) != null) {
                    roomID = (Long)rack.get("RCK_ROOM");
                    RackPos rp = mouse.getRackPos();
                    if (rp != null) {
                        bild = rack.getLabelFor(rp.ivSide, rp.ivRow, rp.ivColumn, sex == 1 ? Color.blue : Color.red, cagnr);
                        posString = String.valueOf(StringHelper.getMLString(rp.ivRackID, 10)) + " " + rp.ivSide + " " + StringHelper.getMLString(rp.ivRow, 2) + " " + StringHelper.getMLString(rp.ivColumn, 2);
                    }
                }
                if (bild == null) {
                    JLabel lab = new JLabel("[" + cagnr + "] " + Babel.get("ORCUS"));
                    lab.setForeground(Color.black);
                    lab.setFont(FontManager.getFont("SSB11"));
                    lab.setVerticalTextPosition(3);
                    lab.setHorizontalTextPosition(0);
                    bild = lab;
                    posString = "ORCUS";
                }
                labelsByMouse.put(mouse, bild);
                stringsByMouse.put(mouse, posString);
                if (roomID == null) continue;
                roomIDs.add(roomID);
                continue;
            }
            noSex.add(mouse);
        }
        TreeMap compsByLabel = new TreeMap();
        int errorNumber = 0;
        boolean fatalError = false;
        if (females.isEmpty()) {
            fatalError = true;
            errorNumber = MassMatingRequester.addMotzTable(males, new MTMouseMMR(), "MMR_NO_FEMALES", compsByLabel, errorNumber);
        }
        if (males.isEmpty()) {
            fatalError = true;
            errorNumber = MassMatingRequester.addMotzTable(males, new MTMouseMMR(), "MMR_NO_MALES", compsByLabel, errorNumber);
        }
        if (females.size() < males.size()) {
            Vector<Mouse> v = new Vector<Mouse>(females.size() + males.size());
            v.addAll(females);
            v.addAll(males);
            errorNumber = MassMatingRequester.addMotzTable(v, new MTMouseMMR(), "MMR_LESS_FEMALES", compsByLabel, errorNumber);
        }
        if (!noSex.isEmpty()) {
            errorNumber = MassMatingRequester.addMotzTable(noSex, new MTMouseMMR(), "MMR_ANIMALS_WITHOUT_SEX", compsByLabel, errorNumber);
        }
        if (!noCage.isEmpty()) {
            errorNumber = MassMatingRequester.addMotzTable(noCage, new MTMouseMMR(), "MMR_MALES_WITHOUT_CAGE", compsByLabel, errorNumber);
        }
        if (!notAlone.isEmpty()) {
            errorNumber = MassMatingRequester.addMotzTable(notAlone, new MTMouseMMR(), "MMR_MALES_NOT_ALONE", compsByLabel, errorNumber);
        }
        if (roomIDs.size() != 1) {
            fatalError = true;
            actualMice.clear();
            Iterator iterator2 = displayTasks.iterator();
            while (iterator2.hasNext()) {
                DisplayTask dt = (DisplayTask)iterator2.next();
                Mouse mouse = (Mouse)dt.getUnderlying();
                if (mouse == null) continue;
                actualMice.add(mouse);
            }
            MTMouseMMR mt = new MTMouseMMR();
            mt.ensurePresenceOfColumn("ROOM", false);
            errorNumber = MassMatingRequester.addMotzTable(actualMice, mt, "MMR_DIFFERENT_ROOMS", compsByLabel, errorNumber);
        }
        Iterator iterator3 = roomIDs.iterator();
        while (iterator3.hasNext()) {
            Long roomID = (Long)iterator3.next();
            Room room = (Room)ObjectStore.getClientObject(10, roomID, commonGroup);
            if (room != null && room.isRoomAccesibilityRestricted()) {
                inaccesibleRooms.add(room);
                fatalError = true;
            }
            errorNumber = MassMatingRequester.addMotzTable(inaccesibleRooms, new MTRoomMMR(), "MMR_ROOM_NOT_ACCESSIBLE", compsByLabel, errorNumber);
        }
        boolean bl = doit = !fatalError;
        if (errorNumber != 0) {
            MassMatingMotzRequester mmmr = new MassMatingMotzRequester(compsByLabel, fatalError);
            doit = mmmr.ivWarOK;
        }
        if (doit) {
            MassMatingRequester mmr = new MassMatingRequester(males, females, labelsByMouse, stringsByMouse, commonGroup, (DisplayTask)displayTasks.firstElement());
            WindowUtils.bringUpCenteredDialog(mmr, UIDef.getScaled(900), UIDef.getScaled(400), true);
        }
    }

    private static int addMotzTable(Vector objects, MausoleumTableModel mtm, String babel, TreeMap compsByLabel, int errorNumber) {
        if (objects != null && !objects.isEmpty()) {
            String label = "[" + ++errorNumber + "] " + Babel.get(babel);
            mtm.setIsSubDisplay();
            mtm.setTable(objects);
            MausoleumTable mt = new MausoleumTable(mtm, false);
            mt.setIsSubdisplay();
            compsByLabel.put(label, mt);
        }
        return errorNumber;
    }

    private MassMatingRequester(Vector males, Vector females, HashMap labelsByMouse, HashMap stringsByMouse, String commonGroup, DisplayTask modelTask) {
        super((Frame)Inspector.getInspector(), true);
        this.setTitle(Babel.get("MMR_TITLE"));
        this.ivCommonGroup = commonGroup;
        this.ivModelTask = modelTask;
        RequesterPane requesterPane = new RequesterPane(new SimpleLayoutManager(){

            public void layoutContainer(Container parent) {
                Dimension d = parent.getSize();
                int x = UIDef.RAND;
                int y = UIDef.RAND;
                int iw = d.width - 2 * UIDef.RAND;
                int ih = d.height - 2 * UIDef.RAND;
                int lbr = (iw - 2 * UIDef.INNER_RAND) / 4;
                int rbr = iw - 2 * UIDef.INNER_RAND - 2 * lbr;
                int oh = ih - UIDef.INNER_RAND - UIDef.BUT_HEIGHT;
                MassMatingRequester.this.ivFemalesPane.setBounds(x, y, lbr, oh);
                MassMatingRequester.this.ivMalesPane.setBounds(x += lbr + UIDef.INNER_RAND, y, lbr, oh);
                MassMatingRequester.this.ivMatingsPane.setBounds(x += lbr + UIDef.INNER_RAND, y, rbr, oh);
                x = UIDef.RAND;
                int nbut = 4;
                int nspc = nbut - 1;
                lbr = (iw - nspc * UIDef.INNER_RAND) / nbut;
                rbr = iw - nspc * UIDef.INNER_RAND - (nbut - 1) * lbr;
                MassMatingRequester.this.ivMatingButton.setBounds(x, y += oh + UIDef.INNER_RAND, lbr, UIDef.BUT_HEIGHT);
                MassMatingRequester.this.ivAutoButton.setBounds(x += lbr + UIDef.INNER_RAND, y, lbr, UIDef.BUT_HEIGHT);
                MassMatingRequester.this.ivDivorceButton.setBounds(x += lbr + UIDef.INNER_RAND, y, lbr, UIDef.BUT_HEIGHT);
                MassMatingRequester.this.ivFinishButton.setBounds(x += lbr + UIDef.INNER_RAND, y, rbr, UIDef.BUT_HEIGHT);
            }
        });
        this.setContentPane(requesterPane);
        this.ivPosLabelsByMouse = labelsByMouse;
        this.ivPosStringsByMouse = stringsByMouse;
        this.ivMalesTable = new MassMatingMouseTable(males, this, false, Babel.get("MMR_MALES"));
        this.ivFemalesTable = new MassMatingMouseTable(females, this, true, Babel.get("MMR_FEMALES"));
        this.ivMatingsTable = new MassMatingMatingTable(this);
        ListSelectionListener lsl = new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    MassMatingRequester.this.checkButtons();
                }
            }
        };
        this.ivMalesTable.ivTable.getSelectionModel().addListSelectionListener(lsl);
        this.ivFemalesTable.ivTable.getSelectionModel().addListSelectionListener(lsl);
        this.ivFemalesPane.setOpaque(false);
        this.ivFemalesPane.setBorder(UIDef.getTitleBorder("MMR_FEMALES"));
        this.ivFemalesPane.add("Center", new JScrollPane(this.ivFemalesTable.ivTable));
        this.ivFemalesTable.arrangeRowHeights();
        this.add(this.ivFemalesPane);
        this.ivMalesPane.setOpaque(false);
        this.ivMalesPane.setBorder(UIDef.getTitleBorder("MMR_MALES"));
        this.ivMalesPane.add("Center", new JScrollPane(this.ivMalesTable.ivTable));
        this.ivMalesTable.arrangeRowHeights();
        this.add(this.ivMalesPane);
        this.ivMatingsTable.ivTable.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                int row;
                if (e.getClickCount() == 2 && (row = ((MassMatingRequester)MassMatingRequester.this).ivMatingsTable.ivTable.rowAtPoint(e.getPoint())) >= 0 && row < ((MassMatingRequester)MassMatingRequester.this).ivMatingsTable.ivMatings.size()) {
                    MassMating mm = (MassMating)((MassMatingRequester)MassMatingRequester.this).ivMatingsTable.ivMatings.elementAt(row);
                    mm.ivPerformed = !mm.ivPerformed;
                    ((MassMatingRequester)MassMatingRequester.this).ivMatingsTable.ivTable.repaint();
                    MassMatingRequester.this.checkButtons();
                }
            }
        });
        this.ivMatingsTable.ivTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    MassMatingRequester.this.ivDivorceButton.setEnabled(((MassMatingRequester)MassMatingRequester.this).ivMatingsTable.ivTable.getSelectedRow() != -1);
                }
            }
        });
        this.ivMatingsPane.setOpaque(false);
        this.ivMatingsPane.setBorder(UIDef.getTitleBorder("MMR_MATINGS"));
        this.ivMatingsPane.add("Center", new JScrollPane(this.ivMatingsTable.ivTable));
        this.ivMatingsTable.arrangeRowHeights();
        this.add(this.ivMatingsPane);
        this.ivMatingButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Mouse male = (Mouse)((MassMatingRequester)MassMatingRequester.this).ivMalesTable.ivMice.elementAt(((MassMatingRequester)MassMatingRequester.this).ivMalesTable.ivTable.getSelectedRow());
                Vector females = new Vector();
                int[] arr = ((MassMatingRequester)MassMatingRequester.this).ivFemalesTable.ivTable.getSelectedRows();
                if (arr != null && arr.length != 0) {
                    int i = 0;
                    while (i < arr.length) {
                        females.add(((MassMatingRequester)MassMatingRequester.this).ivFemalesTable.ivMice.elementAt(arr[i]));
                        ++i;
                    }
                }
                MassMating mm = new MassMating(male, females);
                MassMatingRequester.this.ivMalesTable.removeMouse(male);
                MassMatingRequester.this.ivFemalesTable.removeMice(females);
                MassMatingRequester.this.ivMatingsTable.addMating(mm);
                MassMatingRequester.this.checkButtons();
            }
        });
        this.add(this.ivMatingButton);
        this.ivAutoButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int limitIndex = AllgChoiceRequester.getIndexAnswer(null, Babel.get("MMR_AUTO_SET_LIMIT"), AUTO_LIMITS);
                if (limitIndex != -1) {
                    int limit = AUTO_LIMIT_INTS[limitIndex];
                    int anzMales = ((MassMatingRequester)MassMatingRequester.this).ivMalesTable.ivMice.size();
                    int anzFemales = ((MassMatingRequester)MassMatingRequester.this).ivFemalesTable.ivMice.size();
                    int anzPro = anzFemales / anzMales;
                    int restPro = anzFemales - anzPro * anzMales;
                    if (anzPro >= limit) {
                        anzPro = limit;
                        restPro = 0;
                    }
                    if (anzFemales < anzMales) {
                        anzPro = 1;
                        restPro = 0;
                    }
                    Vector<MassMating> mms = new Vector<MassMating>();
                    int i = 0;
                    while (i < anzMales) {
                        Mouse male = MassMatingRequester.this.ivMalesTable.popMouse();
                        Vector<Mouse> females = new Vector<Mouse>(anzPro + 1);
                        int j = 0;
                        while (j < anzPro) {
                            females.add(MassMatingRequester.this.ivFemalesTable.popMouse());
                            ++j;
                        }
                        if (restPro != 0) {
                            females.add(MassMatingRequester.this.ivFemalesTable.popMouse());
                            --restPro;
                        }
                        mms.add(new MassMating(male, females));
                        ++i;
                    }
                    MassMatingRequester.this.ivFemalesTable.miceChanged();
                    MassMatingRequester.this.ivMalesTable.miceChanged();
                    MassMatingRequester.this.ivMatingsTable.addMatings(mms);
                    MassMatingRequester.this.checkButtons();
                    MassMatingRequester.this.repaint();
                }
            }
        });
        this.add(this.ivAutoButton);
        this.ivDivorceButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MassMating mm = MassMatingRequester.this.ivMatingsTable.getSelectedMassMating();
                if (mm != null) {
                    MassMatingRequester.this.ivMalesTable.addMouse(mm.ivMale);
                    MassMatingRequester.this.ivFemalesTable.addMice(mm.ivFemales);
                    MassMatingRequester.this.ivMatingsTable.removeMating(mm);
                    MassMatingRequester.this.checkButtons();
                    MassMatingRequester.this.repaint();
                }
            }
        });
        this.ivDivorceButton.setEnabled(false);
        this.add(this.ivDivorceButton);
        this.ivFinishButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Date transferDate = new Date();
                Vector<Mouse> paarungsSammler = new Vector<Mouse>();
                Vector<MassMating> entfernte = new Vector<MassMating>();
                Iterator iterator = ((MassMatingRequester)MassMatingRequester.this).ivMatingsTable.ivMatings.iterator();
                while (iterator.hasNext()) {
                    MassMating mm = (MassMating)iterator.next();
                    if (!mm.ivPerformed) continue;
                    paarungsSammler.clear();
                    paarungsSammler.add(mm.ivMale);
                    paarungsSammler.addAll(mm.ivFemales);
                    MATransfer.transferThem(mm.ivFemales, mm.ivMale.getActCageID(-1L), transferDate, paarungsSammler, IDObject.commonGroup(mm.ivFemales), mm.ivFemales, paarungsSammler, "TASK_AC_RUDELBUMS");
                    entfernte.add(mm);
                }
                TaskRudelBums.addExtraTasks(((MassMatingRequester)MassMatingRequester.this).ivMatingsTable.ivMatings, ((MassMatingRequester)MassMatingRequester.this).ivModelTask.ivTask, MassMatingRequester.this.ivCommonGroup);
                ((MassMatingRequester)MassMatingRequester.this).ivMatingsTable.ivMatings.removeAll(entfernte);
                MassMatingRequester.this.ivMatingsTable.matingsChanged();
            }
        });
        this.add(this.ivFinishButton);
        this.checkButtons();
    }

    private void checkButtons() {
        int anzF = this.ivFemalesTable.ivMice.size();
        int anzM = this.ivMalesTable.ivMice.size();
        this.ivAutoButton.setEnabled(anzF != 0 && anzM != 0 && anzF >= anzM);
        int anzFSel = this.ivFemalesTable.ivTable.getSelectedRowCount();
        int anzMSel = this.ivMalesTable.ivTable.getSelectedRowCount();
        this.ivMatingButton.setEnabled(anzFSel >= 1 && anzMSel == 1);
        boolean finishMgl = false;
        Iterator iterator = this.ivMatingsTable.ivMatings.iterator();
        while (iterator.hasNext() && !finishMgl) {
            MassMating mm = (MassMating)iterator.next();
            if (!mm.ivPerformed) continue;
            finishMgl = true;
        }
        this.ivFinishButton.setEnabled(finishMgl);
    }

    public static class MassMatingMotzRequester
    extends JDialog {
        private static final long serialVersionUID = 48641L;
        public boolean ivWarOK = false;
        private JTabbedPane ivTabbedPane = new JTabbedPane();
        private JLabel ivTopLabel = new JLabel(Babel.get("MMR_PROBLEMS_WITH_MASS_MATING"));
        private JLabel ivQuestionLabel = null;
        private MGButton ivOkButton = null;
        private MGButton ivNoButton = null;
        private int ivMinWidth = 700;
        private int ivMinHeight = 500;

        public MassMatingMotzRequester(TreeMap compsByLabel, boolean fatalError) {
            super((Frame)Inspector.getInspector(), true);
            this.setTitle(Babel.get("ALERT"));
            RequesterPane requesterPane = new RequesterPane(new SimpleLayoutManager(this){
                final /* synthetic */ MassMatingMotzRequester this$1;
                {
                    this.this$1 = massMatingMotzRequester;
                }

                public void layoutContainer(Container parent) {
                    Dimension d = parent.getSize();
                    int x = UIDef.RAND;
                    int y = UIDef.RAND;
                    int iw = d.width - 2 * UIDef.RAND;
                    int ih = d.height - 2 * UIDef.RAND;
                    int oh = ih - UIDef.LINE_HEIGHT - UIDef.RAND - UIDef.BUT_HEIGHT - UIDef.RAND - UIDef.LINE_HEIGHT - UIDef.RAND;
                    MassMatingMotzRequester.access$0(this.this$1).setBounds(x, y, iw, UIDef.LINE_HEIGHT);
                    MassMatingMotzRequester.access$1(this.this$1).setBounds(x, y += UIDef.LINE_HEIGHT + UIDef.RAND, iw, oh);
                    MassMatingMotzRequester.access$2(this.this$1).setBounds(x, y += oh + UIDef.RAND, iw, UIDef.LINE_HEIGHT);
                    y += UIDef.LINE_HEIGHT + UIDef.RAND;
                    if (MassMatingMotzRequester.access$3(this.this$1) != null) {
                        int lw = (iw - UIDef.INNER_RAND) / 2;
                        int rw = iw - UIDef.INNER_RAND - lw;
                        MassMatingMotzRequester.access$3(this.this$1).setBounds(x, y, lw, UIDef.BUT_HEIGHT);
                        MassMatingMotzRequester.access$4(this.this$1).setBounds(x += lw + UIDef.INNER_RAND, y, rw, UIDef.BUT_HEIGHT);
                    } else {
                        MassMatingMotzRequester.access$4(this.this$1).setBounds(x, y, iw, UIDef.BUT_HEIGHT);
                    }
                }
            });
            this.ivTabbedPane.setOpaque(false);
            Iterator iterator = compsByLabel.keySet().iterator();
            while (iterator.hasNext()) {
                String label = (String)iterator.next();
                this.ivTabbedPane.addTab(label, (JComponent)compsByLabel.get(label));
            }
            requesterPane.add(this.ivTabbedPane);
            this.ivTopLabel.setFont(FontManager.getFont("SSB18"));
            int lw = this.ivTopLabel.getPreferredSize().width;
            if (lw > this.ivMinWidth) {
                this.ivMinWidth = lw;
            }
            requesterPane.add(this.ivTopLabel);
            this.ivQuestionLabel = new JLabel(Babel.get(fatalError ? "MMR_CANNOT_PERFORM" : "MMR_WANT_PERFORM"));
            this.ivQuestionLabel.setFont(FontManager.getFont("SSB18"));
            this.ivQuestionLabel.setHorizontalAlignment(0);
            lw = this.ivQuestionLabel.getPreferredSize().width;
            if (lw > this.ivMinWidth) {
                this.ivMinWidth = lw;
            }
            requesterPane.add(this.ivQuestionLabel);
            if (!fatalError) {
                this.ivOkButton = MGButton.getRequesterButton(Babel.get("YES"));
                this.ivOkButton.addActionListener(new ActionListener(this){
                    final /* synthetic */ MassMatingMotzRequester this$1;
                    {
                        this.this$1 = massMatingMotzRequester;
                    }

                    public void actionPerformed(ActionEvent e) {
                        this.this$1.ivWarOK = true;
                        this.this$1.setVisible(false);
                    }
                });
                requesterPane.add(this.ivOkButton);
            }
            this.ivNoButton = MGButton.getRequesterButton(Babel.get("NO"));
            this.ivNoButton.addActionListener(new ActionListener(this){
                final /* synthetic */ MassMatingMotzRequester this$1;
                {
                    this.this$1 = massMatingMotzRequester;
                }

                public void actionPerformed(ActionEvent e) {
                    this.this$1.ivWarOK = false;
                    this.this$1.setVisible(false);
                }
            });
            requesterPane.add(this.ivNoButton);
            this.setContentPane(requesterPane);
            this.addComponentListener(new ComponentAdapter(this){
                final /* synthetic */ MassMatingMotzRequester this$1;
                {
                    this.this$1 = massMatingMotzRequester;
                }

                public void componentResized(ComponentEvent e) {
                    Dimension d = this.this$1.getSize();
                    boolean changed = false;
                    if (d.width < MassMatingMotzRequester.access$5(this.this$1)) {
                        d.width = MassMatingMotzRequester.access$5(this.this$1);
                        changed = true;
                    }
                    if (d.height < MassMatingMotzRequester.access$6(this.this$1)) {
                        d.height = MassMatingMotzRequester.access$6(this.this$1);
                        changed = true;
                    }
                    if (changed) {
                        this.this$1.setSize(d);
                    }
                }
            });
            WindowUtils.bringUpCenteredDialog(this, this.ivMinWidth * 3 / 2, this.ivMinHeight * 3 / 2, true);
        }

        static /* synthetic */ JLabel access$0(MassMatingMotzRequester massMatingMotzRequester) {
            return massMatingMotzRequester.ivTopLabel;
        }

        static /* synthetic */ JTabbedPane access$1(MassMatingMotzRequester massMatingMotzRequester) {
            return massMatingMotzRequester.ivTabbedPane;
        }

        static /* synthetic */ JLabel access$2(MassMatingMotzRequester massMatingMotzRequester) {
            return massMatingMotzRequester.ivQuestionLabel;
        }

        static /* synthetic */ MGButton access$3(MassMatingMotzRequester massMatingMotzRequester) {
            return massMatingMotzRequester.ivOkButton;
        }

        static /* synthetic */ MGButton access$4(MassMatingMotzRequester massMatingMotzRequester) {
            return massMatingMotzRequester.ivNoButton;
        }

        static /* synthetic */ int access$5(MassMatingMotzRequester massMatingMotzRequester) {
            return massMatingMotzRequester.ivMinWidth;
        }

        static /* synthetic */ int access$6(MassMatingMotzRequester massMatingMotzRequester) {
            return massMatingMotzRequester.ivMinHeight;
        }
    }
}

