/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.requester.mouse;

import de.hannse.netobjects.util.Babel;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.io.Serializable;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import mausoleum.gui.KomfortTextField;
import mausoleum.gui.MGButton;
import mausoleum.gui.documents.PureIntegerDocument;
import mausoleum.helper.FocusHoler;
import mausoleum.helper.FontManager;
import mausoleum.inspector.Inspector;
import mausoleum.mouse.Mouse;
import mausoleum.requester.BasicRequester;
import mausoleum.ui.UIDef;

public class EartagRequester
extends BasicRequester {
    private static final long serialVersionUID = 1234235L;
    private final KomfortTextField ivEartagField = new KomfortTextField();
    private KomfortTextField ivUpperEartagField = null;
    private final KomfortTextField ivPrefixField = new KomfortTextField();

    public static BigEarTagInfo getEartag(BigEarTagInfo vorschlag, int nextETFromLine, int[] upperLimitTarget) {
        EartagRequester etr = new EartagRequester(vorschlag, nextETFromLine, upperLimitTarget != null);
        new FocusHoler(etr.ivEartagField, 200);
        etr.setVisible(true);
        if (etr.ivWarOK) {
            try {
                if (upperLimitTarget != null) {
                    upperLimitTarget[0] = Integer.parseInt(etr.ivUpperEartagField.getText());
                }
                return new BigEarTagInfo(etr.ivPrefixField.getText(), Integer.parseInt(etr.ivEartagField.getText()));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    private EartagRequester(BigEarTagInfo vorschlag, int nextETFromLine, boolean withRange) {
        super((Frame)Inspector.getInspector(), -1, -1);
        this.prepareEarTagField(this.ivEartagField);
        if (vorschlag != null && vorschlag.ivEarTag != -1) {
            this.ivEartagField.setText(Integer.toString(vorschlag.ivEarTag));
        }
        if (withRange) {
            this.ivUpperEartagField = new KomfortTextField();
            this.prepareEarTagField(this.ivUpperEartagField);
            this.addReturnEqualsOKKeyListener(this.ivUpperEartagField);
        } else {
            this.addReturnEqualsOKKeyListener(this.ivEartagField);
        }
        if (vorschlag != null && vorschlag.ivPrefix != null) {
            this.ivPrefixField.setText(vorschlag.ivPrefix);
        }
        this.ivPrefixField.setFont(FontManager.getFont("SSB13"));
        int fieldWidth = withRange ? UIDef.getScaled(115) : UIDef.getScaled(180);
        int innerwidth = fieldWidth + (withRange ? 2 : 1) * (UIDef.INNER_RAND + fieldWidth);
        int gesWidth = UIDef.RAND + innerwidth + UIDef.RAND;
        int y = UIDef.RAND;
        int x1 = UIDef.RAND;
        int x2 = x1 + fieldWidth + UIDef.INNER_RAND;
        int x3 = x2 + fieldWidth + UIDef.INNER_RAND;
        this.addPermanentLabel(Babel.get("ETR_EARTAG_PREFIX"), x1, y, UIDef.LINE_HEIGHT);
        if (withRange) {
            this.addPermanentLabel(Babel.get("LOWER_LIMIT"), x2, y, UIDef.LINE_HEIGHT);
            this.addPermanentLabel(Babel.get("UPPER_LIMIT"), x3, y, UIDef.LINE_HEIGHT);
        } else {
            this.addPermanentLabel(Babel.get("EARTAG"), x2, y, UIDef.LINE_HEIGHT);
        }
        this.addAndApplyBounds(this.ivPrefixField, x1, y += UIDef.LINE_HEIGHT + UIDef.INNER_RAND, fieldWidth, UIDef.LINE_HEIGHT);
        this.addAndApplyBounds(this.ivEartagField, x2, y, fieldWidth, UIDef.LINE_HEIGHT);
        if (withRange) {
            this.addAndApplyBounds(this.ivUpperEartagField, x3, y, fieldWidth, UIDef.LINE_HEIGHT);
        }
        y += UIDef.LINE_HEIGHT + UIDef.INNER_RAND;
        boolean mitLineETKnopf = nextETFromLine != -1;
        MGButton extraButton = null;
        if (mitLineETKnopf) {
            extraButton = new MGButton(Babel.get("EARTAG_FROM_LINE"));
            extraButton.setActionCommand(Integer.toString(nextETFromLine));
            extraButton.setToolTipText(UIDef.getToolTipString(Babel.get("TT_EARTAG_FROM_LINE")));
            extraButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent arg0) {
                    EartagRequester.this.ivEartagField.setText(arg0.getActionCommand());
                }
            });
            this.addAndApplyBounds(extraButton, x2, y, fieldWidth, UIDef.LINE_HEIGHT);
            y += UIDef.LINE_HEIGHT + UIDef.INNER_RAND;
        }
        int lbw = (innerwidth - UIDef.INNER_RAND) / 2;
        int rbw = innerwidth - UIDef.INNER_RAND - lbw;
        this.applyBounds(this.ivOkButton, x1, y, lbw, UIDef.BUT_HEIGHT);
        this.applyBounds(this.ivNoButton, x1 + lbw + UIDef.INNER_RAND, y, rbw, UIDef.BUT_HEIGHT);
        this.setInnerSize(gesWidth, y += UIDef.BUT_HEIGHT + UIDef.RAND);
        this.checkBut();
    }

    private void prepareEarTagField(KomfortTextField ktf) {
        ktf.setDocument(new PureIntegerDocument(ktf));
        ktf.setFont(FontManager.getFont("SSB13"));
        ktf.setHorizontalAlignment(4);
        ktf.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                ((KomfortTextField)e.getSource()).selectAll();
            }
        });
        ktf.addCaretListener(new CaretListener(){

            public void caretUpdate(CaretEvent arg0) {
                EartagRequester.this.checkBut();
            }
        });
    }

    private void checkBut() {
        boolean enabled;
        boolean bl = enabled = this.ivEartagField.getText().trim().length() != 0;
        if (this.ivUpperEartagField != null) {
            enabled &= this.ivUpperEartagField.getText().trim().length() != 0;
        }
        this.ivOkButton.setEnabled(enabled);
    }

    public static class BigEarTagInfo
    implements Serializable {
        private static final long serialVersionUID = 188547788956122L;
        public String ivPrefix;
        public int ivEarTag;

        public BigEarTagInfo(String prefix, int earTag) {
            this.ivPrefix = prefix != null && prefix.trim().length() != 0 ? prefix.trim() : null;
            this.ivEarTag = earTag;
        }

        public BigEarTagInfo(Mouse mouse) {
            this.ivPrefix = mouse.getString("MOS_ETPF", null);
            this.ivEarTag = mouse.getInt("MOS_EARTAG", -1);
        }

        public boolean matches(Mouse mouse) {
            String mPrefix = mouse.getString("MOS_ETPF", null);
            int mEarTag = mouse.getInt("MOS_EARTAG", -1);
            if (this.ivEarTag != mEarTag) {
                return false;
            }
            return !(this.ivPrefix != null ? !this.ivPrefix.equals(mPrefix) : mPrefix != null);
        }

        public String toString() {
            if (this.ivEarTag > 0) {
                if (this.ivPrefix != null) {
                    return String.valueOf(this.ivPrefix) + Integer.toString(this.ivEarTag);
                }
                return Integer.toString(this.ivEarTag);
            }
            return "";
        }

        public boolean equals(Object obj) {
            if (obj != null && obj instanceof BigEarTagInfo) {
                BigEarTagInfo beti = (BigEarTagInfo)obj;
                if (this.ivEarTag == beti.ivEarTag) {
                    if (this.ivPrefix == null) {
                        return beti.ivPrefix == null;
                    }
                    return this.ivPrefix.equals(beti.ivPrefix);
                }
            }
            return false;
        }
    }
}

