/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.requester.mouse;

import de.hannse.netobjects.util.Babel;
import java.awt.Frame;
import java.util.Vector;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import mausoleum.mouse.Mouse;
import mausoleum.requester.BasicRequester;
import mausoleum.tables.MausoleumTable;
import mausoleum.tables.MausoleumTableModel;
import mausoleum.tables.MausoleumTableSelectionListener;
import mausoleum.tables.models.MTMouse;
import mausoleum.ui.UIDef;

public class SelectMouseRequester
extends BasicRequester
implements MausoleumTableSelectionListener {
    private static final long serialVersionUID = 1L;
    private static final int MARGIN = UIDef.getScaled(10);
    private static final int BUT_HEIGHT = UIDef.getScaled(40);
    private static final int BREITE = UIDef.getScaled(650);
    private static final int HOEHE = UIDef.getScaled(420);
    private static final int HOHE_HOEHE = HOEHE + UIDef.getScaled(20);
    private Mouse ivTempSelectedMouse = null;
    private Mouse ivSelectedMouse = null;

    public static Mouse getSelectedMouse(Frame sender, Vector choosableMice) {
        SelectMouseRequester smr = new SelectMouseRequester(sender, choosableMice);
        smr.setVisible(true);
        return smr.ivSelectedMouse;
    }

    public static Mouse getSelectedMouse(Frame sender, Vector[] choosableMice, String[] titels) {
        SelectMouseRequester smr = new SelectMouseRequester(sender, choosableMice, titels);
        smr.setVisible(true);
        return smr.ivSelectedMouse;
    }

    private SelectMouseRequester(Frame sender, Vector choosableMice) {
        super(sender, BREITE, HOEHE);
        this.setTitle(Babel.get("SELECT_MOUSE"));
        int lbw = (BREITE - 3 * MARGIN) / 2;
        int rbw = BREITE - 3 * MARGIN - lbw;
        this.applyBounds(this.ivOkButton, MARGIN, HOEHE - BUT_HEIGHT - MARGIN, lbw, BUT_HEIGHT);
        this.applyBounds(this.ivNoButton, 2 * MARGIN + lbw, HOEHE - BUT_HEIGHT - MARGIN, rbw, BUT_HEIGHT);
        MTMouse mouseTableModel = new MTMouse();
        mouseTableModel.addSelectionListener(this);
        mouseTableModel.setToNonExecutable();
        MausoleumTable mouseTable = new MausoleumTable(mouseTableModel, false);
        mouseTable.setIsSubdisplay();
        mouseTable.setOwnerButtonState(true);
        mouseTable.ivModel.setTable(choosableMice);
        this.addAndApplyBounds(mouseTable, MARGIN, MARGIN, BREITE - 2 * MARGIN, HOEHE - 3 * MARGIN - BUT_HEIGHT);
        this.ivOkButton.setEnabled(false);
    }

    private SelectMouseRequester(Frame sender, Vector[] choosableMice, String[] titels) {
        super(sender, BREITE, HOHE_HOEHE);
        this.setTitle(Babel.get("SELECT_MOUSE"));
        int lbw = (BREITE - 3 * MARGIN) / 2;
        int rbw = BREITE - 3 * MARGIN - lbw;
        this.applyBounds(this.ivOkButton, MARGIN, HOHE_HOEHE - UIDef.getScaled(50), lbw, BUT_HEIGHT);
        this.applyBounds(this.ivNoButton, 2 * MARGIN + lbw, HOHE_HOEHE - UIDef.getScaled(50), rbw, BUT_HEIGHT);
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                JTabbedPane pane = (JTabbedPane)evt.getSource();
                int sel = pane.getSelectedIndex();
                MausoleumTable mouseTable = (MausoleumTable)pane.getComponentAt(sel);
                SelectMouseRequester.this.selectionChanged(mouseTable.ivModel);
            }
        });
        int i = 0;
        while (i < choosableMice.length) {
            MTMouse mouseTableModel = new MTMouse();
            mouseTableModel.addSelectionListener(this);
            mouseTableModel.setToNonExecutable();
            MausoleumTable mouseTable = new MausoleumTable(mouseTableModel, false);
            mouseTable.setIsSubdisplay();
            mouseTable.setOwnerButtonState(true);
            mouseTable.ivModel.setTable(choosableMice[i]);
            tabbedPane.addTab(titels[i], mouseTable);
            ++i;
        }
        this.addAndApplyBounds(tabbedPane, MARGIN, MARGIN, BREITE - 2 * MARGIN, HOHE_HOEHE - 3 * MARGIN - BUT_HEIGHT);
        this.ivOkButton.setEnabled(false);
    }

    public void OKPressed() {
        this.ivSelectedMouse = this.ivTempSelectedMouse;
        super.OKPressed();
    }

    public void selectionChanged(MausoleumTableModel mt) {
        Vector selMice = mt.getSelectedObjects();
        if (selMice.size() == 1) {
            this.ivTempSelectedMouse = (Mouse)selMice.firstElement();
            this.ivOkButton.setEnabled(true);
        } else {
            this.ivTempSelectedMouse = null;
            this.ivOkButton.setEnabled(false);
        }
    }
}

