/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.requester.mouse;

import de.hannse.netobjects.user.UserManager;
import de.hannse.netobjects.util.Babel;
import de.hannse.netobjects.util.MyDate;
import java.awt.Frame;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.text.JTextComponent;
import mausoleum.definitionlists.ListDefinition;
import mausoleum.gui.BorderPanel;
import mausoleum.helper.FontManager;
import mausoleum.mouse.TissueSample;
import mausoleum.requester.BasicRequester;
import mausoleum.requester.calendar.CalendarPanel;
import mausoleum.ui.UIDef;

public class TissueSampleRequester
extends BasicRequester {
    private static final long serialVersionUID = 1L;
    private static final int ANZ_LINES = 6;
    private static final int BREITE = CalendarPanel.BREITE + 2 * UIDef.RAND;
    private static final int COMBO_WIDTH = UIDef.getScaled(240);
    private static final int COMBO_X = BREITE - UIDef.RAND - COMBO_WIDTH;
    private static final int COMBO_HEIGHT = UIDef.LINE_HEIGHT;
    private static final int COMBO_Y = UIDef.RAND;
    private static final int COMMENT_Y = COMBO_Y + 6 * (UIDef.LINE_HEIGHT + UIDef.INNER_RAND);
    private static final int COMMENT_HEIGHT = UIDef.getScaled(80);
    private static final int DATESTART = COMMENT_Y + COMMENT_HEIGHT + UIDef.INNER_RAND;
    private static final int BUTSTART = DATESTART + CalendarPanel.HOEHE + UIDef.INNER_RAND;
    private static final int HOEHE = BUTSTART + UIDef.BUT_HEIGHT + UIDef.RAND;
    private JComboBox ivTissueCombo = null;
    private JComboBox ivPreparationCombo = null;
    private JComboBox ivFixationCombo = null;
    private JComboBox ivEmbeddingCombo = null;
    private JTextField ivLocationField = new JTextField();
    private JTextField ivSpecimenIDField = new JTextField();
    private JTextPane ivCommentPane = new JTextPane();
    private JScrollPane ivCommentSPane = new JScrollPane(this.ivCommentPane);
    private BorderPanel ivBorderPanel = new BorderPanel(this.ivCommentSPane, Babel.get("COMMENT"));
    private CalendarPanel ivCalendarPanel;

    public TissueSampleRequester(Frame sender, MyDate minimum, String group, TissueSample objectToModify) {
        super(sender, BREITE, HOEHE);
        int y = COMBO_Y;
        Vector v = ListDefinition.getItems(UserManager.getGroupAndService(group), 2, true, false, false);
        this.ivTissueCombo = new JComboBox(v);
        TissueSampleRequester.selectIfPossible(this.ivTissueCombo, objectToModify == null ? -1 : objectToModify.ivTissueType, v);
        this.addPermanentLabel(Babel.get("TISSUE"), UIDef.RAND, y, COMBO_HEIGHT);
        this.addAndApplyBounds(this.ivTissueCombo, COMBO_X, y, COMBO_WIDTH, COMBO_HEIGHT);
        y += UIDef.LINE_HEIGHT + UIDef.INNER_RAND;
        v = ListDefinition.getItems(UserManager.getGroupAndService(group), 4, true, false, false);
        if (!v.isEmpty()) {
            v.insertElementAt("", 0);
        }
        this.ivPreparationCombo = new JComboBox(v);
        this.ivPreparationCombo.setEnabled(!v.isEmpty());
        this.addPermanentLabel(Babel.get("TISSUE_PREP"), UIDef.RAND, y, COMBO_HEIGHT);
        this.addAndApplyBounds(this.ivPreparationCombo, COMBO_X, y, COMBO_WIDTH, COMBO_HEIGHT);
        y += UIDef.LINE_HEIGHT + UIDef.INNER_RAND;
        v = ListDefinition.getItems(UserManager.getGroupAndService(group), 5, true, false, false);
        if (!v.isEmpty()) {
            v.insertElementAt("", 0);
        }
        this.ivFixationCombo = new JComboBox(v);
        this.ivFixationCombo.setEnabled(!v.isEmpty());
        this.addPermanentLabel(Babel.get("TISSUE_FIXATION"), UIDef.RAND, y, COMBO_HEIGHT);
        this.addAndApplyBounds(this.ivFixationCombo, COMBO_X, y, COMBO_WIDTH, COMBO_HEIGHT);
        y += UIDef.LINE_HEIGHT + UIDef.INNER_RAND;
        v = ListDefinition.getItems(UserManager.getGroupAndService(group), 3, true, false, false);
        if (!v.isEmpty()) {
            v.insertElementAt("", 0);
        }
        this.ivEmbeddingCombo = new JComboBox(v);
        this.ivEmbeddingCombo.setEnabled(!v.isEmpty());
        this.addPermanentLabel(Babel.get("TISSUE_EMBEDDING"), UIDef.RAND, y, COMBO_HEIGHT);
        this.addAndApplyBounds(this.ivEmbeddingCombo, COMBO_X, y, COMBO_WIDTH, COMBO_HEIGHT);
        this.addPermanentLabel(Babel.get("SAMPLE_LOCATION"), UIDef.RAND, y += UIDef.LINE_HEIGHT + UIDef.INNER_RAND, COMBO_HEIGHT);
        this.ivLocationField.setFont(FontManager.getFont("SSB12"));
        this.addAndApplyBounds(this.ivLocationField, COMBO_X, y, COMBO_WIDTH, COMBO_HEIGHT);
        this.addPermanentLabel(Babel.get("TISSUE_SAMPLE_ID"), UIDef.RAND, y += UIDef.LINE_HEIGHT + UIDef.INNER_RAND, COMBO_HEIGHT);
        this.ivSpecimenIDField.setFont(FontManager.getFont("SSB12"));
        this.addAndApplyBounds(this.ivSpecimenIDField, COMBO_X, y, COMBO_WIDTH, COMBO_HEIGHT);
        y += UIDef.LINE_HEIGHT + UIDef.INNER_RAND;
        this.ivCommentPane.setFont(FontManager.getFont("SSB12"));
        this.addAndApplyBounds(this.ivBorderPanel, UIDef.RAND, COMMENT_Y, CalendarPanel.BREITE, COMMENT_HEIGHT);
        this.ivCalendarPanel = new CalendarPanel(minimum, MyDate.getMyDate(System.currentTimeMillis()), objectToModify == null ? null : new MyDate(objectToModify.ivDatum));
        this.addAndApplyBounds(this.ivCalendarPanel, UIDef.RAND, DATESTART, CalendarPanel.BREITE, CalendarPanel.HOEHE);
        this.applyBounds(this.ivOkButton, UIDef.RAND, BUTSTART, CalendarPanel.BREITE, UIDef.BUT_HEIGHT);
        if (objectToModify != null) {
            if (objectToModify.ivLocation != null) {
                this.ivLocationField.setText(objectToModify.ivLocation);
            }
            if (objectToModify.ivSpecimenID != null) {
                this.ivSpecimenIDField.setText(objectToModify.ivSpecimenID);
            }
            if (objectToModify.ivComment != null) {
                this.ivCommentPane.setText(objectToModify.ivComment);
                this.ivCommentPane.setCaretPosition(0);
            }
        }
    }

    private static void selectIfPossible(JComboBox combo, int itemID, Vector choices) {
        if (combo.isEnabled() && choices != null && !choices.isEmpty() && itemID > 0) {
            int indexToSelect = -1;
            int i = 0;
            while (i < choices.size()) {
                Object ooo = choices.elementAt(i);
                if (ooo instanceof ListDefinition) {
                    ListDefinition ld = (ListDefinition)ooo;
                    if (ld.ivID == itemID) {
                        indexToSelect = i;
                    }
                }
                ++i;
            }
            if (indexToSelect != -1) {
                combo.setSelectedIndex(indexToSelect);
            }
        }
    }

    public boolean okAndNoWanted() {
        return false;
    }

    public boolean onlyOKWanted() {
        return true;
    }

    public TissueSample getTissueSample() {
        TissueSample model = new TissueSample();
        model.ivDatum = this.ivCalendarPanel.getSelectedDatumInt();
        model.ivTissueType = this.getListDefValue(this.ivTissueCombo, 0);
        model.ivPreparationType = this.getListDefValue(this.ivPreparationCombo, 0);
        model.ivEmbeddingType = this.getListDefValue(this.ivEmbeddingCombo, 0);
        model.ivFixationType = this.getListDefValue(this.ivFixationCombo, 0);
        model.ivLocation = this.getStringVal(this.ivLocationField, null);
        model.ivSpecimenID = this.getStringVal(this.ivSpecimenIDField, null);
        model.ivComment = this.getStringVal(this.ivCommentPane, null);
        return model;
    }

    private String getStringVal(JTextComponent tc, String defVal) {
        String s = tc.getText().trim();
        return s.length() == 0 ? defVal : s;
    }

    private int getListDefValue(JComboBox combo, int defVal) {
        Object ooo;
        if (combo.isEnabled() && (ooo = combo.getSelectedItem()) instanceof ListDefinition) {
            ListDefinition ld = (ListDefinition)ooo;
            return ld.ivID;
        }
        return defVal;
    }
}

