/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.requester.pope;

import de.hannse.netobjects.objectstore.IDObject;
import de.hannse.netobjects.objectstore.ObjectStore;
import de.hannse.netobjects.tools.StringHelper;
import de.hannse.netobjects.user.UserManager;
import de.hannse.netobjects.util.Babel;
import de.hannse.netobjects.util.MyDate;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Point;
import java.util.HashSet;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JLabel;
import mausoleum.cage.Cage;
import mausoleum.cage.CageManager;
import mausoleum.gui.TextWrapComponent;
import mausoleum.gui.TextWrapComponentInitiale;
import mausoleum.helper.FontManager;
import mausoleum.helper.LitterHelper;
import mausoleum.helper.LongPunkt;
import mausoleum.helper.MausoleumImageStore;
import mausoleum.inspector.Inspector;
import mausoleum.mail.Mail;
import mausoleum.main.DefaultManager;
import mausoleum.main.MausoleumClient;
import mausoleum.mouse.Mouse;
import mausoleum.mouse.MouseManager;
import mausoleum.rack.Rack;
import mausoleum.requester.BasicRequester;
import mausoleum.requester.MoreTextRequester;
import mausoleum.requester.pope.GuruManager;
import mausoleum.result.MResult;
import mausoleum.result.embryotransfer.EmbryoTransfer;
import mausoleum.room.Room;
import mausoleum.task.standards.StandardTask;
import mausoleum.ui.UIDef;
import mausoleum.util.InstallationType;
import mausoleum.util.Standards;
import mausoleum.util.calendar.InstituteHolidays;

public class PopeAlert
extends BasicRequester {
    private static final long serialVersionUID = 1L;
    private static final int MARGIN = UIDef.getScaled(10);
    private static final int TEXT_WIDTH = UIDef.getScaled(400);
    private static final int BUT_HEIGHT = UIDef.getScaled(40);
    private static final int TOTHEIGHT = UIDef.getScaled(500);
    private static final int TOTWIDTH = UIDef.getScaled(200);
    private static final Image POPE_IMAGE = MausoleumImageStore.getPope();
    private static final Long MINUS_EINS_L = new Long(-1L);
    public static final String PETZ_LITTER_WITHOUT_CLEAR_FATHER = "PETZ_LITTER_WITHOUT_CLEAR_FATHER";
    public static final String PETZ_IMPROPER_MOUSE_HANDLING = "PETZ_IMPROPER_MOUSE_HANDLING";
    public static final String PETZ_EXPORT_MICE = "PETZ_EXPORT_MICE";
    public static final String PETZ_MOUSE_ROOM_TRANSFER = "PETZ_MOUSE_ROOM_TRANSFER";
    public static final String PETZ_MOUSE_GROUP_TRANSFER = "PETZ_MOUSE_GROUP_TRANSFER";
    public static final String PETZ_CAGE_GROUP_TRANSFER = "PETZ_CAGE_GROUP_TRANSFER";
    public static final String PETZ_MAIL_EXTRACTION = "PETZ_MAIL_EXTRACTION";
    public static final String PETZ_ROOM_SECURITY = "PETZ_ROOM_SECURITY";
    public static final String PETZ_ALLELES_REMOVED = "PETZ_ALLELES_REMOVED";
    public static final String PETZ_NEW_RACK = "PETZ_NEW_RACK_IN_NORMAL_GROUP";
    public static final String PETZ_MATING_WITHOUT_MATCHING_LINE = "PETZ_MATING_WITHOUT_MATCHING_LINE";

    public static String getPopeMeldung(String primaryTag) {
        return String.valueOf(Babel.get(primaryTag)) + "\n\n" + Babel.get("POPE_CONTINUE");
    }

    public static boolean checkTaskDateForHoliday(int date) {
        MyDate md = new MyDate(date);
        TreeMap holidays = InstituteHolidays.getHolidayNamesByDate(md.ivJahr);
        if (holidays.containsKey(new Integer(date))) {
            return PopeAlert.getAnswer(PopeAlert.getPopeMeldung("POPE_TASK_HOLIDAY"));
        }
        if (InstituteHolidays.isWeeklyDayOff(MyDate.getWochentag(date))) {
            return PopeAlert.getAnswer(PopeAlert.getPopeMeldung("POPE_TASK_WEEKEND"));
        }
        return true;
    }

    public static boolean makeTaskScheduleCheck(int taskProcedure, String group, int datum, Vector objects, JDialog sender) {
        int mcdo = StandardTask.getAutoCompletionOffsetIfThere("TASK_AC_TO_MATING", taskProcedure, group, 0, -1);
        if (mcdo != -1) {
            return PopeAlert.makeMouseTransferTaskMulticheck(datum + mcdo, objects, true, false, group, sender);
        }
        mcdo = StandardTask.getAutoCompletionOffsetIfThere("TASK_AC_PRECISE_POOLING", taskProcedure, group, 0, -1);
        if (mcdo != -1) {
            return PopeAlert.makeMouseTransferTaskMulticheck(datum + mcdo, objects, false, true, group, sender);
        }
        return true;
    }

    private static boolean makeMouseTransferTaskMulticheck(int datum, Vector objects, boolean forMating, boolean forExactPooling, String group, JDialog sender) {
        Vector<String> killerComplaints = new Vector<String>();
        Vector<String> normalComplaints = new Vector<String>();
        if (objects.size() < 2) {
            killerComplaints.add("ALERT_MT_ONE_MOUSE");
        } else if (datum == Integer.MIN_VALUE) {
            killerComplaints.add("ALERT_MT_FIXED_DATE");
        } else {
            long millis = (long)datum * 86400000L;
            int numMale = 0;
            int numFemale = 0;
            int numNonMouse = 0;
            int numNonSexactive = 0;
            int numNoRoom = 0;
            HashSet<Long> roomIDs = new HashSet<Long>();
            Vector<Mouse> matureFemales = new Vector<Mouse>();
            Vector<Mouse> matureMales = new Vector<Mouse>();
            Iterator iterator = objects.iterator();
            while (iterator.hasNext()) {
                IDObject ido = (IDObject)iterator.next();
                if (ido instanceof Mouse) {
                    Mouse mouse = (Mouse)ido;
                    if (!mouse.isSexActive(millis)) {
                        ++numNonSexactive;
                    } else {
                        int sex = mouse.getSex();
                        if (sex == 1) {
                            matureMales.add(mouse);
                            ++numMale;
                        }
                        if (sex == 2) {
                            matureFemales.add(mouse);
                            ++numFemale;
                        }
                    }
                    Room room = mouse.getRoom();
                    if (room != null) {
                        roomIDs.add(room.getLongID());
                        continue;
                    }
                    ++numNoRoom;
                    continue;
                }
                ++numNonMouse;
            }
            if (numNonMouse != 0) {
                killerComplaints.add("ALERT_MT_NON_MOUSE");
            } else {
                boolean implicitMating;
                boolean bl = implicitMating = !matureMales.isEmpty() && !matureFemales.isEmpty();
                if (forMating) {
                    if (numMale + numFemale != objects.size()) {
                        killerComplaints.add("ALERT_MT_NO_SEX");
                    }
                    if (numMale == 0) {
                        killerComplaints.add("ALERT_MT_MALE_MISSING");
                    }
                    if (numFemale == 0) {
                        killerComplaints.add("ALERT_MT_FEMALE_MISSING");
                    }
                }
                if (forMating || implicitMating) {
                    if (numMale > 1) {
                        killerComplaints.add("ALERT_MT_TOO_MANY_MALE");
                    }
                    if (numNonSexactive > 0) {
                        killerComplaints.add("ALERT_MT_IMMATURE");
                    }
                    if (PopeAlert.hasWaelsungen(objects)) {
                        normalComplaints.add("POPE_SIBLING_MATING");
                    }
                    if (PopeAlert.hasLineProblem(matureMales, matureFemales)) {
                        if (Standards.extendedAlertFoMatingWithoutMatchingLine()) {
                            if (!PopeAlert.checkForMatingWithNoProperLineForOffspring(matureMales, matureFemales, true, false, false)) {
                                return false;
                            }
                        } else {
                            normalComplaints.add("ALERT_LINE_PROBLEM");
                        }
                    }
                    if (PopeAlert.hasMiceWithSymptoms(objects)) {
                        normalComplaints.add("POPE_MATING_WITH_SYMPTOMS");
                    }
                }
                if (forExactPooling && PopeAlert.alreadyPreciselyPooled(objects, group)) {
                    killerComplaints.add("ALERT_ALREADY_POOLED");
                }
                if (DefaultManager.cvShowEarTag100Alert && PopeAlert.hasEartag100Collision(null, objects)) {
                    normalComplaints.add("POPE_EARTAG_100");
                }
                if (PopeAlert.hasGommorrha(null, objects, null, null) != null) {
                    normalComplaints.add("POPE_CAGE_GOMORRHA");
                }
                if (numNoRoom != 0 && numNoRoom != objects.size()) {
                    killerComplaints.add("ALERT_MT_WITH_AND_WITOUT_ROOMS");
                }
                if (roomIDs.size() != 0 && roomIDs.size() != 1) {
                    killerComplaints.add("ALERT_MT_ROOMS");
                }
            }
        }
        if (!killerComplaints.isEmpty() || !normalComplaints.isEmpty()) {
            StringBuilder msb = new StringBuilder();
            boolean proceedPossible = true;
            if (!killerComplaints.isEmpty()) {
                proceedPossible = false;
                msb.append(Babel.get("ALERT_MT_MATING_CRASHED"));
            } else {
                msb.append(Babel.get("ALERT_TASK_PROBLEM"));
            }
            Iterator iterator = killerComplaints.iterator();
            while (iterator.hasNext()) {
                String s = (String)iterator.next();
                msb.append("\n").append(Babel.get(s));
            }
            iterator = normalComplaints.iterator();
            while (iterator.hasNext()) {
                String s = (String)iterator.next();
                msb.append("\n").append(Babel.get(s));
            }
            if (proceedPossible) {
                msb.append("\n\n").append(Babel.get("POPE_CONTINUE"));
            }
            boolean alertRes = PopeAlert.showPopeAlert(msb.toString(), sender, !proceedPossible);
            if (proceedPossible) {
                return alertRes;
            }
            return false;
        }
        return true;
    }

    public static boolean hasLineProblem(Vector matureMales, Vector matureFemales) {
        Iterator iterator = matureMales.iterator();
        while (iterator.hasNext()) {
            Mouse dad = (Mouse)iterator.next();
            Iterator iterator2 = matureFemales.iterator();
            while (iterator2.hasNext()) {
                Mouse mom = (Mouse)iterator2.next();
                if (LitterHelper.determineLineIDForOffspring(mom, dad, false, -1L) != -1L) continue;
                return true;
            }
        }
        return false;
    }

    public static void fromDifferentRooms(Vector mice, boolean[] marker) {
        HashSet<Long> roomIDs = new HashSet<Long>();
        Iterator iterator = mice.iterator();
        while (iterator.hasNext()) {
            Mouse mouse = (Mouse)iterator.next();
            Room room = mouse.getRoom();
            roomIDs.add(room != null && room.getLongID() != null ? room.getLongID() : MINUS_EINS_L);
        }
        if (roomIDs.contains(MINUS_EINS_L)) {
            marker[1] = true;
            marker[0] = roomIDs.size() > 2;
        } else {
            marker[1] = false;
            marker[0] = roomIDs.size() > 1;
        }
        roomIDs.clear();
        roomIDs = null;
    }

    public static boolean alreadyPreciselyPooled(Vector mice, String group) {
        Vector cageMice;
        Cage cage;
        Long lastID = null;
        HashSet<Long> cageIDs = new HashSet<Long>();
        Iterator iterator = mice.iterator();
        while (iterator.hasNext()) {
            Mouse mouse = (Mouse)iterator.next();
            Cage cage2 = mouse.getActCage();
            if (cage2 == null || cage2.getLongID() == null) {
                return false;
            }
            lastID = cage2.getLongID();
            cageIDs.add(lastID);
        }
        boolean res = false;
        if (cageIDs.size() == 1 && (cage = (Cage)ObjectStore.getClientObject(2, lastID, group)) != null && (cageMice = cage.getActualMice()) != null && cageMice.size() == mice.size()) {
            res = true;
        }
        cageIDs.clear();
        cageIDs = null;
        return res;
    }

    public static boolean checkForRealMatingWithNoProperLineForOffspring(Vector mice) {
        if (mice != null && !mice.isEmpty()) {
            Vector males = new Vector();
            Vector females = new Vector();
            Mouse.separateMiceBySex(mice, males, females);
            if (Standards.extendedAlertFoMatingWithoutMatchingLine()) {
                return PopeAlert.checkForMatingWithNoProperLineForOffspring(males, females, false, true, false);
            }
            if (PopeAlert.hasLineProblem(males, females)) {
                StringBuilder msb = new StringBuilder(Babel.get("ALERT_LINE_PROBLEM"));
                msb.append("\n\n").append(Babel.get("POPE_CONTINUE"));
                return PopeAlert.getAnswer(msb.toString(), false);
            }
        }
        return true;
    }

    public static boolean checkForLitterWithNoProperLineForOffspring(Mouse father, Mouse mother) {
        if (father != null && mother != null) {
            Vector<Mouse> males = new Vector<Mouse>(1);
            Vector<Mouse> females = new Vector<Mouse>(1);
            males.add(father);
            females.add(mother);
            if (Standards.extendedAlertFoMatingWithoutMatchingLine()) {
                return PopeAlert.checkForMatingWithNoProperLineForOffspring(males, females, false, false, true);
            }
            if (PopeAlert.hasLineProblem(males, females)) {
                StringBuilder msb = new StringBuilder(Babel.get("ALERT_LINE_PROBLEM"));
                msb.append("\n\n").append(Babel.get("POPE_CONTINUE"));
                return PopeAlert.getAnswer(msb.toString(), false);
            }
        }
        return true;
    }

    public static boolean checkForEmbryoTransferAndKilltask(int taskProc, int killDate, Vector targetObjects) {
        if (EmbryoTransfer.useEmbryoTransfer() && taskProc == 2) {
            boolean hasET = false;
            Iterator iterator = targetObjects.iterator();
            while (iterator.hasNext() && !hasET) {
                Mouse mouse;
                IDObject ido = (IDObject)iterator.next();
                if (!(ido instanceof Mouse) || (mouse = (Mouse)ido).getSex() != 2) continue;
                hasET |= EmbryoTransfer.hasEmbryoTransferCoveringDate(mouse, killDate);
            }
            if (hasET) {
                return PopeAlert.getAnswer(Babel.get("ETR_KILLTASK_PROBLEM"), false);
            }
        }
        return true;
    }

    public static boolean checkForTaskMinMaxDateProblem(int taskProc, int date, Vector targetObjects) {
        int dayOffset = date - (int)(System.currentTimeMillis() / 86400000L);
        if (taskProc != -1) {
            boolean hatDr\u00fcber = false;
            boolean hatDrunter = false;
            Iterator iterator = targetObjects.iterator();
            while (iterator.hasNext()) {
                int ageHeute;
                IDObject ido = (IDObject)iterator.next();
                if (!(ido instanceof Mouse) || !ido.isAliveAndVisible()) continue;
                Mouse mouse = (Mouse)ido;
                StandardTask st = StandardTask.findTask(ido.getGroup(), taskProc);
                if (st == null || st.ivMinimumAge <= 0 && st.ivMaximumAge <= 0 || (ageHeute = mouse.getAgeInDays(Integer.MIN_VALUE)) == Integer.MIN_VALUE) continue;
                int ageDann = ageHeute + dayOffset;
                if (st.ivMinimumAge > 0 && ageDann < st.ivMinimumAge) {
                    hatDrunter = true;
                }
                if (st.ivMaximumAge <= 0 || ageDann <= st.ivMaximumAge) continue;
                hatDr\u00fcber = true;
            }
            if (hatDr\u00fcber && hatDrunter) {
                return PopeAlert.getAnswer(Babel.get("ALERT_TASK_MIN_MAX_DATE_PROBLEM"), false);
            }
            if (hatDrunter) {
                return PopeAlert.getAnswer(Babel.get("ALERT_TASK_MIN_DATE_PROBLEM"), false);
            }
            if (hatDr\u00fcber) {
                return PopeAlert.getAnswer(Babel.get("ALERT_TASK_MAX_DATE_PROBLEM"), false);
            }
        }
        return true;
    }

    public static boolean checkForSecondEmbryoTransfer(int etDate, Mouse female) {
        if (EmbryoTransfer.useEmbryoTransfer() && female.getSex() == 2 && EmbryoTransfer.hasEmbryoTransferCoveringDate(female, etDate)) {
            return PopeAlert.getAnswer(Babel.get("ETR_SECOND_ET_PROBLEM"), false);
        }
        return true;
    }

    private static boolean checkForMatingWithNoProperLineForOffspring(Vector males, Vector females, boolean forMatingTask, boolean forRealMating, boolean forLitter) {
        if (InstallationType.isMouse() && !males.isEmpty() && !females.isEmpty()) {
            String maleGroup = IDObject.commonGroup(males);
            String femaleGroup = IDObject.commonGroup(females);
            if (maleGroup == null || femaleGroup == null || !maleGroup.equals(femaleGroup)) {
                PopeAlert.getAnswer(Babel.get("POPE_MATING_DIFFERENT_GROUPS"), true);
                return false;
            }
            Vector<Mouse[]> problematicCouples = new Vector<Mouse[]>();
            Iterator iterator = males.iterator();
            while (iterator.hasNext()) {
                Mouse father = (Mouse)iterator.next();
                if (father.getSex() == 0 || !father.isSexActive()) continue;
                Iterator iterator2 = females.iterator();
                while (iterator2.hasNext()) {
                    long lineID;
                    Mouse mother = (Mouse)iterator2.next();
                    if (mother.getSex() == 0 || !mother.isSexActive() || (lineID = LitterHelper.determineLineIDForOffspring(mother, father, false, -1L)) != -1L) continue;
                    problematicCouples.add(new Mouse[]{father, mother});
                }
            }
            if (!problematicCouples.isEmpty()) {
                boolean res = PopeAlert.getAnswer(PopeAlert.getPopeMeldung("POPE_MATING_WITHOUT_MATCHING_LINE"));
                if (res) {
                    Vector[] gurus = GuruManager.getGurunamesAndIDs(maleGroup, PETZ_MATING_WITHOUT_MATCHING_LINE);
                    if (!gurus[0].isEmpty()) {
                        PopeAlert.petze("Mating without matching line for offspring", PopeAlert.getPetzTextMatingWithoutLine(problematicCouples, true, forMatingTask, forRealMating, forLitter, maleGroup), maleGroup, PETZ_MATING_WITHOUT_MATCHING_LINE);
                    }
                    if (!(gurus = GuruManager.getGurunamesAndIDs("service", PETZ_MATING_WITHOUT_MATCHING_LINE))[0].isEmpty()) {
                        PopeAlert.petze("Mating without matching line for offspring", PopeAlert.getPetzTextMatingWithoutLine(problematicCouples, false, forMatingTask, forRealMating, forLitter, maleGroup), "service", PETZ_MATING_WITHOUT_MATCHING_LINE);
                    }
                    return true;
                }
                return false;
            }
        }
        return true;
    }

    private static String getPetzTextMatingWithoutLine(Vector problematicCouples, boolean forGroup, boolean forMatingTask, boolean forRealMating, boolean forLitter, String animalGroup) {
        StringBuilder msb = new StringBuilder(400);
        boolean wasServiceCT = MausoleumClient.isServiceCaretaker();
        msb.append("<html><body>");
        if (forGroup) {
            if (wasServiceCT) {
                msb.append("A caretaker of the service group ");
            } else {
                msb.append("User <b>").append(UserManager.getNameOfUser()).append("</b> ");
            }
        } else if (wasServiceCT) {
            msb.append("A caretaker of the service group ");
        } else {
            msb.append("A user from group <b>'").append(UserManager.getUser().getGroup()).append("'</b> ");
        }
        if (forMatingTask) {
            msb.append("set up a mating task ");
        } else if (forRealMating) {
            msb.append("set up a mating ");
        } else if (forLitter) {
            msb.append("created a litter ");
        }
        if (!forGroup) {
            msb.append("for group <b>").append(animalGroup).append("</b> ");
        }
        if (problematicCouples.size() == 1) {
            Mouse[] paar = (Mouse[])problematicCouples.firstElement();
            msb.append("with this couple ");
            msb.append("(").append(forGroup ? paar[0].getLink() : paar[0].getName()).append(", ");
            msb.append(forGroup ? paar[1].getLink() : paar[1].getName()).append(") ");
        } else {
            msb.append("with these couples ");
            Iterator iterator = problematicCouples.iterator();
            while (iterator.hasNext()) {
                Mouse[] paar = (Mouse[])iterator.next();
                msb.append("(").append(forGroup ? paar[0].getLink() : paar[0].getName()).append(", ");
                msb.append(forGroup ? paar[1].getLink() : paar[1].getName()).append(") ");
            }
        }
        msb.append("without a matching line for the offspring!");
        return msb.toString();
    }

    public static boolean checkForCageGomorrha(long cid, Vector v, String group) {
        StringBuilder linkSB;
        Cage cage;
        Point numMF;
        if (InstallationType.isMouse() && (numMF = PopeAlert.hasGommorrha(cage = cid != 0L ? (Cage)ObjectStore.getClientObject(2, cid, group) : null, v, linkSB = new StringBuilder(), null)) != null) {
            if (UserManager.getRoleOfUser() == 42) {
                return PopeAlert.getAnswer(PopeAlert.getPopeMeldung("POPE_CAGE_GOMORRHA"));
            }
            boolean res = PopeAlert.getAnswer(PopeAlert.getPopeMeldung("POPE_CAGE_GOMORRHA_MIT_PETZE"));
            if (res) {
                String cids = cage == null ? "a new cage" : cage.getLink();
                String text = "<html><body>User <b>" + UserManager.getNameOfUser() + "</b> put " + numMF.x + " male " + numMF.y + " female mice (" + linkSB + ") together in " + cids + "!</body></html>";
                PopeAlert.petze("Improper mouse handling", text, group, PETZ_IMPROPER_MOUSE_HANDLING);
                return true;
            }
            return false;
        }
        return true;
    }

    public static Point hasGommorrha(Cage targetCage, Vector mice, StringBuilder linkSB, int[] aborigineNumber) {
        Vector<Mouse> allMice = new Vector<Mouse>(10);
        if (targetCage != null) {
            allMice.addAll(targetCage.getActualMice());
        }
        if (aborigineNumber != null) {
            aborigineNumber[0] = 0;
        }
        Iterator iterator = mice.iterator();
        while (iterator.hasNext()) {
            Mouse mouse = (Mouse)iterator.next();
            if (!allMice.contains(mouse)) {
                allMice.add(mouse);
                continue;
            }
            if (aborigineNumber == null) continue;
            aborigineNumber[0] = aborigineNumber[0] + 1;
        }
        int numFemale = 0;
        int numMale = 0;
        Iterator iterator2 = allMice.iterator();
        while (iterator2.hasNext()) {
            Mouse m = (Mouse)iterator2.next();
            int sex = m.getSex();
            if (sex == 1) {
                ++numMale;
            } else if (sex == 2) {
                ++numFemale;
            }
            if (linkSB == null) continue;
            if (linkSB.length() != 0) {
                linkSB.append(" ");
            }
            linkSB.append(m.getLink());
        }
        return numMale > 1 && numFemale != 0 ? new Point(numMale, numFemale) : null;
    }

    public static boolean makeCompleteMatingCheck(Cage targetCage, Vector mice, Vector paarungsSammler) {
        if (InstallationType.isMouse()) {
            paarungsSammler.clear();
            Vector allMiceCollector = new Vector();
            Vector matureMiceIfMating = CageManager.returnMatureMiceIfMating(targetCage, mice, allMiceCollector);
            if (matureMiceIfMating != null) {
                paarungsSammler.addAll(matureMiceIfMating);
            } else if (DefaultManager.cvShowPoolDifferentLinesAlert && !PopeAlert.checkForPoolDiferrentLines(allMiceCollector)) {
                return false;
            }
            if (!PopeAlert.checkForRealMatingWithNoProperLineForOffspring(paarungsSammler)) {
                return false;
            }
            if (!PopeAlert.checkForSiblingMating(paarungsSammler)) {
                return false;
            }
            if (!PopeAlert.checkForMatingOfMiceWithSymptoms(paarungsSammler)) {
                return false;
            }
        }
        return true;
    }

    private static boolean checkForPoolDiferrentLines(Vector mice) {
        if (InstallationType.isMouse() && DefaultManager.cvShowPoolDifferentLinesAlert) {
            HashSet<Long> hs = new HashSet<Long>();
            Iterator iterator = mice.iterator();
            while (iterator.hasNext()) {
                Mouse mouse = (Mouse)iterator.next();
                Long lineID = (Long)mouse.get("MOS_LINEID");
                hs.add(lineID == null ? MINUS_EINS_L : lineID);
            }
            if (hs.size() != 1) {
                return PopeAlert.getAnswer(PopeAlert.getPopeMeldung("POPE_DIFFERENT_LINES"));
            }
        }
        return true;
    }

    private static boolean checkForMatingOfMiceWithSymptoms(Vector mice) {
        if (InstallationType.isMouse() && PopeAlert.hasMiceWithSymptoms(mice)) {
            return PopeAlert.getAnswer(PopeAlert.getPopeMeldung("POPE_MATING_WITH_SYMPTOMS"));
        }
        return true;
    }

    private static boolean hasMiceWithSymptoms(Vector mice) {
        if (InstallationType.isMouse()) {
            Iterator iterator = mice.iterator();
            while (iterator.hasNext()) {
                if (MResult.getSymptomListType((Mouse)iterator.next()) != 2) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean checkForSiblingMating(Vector paarungsSammler) {
        if (InstallationType.isMouse() && PopeAlert.hasWaelsungen(paarungsSammler)) {
            return PopeAlert.getAnswer(PopeAlert.getPopeMeldung("POPE_SIBLING_MATING"));
        }
        return true;
    }

    private static boolean hasWaelsungen(Vector cmice) {
        if (InstallationType.isMouse() && DefaultManager.cvShowWaelsungenAlert) {
            HashSet<LongPunkt> frauenEltern = new HashSet<LongPunkt>(5);
            HashSet maennerEltern = new HashSet(5);
            Iterator iter = cmice.iterator();
            while (iter.hasNext()) {
                HashSet andereSeite;
                Mouse mouse = (Mouse)iter.next();
                Long fid = (Long)mouse.get("MOS_FATHER");
                Long mid = (Long)mouse.get("MOS_MOTHER");
                if (fid == null || mid == null) continue;
                LongPunkt eltern = new LongPunkt(fid, mid);
                int sex = mouse.getSex();
                HashSet<LongPunkt> meineSeite = sex == 2 ? frauenEltern : maennerEltern;
                HashSet<Object> hashSet = andereSeite = sex == 2 ? maennerEltern : frauenEltern;
                if (andereSeite.contains(eltern)) {
                    frauenEltern.clear();
                    frauenEltern = null;
                    maennerEltern.clear();
                    maennerEltern = null;
                    return true;
                }
                meineSeite.add(eltern);
            }
            frauenEltern.clear();
            frauenEltern = null;
            maennerEltern.clear();
            Object var2_2 = null;
        }
        return false;
    }

    public static boolean checkForEartagCollision(int startEartag, String prefix, Vector maeuse) {
        String fcet;
        boolean res = true;
        if (DefaultManager.cvShowEarTagAlert && (fcet = MouseManager.getFirstCollisionEartag(startEartag, prefix, maeuse)) != null) {
            String s = PopeAlert.getPopeMeldung("POPE_EARTAG_DOUBLE");
            s = StringHelper.gSub(s, "_EARTAG_", fcet);
            res = PopeAlert.getAnswer(s);
        }
        return res;
    }

    public static boolean hasEartag100Collision(Cage cage, Vector mice) {
        if (DefaultManager.cvShowEarTag100Alert) {
            Integer oet;
            Mouse maus;
            Iterator iterator;
            HashSet<Integer> hs = new HashSet<Integer>();
            if (cage != null) {
                iterator = cage.getActualMice().iterator();
                while (iterator.hasNext()) {
                    maus = (Mouse)iterator.next();
                    oet = (Integer)maus.get("MOS_EARTAG");
                    if (oet == null) continue;
                    hs.add(new Integer(oet % 100));
                }
            }
            iterator = mice.iterator();
            while (iterator.hasNext()) {
                maus = (Mouse)iterator.next();
                oet = (Integer)maus.get("MOS_EARTAG");
                if (oet == null || (oet = (Integer)maus.get("MOS_EARTAG")) == null) continue;
                if (hs.contains(oet = new Integer(oet % 100))) {
                    hs.clear();
                    hs = null;
                    return true;
                }
                hs.add(oet);
            }
            hs.clear();
            Object var2_2 = null;
        }
        return false;
    }

    public static boolean checkForEartag100Collision(long cid, Vector mice, String group) {
        boolean res = true;
        if (DefaultManager.cvShowEarTag100Alert) {
            Cage cage;
            Cage cage2 = cage = cid != 0L ? (Cage)ObjectStore.getClientObject(2, cid, group) : null;
            if (PopeAlert.hasEartag100Collision(cage, mice)) {
                res = PopeAlert.getAnswer(PopeAlert.getPopeMeldung("POPE_EARTAG_100"));
            }
        }
        return res;
    }

    public static boolean checkForCageNumberCollision(Cage cage, int wantedCageNumber) {
        long cageID = cage.getID();
        Vector v = CageManager.cvInstance.getActualObjectVector(cage.getGroup());
        int i = 0;
        while (i < v.size()) {
            Cage c = (Cage)v.elementAt(i);
            if (!c.hasSuperCage() && c.getID() != cageID && c.getInt("CAG_PSEUDOID", 0) == wantedCageNumber) {
                return PopeAlert.getAnswer(PopeAlert.getPopeMeldung("POPE_CAGE_DOUBLE"));
            }
            ++i;
        }
        return true;
    }

    public static boolean checkForRoomSecurity(Vector mice, Vector cages, Cage targetCage, Rack targetRack, Room targetRoom, Vector changingMice) {
        int targetSecurityLevel = 0;
        long targetRoomTopLevelID = -1L;
        if (targetRoom == null) {
            if (targetCage != null) {
                targetRoom = targetCage.getRoom();
            } else if (targetRack != null) {
                targetRoom = targetRack.getRoom();
            }
        }
        if (targetRoom != null) {
            targetSecurityLevel = targetRoom.getInt("ROM_SECURITY", 0);
            targetRoomTopLevelID = targetRoom.getTopLevelID(targetRoomTopLevelID);
        }
        if (mice == null) {
            mice = new Vector();
            if (cages != null) {
                Iterator iter = cages.iterator();
                while (iter.hasNext()) {
                    Cage cage = (Cage)iter.next();
                    mice.addAll(cage.getActualMice());
                }
            }
        }
        if (mice.isEmpty()) {
            return true;
        }
        String group = IDObject.commonGroup(mice);
        if (group == null) {
            return false;
        }
        Iterator iter = mice.iterator();
        while (iter.hasNext()) {
            Mouse m = (Mouse)iter.next();
            Room room = m.getRoom();
            if (room == null) {
                if (targetRoomTopLevelID == -1L) continue;
                changingMice.add(m);
                continue;
            }
            if (room.getTopLevelID(-1L) == targetRoomTopLevelID) continue;
            changingMice.add(m);
        }
        if (targetRoom == null || targetRoomTopLevelID == -1L || targetSecurityLevel == 0) {
            return true;
        }
        String rids = targetRoom.getName();
        boolean alertNecessary = false;
        boolean commentNecessary = false;
        String mids = "";
        Iterator iter2 = mice.iterator();
        while (iter2.hasNext()) {
            int roomSec;
            Mouse m = (Mouse)iter2.next();
            Room room = m.getRoom();
            if (room == null || room.getTopLevelID(-1L) == targetRoomTopLevelID || (roomSec = room.getInt("ROM_SECURITY", 0)) == 0) continue;
            alertNecessary = true;
            if (mids.length() != 0) {
                mids = String.valueOf(mids) + ", ";
            }
            mids = String.valueOf(mids) + m.getLink();
            if (roomSec >= targetSecurityLevel) continue;
            commentNecessary = true;
        }
        if (alertNecessary) {
            boolean res = false;
            String body = null;
            if (commentNecessary) {
                res = PopeAlert.getAnswer(PopeAlert.getPopeMeldung("POPE_ROOM_MOVE_EXTRA"));
                if (res) {
                    String text = MoreTextRequester.getText(Inspector.getInspector(), Babel.get("TRANSFER_COMMENT"), true);
                    if (text == null) {
                        return false;
                    }
                    body = "<html><body>User <b>" + UserManager.getNameOfUser() + "</b> of group <b>" + UserManager.getGroupOfUser() + "</b> transferred animals " + mids + " (group: " + group + ") to room " + rids + " with higher security level!" + "\n---- Comment from User " + UserManager.getNameOfUser() + " ----\n" + text + "</body></html>";
                }
            } else {
                res = PopeAlert.getAnswer(PopeAlert.getPopeMeldung("POPE_ROOM_MOVE"));
                if (res) {
                    body = "<html><body>User <b>" + UserManager.getNameOfUser() + "</b> of group <b>" + UserManager.getGroupOfUser() + "</b> transferred animals " + mids + " (group: " + group + ") to room " + rids + " with lower or equal security level!" + "</body></html>";
                }
            }
            if (res) {
                if (MausoleumClient.isServiceCaretaker() || MausoleumClient.isRegularOrTGService()) {
                    PopeAlert.petze("Animal transfer between rooms", body, group, PETZ_MOUSE_ROOM_TRANSFER);
                    if (MausoleumClient.isServiceCaretaker() || targetRoom.isSharedWithOtherGroups()) {
                        PopeAlert.petze("Animal transfer between rooms", body, "service", PETZ_MOUSE_ROOM_TRANSFER);
                    }
                }
                return true;
            }
            return false;
        }
        return true;
    }

    public static void petze(String header, String body, String group, String petzPrivilege) {
        Mail brief = Mail.getSystemMail();
        brief.set("MAI_RGROUP", group);
        brief.set("MAI_SUBJECT", header);
        brief.set("MAI_TEXT", body);
        brief.set("MAI_ATTINFO", null);
        brief.set("MAI_ATTACHMENT", null);
        brief.versendeDichAnGurus(new String[]{group}, petzPrivilege);
    }

    public static boolean checkSex(Vector mice, String alertBabel) {
        Iterator iterator = mice.iterator();
        while (iterator.hasNext()) {
            Mouse mouse = (Mouse)iterator.next();
            if (mouse.getSex() == 0) continue;
            return PopeAlert.getAnswer(PopeAlert.getPopeMeldung(alertBabel));
        }
        return true;
    }

    public static boolean settingOk(Vector v, String tag, String alertBabel) {
        return PopeAlert.settingOk(v, tag, alertBabel, null);
    }

    public static boolean settingOk(Vector v, String tag, String alertBabel, Object tolerable) {
        int i = 0;
        while (i < v.size()) {
            IDObject m = (IDObject)v.elementAt(i);
            Object schonDa = m.get(tag);
            if (schonDa != null && !schonDa.equals(tolerable)) {
                return PopeAlert.getAnswer(PopeAlert.getPopeMeldung(alertBabel));
            }
            ++i;
        }
        return true;
    }

    public static boolean getAnswer(String meldung) {
        PopeAlert pa = new PopeAlert(meldung, Inspector.getInspector(), false);
        pa.setVisible(true);
        return pa.ivWarOK;
    }

    public static boolean getAnswer(String meldung, boolean onlyOK) {
        PopeAlert pa = new PopeAlert(meldung, Inspector.getInspector(), onlyOK);
        pa.setVisible(true);
        return pa.ivWarOK;
    }

    public static boolean showPopeAlert(String s, JDialog sender, boolean onlyOk) {
        PopeAlert pa = new PopeAlert(s, sender, onlyOk);
        pa.setVisible(true);
        return pa.ivWarOK;
    }

    private PopeAlert(String s, Frame sender, boolean onlyOk) {
        super(sender, TOTWIDTH, TOTHEIGHT);
        this.init(s, false);
    }

    private PopeAlert(String s, JDialog sender, boolean onlyOk) {
        super(sender, TOTWIDTH, TOTHEIGHT);
        this.init(s, onlyOk);
    }

    private void init(String meldung, boolean onlyOk) {
        this.setTitle(Babel.get("MOUSE_POPE_SAYS"));
        int imgHeight = POPE_IMAGE.getHeight(null);
        int imgWidth = POPE_IMAGE.getWidth(null);
        int textHeight = TextWrapComponent.getNecessaryHeight(meldung, TEXT_WIDTH, FontManager.getFont("SP16"));
        int obenHeight = imgHeight;
        if (textHeight > obenHeight) {
            obenHeight = textHeight;
        }
        JLabel popeLabel = new JLabel(new ImageIcon(POPE_IMAGE));
        this.addAndApplyBounds(popeLabel, MARGIN, MARGIN, imgWidth, imgHeight);
        TextWrapComponentInitiale twc = new TextWrapComponentInitiale(meldung, FontManager.getFont("SB18"), TEXT_WIDTH, 1112);
        int twcHeight = twc.getNecessaryHeight();
        this.addAndApplyBounds(twc, 2 * MARGIN + imgWidth, MARGIN, TEXT_WIDTH, twcHeight);
        int realUpperHeight = obenHeight;
        if (twcHeight > realUpperHeight) {
            realUpperHeight = twcHeight;
        }
        int breite = 3 * MARGIN + imgWidth + TEXT_WIDTH;
        int hoehe = 3 * MARGIN + realUpperHeight + BUT_HEIGHT;
        if (onlyOk) {
            super.remove(this.ivNoButton);
            this.applyBounds(this.ivOkButton, MARGIN, 2 * MARGIN + realUpperHeight, breite - 2 * MARGIN, BUT_HEIGHT);
        } else {
            int gbbr = breite - 3 * MARGIN;
            int bbr1 = gbbr / 2;
            int bbr2 = gbbr - bbr1;
            this.applyBounds(this.ivNoButton, MARGIN, 2 * MARGIN + realUpperHeight, bbr1, BUT_HEIGHT);
            this.applyBounds(this.ivOkButton, 2 * MARGIN + bbr1, 2 * MARGIN + realUpperHeight, bbr2, BUT_HEIGHT);
        }
        this.pack();
        this.setInnerSize(breite, hoehe);
    }
}

