/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.requester.preferences;

import de.hannse.netobjects.util.Babel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import mausoleum.cage.colors.CageColorManager;
import mausoleum.gui.BorderPanel;
import mausoleum.gui.MGButton;
import mausoleum.gui.RequesterPane;
import mausoleum.helper.FontManager;
import mausoleum.helper.ImageProvider;
import mausoleum.ui.UIDef;

public class ColorModePane
extends RequesterPane
implements ActionListener,
LayoutManager,
ListCellRenderer {
    private static final long serialVersionUID = 23323L;
    private static final int RAND = 5;
    private static final int BUT_HEIGHT = 30;
    private JList ivUsedModesList = null;
    private JList ivNotUsedModesList = null;
    private JLabel ivObjectLabel = new JLabel();
    private MGButton ivMoveObjectUpButton = MGButton.getRequesterButton(Babel.get("MOVEUPOBJECT"));
    private MGButton ivMoveObjectDownButton = MGButton.getRequesterButton(Babel.get("MOVEDOWNOBJECT"));
    private MGButton ivUseColumnButton = MGButton.getRequesterButton(Babel.get("USE_MODE"));
    private MGButton ivDontUseColumnButton = MGButton.getRequesterButton(Babel.get("DONT_USE_MODE"));
    private BorderPanel ivUnusedPanel;
    private BorderPanel ivUsedPanel;
    private final Vector ivUsed = new Vector();
    private final Vector ivNotUsed = new Vector();
    private int ivMainMode = 0;
    private boolean ivReact = true;

    public ColorModePane() {
        super(null);
        this.setLayout(this);
        this.ivObjectLabel.setFont(FontManager.getFont("SSB12"));
        this.ivObjectLabel.setHorizontalTextPosition(4);
        this.ivUsedModesList = new JList(this.ivUsed);
        this.ivUsedModesList.setSelectionMode(0);
        this.ivUsedModesList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (ColorModePane.this.ivReact) {
                    ColorModePane.this.ivUseColumnButton.setEnabled(false);
                    int ind = ColorModePane.this.ivUsedModesList.getSelectedIndex();
                    Integer selValue = (Integer)ColorModePane.this.ivUsedModesList.getSelectedValue();
                    ColorModePane.this.ivDontUseColumnButton.setEnabled(ind != -1 && ColorModePane.this.ivUsed.size() > 1 && selValue != ColorModePane.this.ivMainMode);
                    ColorModePane.this.ivMoveObjectUpButton.setEnabled(ind > 0);
                    ColorModePane.this.ivMoveObjectDownButton.setEnabled(ind != -1 && ind < ColorModePane.this.ivUsedModesList.getModel().getSize() - 1);
                    ColorModePane.this.ivReact = false;
                    ColorModePane.this.ivNotUsedModesList.clearSelection();
                    ColorModePane.this.ivReact = true;
                }
            }
        });
        this.ivUsedModesList.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent arg0) {
                Point p = arg0.getPoint();
                int row = ColorModePane.this.ivUsedModesList.locationToIndex(p);
                if (row != -1 && p.x < ImageProvider.CHECK_EMPTY_ICON.getIconWidth()) {
                    Integer selValue = (Integer)ColorModePane.this.ivUsedModesList.getSelectedValue();
                    ColorModePane.this.ivMainMode = selValue;
                    ColorModePane.this.ivDontUseColumnButton.setEnabled(false);
                    ColorModePane.this.ivUsedModesList.repaint();
                }
            }
        });
        this.ivUsedModesList.setCellRenderer(this);
        this.ivNotUsedModesList = new JList(this.ivNotUsed);
        this.ivNotUsedModesList.setSelectionMode(0);
        this.ivNotUsedModesList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (ColorModePane.this.ivReact) {
                    ColorModePane.this.ivMoveObjectUpButton.setEnabled(false);
                    ColorModePane.this.ivMoveObjectDownButton.setEnabled(false);
                    ColorModePane.this.ivDontUseColumnButton.setEnabled(false);
                    int ind = ColorModePane.this.ivNotUsedModesList.getSelectedIndex();
                    ColorModePane.this.ivUseColumnButton.setEnabled(ind != -1);
                    ColorModePane.this.ivReact = false;
                    ColorModePane.this.ivUsedModesList.clearSelection();
                    ColorModePane.this.ivReact = true;
                }
            }
        });
        this.ivNotUsedModesList.setCellRenderer(this);
        JScrollPane jsp = new JScrollPane(this.ivNotUsedModesList);
        this.ivUnusedPanel = new BorderPanel(jsp, Babel.get("UNUSED_COLOR_MODES"), FontManager.getFont("SSB14"));
        this.add(this.ivUnusedPanel);
        jsp = new JScrollPane(this.ivUsedModesList);
        this.ivUsedPanel = new BorderPanel(jsp, Babel.get("USED_COLOR_MODES"), FontManager.getFont("SSB14"));
        this.add(this.ivUsedPanel);
        this.ivUseColumnButton.setFont(FontManager.getFont("SSB14"));
        this.ivUseColumnButton.setActionCommand("UC");
        this.ivUseColumnButton.addActionListener(this);
        this.ivUseColumnButton.setEnabled(false);
        this.ivDontUseColumnButton.setFont(FontManager.getFont("SSB14"));
        this.ivDontUseColumnButton.setActionCommand("DUC");
        this.ivDontUseColumnButton.addActionListener(this);
        this.ivDontUseColumnButton.setEnabled(false);
        this.add(this.ivUseColumnButton);
        this.add(this.ivDontUseColumnButton);
        this.ivMoveObjectUpButton.setFont(FontManager.getFont("SSB14"));
        this.ivMoveObjectUpButton.setActionCommand("UP");
        this.ivMoveObjectUpButton.addActionListener(this);
        this.ivMoveObjectUpButton.setEnabled(false);
        this.ivMoveObjectDownButton.setFont(FontManager.getFont("SSB14"));
        this.ivMoveObjectDownButton.setActionCommand("DOWN");
        this.ivMoveObjectDownButton.addActionListener(this);
        this.ivMoveObjectDownButton.setEnabled(false);
        this.add(this.ivMoveObjectUpButton);
        this.add(this.ivMoveObjectDownButton);
    }

    public void adapt(int[] modes, int mainMode) {
        int[] maxModes = CageColorManager.getAllPossibleCageColorModes();
        if (modes == null || modes.length == 0) {
            modes = maxModes;
        }
        this.ivUsed.clear();
        this.ivNotUsed.clear();
        int i = 0;
        while (i < maxModes.length) {
            if (this.isIn(maxModes[i], modes)) {
                this.ivUsed.add(new Integer(maxModes[i]));
            } else {
                this.ivNotUsed.add(new Integer(maxModes[i]));
            }
            ++i;
        }
        this.ivUsedModesList.setListData(this.ivUsed);
        this.ivNotUsedModesList.setListData(this.ivNotUsed);
        this.ivMainMode = this.ivUsed.contains(new Integer(mainMode)) ? mainMode : (Integer)this.ivUsed.firstElement();
        this.repaint();
    }

    private boolean isIn(int val, int[] values) {
        if (values != null) {
            int i = 0;
            while (i < values.length) {
                if (val == values[i]) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public int getMainMode() {
        return this.ivMainMode;
    }

    public int[] getModes() {
        int[] res = new int[this.ivUsed.size()];
        int i = 0;
        while (i < this.ivUsed.size()) {
            Integer inti = (Integer)this.ivUsed.elementAt(i);
            res[i] = inti;
            ++i;
        }
        return res;
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        Integer kennung = (Integer)value;
        String displayValue = CageColorManager.getName(kennung);
        this.ivObjectLabel.setToolTipText(CageColorManager.getToolTip(kennung));
        this.ivObjectLabel.setText(" " + displayValue + " ");
        if (list == this.ivUsedModesList) {
            if (kennung == this.ivMainMode) {
                this.ivObjectLabel.setIcon(ImageProvider.getBulletIcon(Color.red));
            } else {
                this.ivObjectLabel.setIcon(ImageProvider.CLEAR_BULLET_ICON);
            }
        } else {
            this.ivObjectLabel.setIcon(null);
        }
        if (isSelected) {
            this.ivObjectLabel.setOpaque(true);
            this.ivObjectLabel.setBackground(UIDef.SELECTED_BACKGROUND);
        } else {
            this.ivObjectLabel.setOpaque(false);
            this.ivObjectLabel.setBackground(null);
        }
        return this.ivObjectLabel;
    }

    public void addLayoutComponent(String arg0, Component arg1) {
    }

    public void layoutContainer(Container arg0) {
        Dimension d = arg0.getSize();
        int iw = d.width - 10;
        int ih = d.height - 10;
        int ph = ih - 30 - 5;
        int pw = (iw - 5) / 2;
        int y = 5;
        this.ivUnusedPanel.setBounds(5, y, pw, ph);
        this.ivUsedPanel.setBounds(5 + iw - pw, y, pw, ph);
        int nbb = (iw - 15) / 4;
        int rbb = iw - 15 - 3 * nbb;
        int x = 5;
        this.ivUseColumnButton.setBounds(x, y += ph + 5, nbb, 30);
        this.ivDontUseColumnButton.setBounds(x += nbb + 5, y, nbb, 30);
        this.ivMoveObjectUpButton.setBounds(x += nbb + 5, y, nbb, 30);
        this.ivMoveObjectDownButton.setBounds(x += nbb + 5, y, rbb, 30);
        x += nbb + 5;
    }

    public Dimension minimumLayoutSize(Container arg0) {
        return UIDef.MINI_DIM;
    }

    public Dimension preferredLayoutSize(Container arg0) {
        return UIDef.MINI_DIM;
    }

    public void removeLayoutComponent(Component arg0) {
    }

    public void actionPerformed(ActionEvent e) {
        int ind;
        String comm = e.getActionCommand();
        if (comm.equals("UP")) {
            int ind2 = this.ivUsedModesList.getSelectedIndex();
            if (ind2 > 0) {
                Object drueber = this.ivUsed.elementAt(ind2 - 1);
                this.ivUsed.setElementAt(this.ivUsed.elementAt(ind2), ind2 - 1);
                this.ivUsed.setElementAt(drueber, ind2);
                this.ivUsedModesList.setSelectedIndex(ind2 - 1);
                this.ivUsedModesList.repaint();
            }
        } else if (comm.equals("DOWN")) {
            int ind3 = this.ivUsedModesList.getSelectedIndex();
            if (ind3 < this.ivUsed.size() - 1) {
                Object drunter = this.ivUsed.elementAt(ind3 + 1);
                this.ivUsed.setElementAt(this.ivUsed.elementAt(ind3), ind3 + 1);
                this.ivUsed.setElementAt(drunter, ind3);
                this.ivUsedModesList.setSelectedIndex(ind3 + 1);
                this.ivUsedModesList.repaint();
            }
        } else if (comm.equals("UC")) {
            int ind4 = this.ivNotUsedModesList.getSelectedIndex();
            if (ind4 != -1) {
                this.ivUsed.addElement(this.ivNotUsed.elementAt(ind4));
                this.ivNotUsed.removeElementAt(ind4);
                this.ivUsedModesList.setListData(this.ivUsed);
                this.ivNotUsedModesList.setListData(this.ivNotUsed);
                this.ivNotUsedModesList.clearSelection();
                this.ivUsedModesList.setSelectedIndex(this.ivUsed.size() - 1);
                this.ivUsedModesList.repaint();
                this.ivNotUsedModesList.repaint();
            }
        } else if (comm.equals("DUC") && (ind = this.ivUsedModesList.getSelectedIndex()) != -1 && this.ivUsed.size() > 1) {
            this.ivNotUsed.addElement(this.ivUsed.elementAt(ind));
            this.ivUsed.removeElementAt(ind);
            this.ivUsedModesList.setListData(this.ivUsed);
            this.ivNotUsedModesList.setListData(this.ivNotUsed);
            this.ivUsedModesList.clearSelection();
            this.ivNotUsedModesList.setSelectedIndex(this.ivNotUsed.size() - 1);
            this.ivUsedModesList.repaint();
            this.ivNotUsedModesList.repaint();
        }
    }
}

