/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.requester.preferences;

import de.hannse.netobjects.tools.Base64Manager;
import de.hannse.netobjects.tools.FileManager;
import de.hannse.netobjects.user.User;
import de.hannse.netobjects.user.UserManager;
import de.hannse.netobjects.util.ArrayHelper;
import de.hannse.netobjects.util.Babel;
import de.hannse.netobjects.util.Log;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import mausoleum.alert.Alert;
import mausoleum.cage.CageManager;
import mausoleum.cage.colors.CageColorManager;
import mausoleum.gui.MGButton;
import mausoleum.gui.RequesterPane;
import mausoleum.gui.SimpleLayoutManager;
import mausoleum.helper.DatumFormat;
import mausoleum.helper.FontManager;
import mausoleum.helper.MausoleumImageStore;
import mausoleum.helper.NumberFormatter;
import mausoleum.main.DefaultManager;
import mausoleum.main.MausoleumClient;
import mausoleum.printing.labelprinters.LabelPrinter;
import mausoleum.rack.frame.RackFrame;
import mausoleum.rack.frame.RackOverview;
import mausoleum.requester.BasicRequester;
import mausoleum.requester.LabelPrintRequester;
import mausoleum.requester.preferences.CageMaskIcons;
import mausoleum.requester.preferences.ColorModePane;
import mausoleum.requester.preferences.LabelPrinterPane;
import mausoleum.tables.MausoleumTableFrame;
import mausoleum.ui.UIDef;
import mausoleum.util.PathStore;

public class Preferences
extends BasicRequester {
    private static final long serialVersionUID = 1L;
    private static final int BREITE = UIDef.getScaled(780);
    private static final int HOEHE = UIDef.getScaled(550);
    private static final String[] MOUSE_DATE_MODES = new String[]{Babel.get("PREF_DM_WEEKS"), Babel.get("PREF_DM_MONTHS_WEEK_DAYS"), Babel.get("PREF_DM_WEEKS_DAYS"), Babel.get("PREF_DM_DAYS")};
    private static final String[] SEX_MODES = new String[]{Babel.get("PREF_SM_SIGNS"), Babel.get("PREF_SM_LETTERS")};
    private static final String[] MATINGSIGN_MODES = new String[]{Babel.get("PREF_MM_SIGN"), Babel.get("PREF_MM_LETTER")};
    private static final String[] MASK_NAMES = new String[]{Babel.get("MASK_NOTHING"), Babel.get("MASK_BORDER"), Babel.get("MASK_NUMBER"), Babel.get("MASK_COLOR")};
    public static final String[] ZOOM_STRINGS = new String[]{" 200% ", " 170% ", " 150% ", " 140% ", " 130% ", " 120% ", " 110% ", " 100% ", " 90% ", " 80% ", " 70% ", " 60% ", " 50% ", " 40% ", " 30% ", " 20% "};
    public static final double[] ZOOM_FACTORS = new double[]{2.0, 1.7, 1.5, 1.4, 1.3, 1.2, 1.1, 1.0, 0.9, 0.8, 0.7, 0.6, 0.5, 0.4, 0.3, 0.2};
    private static final Integer[] TABLE_FONT_SIZES = new Integer[]{new Integer(8), new Integer(9), new Integer(10), new Integer(11), new Integer(12), new Integer(13), new Integer(14), new Integer(15), new Integer(16), new Integer(17), new Integer(18), new Integer(19), new Integer(20), new Integer(21), new Integer(22), new Integer(23), new Integer(24)};
    private static final String[] CTT_MODE_NAMES = new String[]{Babel.get("CTT_MODE_SIMPLE"), Babel.get("CTT_MODE_TASKS"), Babel.get("CTT_MODE_CAGECARD")};
    private static final int[] CTT_MODE_INTS = new int[]{1, 3, 2};
    private static final String[] UND_MODE_NAMES = new String[]{Babel.get("PREF_UND_LOGIN"), Babel.get("PREF_UND_FULL"), Babel.get("PREF_UND_BOTH")};
    private static final int[] UND_MODE_INTS = new int[]{1, 2, 3};
    private static final double[] SCALE_FACTORS = new double[]{0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 1.0, 1.1, 1.2, 1.3, 1.4, 1.5, 1.6, 1.7, 1.8, 1.9, 2.0};
    private JComboBox ivDesignCombo = new JComboBox<String>(MausoleumImageStore.DESIGNSTRINGS);
    private JSlider ivScaleSlider = null;
    private JComboBox ivDateformatCombo = new JComboBox<String>(DatumFormat.SEL_COMBO_STRINGS);
    private JComboBox ivMouseAgeCombo = new JComboBox<String>(MOUSE_DATE_MODES);
    private JComboBox ivSexCombo = new JComboBox<String>(SEX_MODES);
    private JComboBox ivMatingSignCombo = new JComboBox<String>(MATINGSIGN_MODES);
    private JCheckBox ivEditInTableBox = new JCheckBox();
    private JCheckBox ivAbutPressedBox = new JCheckBox();
    private JComboBox ivTableFontSizeCombo = new JComboBox<Integer>(TABLE_FONT_SIZES);
    private JComboBox ivUserNameDisplayCombo = new JComboBox<String>(UND_MODE_NAMES);
    private JCheckBox ivUseMouseWheelInTableBox = new JCheckBox();
    private JCheckBox ivAutoGenotypBox = new JCheckBox();
    private JCheckBox ivStoreEarTagBox = new JCheckBox();
    private JCheckBox ivWaelsungenAlert = new JCheckBox();
    private JCheckBox ivEartagAlert = new JCheckBox();
    private JCheckBox ivEartag100Alert = new JCheckBox();
    private JCheckBox ivShowPoolDifferentLinesAlert = new JCheckBox();
    private JCheckBox ivCagePseudoIDs = new JCheckBox();
    private JCheckBox ivTooltipBox = new JCheckBox();
    private JComboBox ivCageToolTipModeCombo = new JComboBox<String>(CTT_MODE_NAMES);
    private JComboBox ivCageToolTipZoomCombo = new JComboBox<String>(ZOOM_STRINGS);
    private JComboBox ivCageMaskingCombo = new JComboBox<String>(MASK_NAMES);
    private JLabel ivCageMaskLabel = new JLabel();
    private JCheckBox ivTaskTriangleBox = new JCheckBox();
    private JCheckBox ivShowCageTablesInRackDisplayBox = new JCheckBox();
    private JCheckBox ivOpticalMailAlert = new JCheckBox();
    private JCheckBox ivAcousticalMailAlert = new JCheckBox();
    private JCheckBox ivShowDoneTasks = new JCheckBox();
    private JCheckBox ivShowRejectedTasks = new JCheckBox();
    private JCheckBox ivShowWithdrawnTasks = new JCheckBox();
    private JCheckBox ivAutoSelExtendTasks = new JCheckBox();
    private JCheckBox ivOpticalTaskAlert = new JCheckBox();
    private JCheckBox ivAcousticalTaskAlert = new JCheckBox();
    private ColorModePane ivColorModePane = new ColorModePane();
    private LabelPrinterPane ivCageCardPane = new LabelPrinterPane();
    private MGButton ivResetButton = MGButton.getRequesterButton(Babel.get("Reset"));
    private double ivScaleFactorBefore = UIDef.getUserFactor();
    static /* synthetic */ Class class$0;

    public static void showPreferences(Frame sender) {
        new Preferences(sender).setVisible(true);
    }

    public static void setCageDisplayMode(int mode) {
        if (mode != -1) {
            int oldMode = DefaultManager.getCageDisplayMode();
            DefaultManager.setCageDisplayMode(mode);
            DefaultManager.storeDefaults();
            MausoleumTableFrame.repaintAllTables(false);
            if (oldMode != mode && !MausoleumClient.isHeadOfService()) {
                RackFrame.cageColorModeChanged();
                RackOverview.cageColorModeChanged();
            }
        }
    }

    public static double getClientScaleFactor(User user, double defaultVal) {
        String path;
        File file;
        double res = defaultVal;
        if (user != null && (file = new File(path = PathStore.getClientFactorPath())).exists()) {
            try {
                String key = String.valueOf(Base64Manager.encodeBase64(user.getGroup())) + "_" + user.getID() + "|";
                BufferedReader br = new BufferedReader(new FileReader(file));
                String line = br.readLine();
                while (line != null) {
                    if (line.startsWith(key)) {
                        try {
                            res = Double.parseDouble(line.substring(key.length(), line.length()));
                        }
                        catch (Exception e) {
                            String string = "Malformed scale line " + line;
                            Class<?> clazz = class$0;
                            if (clazz == null) {
                                try {
                                    clazz = Class.forName("mausoleum.requester.preferences.Preferences");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                            }
                            Log.error(string, e, clazz);
                        }
                    }
                    line = br.readLine();
                }
            }
            catch (Exception e) {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("mausoleum.requester.preferences.Preferences");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                Log.error("Error while checking scale factor", e, clazz);
            }
        }
        return res;
    }

    public static void saveScaleFactor(User user, double factor) {
        FileManager.pureAppend(PathStore.getClientFactorPath(), String.valueOf(Base64Manager.encodeBase64(user.getGroup())) + "_" + user.getID() + "|" + factor + "\n");
    }

    private static void setBoolCombo(JComboBox combo, boolean value) {
        if (value) {
            combo.setSelectedIndex(0);
        } else {
            combo.setSelectedIndex(1);
        }
    }

    private Preferences(Frame sender) {
        super(sender, BREITE, HOEHE);
        super.setTitle(Babel.get("PREFS"));
        this.ivResetButton.setActionCommand("RESET");
        this.ivResetButton.addActionListener(this);
        int innerBreite = BREITE - 2 * UIDef.RAND;
        int innerHoehe = HOEHE - 2 * UIDef.RAND;
        int butHeight = this.ivResetButton.getPreferredSize().height + 4;
        int lbw = (innerBreite - UIDef.INNER_RAND) / 2;
        int rbw = innerBreite - UIDef.INNER_RAND - lbw;
        int tabHeight = innerHoehe - butHeight - UIDef.INNER_RAND;
        int butY = UIDef.RAND + tabHeight + UIDef.INNER_RAND;
        this.addAndApplyBounds(this.ivResetButton, UIDef.RAND, butY, lbw, butHeight);
        this.applyBounds(this.ivOkButton, UIDef.RAND + lbw + UIDef.INNER_RAND, butY, rbw, butHeight);
        JTabbedPane tabbedPane = new JTabbedPane();
        this.addAndApplyBounds(tabbedPane, UIDef.RAND, UIDef.RAND, innerBreite, tabHeight);
        RequesterPane pane = new RequesterPane(new PrefTabManager());
        tabbedPane.add(Babel.get("PREF_GENERAL"), pane);
        pane.addC(new JLabel(Babel.get("DESIGN")));
        pane.addC(this.ivDesignCombo);
        pane.addC(new JLabel(""));
        pane.addC(new JLabel(""));
        pane.addC(new JLabel(Babel.get("SCALE_FACTOR")));
        int ind = ArrayHelper.finddoubleInArray(this.ivScaleFactorBefore, SCALE_FACTORS);
        this.ivScaleSlider = new JSlider(0, 0, SCALE_FACTORS.length - 1, ind);
        this.ivScaleSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent arg0) {
            }
        });
        this.ivScaleSlider.setPaintTicks(true);
        this.ivScaleSlider.setMajorTickSpacing(2);
        this.ivScaleSlider.setMinorTickSpacing(1);
        this.ivScaleSlider.setPaintLabels(true);
        this.ivScaleSlider.setOpaque(false);
        this.ivScaleSlider.setSnapToTicks(true);
        Hashtable<Integer, JLabel> labelTable = new Hashtable<Integer, JLabel>();
        int i = 0;
        while (i < SCALE_FACTORS.length) {
            labelTable.put(new Integer(i), new JLabel(NumberFormatter.formatNumberString(SCALE_FACTORS[i], 1)));
            i += 2;
        }
        this.ivScaleSlider.setLabelTable(labelTable);
        this.ivScaleSlider.setFont(FontManager.getFont("SSB11"));
        Dimension dim = this.ivScaleSlider.getPreferredSize();
        dim.width = dim.width * 3 / 2;
        this.ivScaleSlider.setPreferredSize(dim);
        this.ivScaleSlider.setPaintLabels(true);
        pane.addC(this.ivScaleSlider);
        pane = new RequesterPane(new PrefTabManager());
        tabbedPane.add(Babel.get("PREF_TABLES"), pane);
        pane.addC(new JLabel(Babel.get("DATEMODE")));
        pane.addC(this.ivDateformatCombo);
        pane.addC(new JLabel(Babel.get("AGEMODE")));
        pane.addC(this.ivMouseAgeCombo);
        pane.addC(new JLabel(Babel.get("SEXMODE")));
        pane.addC(this.ivSexCombo);
        pane.addC(new JLabel(Babel.get("MATINGSIGNMODE")));
        pane.addC(this.ivMatingSignCombo);
        pane.addC(new JLabel(Babel.get("PREF_USER_NAME_DISPLAY")));
        pane.addC(this.ivUserNameDisplayCombo);
        pane.addC(new JLabel(Babel.get("EDITINTABLE")));
        this.ivEditInTableBox.setOpaque(false);
        pane.addC(this.ivEditInTableBox);
        pane.addC(new JLabel(Babel.get("ABUTPRESSED")));
        this.ivAbutPressedBox.setOpaque(false);
        pane.addC(this.ivAbutPressedBox);
        pane.addC(new JLabel(Babel.get("TABLE_FONT_SIZE")));
        pane.addC(this.ivTableFontSizeCombo);
        pane.addC(new JLabel(Babel.get("USE_MOUSE_WHEEL_SCALING")));
        this.ivUseMouseWheelInTableBox.setOpaque(false);
        pane.addC(this.ivUseMouseWheelInTableBox);
        pane = new RequesterPane(new PrefTabManager());
        tabbedPane.add(Babel.get("PREF_MICE"), pane);
        pane.addC(new JLabel(Babel.get("AUTOGENOTYPE")));
        this.ivAutoGenotypBox.setOpaque(false);
        pane.addC(this.ivAutoGenotypBox);
        pane.addC(new JLabel(Babel.get("STORE_LAST_EARTAG")));
        this.ivStoreEarTagBox.setOpaque(false);
        pane.addC(this.ivStoreEarTagBox);
        pane.addC(new JLabel(Babel.get("MOUSEPREF_WAELSUNGEN")));
        this.ivWaelsungenAlert.setOpaque(false);
        pane.addC(this.ivWaelsungenAlert);
        pane.addC(new JLabel(Babel.get("MOUSEPREF_EARTAG")));
        this.ivEartagAlert.setOpaque(false);
        pane.addC(this.ivEartagAlert);
        pane.addC(new JLabel(Babel.get("MOUSEPREF_EARTAG_100")));
        this.ivEartag100Alert.setOpaque(false);
        pane.addC(this.ivEartag100Alert);
        pane.addC(new JLabel(Babel.get("MOUSEPREF_POOL_DIFFERENT_LINES")));
        this.ivShowPoolDifferentLinesAlert.setOpaque(false);
        pane.addC(this.ivShowPoolDifferentLinesAlert);
        pane = new RequesterPane(new PrefTabManager());
        tabbedPane.add(Babel.get("PREF_CAGES"), pane);
        pane.addC(new JLabel(Babel.get("CAGE_PSEUDO_IDS")));
        this.ivCagePseudoIDs.setOpaque(false);
        pane.addC(this.ivCagePseudoIDs);
        pane.addC(new JLabel(Babel.get("TOOLTIPS")));
        this.ivTooltipBox.setOpaque(false);
        pane.addC(this.ivTooltipBox);
        this.ivCageToolTipModeCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                Preferences.this.checkZoomCombo();
            }
        });
        JPanel px = new JPanel(new BorderLayout());
        px.setOpaque(false);
        px.add("Center", this.ivCageToolTipModeCombo);
        px.add("East", this.ivCageToolTipZoomCombo);
        pane.addC(new JLabel(Babel.get("CTT_MODE")));
        pane.addC(px);
        this.ivCageMaskingCombo.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent arg0) {
                Preferences.this.ivCageMaskLabel.setIcon(CageMaskIcons.getIcon(Preferences.this.ivCageMaskingCombo.getSelectedIndex()));
            }
        });
        px = new JPanel(new BorderLayout());
        px.setOpaque(false);
        px.add("East", this.ivCageMaskLabel);
        px.add("Center", this.ivCageMaskingCombo);
        pane.addC(new JLabel(Babel.get("MASKCAGES")));
        pane.addC(px);
        pane.addC(new JLabel(Babel.get("SHOW_TASK_MARKER_IN_RACK_VIEW")));
        this.ivTaskTriangleBox.setOpaque(false);
        pane.addC(this.ivTaskTriangleBox);
        pane.addC(new JLabel(Babel.get("SHOW_CAGE_TABLES_IN_RACK_VIEW")));
        this.ivShowCageTablesInRackDisplayBox.setOpaque(false);
        pane.addC(this.ivShowCageTablesInRackDisplayBox);
        pane = new RequesterPane(new PrefTabManager());
        tabbedPane.add(Babel.get("PREF_MAIL"), pane);
        pane.addC(new JLabel(Babel.get("MAILPREF_GIVE_OPTICAL_ALERT")));
        this.ivOpticalMailAlert.setOpaque(false);
        pane.addC(this.ivOpticalMailAlert);
        pane.addC(new JLabel(Babel.get("MAILPREF_GIVE_ACOUSTICAL_ALERT")));
        this.ivAcousticalMailAlert.setOpaque(false);
        pane.addC(this.ivAcousticalMailAlert);
        pane = new RequesterPane(new PrefTabManager());
        tabbedPane.add(Babel.get("PREF_TASKS"), pane);
        pane.addC(new JLabel(Babel.get("VIEW_DONE_TASKS")));
        this.ivShowDoneTasks.setOpaque(false);
        pane.addC(this.ivShowDoneTasks);
        pane.addC(new JLabel(Babel.get("VIEW_REJECTED_TASKS")));
        this.ivShowRejectedTasks.setOpaque(false);
        pane.addC(this.ivShowRejectedTasks);
        pane.addC(new JLabel(Babel.get("VIEW_WITHDRAWN_TASKS")));
        this.ivShowWithdrawnTasks.setOpaque(false);
        pane.addC(this.ivShowWithdrawnTasks);
        pane.addC(new JLabel(Babel.get("AUTO_TASK_SELECT_SIBLINGS")));
        this.ivAutoSelExtendTasks.setOpaque(false);
        pane.addC(this.ivAutoSelExtendTasks);
        pane.addC(new JLabel(Babel.get("TPREF_GIVE_OPTICAL_ALERT")));
        this.ivOpticalTaskAlert.setOpaque(false);
        pane.addC(this.ivOpticalTaskAlert);
        pane.addC(new JLabel(Babel.get("TPREF_GIVE_ACOUSTICAL_ALERT")));
        this.ivAcousticalTaskAlert.setOpaque(false);
        pane.addC(this.ivAcousticalTaskAlert);
        tabbedPane.add(Babel.get("PREF_COLOR"), this.ivColorModePane);
        tabbedPane.add(Babel.get("LABELPRINTER"), this.ivCageCardPane);
        this.resetValues();
    }

    public boolean okAndNoWanted() {
        return true;
    }

    public boolean onlyOKWanted() {
        return false;
    }

    private void resetValues() {
        DatumFormat.adjustCombo(DefaultManager.getDatumFormat(), this.ivDateformatCombo);
        switch (DefaultManager.getMouseAgeFormat()) {
            case 1: {
                this.ivMouseAgeCombo.setSelectedIndex(1);
                break;
            }
            case 2: {
                this.ivMouseAgeCombo.setSelectedIndex(0);
                break;
            }
            case 3: {
                this.ivMouseAgeCombo.setSelectedIndex(2);
                break;
            }
            case 4: {
                this.ivMouseAgeCombo.setSelectedIndex(3);
                break;
            }
            default: {
                this.ivMouseAgeCombo.setSelectedIndex(1);
            }
        }
        this.ivColorModePane.adapt(DefaultManager.getColorModes(), DefaultManager.getCageDisplayMode());
        this.ivCageCardPane.adapt(DefaultManager.cvExcludedPrinters, DefaultManager.getLabelPrinter());
        this.ivDesignCombo.setSelectedItem(MausoleumImageStore.getDesignStringForDesign(DefaultManager.getLocalDesign()));
        Preferences.setBoolCombo(this.ivSexCombo, DefaultManager.isSexModeSign());
        Preferences.setBoolCombo(this.ivMatingSignCombo, DefaultManager.showMatingSign());
        this.ivTooltipBox.setSelected(DefaultManager.getWantsTooltips());
        this.ivEditInTableBox.setSelected(DefaultManager.getExecuteInTable());
        this.ivAbutPressedBox.setSelected(DefaultManager.getAButtonAlwaysPressed());
        this.ivAutoGenotypBox.setSelected(DefaultManager.getAutoGenotype());
        this.ivCageMaskingCombo.setSelectedIndex(DefaultManager.getMaskCagesMode());
        this.ivCageMaskLabel.setIcon(CageMaskIcons.getIcon(DefaultManager.getMaskCagesMode()));
        int ind = ArrayHelper.findIndexInArray(DefaultManager.getCageTooltipMode(), CTT_MODE_INTS);
        this.ivCageToolTipModeCombo.setSelectedIndex(ind < 0 ? 0 : ind);
        ind = ArrayHelper.findIndexInArray(DefaultManager.getUserNameDisplayMode(), UND_MODE_INTS);
        this.ivUserNameDisplayCombo.setSelectedIndex(ind < 0 ? 0 : ind);
        this.ivCagePseudoIDs.setSelected(!DefaultManager.useCagePseudoIDs());
        this.ivStoreEarTagBox.setSelected(DefaultManager.cvStoreLastUsedEarTag);
        int zind = 5;
        double cttZoom = DefaultManager.getCageTooltipZoom();
        int i = 0;
        while (i < ZOOM_FACTORS.length) {
            if (ZOOM_FACTORS[i] == cttZoom) {
                zind = i;
            }
            ++i;
        }
        this.ivCageToolTipZoomCombo.setSelectedIndex(zind);
        this.ivTableFontSizeCombo.setSelectedItem(new Integer(DefaultManager.cvTableFontSize));
        this.checkZoomCombo();
        this.ivShowDoneTasks.setSelected(DefaultManager.showDoneTasks());
        this.ivShowRejectedTasks.setSelected(DefaultManager.showRejectedTasks());
        this.ivShowWithdrawnTasks.setSelected(DefaultManager.showWithdrawnTasks());
        this.ivAutoSelExtendTasks.setSelected(DefaultManager.autoSelExtendTasks());
        this.ivOpticalTaskAlert.setSelected(DefaultManager.cvOpticalTaskAlert);
        this.ivAcousticalTaskAlert.setSelected(DefaultManager.cvAcousticalTaskAlert);
        this.ivOpticalMailAlert.setSelected(DefaultManager.cvOpticalMailAlert);
        this.ivAcousticalMailAlert.setSelected(DefaultManager.cvAcousticalMailAlert);
        this.ivWaelsungenAlert.setSelected(DefaultManager.cvShowWaelsungenAlert);
        this.ivEartagAlert.setSelected(DefaultManager.cvShowEarTagAlert);
        this.ivEartag100Alert.setSelected(DefaultManager.cvShowEarTag100Alert);
        this.ivShowPoolDifferentLinesAlert.setSelected(DefaultManager.cvShowPoolDifferentLinesAlert);
        this.ivTaskTriangleBox.setSelected(DefaultManager.showTaskTriangleInRack());
        this.ivShowCageTablesInRackDisplayBox.setSelected(DefaultManager.showCageTablesInRackDisplay());
        this.ivUseMouseWheelInTableBox.setSelected(DefaultManager.cvUseMouseWheelInTables);
    }

    public void OKPressed() {
        int ddm = 2;
        switch (this.ivMouseAgeCombo.getSelectedIndex()) {
            case 0: {
                ddm = 2;
                break;
            }
            case 1: {
                ddm = 1;
                break;
            }
            case 2: {
                ddm = 3;
                break;
            }
            case 3: {
                ddm = 4;
                break;
            }
            default: {
                ddm = 2;
            }
        }
        int oldCageMode = DefaultManager.getCageDisplayMode();
        boolean oldCagePseudoIDMode = DefaultManager.useCagePseudoIDs();
        boolean oldTriangleMode = DefaultManager.showTaskTriangleInRack();
        int oldMaskMode = DefaultManager.getMaskCagesMode();
        boolean oldCageTablesInRackDisplayMode = DefaultManager.showCageTablesInRackDisplay();
        LabelPrintRequester.setLastUsedLablePrinter(this.ivCageCardPane.getMainMode());
        DefaultManager.writeNewDefaults(DatumFormat.SEL_COMBO_VALS[this.ivDateformatCombo.getSelectedIndex()], ddm, this.ivSexCombo.getSelectedIndex(), this.ivColorModePane.getMainMode(), MausoleumImageStore.getDesignForDesignString((String)this.ivDesignCombo.getSelectedItem()), this.ivCageCardPane.getMainMode(), this.ivTooltipBox.isSelected(), this.ivEditInTableBox.isSelected(), this.ivCageMaskingCombo.getSelectedIndex(), this.ivAbutPressedBox.isSelected(), this.ivAutoGenotypBox.isSelected(), this.ivMatingSignCombo.getSelectedIndex(), CTT_MODE_INTS[this.ivCageToolTipModeCombo.getSelectedIndex()], !this.ivCagePseudoIDs.isSelected(), ZOOM_FACTORS[this.ivCageToolTipZoomCombo.getSelectedIndex()], (Integer)this.ivTableFontSizeCombo.getSelectedItem(), this.ivColorModePane.getModes(), this.ivStoreEarTagBox.isSelected(), this.ivShowDoneTasks.isSelected(), this.ivShowRejectedTasks.isSelected(), this.ivShowWithdrawnTasks.isSelected(), this.ivAutoSelExtendTasks.isSelected(), this.ivTaskTriangleBox.isSelected(), this.ivOpticalTaskAlert.isSelected(), this.ivAcousticalTaskAlert.isSelected(), this.ivOpticalMailAlert.isSelected(), this.ivAcousticalMailAlert.isSelected(), this.ivWaelsungenAlert.isSelected(), this.ivEartagAlert.isSelected(), this.ivEartag100Alert.isSelected(), this.ivShowCageTablesInRackDisplayBox.isSelected(), this.ivCageCardPane.getExcludedPrinters(), this.ivShowPoolDifferentLinesAlert.isSelected(), UND_MODE_INTS[this.ivUserNameDisplayCombo.getSelectedIndex()], this.ivUseMouseWheelInTableBox.isSelected());
        MausoleumTableFrame.repaintAllTables(true);
        if (MausoleumClient.isRegularOrTGService()) {
            if (DefaultManager.getCageDisplayMode() != oldCageMode || CageColorManager.needsMattColor(oldMaskMode) != CageColorManager.needsMattColor(DefaultManager.getMaskCagesMode())) {
                CageManager.prepareSingleColorsOfAllCages(DefaultManager.getCageDisplayMode(), null);
            }
            if (oldMaskMode != DefaultManager.getMaskCagesMode() || oldCagePseudoIDMode != DefaultManager.useCagePseudoIDs() || oldTriangleMode != DefaultManager.showTaskTriangleInRack() || oldCageTablesInRackDisplayMode != DefaultManager.showCageTablesInRackDisplay()) {
                boolean potResize = oldCageTablesInRackDisplayMode ^ DefaultManager.showCageTablesInRackDisplay();
                RackFrame.redisplay(potResize);
                if (potResize) {
                    RackFrame.getInstance().validate();
                    RackFrame.getInstance().reselectCages();
                }
                RackOverview.cageColorModeChanged();
            }
        }
        if (DefaultManager.getCageDisplayMode() != oldCageMode && MausoleumClient.isRegularOrTGService()) {
            RackFrame.cageColorModeChanged();
            RackOverview.cageColorModeChanged();
        }
        LabelPrinter.makeCagePrinterNames();
        double scaleFactorAfter = SCALE_FACTORS[this.ivScaleSlider.getValue()];
        if (scaleFactorAfter != this.ivScaleFactorBefore) {
            Preferences.saveScaleFactor(UserManager.getUserWithoutDisguise(), scaleFactorAfter);
            Alert.showAlert(Babel.get("ALERT_SCALE_FACTOR"), true);
        }
        this.dispose();
    }

    private void checkZoomCombo() {
        this.ivCageToolTipZoomCombo.setEnabled(CTT_MODE_INTS[this.ivCageToolTipModeCombo.getSelectedIndex()] == 2);
        this.ivCageToolTipZoomCombo.setVisible(CTT_MODE_INTS[this.ivCageToolTipModeCombo.getSelectedIndex()] == 2);
    }

    public void actionPerformed(ActionEvent e) {
        super.actionPerformed(e);
        String comm = e.getActionCommand();
        if (comm.equals("RESET")) {
            this.resetValues();
        }
    }

    class PrefTabManager
    extends SimpleLayoutManager {
        private static final int MIN_R = 200;
        private final Vector ivComps = new Vector();

        PrefTabManager() {
        }

        public void addLayoutComponent(String arg0, Component arg1) {
            this.ivComps.add(arg1);
        }

        public void layoutContainer(Container arg0) {
            int yoff;
            Dimension bd = arg0.getSize();
            int lw = 0;
            int rw = 200;
            int i = 0;
            while (i < this.ivComps.size()) {
                Component c = (Component)this.ivComps.elementAt(i);
                Dimension d = c.getPreferredSize();
                if (d.width > lw) {
                    lw = d.width;
                }
                c = (Component)this.ivComps.elementAt(i + 1);
                d = c.getPreferredSize();
                if (d.width > rw) {
                    rw = d.width;
                }
                i += 2;
            }
            int gw = lw + rw + UIDef.RAND;
            int xoff = (bd.width - gw) / 2;
            int al = this.ivComps.size() / 2;
            int gh = al * UIDef.LINE_HEIGHT + (al - 1) * UIDef.INNER_RAND;
            int y = yoff = (bd.height - gh) / 2;
            int x1 = xoff;
            int x2 = x1 + lw + UIDef.RAND;
            int i2 = 0;
            while (i2 < this.ivComps.size()) {
                Component c = (Component)this.ivComps.elementAt(i2);
                c.setBounds(x1, y, lw, UIDef.LINE_HEIGHT);
                c = (Component)this.ivComps.elementAt(i2 + 1);
                int h = UIDef.LINE_HEIGHT;
                Dimension d = c.getPreferredSize();
                if (d.height > h) {
                    h = d.height;
                }
                if (c instanceof JCheckBox) {
                    c.setBounds(x2, y, UIDef.LINE_HEIGHT, h);
                } else {
                    c.setBounds(x2, y, rw, h);
                }
                y += h + UIDef.INNER_RAND;
                i2 += 2;
            }
        }
    }
}

