/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.requester.rack;

import de.hannse.netobjects.tools.Base64Manager;
import de.hannse.netobjects.util.Babel;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import mausoleum.alert.Alert;
import mausoleum.helper.FontManager;
import mausoleum.rack.RackManager;
import mausoleum.requester.BasicRequester;
import mausoleum.ui.UIDef;

public class NewRackRequester
extends BasicRequester {
    private static final long serialVersionUID = 1L;
    private static final int BREITE = UIDef.getScaled(340);
    private static final int HOEHE = UIDef.getScaled(134);
    private static final int ZEILEN_HOEHE = UIDef.getScaled(24);
    private static final int FIELD_WIDTH = UIDef.getScaled(110);
    private static final int RAND = UIDef.getScaled(10);
    private String[] ivSideChoices = new String[]{"1", "2"};
    private String[] ivSquareChoices = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17"};
    private JComboBox ivSides = new JComboBox<String>(this.ivSideChoices);
    private JComboBox ivRows = new JComboBox<String>(this.ivSquareChoices);
    private JComboBox ivCols = new JComboBox<String>(this.ivSquareChoices);
    private JTextField ivName = new JTextField();
    private final String ivGroup;

    public static String getSRCNString(Frame sender, String group) {
        NewRackRequester nrr = new NewRackRequester(sender, group);
        nrr.setVisible(true);
        if (nrr.ivWarOK) {
            return nrr.ivSides.getSelectedItem() + " " + nrr.ivRows.getSelectedItem() + " " + nrr.ivCols.getSelectedItem() + " " + Base64Manager.encodeBase64(nrr.ivName.getText());
        }
        return null;
    }

    private NewRackRequester(Frame sender, String group) {
        super(sender, BREITE, HOEHE);
        this.ivGroup = group;
        this.ivSides.setSelectedItem("2");
        this.ivRows.setSelectedItem("7");
        this.ivCols.setSelectedItem("7");
        this.applyBounds(this.ivOkButton, UIDef.getScaled(230), RAND, UIDef.getScaled(90), UIDef.getScaled(55));
        this.applyBounds(this.ivNoButton, UIDef.getScaled(230), RAND + UIDef.getScaled(59), UIDef.getScaled(90), UIDef.getScaled(55));
        this.addPermanentLabel(Babel.get("NAME"), RAND, UIDef.getScaled(10), ZEILEN_HOEHE);
        this.addPermanentLabel(Babel.get("SIDES"), RAND, UIDef.getScaled(40), ZEILEN_HOEHE);
        this.addPermanentLabel(Babel.get("ROWS"), RAND, UIDef.getScaled(70), ZEILEN_HOEHE);
        this.addPermanentLabel(Babel.get("COLUMNS"), RAND, UIDef.getScaled(100), ZEILEN_HOEHE);
        this.addAndApplyBounds(this.ivName, UIDef.getScaled(110), UIDef.getScaled(10), FIELD_WIDTH, ZEILEN_HOEHE);
        this.addAndApplyBounds(this.ivSides, UIDef.getScaled(110), UIDef.getScaled(40), FIELD_WIDTH, ZEILEN_HOEHE);
        this.addAndApplyBounds(this.ivRows, UIDef.getScaled(110), UIDef.getScaled(70), FIELD_WIDTH, ZEILEN_HOEHE);
        this.addAndApplyBounds(this.ivCols, UIDef.getScaled(110), UIDef.getScaled(100), FIELD_WIDTH, ZEILEN_HOEHE);
        this.addWindowListener(new WindowAdapter(){

            public void windowOpened(WindowEvent e) {
                NewRackRequester.this.ivName.requestFocus();
            }
        });
        this.ivName.setFont(FontManager.getFont("SSB11"));
        this.ivName.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                if (NewRackRequester.this.ivName.getText().trim().length() != 0) {
                    NewRackRequester.this.OKPressed();
                }
            }
        });
        this.ivName.addCaretListener(new CaretListener(){

            public void caretUpdate(CaretEvent arg0) {
                NewRackRequester.this.checkOKBut();
            }
        });
        this.checkOKBut();
    }

    private void checkOKBut() {
        this.ivOkButton.setEnabled(this.ivName.getText().trim().length() != 0);
    }

    public void OKPressed() {
        String name = this.ivName.getText().trim();
        if (name.length() == 0) {
            Alert.showAlert(Babel.get("EMPTY_NOT_ALLOWED"), true);
        } else if (RackManager.isNameAlreadyTaken(name, this.ivGroup)) {
            Alert.showAlert(Babel.get("RACKALREADYPRESENT"), true);
        } else {
            this.ivWarOK = true;
            this.dispose();
        }
    }
}

