/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.requester.rack;

import de.hannse.netobjects.objectstore.IDObject;
import de.hannse.netobjects.util.Babel;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.border.EtchedBorder;
import mausoleum.cage.colors.CageColorManager;
import mausoleum.cage.colors.ColorMode;
import mausoleum.gui.RequesterPane;
import mausoleum.gui.SimpleLayoutManager;
import mausoleum.helper.MausoleumImageStore;
import mausoleum.helper.WindowUtils;
import mausoleum.helper.Zeile;
import mausoleum.rack.Rack;
import mausoleum.rack.RackManager;
import mausoleum.requester.rack.RackServiceDisplayComponent;
import mausoleum.requester.rack.RackServiceLegendList;
import mausoleum.ui.UIDef;

public class RackServiceDisplayFrame
extends JFrame {
    private static final long serialVersionUID = 1234L;
    private static RackServiceDisplayFrame cvInstance = null;
    private RackServiceDisplayComponent ivComponent = new RackServiceDisplayComponent();
    private RackServiceLegendList ivLegendList = new RackServiceLegendList();
    private JPanel ivLegendPane = new JPanel(new BorderLayout());
    private JSplitPane ivSplitPane = new JSplitPane(1, this.ivComponent, this.ivLegendPane);
    private JComboBox ivRackCombo;
    private JComboBox ivModeCombo;
    private final Vector ivRacks;
    private final Vector ivModes;
    private Long ivSelRackID = null;
    private int ivSelModeID = -1;

    public static void showDisplay(Vector selectedRacks) {
        if (cvInstance == null) {
            cvInstance = new RackServiceDisplayFrame();
        }
        WindowUtils.bringUpFrame(cvInstance);
        if (selectedRacks != null && !selectedRacks.isEmpty()) {
            Rack toSel = (Rack)selectedRacks.firstElement();
            Long toSelID = (Long)toSel.get("IDO_ID");
            int i = 0;
            while (i < RackServiceDisplayFrame.cvInstance.ivRacks.size()) {
                Rack track = (Rack)RackServiceDisplayFrame.cvInstance.ivRacks.elementAt(i);
                if (toSelID.equals(track.get("IDO_ID"))) {
                    RackServiceDisplayFrame.cvInstance.ivRackCombo.setSelectedIndex(i);
                    return;
                }
                ++i;
            }
        }
    }

    public static void destroyIt() {
        if (cvInstance != null) {
            cvInstance.setVisible(false);
            cvInstance.getContentPane().removeAll();
            if (RackServiceDisplayFrame.cvInstance.ivComponent != null) {
                RackServiceDisplayFrame.cvInstance.ivComponent.dispose();
                RackServiceDisplayFrame.cvInstance.ivComponent = null;
            }
            RackServiceDisplayFrame.cvInstance.ivRacks.clear();
            RackServiceDisplayFrame.cvInstance.ivModes.clear();
            cvInstance = null;
        }
    }

    public static void groupColorsChanged() {
        if (cvInstance != null && RackServiceDisplayFrame.cvInstance.ivSelModeID == 20) {
            cvInstance.adapt();
        }
    }

    private RackServiceDisplayFrame() {
        this.setTitle(Babel.get("HEAD_OF_SERVICE_RACK_OVERVIEW"));
        this.setIconImage(MausoleumImageStore.getLogo());
        RequesterPane pane = new RequesterPane(new SimpleLayoutManager(){

            public void layoutContainer(Container arg0) {
                Dimension d = arg0.getSize();
                int iw = d.width - 2 * UIDef.RAND;
                int ih = d.height - 2 * UIDef.RAND;
                int uh = ih - UIDef.LINE_HEIGHT - UIDef.INNER_RAND;
                int x = UIDef.RAND;
                int y = UIDef.RAND;
                int cwidth = ((RackServiceDisplayFrame)RackServiceDisplayFrame.this).ivRackCombo.getPreferredSize().width;
                RackServiceDisplayFrame.this.ivRackCombo.setBounds(x, y, cwidth, UIDef.LINE_HEIGHT);
                x += cwidth + UIDef.INNER_RAND;
                cwidth = ((RackServiceDisplayFrame)RackServiceDisplayFrame.this).ivModeCombo.getPreferredSize().width;
                RackServiceDisplayFrame.this.ivModeCombo.setBounds(x, y, cwidth, UIDef.LINE_HEIGHT);
                x = UIDef.RAND;
                RackServiceDisplayFrame.this.ivSplitPane.setBounds(x, y += UIDef.LINE_HEIGHT + UIDef.INNER_RAND, iw, uh);
            }
        });
        this.ivRacks = RackManager.cvInstance.getActualObjectVectorAllGroups();
        Collections.sort(this.ivRacks, IDObject.SORTER_BY_NAME);
        Vector<String> rackNames = new Vector<String>();
        Iterator iter = this.ivRacks.iterator();
        while (iter.hasNext()) {
            Rack rack = (Rack)iter.next();
            rackNames.add(" " + rack.getBrowseName() + " [" + rack.anzCagesInServiceRack() + "] ");
        }
        this.ivRackCombo = new JComboBox(rackNames);
        pane.add(this.ivRackCombo);
        this.ivSelRackID = (Long)((Rack)this.ivRacks.firstElement()).get("IDO_ID");
        this.ivRackCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                RackServiceDisplayFrame.this.ivSelRackID = (Long)((Rack)RackServiceDisplayFrame.this.ivRacks.elementAt(RackServiceDisplayFrame.this.ivRackCombo.getSelectedIndex())).get("IDO_ID");
                RackServiceDisplayFrame.this.adapt();
            }
        });
        this.ivModes = CageColorManager.getDefinedModes();
        Vector<String> modeNames = new Vector<String>();
        Iterator iter2 = this.ivModes.iterator();
        while (iter2.hasNext()) {
            ColorMode cmode = (ColorMode)iter2.next();
            modeNames.add(" " + CageColorManager.getName(cmode.ivModeInt) + " ");
        }
        this.ivModeCombo = new JComboBox(modeNames);
        pane.add(this.ivModeCombo);
        this.ivSelModeID = ((ColorMode)this.ivModes.firstElement()).ivModeInt;
        this.ivModeCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                RackServiceDisplayFrame.this.ivSelModeID = ((ColorMode)((RackServiceDisplayFrame)RackServiceDisplayFrame.this).ivModes.elementAt((int)((RackServiceDisplayFrame)RackServiceDisplayFrame.this).ivModeCombo.getSelectedIndex())).ivModeInt;
                RackServiceDisplayFrame.this.adapt();
                RackServiceDisplayFrame.this.rememberSettings();
            }
        });
        this.ivComponent.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent arg0) {
                RackServiceDisplayFrame.this.ivComponent.createImage();
                RackServiceDisplayFrame.this.ivComponent.repaint();
                RackServiceDisplayFrame.this.rememberSettings();
            }
        });
        this.ivComponent.setBorder(new EtchedBorder(1));
        this.ivLegendPane.add("Center", this.ivLegendList.ivScrollPane);
        this.ivLegendPane.setOpaque(false);
        this.ivLegendPane.setBorder(UIDef.getTitleBorder("LEGEND"));
        this.ivSplitPane.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent changeEvent) {
                if (changeEvent.getPropertyName().equals("lastDividerLocation")) {
                    RackServiceDisplayFrame.this.rememberSettings();
                }
            }
        });
        this.ivSplitPane.setOpaque(false);
        pane.add(this.ivSplitPane);
        this.getContentPane().add(pane);
        this.getSettings();
    }

    private void adapt() {
        if (this.ivSelRackID != null && this.ivSelModeID != -1) {
            this.ivComponent.adapt(this.ivSelRackID, this.ivSelModeID, this.ivLegendList);
            this.ivModeCombo.setToolTipText(CageColorManager.getToolTip(this.ivSelModeID));
        }
    }

    private void rememberSettings() {
        Rectangle r = this.getBounds();
        String s = String.valueOf(r.x) + " " + r.y + " " + r.width + " " + r.height + " " + this.ivSelModeID + " " + this.ivSplitPane.getDividerLocation();
        WindowUtils.rememberSettings(this, s);
    }

    private void getSettings() {
        Rectangle r = new Rectangle(UIDef.getScaled(10), UIDef.getScaled(10), UIDef.getScaled(600), UIDef.getScaled(400));
        int split = UIDef.getScaled(400);
        int sel = 0;
        String s = WindowUtils.getSettings(this);
        if (s != null) {
            Zeile z = new Zeile(s, ' ');
            r = new Rectangle(z.getInt(0, r.x), z.getInt(1, r.y), z.getInt(2, r.width), z.getInt(3, r.height));
            int mode = z.getInt(4, -1);
            if (mode != -1) {
                int i = 0;
                while (i < this.ivModes.size()) {
                    ColorMode cm = (ColorMode)this.ivModes.elementAt(i);
                    if (cm.ivModeInt == mode) {
                        sel = i;
                        break;
                    }
                    ++i;
                }
            }
            split = z.getInt(5, split);
        }
        this.ivModeCombo.setSelectedIndex(sel);
        this.setBounds(r);
        this.ivSplitPane.setDividerLocation(split);
    }
}

