/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.requester.rack;

import de.hannse.netobjects.tools.Base64Manager;
import de.hannse.netobjects.user.UserManager;
import de.hannse.netobjects.util.Babel;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import mausoleum.gui.MGButton;
import mausoleum.gui.RequesterPane;
import mausoleum.gui.SimpleLayoutManager;
import mausoleum.gui.TextWrapComponent;
import mausoleum.helper.FontManager;
import mausoleum.inspector.Inspector;
import mausoleum.inspector.actions.usergroup.RackMerker;
import mausoleum.rack.Rack;
import mausoleum.rack.RackManager;
import mausoleum.requester.BasicRequester;
import mausoleum.requester.rack.RackConflictDialog;
import mausoleum.room.Room;
import mausoleum.room.RoomManager;
import mausoleum.ui.UIDef;

public class TransferRackToServiceRequester
extends BasicRequester {
    private static final long serialVersionUID = 1123L;
    private static final int BREITE = UIDef.getScaled(600);
    private static final int HOEHE = UIDef.getScaled(400);
    private static final int RAND = UIDef.getScaled(10);
    private static final int INNER_BREITE = BREITE - 2 * RAND;
    private static final int BUT_HEIGHT = UIDef.getScaled(35);
    private static final int TAB_HEIGHT = UIDef.getScaled(180);
    private static final int LAB_WIDTH = UIDef.getScaled(100);
    private static final int FIELD_WIDTH = UIDef.getScaled(200);
    private static final int LINE_HEIGHT = UIDef.getScaled(24);
    public long ivServiceRackID = -1L;
    public long ivServiceRoomID = -1L;
    public String ivTargetName = null;
    private JLabel ivRaumLabel = new JLabel(Babel.get("ROOM"));
    private Vector ivRaeume = RoomManager.getActualObjects(UserManager.getFirstGroup());
    private Vector ivRaumNamen = new Vector();
    private JComboBox ivRaumCombo = null;
    private JLabel ivNameLabel = new JLabel(Babel.get("NAME"));
    private JTextField ivNameField = new JTextField();
    private MGButton ivOK1 = MGButton.getRequesterButton(Babel.get("YES"));
    private MGButton ivNO1 = MGButton.getRequesterButton(Babel.get("NO"));
    private JLabel ivRackLabel = new JLabel(Babel.get("RACK"));
    private Vector ivRacks = new Vector();
    private Vector ivRackNamen = new Vector();
    private JComboBox ivRackCombo = null;
    private MGButton ivOK2 = MGButton.getRequesterButton(Babel.get("YES"));
    private MGButton ivNO2 = MGButton.getRequesterButton(Babel.get("NO"));
    private final String ivGruppe;
    private final RackMerker ivRackMerker;
    private final HashSet ivRackNamesSoFar = new HashSet();
    public String ivCommand = null;

    public TransferRackToServiceRequester(String gruppe, RackMerker merker) {
        super((Frame)Inspector.getInspector(), BREITE, HOEHE);
        this.ivGruppe = gruppe;
        this.ivRackMerker = merker;
        int y = RAND;
        TextWrapComponent twc = new TextWrapComponent(Babel.get("RACK_IMPORT_OPTIONS"), FontManager.getFont("SSB16"));
        twc.setOrientation(1112);
        twc.setSize(INNER_BREITE, 100);
        twc.generateElements();
        int h = twc.getNecessaryHeight() + UIDef.getScaled(5);
        this.addAndApplyBounds(twc, RAND, y, INNER_BREITE, h);
        JTabbedPane tabbedPane = new JTabbedPane();
        this.addAndApplyBounds(tabbedPane, RAND, y += h + RAND, INNER_BREITE, TAB_HEIGHT);
        this.setInnerSize(BREITE, y += TAB_HEIGHT + RAND);
        Iterator iter = this.ivRaeume.iterator();
        while (iter.hasNext()) {
            Room room = (Room)iter.next();
            this.ivRaumNamen.addElement(room.getBrowseName());
        }
        if (!this.ivRaumNamen.isEmpty()) {
            this.ivRaumCombo = new JComboBox(this.ivRaumNamen);
            this.ivNameField.setText(this.ivRackMerker.ivNameInGroup);
            RequesterPane panel = new RequesterPane(new SimpleLayoutManager(){

                public void layoutContainer(Container arg0) {
                    Dimension d = arg0.getSize();
                    int r = UIDef.INNER_RAND;
                    int nw = LAB_WIDTH + r + FIELD_WIDTH;
                    int nh = LINE_HEIGHT + r + LINE_HEIGHT + UIDef.RAND + BUT_HEIGHT;
                    int xoff = (d.width - nw) / 2;
                    int yoff = (d.height - nh) / 2;
                    int x1 = xoff;
                    int x2 = x1 + LAB_WIDTH + r;
                    int y = yoff;
                    TransferRackToServiceRequester.this.ivRaumLabel.setBounds(x1, y, LAB_WIDTH, LINE_HEIGHT);
                    TransferRackToServiceRequester.this.ivRaumCombo.setBounds(x2, y, FIELD_WIDTH, LINE_HEIGHT);
                    TransferRackToServiceRequester.this.ivNameLabel.setBounds(x1, y += LINE_HEIGHT + r, LAB_WIDTH, LINE_HEIGHT);
                    TransferRackToServiceRequester.this.ivNameField.setBounds(x2, y, FIELD_WIDTH, LINE_HEIGHT);
                    int blw = (nw - r) / 2;
                    int brw = nw - r - blw;
                    int x = xoff;
                    TransferRackToServiceRequester.this.ivOK1.setBounds(x, y += LINE_HEIGHT + UIDef.RAND, blw, BUT_HEIGHT);
                    TransferRackToServiceRequester.this.ivNO1.setBounds(x += blw + r, y, brw, BUT_HEIGHT);
                }
            });
            panel.add(this.ivRaumLabel);
            panel.add(this.ivRaumCombo);
            panel.add(this.ivNameLabel);
            panel.add(this.ivNameField);
            panel.add(this.ivOK1);
            panel.add(this.ivNO1);
            this.ivNameField.addCaretListener(new CaretListener(){

                public void caretUpdate(CaretEvent arg0) {
                    TransferRackToServiceRequester.this.checkImportOK1();
                }
            });
            this.ivOK1.setEnabled(this.ivNameField.getText().trim().length() != 0);
            this.ivOK1.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent arg0) {
                    TransferRackToServiceRequester.this.doImportNew();
                }
            });
            this.ivNO1.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent arg0) {
                    TransferRackToServiceRequester.this.setVisible(false);
                }
            });
            tabbedPane.addTab(Babel.get("SEL_IMPORT_NEW"), panel);
        }
        Enumeration en = RackManager.cvInstance.getActualObjectEnumeration(UserManager.getFirstGroup());
        while (en.hasMoreElements()) {
            Rack rack = (Rack)en.nextElement();
            this.ivRackNamesSoFar.add(rack.getName());
            if (rack.getInt("RCK_SIDES", 0) != this.ivRackMerker.ivSides || rack.getInt("RCK_ROWS", 0) != this.ivRackMerker.ivRows || rack.getInt("RCK_COLUMNS", 0) != this.ivRackMerker.ivColumns || rack.getSharedGroups().contains(gruppe)) continue;
            this.ivRacks.add(rack);
            this.ivRackNamen.add(rack.getBrowseName());
        }
        if (!this.ivRackNamen.isEmpty()) {
            this.ivRackCombo = new JComboBox(this.ivRackNamen);
            RequesterPane panel = new RequesterPane(new SimpleLayoutManager(){

                public void layoutContainer(Container arg0) {
                    Dimension d = arg0.getSize();
                    int r = UIDef.INNER_RAND;
                    int nw = LAB_WIDTH + r + FIELD_WIDTH;
                    int nh = LINE_HEIGHT + UIDef.RAND + BUT_HEIGHT;
                    int xoff = (d.width - nw) / 2;
                    int yoff = (d.height - nh) / 2;
                    int x1 = xoff;
                    int x2 = x1 + LAB_WIDTH + r;
                    int y = yoff;
                    TransferRackToServiceRequester.this.ivRackLabel.setBounds(x1, y, LAB_WIDTH, LINE_HEIGHT);
                    TransferRackToServiceRequester.this.ivRackCombo.setBounds(x2, y, FIELD_WIDTH, LINE_HEIGHT);
                    int blw = (nw - r) / 2;
                    int brw = nw - r - blw;
                    int x = xoff;
                    TransferRackToServiceRequester.this.ivOK2.setBounds(x, y += LINE_HEIGHT + UIDef.RAND, blw, BUT_HEIGHT);
                    TransferRackToServiceRequester.this.ivNO2.setBounds(x += blw + r, y, brw, BUT_HEIGHT);
                }
            });
            panel.add(this.ivRackLabel);
            panel.add(this.ivRackCombo);
            panel.add(this.ivOK2);
            panel.add(this.ivNO2);
            this.ivOK2.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent arg0) {
                    TransferRackToServiceRequester.this.doImportExisting();
                }
            });
            this.ivNO2.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent arg0) {
                    TransferRackToServiceRequester.this.setVisible(false);
                }
            });
            tabbedPane.addTab(Babel.get("SEL_IMPORT_EXISTING"), panel);
        }
        this.checkImportOK1();
        this.setVisible(true);
    }

    private void checkImportOK1() {
        String testName = this.ivNameField.getText().trim();
        this.ivOK1.setEnabled(testName.length() != 0 && !this.ivRackNamesSoFar.contains(testName));
    }

    private void doImportNew() {
        Room room = (Room)this.ivRaeume.elementAt(this.ivRaumCombo.getSelectedIndex());
        String name = this.ivNameField.getText().trim();
        StringBuffer msb = new StringBuffer("RK_IMPORT_SERVICE");
        msb.append(" ").append(Base64Manager.encodeBase64(this.ivGruppe));
        msb.append(" ").append(this.ivRackMerker.ivIDInGroup);
        msb.append(" ").append(-1L);
        msb.append(" ").append(room.getID());
        msb.append(" ").append(Base64Manager.encodeBase64(name));
        this.ivCommand = msb.toString();
        this.setVisible(false);
    }

    private void doImportExisting() {
        boolean[] groupOccupied;
        Rack serviceRack = (Rack)this.ivRacks.elementAt(this.ivRackCombo.getSelectedIndex());
        boolean[] serviceOccupied = (boolean[])serviceRack.get("RCK_OCC");
        if (serviceOccupied == null) {
            serviceOccupied = new boolean[this.ivRackMerker.ivSides * this.ivRackMerker.ivRows * this.ivRackMerker.ivColumns];
        }
        if ((groupOccupied = this.ivRackMerker.ivGroupCages) == null) {
            groupOccupied = new boolean[this.ivRackMerker.ivSides * this.ivRackMerker.ivRows * this.ivRackMerker.ivColumns];
        }
        int doubleOccupieds = 0;
        int i = 0;
        while (i < groupOccupied.length) {
            if (groupOccupied[i] && serviceOccupied[i]) {
                ++doubleOccupieds;
            }
            ++i;
        }
        if (doubleOccupieds != 0) {
            RackConflictDialog rcd = new RackConflictDialog(this, this.ivRackMerker.ivSides, this.ivRackMerker.ivRows, this.ivRackMerker.ivColumns, serviceOccupied, groupOccupied);
            if (!rcd.ivWarOK) {
                return;
            }
        }
        StringBuffer msb = new StringBuffer("RK_IMPORT_SERVICE");
        msb.append(" ").append(Base64Manager.encodeBase64(this.ivGruppe));
        msb.append(" ").append(this.ivRackMerker.ivIDInGroup);
        msb.append(" ").append(serviceRack.getID());
        msb.append(" ").append(-1L);
        msb.append(" ").append(Base64Manager.encodeBase64("Brauchen wir nicht"));
        this.ivCommand = msb.toString();
        this.setVisible(false);
    }

    public boolean okAndNoWanted() {
        return false;
    }

    public boolean onlyOKWanted() {
        return false;
    }

    public void dispose() {
        super.dispose();
    }
}

