/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.requester.result;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import mausoleum.experiment.Experiment;
import mausoleum.gui.DoubleScrollBar;
import mausoleum.gui.KomfortTextField;
import mausoleum.gui.SimpleLayoutManager;
import mausoleum.gui.documents.DoubleDocument;
import mausoleum.helper.FontManager;
import mausoleum.requester.result.EnterResultPanel;
import mausoleum.ui.UIDef;

public class EnterResultPanelDouble
extends EnterResultPanel {
    private static final long serialVersionUID = 1L;
    private static final int SCROLL_WIDTH = UIDef.getScaled(180);
    private static final int FIELD_WIDTH = UIDef.getScaled(120);
    private static final int FIELD_HEIGHT = UIDef.getScaled(30);
    public DoubleScrollBar ivScrollBar = new DoubleScrollBar(0);
    private KomfortTextField ivDoubleField = new KomfortTextField();
    private double ivLowerLimit;
    private double ivUpperLimit;
    private double ivValue;
    private int ivLastScrollerVal = -1;
    private boolean ivScrollerReacts = true;
    private boolean ivFieldReacts = true;
    public boolean ivUseFullSpace = false;

    public EnterResultPanelDouble() {
        this.setLayout(new SimpleLayoutManager(){

            public void layoutContainer(Container parent) {
                Dimension d = parent.getSize();
                int fh = d.height < FIELD_HEIGHT ? d.height : FIELD_HEIGHT;
                int y = (d.height - fh) / 2;
                int scrollWidth = EnterResultPanelDouble.this.ivUseFullSpace ? d.width - FIELD_WIDTH - UIDef.INNER_RAND : SCROLL_WIDTH;
                int gesw = scrollWidth + UIDef.INNER_RAND + FIELD_WIDTH;
                int x = (d.width - gesw) / 2;
                EnterResultPanelDouble.this.ivScrollBar.setBounds(x, y, scrollWidth, fh);
                EnterResultPanelDouble.this.ivDoubleField.setBounds(x + scrollWidth + UIDef.INNER_RAND, y, FIELD_WIDTH, fh);
            }
        });
        this.ivScrollBar.addAdjustmentListener(new AdjustmentListener(){

            public void adjustmentValueChanged(AdjustmentEvent e) {
                int sval;
                if (EnterResultPanelDouble.this.ivScrollerReacts && (sval = EnterResultPanelDouble.this.ivScrollBar.getValue()) != EnterResultPanelDouble.this.ivLastScrollerVal) {
                    EnterResultPanelDouble.this.ivFieldReacts = false;
                    try {
                        EnterResultPanelDouble.this.ivLastScrollerVal = sval;
                        double newVal = EnterResultPanelDouble.this.ivScrollBar.getDoubleValue();
                        if (newVal != EnterResultPanelDouble.this.ivValue) {
                            EnterResultPanelDouble.this.ivValue = newVal;
                            EnterResultPanelDouble.this.ivDoubleField.setText(EnterResultPanelDouble.this.ivScrollBar.getDoubleString(EnterResultPanelDouble.this.ivValue));
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    EnterResultPanelDouble.this.ivFieldReacts = true;
                }
            }
        });
        this.add(this.ivScrollBar);
        this.ivDoubleField.addCaretListener(new CaretListener(){

            public void caretUpdate(CaretEvent arg0) {
                if (EnterResultPanelDouble.this.ivFieldReacts) {
                    EnterResultPanelDouble.this.ivScrollerReacts = false;
                    try {
                        double val = EnterResultPanelDouble.this.ivDoubleField.getDouble(Double.NaN);
                        if (!Double.isNaN(val) && val != EnterResultPanelDouble.this.ivValue) {
                            try {
                                EnterResultPanelDouble.this.ivValue = val;
                                EnterResultPanelDouble.this.ivScrollBar.setDoubleValue(EnterResultPanelDouble.this.ivValue);
                                EnterResultPanelDouble.this.ivLastScrollerVal = EnterResultPanelDouble.this.ivScrollBar.getValue();
                            }
                            catch (Exception exception) {}
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    EnterResultPanelDouble.this.ivScrollerReacts = true;
                }
            }
        });
        this.ivDoubleField.setHorizontalAlignment(4);
        this.ivDoubleField.setFont(FontManager.getFont("SSB12"));
        this.ivDoubleField.setDocument(new DoubleDocument(this.ivDoubleField));
        this.add(this.ivDoubleField);
    }

    protected void adaptToExperiment(Experiment expi) {
        Object[] posValues = (Object[])expi.get("EXP_POSV");
        if (posValues.length == 2) {
            this.setLimits((Double)posValues[0], (Double)posValues[1], Double.NaN);
        }
    }

    public void setValue(double newVal) {
        this.ivValue = newVal;
        this.ivDoubleField.setText(this.ivScrollBar.getDoubleString(this.ivValue));
        this.ivScrollBar.setDoubleValue(this.ivValue);
        this.ivLastScrollerVal = this.ivScrollBar.getValue();
    }

    public void setLimits(double lower, double upper, double val) {
        this.ivLowerLimit = lower;
        this.ivUpperLimit = upper;
        this.ivScrollBar.setDoubleLimits(this.ivLowerLimit, this.ivUpperLimit);
        this.ivScrollBar.setDoubleValue((this.ivLowerLimit + this.ivUpperLimit) / 2.0);
        if (!Double.isNaN(val)) {
            this.ivScrollBar.setDoubleValue(val);
            this.ivValue = val;
            this.ivDoubleField.setText(this.ivScrollBar.getDoubleString(this.ivValue));
            this.ivLastScrollerVal = this.ivScrollBar.getValue();
        } else {
            this.ivValue = this.ivScrollBar.getDoubleValue();
            this.ivDoubleField.setText(this.ivScrollBar.getDoubleString(this.ivValue));
        }
    }

    protected boolean isResultOK(Object result) {
        Double dbl;
        double d;
        return result != null && result instanceof Double && !Double.isNaN(d = (dbl = (Double)result).doubleValue()) && d >= this.ivLowerLimit && d <= this.ivUpperLimit;
    }

    public Object getResult() {
        double strdbl = this.ivDoubleField.getDouble(Double.NaN);
        if (!Double.isNaN(strdbl)) {
            return new Double(strdbl);
        }
        return null;
    }
}

