/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.requester.result;

import de.hannse.netobjects.user.UserManager;
import de.hannse.netobjects.util.Babel;
import de.hannse.netobjects.util.MyDate;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import mausoleum.definitionlists.ListDefinition;
import mausoleum.definitionlists.Microorganism;
import mausoleum.gui.BorderPanel;
import mausoleum.gui.MGButton;
import mausoleum.gui.SimpleLayoutManager;
import mausoleum.helper.FontManager;
import mausoleum.helper.ImageProvider;
import mausoleum.helper.WindowUtils;
import mausoleum.requester.AllgChoiceRequester;
import mausoleum.requester.BasicRequester;
import mausoleum.requester.calendar.CalendarPanel;
import mausoleum.result.rackhealthreport.RResHealthReport;
import mausoleum.result.rackhealthreport.RResWrapper;
import mausoleum.ui.UIDef;
import mausoleum.ui.table.NiceRegularTable;

public class RackHealthReportGeneralsRequester
extends BasicRequester {
    private static final long serialVersionUID = 11881689443435L;
    private static final int NAME_HEIGHT = UIDef.getScaled(28);
    private static final int COMBO_WIDTH = UIDef.getScaled(240);
    private static Rectangle cvBounds = null;
    private JLabel ivPerformerLabel = null;
    private JTextField ivPerformerField = null;
    private BorderPanel ivResultBorderPanel = null;
    private final NiceRegularTable ivMicroorganismTable;
    private CalendarPanel ivCalendarPanel = null;
    private Dimension ivMiniDim = new Dimension(0, 0);
    private Dimension ivMaxiDim = new Dimension(0, 0);
    public GeneralMicroorganismResult ivResult = null;
    static /* synthetic */ Class class$0;

    public static void maximizeIt(int w, int h, Dimension d) {
        if (w > d.width) {
            d.width = w;
        }
        d.height += h;
    }

    public RackHealthReportGeneralsRequester(Frame sender) {
        super(sender, 10, 10);
        this.setResizable(true);
        this.getContentPane().setLayout(new SimpleLayoutManager(){

            public void layoutContainer(Container parent) {
                boolean anzButtons;
                Dimension d = parent.getSize();
                int x = UIDef.RAND;
                int y = UIDef.RAND;
                int iw = d.width - 2 * UIDef.RAND;
                int ih = d.height - 2 * UIDef.RAND;
                if (RackHealthReportGeneralsRequester.this.ivPerformerLabel != null) {
                    int lw = iw - UIDef.INNER_RAND - COMBO_WIDTH;
                    RackHealthReportGeneralsRequester.this.ivPerformerLabel.setBounds(x, y, lw, NAME_HEIGHT);
                    RackHealthReportGeneralsRequester.this.ivPerformerField.setBounds(x + lw + UIDef.INNER_RAND, y, COMBO_WIDTH, NAME_HEIGHT);
                    y += NAME_HEIGHT + UIDef.INNER_RAND;
                }
                int panH = ih - (RackHealthReportGeneralsRequester.this.ivPerformerLabel != null ? NAME_HEIGHT + UIDef.INNER_RAND : 0) - (RackHealthReportGeneralsRequester.this.ivCalendarPanel != null ? CalendarPanel.HOEHE + UIDef.INNER_RAND : 0) - (UIDef.BUT_HEIGHT + UIDef.INNER_RAND) - UIDef.INNER_RAND;
                RackHealthReportGeneralsRequester.this.ivResultBorderPanel.setBounds(x, y, iw, panH);
                y += panH + UIDef.INNER_RAND;
                if (RackHealthReportGeneralsRequester.this.ivCalendarPanel != null) {
                    int lw = (iw - CalendarPanel.BREITE) / 2;
                    RackHealthReportGeneralsRequester.this.ivCalendarPanel.setBounds(x + lw, y, CalendarPanel.BREITE, CalendarPanel.HOEHE);
                    y += CalendarPanel.HOEHE + UIDef.INNER_RAND;
                }
                if (anzButtons = true) {
                    RackHealthReportGeneralsRequester.this.ivOkButton.setBounds(x, y, iw, UIDef.BUT_HEIGHT);
                }
            }
        });
        MicroorganismTable mot = new MicroorganismTable(this.ivOkButton, this, null);
        this.ivMicroorganismTable = new NiceRegularTable(mot);
        mot.addClicker(this.ivMicroorganismTable);
        int col = 0;
        while (col < mot.getColumnCount()) {
            this.ivMicroorganismTable.getColumnModel().getColumn(col).setPreferredWidth(mot.getPrefWidth(col));
            ++col;
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.ivMicroorganismTable.setDefaultRenderer(clazz, mot);
        this.ivPerformerLabel = new JLabel(Babel.get("REPORTED_BY"));
        this.ivPerformerLabel.setFont(FontManager.getFont("SSB14"));
        this.getContentPane().add(this.ivPerformerLabel);
        this.ivPerformerField = new JTextField();
        this.ivPerformerField.setFont(FontManager.getFont("SSB14"));
        this.ivPerformerField.setText(UserManager.getNameOfUser());
        this.getContentPane().add(this.ivPerformerField);
        int mw = this.ivPerformerLabel.getPreferredSize().width + UIDef.INNER_RAND + COMBO_WIDTH;
        int mh = NAME_HEIGHT + UIDef.INNER_RAND;
        RackHealthReportGeneralsRequester.maximizeIt(mw, mh, this.ivMiniDim);
        RackHealthReportGeneralsRequester.maximizeIt(mw, mh, this.ivMaxiDim);
        JScrollPane jsp = new JScrollPane(this.ivMicroorganismTable);
        jsp.setOpaque(false);
        jsp.getViewport().setOpaque(false);
        jsp.getVerticalScrollBar().setUnitIncrement(4);
        JPanel pan = new JPanel(new BorderLayout(UIDef.INNER_RAND, UIDef.INNER_RAND));
        pan.setOpaque(false);
        pan.add("Center", jsp);
        JPanel pan2 = new JPanel(new GridLayout(1, 2, UIDef.INNER_RAND, UIDef.INNER_RAND));
        pan2.setOpaque(false);
        pan.add("South", pan2);
        MGButton but = new MGButton(Babel.get("PRIV_SELECT_ALL"));
        but.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ((MicroorganismTable)RackHealthReportGeneralsRequester.this.ivMicroorganismTable.getModel()).selectAll();
            }
        });
        pan2.add(but);
        but = new MGButton(Babel.get("PRIV_SELECT_NOTHING"));
        but.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ((MicroorganismTable)RackHealthReportGeneralsRequester.this.ivMicroorganismTable.getModel()).selectNone();
            }
        });
        pan2.add(but);
        this.ivResultBorderPanel = new BorderPanel(pan, Babel.get("ARHR_TESTED_MICROORGANISMS"));
        this.getContentPane().add(this.ivResultBorderPanel);
        mw = this.ivMicroorganismTable.getPreferredSize().width + UIDef.getScaled(40);
        int mxh = this.ivMicroorganismTable.getPreferredSize().height + UIDef.getScaled(50);
        if (mxh > 300) {
            mxh = 300;
        }
        int mnh = UIDef.getScaled(200);
        RackHealthReportGeneralsRequester.maximizeIt(mw, mnh + UIDef.INNER_RAND, this.ivMiniDim);
        RackHealthReportGeneralsRequester.maximizeIt(mw + UIDef.getScaled(30), mxh + UIDef.INNER_RAND, this.ivMaxiDim);
        this.ivCalendarPanel = new CalendarPanel(null, MyDate.getMyDate(System.currentTimeMillis()));
        RackHealthReportGeneralsRequester.maximizeIt(CalendarPanel.BREITE, CalendarPanel.HOEHE + UIDef.INNER_RAND, this.ivMiniDim);
        RackHealthReportGeneralsRequester.maximizeIt(CalendarPanel.BREITE, CalendarPanel.HOEHE + UIDef.INNER_RAND, this.ivMaxiDim);
        this.getContentPane().add(this.ivCalendarPanel);
        this.getContentPane().add(this.ivOkButton);
        RackHealthReportGeneralsRequester.maximizeIt(UIDef.getScaled(400), UIDef.BUT_HEIGHT, this.ivMiniDim);
        RackHealthReportGeneralsRequester.maximizeIt(UIDef.getScaled(400), UIDef.BUT_HEIGHT, this.ivMaxiDim);
        this.ivMiniDim.width += 2 * UIDef.RAND;
        this.ivMiniDim.height += 2 * UIDef.RAND;
        this.ivMaxiDim.width += 2 * UIDef.RAND;
        this.ivMaxiDim.height += 2 * UIDef.RAND;
        int ww = this.ivMiniDim.width;
        int wh = this.ivMaxiDim.height;
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        if (screen.height - UIDef.getScaled(90) < wh) {
            wh = screen.height - UIDef.getScaled(90);
        }
        this.pack();
        Insets innis = this.getInsets();
        this.ivMiniDim.width += innis.left + innis.right;
        this.ivMiniDim.height += innis.top + innis.bottom;
        this.ivMaxiDim.width += innis.left + innis.right;
        this.ivMaxiDim.height += innis.top + innis.bottom;
        this.setMinimumSize(this.ivMiniDim);
        this.setMaximumSize(this.ivMaxiDim);
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                Component c = (Component)e.getSource();
                Dimension d = c.getSize();
                boolean changed = false;
                if (d.width < ((RackHealthReportGeneralsRequester)RackHealthReportGeneralsRequester.this).ivMiniDim.width) {
                    d.width = ((RackHealthReportGeneralsRequester)RackHealthReportGeneralsRequester.this).ivMiniDim.width;
                    changed = true;
                }
                if (d.width > ((RackHealthReportGeneralsRequester)RackHealthReportGeneralsRequester.this).ivMaxiDim.width) {
                    d.width = ((RackHealthReportGeneralsRequester)RackHealthReportGeneralsRequester.this).ivMaxiDim.width;
                    changed = true;
                }
                if (d.height < ((RackHealthReportGeneralsRequester)RackHealthReportGeneralsRequester.this).ivMiniDim.height) {
                    d.height = ((RackHealthReportGeneralsRequester)RackHealthReportGeneralsRequester.this).ivMiniDim.height;
                    changed = true;
                }
                if (d.height > ((RackHealthReportGeneralsRequester)RackHealthReportGeneralsRequester.this).ivMaxiDim.height) {
                    d.height = ((RackHealthReportGeneralsRequester)RackHealthReportGeneralsRequester.this).ivMaxiDim.height;
                    changed = true;
                }
                if (changed) {
                    c.setSize(d);
                    super.componentResized(e);
                }
                cvBounds = c.getBounds();
            }

            public void componentMoved(ComponentEvent e) {
                Component c = (Component)e.getSource();
                cvBounds = c.getBounds();
            }
        });
        this.checkButton();
        if (cvBounds != null) {
            this.setBounds(cvBounds);
            this.setVisible(true);
        } else {
            WindowUtils.bringUpCenteredDialog(this, ww, wh, true);
        }
    }

    public void repaint() {
        this.checkButton();
        super.repaint();
    }

    private void checkButton() {
        boolean okPossible;
        MicroorganismTable mot = (MicroorganismTable)this.ivMicroorganismTable.getModel();
        boolean bl = okPossible = !mot.ivSelectedMicroorganisms.isEmpty();
        if (okPossible) {
            Iterator iterator = mot.ivSelectedMicroorganisms.iterator();
            while (iterator.hasNext()) {
                Microorganism.Keim keim = (Microorganism.Keim)iterator.next();
                if (mot.ivMethodForMicroorganisms.containsKey(keim)) continue;
                okPossible = false;
            }
        }
        this.ivOkButton.setEnabled(okPossible);
    }

    public boolean okAndNoWanted() {
        return false;
    }

    public boolean onlyOKWanted() {
        return true;
    }

    public void OKPressed() {
        this.ivResult = new GeneralMicroorganismResult(this.ivPerformerField.getText(), this.ivCalendarPanel.getSelectedDatumInt(), (MicroorganismTable)this.ivMicroorganismTable.getModel());
        super.OKPressed();
    }

    public void dispose() {
        ((MicroorganismTable)this.ivMicroorganismTable.getModel()).dispose();
        super.dispose();
    }

    public static class GeneralMicroorganismResult {
        public String ivPerformer;
        public int ivDate;
        public ListDefinition[] ivMicroorganisms;
        public ListDefinition[] ivMethods;
        public String ivDetails;

        public GeneralMicroorganismResult(String performer, int date, ListDefinition[] microorganisms, ListDefinition[] methods, String details) {
            this.ivPerformer = performer;
            this.ivDate = date;
            this.ivMicroorganisms = microorganisms;
            this.ivMethods = methods;
            this.ivDetails = details != null && details.trim().length() != 0 ? details.trim() : null;
        }

        public GeneralMicroorganismResult(String performer, int date, MicroorganismTable mot) {
            this.ivPerformer = performer;
            this.ivDate = date;
            this.ivMicroorganisms = new ListDefinition[mot.ivSelectedMicroorganisms.size()];
            this.ivMethods = new ListDefinition[mot.ivSelectedMicroorganisms.size()];
            int pos = 0;
            Vector v = new Vector(mot.ivMicroorganisms);
            Collections.sort(v, Microorganism.KEIM_OHNE_FELASA_COMP);
            Iterator iterator = v.iterator();
            while (iterator.hasNext()) {
                ListDefinition mold = (ListDefinition)iterator.next();
                if (!mot.ivSelectedMicroorganisms.contains(mold)) continue;
                this.ivMicroorganisms[pos] = mold;
                this.ivMethods[pos] = (ListDefinition)mot.ivMethodForMicroorganisms.get(mold);
                ++pos;
            }
        }

        public GeneralMicroorganismResult(RResWrapper healthResultWrapper) {
            RResHealthReport report = healthResultWrapper.ivHealthReport;
            this.ivPerformer = report.ivPerformer;
            this.ivDate = report.ivDate;
            this.ivMicroorganisms = new ListDefinition[report.ivMicroResults.length];
            this.ivMethods = new ListDefinition[report.ivMicroResults.length];
            int i = 0;
            while (i < report.ivMicroResults.length) {
                RResHealthReport.MicroRes mr = report.ivMicroResults[i];
                this.ivMicroorganisms[i] = Microorganism.getKeim(mr.ivMicroOrganismID);
                this.ivMethods[i] = Microorganism.getKeimMethod(mr.ivCheckMethodID);
                ++i;
            }
            this.ivDetails = report.ivDetails;
        }

        public ListDefinition getMethod(Microorganism.Keim keim) {
            int i = 0;
            while (i < this.ivMicroorganisms.length) {
                if (keim.ivID == this.ivMicroorganisms[i].ivID) {
                    return this.ivMethods[i];
                }
                ++i;
            }
            return keim.getMethodDefinition();
        }
    }

    public static class MicroorganismTable
    implements TableModel,
    TableCellRenderer {
        private Vector ivMicroorganisms = ListDefinition.getItems(new String[]{"service"}, 8, true, false, true);
        private Vector ivMethods = ListDefinition.getItems(new String[]{"service"}, 9, true, false, true);
        private String[] ivMethodNames = null;
        protected HashSet ivSelectedMicroorganisms = new HashSet();
        public HashMap ivMethodForMicroorganisms = new HashMap();
        private JLabel ivListLabel = new JLabel();
        private boolean ivDragClickedAllowed = false;
        private boolean ivDragMode = false;
        private MGButton ivReqOkButton = null;
        private Component ivSuperComponent = null;

        public MicroorganismTable(MGButton okButton, Component superComponent, HashSet selectedKeimIDs) {
            Microorganism.Keim keim;
            Iterator iterator;
            this.ivSuperComponent = superComponent;
            if (selectedKeimIDs != null) {
                iterator = this.ivMicroorganisms.iterator();
                while (iterator.hasNext()) {
                    keim = (Microorganism.Keim)iterator.next();
                    if (!selectedKeimIDs.contains(new Integer(keim.ivID))) continue;
                    this.ivSelectedMicroorganisms.add(keim);
                }
            } else {
                this.ivSelectedMicroorganisms.addAll(this.ivMicroorganisms);
            }
            iterator = this.ivMicroorganisms.iterator();
            while (iterator.hasNext()) {
                keim = (Microorganism.Keim)iterator.next();
                ListDefinition methLD = keim.getMethodDefinition();
                if (methLD == null) continue;
                this.ivMethodForMicroorganisms.put(keim, methLD);
            }
            this.ivMethodNames = new String[this.ivMethods.size()];
            int i = 0;
            while (i < this.ivMethods.size()) {
                ListDefinition methLD = (ListDefinition)this.ivMethods.elementAt(i);
                this.ivMethodNames[i] = methLD.toString();
                ++i;
            }
            this.ivReqOkButton = okButton;
            if (this.ivReqOkButton != null) {
                this.ivReqOkButton.setEnabled(!this.ivSelectedMicroorganisms.isEmpty());
            }
        }

        public void dispose() {
            this.ivReqOkButton = null;
        }

        public void selectAll() {
            this.ivSelectedMicroorganisms.addAll(this.ivMicroorganisms);
            this.ivSuperComponent.repaint();
        }

        public void selectNone() {
            this.ivSelectedMicroorganisms.clear();
            this.ivSuperComponent.repaint();
        }

        public void addClicker(JTable table) {
            table.addMouseMotionListener(new MouseMotionAdapter(this){
                final /* synthetic */ MicroorganismTable this$1;
                {
                    this.this$1 = microorganismTable;
                }

                public void mouseDragged(MouseEvent e) {
                    if (MicroorganismTable.access$1(this.this$1) && !e.isMetaDown()) {
                        JTable tab = (JTable)e.getSource();
                        int row = tab.rowAtPoint(e.getPoint());
                        int col = tab.columnAtPoint(e.getPoint());
                        if (col == 0 && row >= 0 && row < MicroorganismTable.access$0(this.this$1).size()) {
                            ListDefinition microLD = (ListDefinition)MicroorganismTable.access$0(this.this$1).elementAt(row);
                            if (MicroorganismTable.access$2(this.this$1)) {
                                this.this$1.ivSelectedMicroorganisms.add(microLD);
                            } else {
                                this.this$1.ivSelectedMicroorganisms.remove(microLD);
                            }
                            if (MicroorganismTable.access$3(this.this$1) != null) {
                                MicroorganismTable.access$3(this.this$1).setEnabled(!this.this$1.ivSelectedMicroorganisms.isEmpty());
                            }
                        }
                    }
                }
            });
            table.addMouseListener(new MouseAdapter(this){
                final /* synthetic */ MicroorganismTable this$1;
                {
                    this.this$1 = microorganismTable;
                }

                public void mouseReleased(MouseEvent e) {
                    MicroorganismTable.access$4(this.this$1, false);
                }

                public void mousePressed(MouseEvent e) {
                    if (!e.isMetaDown()) {
                        MicroorganismTable.access$4(this.this$1, false);
                        JTable tab = (JTable)e.getSource();
                        int row = tab.rowAtPoint(e.getPoint());
                        int col = tab.columnAtPoint(e.getPoint());
                        if (col == 0) {
                            MicroorganismTable.access$4(this.this$1, true);
                            ListDefinition microLD = (ListDefinition)MicroorganismTable.access$0(this.this$1).elementAt(row);
                            if (this.this$1.ivSelectedMicroorganisms.contains(microLD)) {
                                this.this$1.ivSelectedMicroorganisms.remove(microLD);
                                MicroorganismTable.access$5(this.this$1, false);
                            } else {
                                this.this$1.ivSelectedMicroorganisms.add(microLD);
                                MicroorganismTable.access$5(this.this$1, true);
                            }
                            if (MicroorganismTable.access$3(this.this$1) != null) {
                                MicroorganismTable.access$3(this.this$1).setEnabled(!this.this$1.ivSelectedMicroorganisms.isEmpty());
                            }
                            tab.repaint();
                        }
                    }
                }

                public void mouseClicked(MouseEvent e) {
                    if (!e.isMetaDown()) {
                        ListDefinition microLD;
                        JTable tab = (JTable)e.getSource();
                        int row = tab.rowAtPoint(e.getPoint());
                        int col = tab.columnAtPoint(e.getPoint());
                        if (col == 2 && this.this$1.ivSelectedMicroorganisms.contains(microLD = (ListDefinition)MicroorganismTable.access$0(this.this$1).elementAt(row))) {
                            int ind;
                            int selInd = -1;
                            ListDefinition methLD = (ListDefinition)this.this$1.ivMethodForMicroorganisms.get(microLD);
                            if (methLD != null) {
                                selInd = MicroorganismTable.access$6(this.this$1).indexOf(methLD);
                            }
                            if ((ind = AllgChoiceRequester.getIndexAnswer(null, Babel.get("ARHR_SELECT_METHOD"), MicroorganismTable.access$7(this.this$1), null, selInd)) != -1) {
                                this.this$1.ivMethodForMicroorganisms.put(microLD, MicroorganismTable.access$6(this.this$1).elementAt(ind));
                                MicroorganismTable.access$8(this.this$1).repaint();
                                tab.repaint();
                            }
                        }
                    }
                }
            });
        }

        public void addTableModelListener(TableModelListener arg0) {
        }

        public Class getColumnClass(int col) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return clazz;
        }

        public int getColumnCount() {
            return 5;
        }

        public String getColumnName(int col) {
            switch (col) {
                case 0: {
                    return "";
                }
                case 1: {
                    return Babel.get("ARHR_MICORORGANISM");
                }
                case 2: {
                    return Babel.get("TYPE");
                }
                case 3: {
                    return "F";
                }
                case 4: {
                    return Babel.get("ARHR_METHOD");
                }
            }
            return null;
        }

        public int getRowCount() {
            return this.ivMicroorganisms.size();
        }

        public Object getValueAt(int row, int column) {
            if (row >= 0 && row < this.ivMicroorganisms.size()) {
                return "";
            }
            return null;
        }

        public boolean isCellEditable(int row, int column) {
            return false;
        }

        public void removeTableModelListener(TableModelListener arg0) {
        }

        public void setValueAt(Object arg0, int arg1, int arg2) {
        }

        public int getPrefWidth(int column) {
            if (column == 0) {
                return 2 * (ImageProvider.getBulletIcon(Color.green).getIconWidth() + UIDef.INNER_RAND);
            }
            int w = UIDef.RAND;
            int row = 0;
            while (row < this.ivMicroorganisms.size()) {
                Component c = this.getTableCellRendererComponent(null, null, false, false, row, column);
                if (c != null && c.getPreferredSize().width > w) {
                    w = c.getPreferredSize().width;
                }
                ++row;
            }
            return w;
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.ivListLabel.setForeground(Color.black);
            this.ivListLabel.setFont(FontManager.getFont("SSB11"));
            Microorganism.Keim keim = (Microorganism.Keim)this.ivMicroorganisms.elementAt(row);
            boolean drin = this.ivSelectedMicroorganisms.contains(keim);
            this.ivListLabel.setFont(FontManager.getFont(drin ? "SSB11" : "SSP11"));
            if (column == 0) {
                this.ivListLabel.setHorizontalAlignment(0);
                this.ivListLabel.setIcon(this.ivSelectedMicroorganisms.contains(keim) ? ImageProvider.getBulletIcon(Color.green) : null);
                this.ivListLabel.setText(null);
            } else {
                ListDefinition methLD;
                this.ivListLabel.setHorizontalAlignment(2);
                this.ivListLabel.setIcon(null);
                StringBuilder msb = new StringBuilder();
                msb.append(" ");
                if (column == 1) {
                    msb.append(keim.toString());
                } else if (column == 2) {
                    msb.append(keim.getTypString());
                } else if (column == 3) {
                    this.ivListLabel.setHorizontalAlignment(0);
                    msb.append(keim.ivFelasaRelevant ? "\u2713" : "");
                } else if (column == 4 && (methLD = (ListDefinition)this.ivMethodForMicroorganisms.get(keim)) != null) {
                    msb.append(methLD.toString());
                }
                msb.append(" ");
                this.ivListLabel.setText(msb.toString());
                this.ivListLabel.setForeground(keim.getFG());
            }
            this.ivListLabel.setOpaque(false);
            return this.ivListLabel;
        }

        static /* synthetic */ boolean access$1(MicroorganismTable microorganismTable) {
            return microorganismTable.ivDragClickedAllowed;
        }

        static /* synthetic */ boolean access$2(MicroorganismTable microorganismTable) {
            return microorganismTable.ivDragMode;
        }

        static /* synthetic */ MGButton access$3(MicroorganismTable microorganismTable) {
            return microorganismTable.ivReqOkButton;
        }

        static /* synthetic */ void access$4(MicroorganismTable microorganismTable, boolean bl) {
            microorganismTable.ivDragClickedAllowed = bl;
        }

        static /* synthetic */ void access$5(MicroorganismTable microorganismTable, boolean bl) {
            microorganismTable.ivDragMode = bl;
        }

        static /* synthetic */ Vector access$6(MicroorganismTable microorganismTable) {
            return microorganismTable.ivMethods;
        }

        static /* synthetic */ String[] access$7(MicroorganismTable microorganismTable) {
            return microorganismTable.ivMethodNames;
        }

        static /* synthetic */ Component access$8(MicroorganismTable microorganismTable) {
            return microorganismTable.ivSuperComponent;
        }
    }
}

