/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.requester.task;

import de.hannse.netobjects.util.Babel;
import de.hannse.netobjects.util.MyDate;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import mausoleum.gui.RequesterPane;
import mausoleum.gui.SimpleLayoutManager;
import mausoleum.mouse.TaskExtended;
import mausoleum.mouse.TaskWorkFlow;
import mausoleum.requester.BasicRequester;
import mausoleum.requester.calendar.CalendarPanel;
import mausoleum.requester.calendar.TRDatePanelWorkFlow;
import mausoleum.requester.calendar.TRPeriodPanel;
import mausoleum.requester.calendar.TRPeriodPanelWorkFlow;
import mausoleum.requester.pope.PopeAlert;
import mausoleum.task.standards.StandardTask;
import mausoleum.ui.UIDef;

public class TaskRequester
extends BasicRequester {
    private static final long serialVersionUID = 1L;
    public static final int MODE_NORMAL = 0;
    public static final int MODE_WORKFLOW = 1;
    private static final int INNER_BREITE = CalendarPanel.BREITE + UIDef.getScaled(20);
    private static final int BREITE = UIDef.RAND + INNER_BREITE + UIDef.RAND;
    private static final int X_1 = UIDef.RAND;
    private static final int LAB_WIDTH = UIDef.getScaled(150);
    private static final int X_2 = X_1 + LAB_WIDTH + UIDef.RAND;
    private static final int FIELD_WIDTH = BREITE - UIDef.RAND - X_2;
    private static final int LINE_HEIGHT = UIDef.getScaled(22);
    private static final int BUT_HEIGHT = UIDef.getScaled(40);
    private static final int[] HOEHEN = new int[]{3 * UIDef.RAND + 5 * LINE_HEIGHT + 5 * UIDef.INNER_RAND + (CalendarPanel.HOEHE + UIDef.getScaled(40)) + BUT_HEIGHT, 3 * UIDef.RAND + 4 * LINE_HEIGHT + 4 * UIDef.INNER_RAND + (CalendarPanel.HOEHE + UIDef.getScaled(40)) + BUT_HEIGHT};
    private final int ivMode;
    private final JComboBox ivStandardCombo;
    private final JTextField ivDescription = new JTextField();
    private final JTextField ivDetailsField = new JTextField();
    public final JComboBox ivTimeCombo = new JComboBox<String>(Babel.get(TaskExtended.TIME_STRINGS, true));
    private final int[] ivStandardTaskIDsAnd0;
    private final JComboBox ivFavoriteCombo;
    private final Vector ivFavoritenNamen;
    private final Vector ivFavoritenIDs;
    private final Vector ivFavoritenGroups;
    private CalendarPanel ivCalendarPanel = null;
    private final JTabbedPane ivDateTabbedPane;
    private final String ivCommonGroup;
    private final Vector ivObjectsForTask = new Vector();
    private final JComponent ivPeriodComponent;

    public TaskRequester(Frame sender, int objectType, Vector objectsForTask, int modus, String group, TaskWorkFlow taskWorkflow) {
        super(sender, BREITE, HOEHEN[modus]);
        this.ivMode = modus;
        if (this.ivMode == 0) {
            this.ivObjectsForTask.addAll(objectsForTask);
        }
        this.ivCommonGroup = group;
        int y = UIDef.RAND;
        Object[] vals = StandardTask.getComboFeeders(this.ivObjectsForTask, objectType, this.ivCommonGroup);
        this.ivStandardCombo = new JComboBox<String>((String[])vals[1]);
        this.ivStandardTaskIDsAnd0 = (int[])vals[0];
        if (taskWorkflow != null) {
            int ind = -1;
            int i = 0;
            while (i < this.ivStandardTaskIDsAnd0.length && ind == -1) {
                if (this.ivStandardTaskIDsAnd0[i] == taskWorkflow.ivStandardTaskID) {
                    ind = i;
                }
                ++i;
            }
            if (ind != -1) {
                this.ivStandardCombo.setSelectedIndex(ind);
            }
        }
        this.ivStandardCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TaskRequester.this.adaptToStandardSelection();
            }
        });
        this.addPermanentLabel(Babel.get("TASK_TYPE"), X_1, y, LINE_HEIGHT);
        this.addAndApplyBounds(this.ivStandardCombo, X_2, y, FIELD_WIDTH, LINE_HEIGHT);
        y += LINE_HEIGHT + UIDef.INNER_RAND;
        this.ivDescription.addCaretListener(new CaretListener(){

            public void caretUpdate(CaretEvent e) {
                TaskRequester.this.checkOKButton();
            }
        });
        if (taskWorkflow != null) {
            this.ivDescription.setText(taskWorkflow.ivDescription);
        }
        this.addPermanentLabel(Babel.get("TASK_DESCRIPTION"), X_1, y, LINE_HEIGHT);
        this.addAndApplyBounds(this.ivDescription, X_2, y, FIELD_WIDTH, LINE_HEIGHT);
        y += LINE_HEIGHT + UIDef.INNER_RAND;
        if (taskWorkflow != null) {
            this.ivDetailsField.setText(taskWorkflow.ivDetails);
        }
        this.addPermanentLabel(Babel.get("TASK_DETAILS"), X_1, y, LINE_HEIGHT);
        this.addAndApplyBounds(this.ivDetailsField, X_2, y, FIELD_WIDTH, LINE_HEIGHT);
        y += LINE_HEIGHT + UIDef.INNER_RAND;
        if (this.ivMode == 0) {
            this.ivFavoritenNamen = new Vector();
            this.ivFavoritenIDs = new Vector();
            this.ivFavoritenGroups = new Vector();
            boolean esGabUser = TaskExtended.getFavoritChoices(this.ivObjectsForTask, this.ivFavoritenNamen, this.ivFavoritenIDs, this.ivFavoritenGroups, false);
            if (esGabUser) {
                this.ivFavoriteCombo = new JComboBox(this.ivFavoritenNamen);
                this.ivFavoriteCombo.setEnabled(true);
            } else {
                this.ivFavoriteCombo = new JComboBox(new Vector());
                this.ivFavoriteCombo.setEnabled(false);
            }
            this.addPermanentLabel(Babel.get("FAVORITE"), X_1, y, LINE_HEIGHT);
            this.addAndApplyBounds(this.ivFavoriteCombo, X_2, y, FIELD_WIDTH, LINE_HEIGHT);
            y += LINE_HEIGHT + UIDef.INNER_RAND;
        } else {
            this.ivFavoriteCombo = null;
            this.ivFavoritenNamen = null;
            this.ivFavoritenIDs = null;
            this.ivFavoritenGroups = null;
        }
        this.addPermanentLabel(Babel.get("TASK_TIME"), X_1, y, LINE_HEIGHT);
        this.addAndApplyBounds(this.ivTimeCombo, X_2, y, FIELD_WIDTH, LINE_HEIGHT);
        y += LINE_HEIGHT + UIDef.INNER_RAND;
        this.ivDateTabbedPane = new JTabbedPane();
        this.ivDateTabbedPane.setOpaque(false);
        RequesterPane specComp = null;
        RequesterPane periodComp = null;
        if (this.ivMode == 0) {
            this.ivCalendarPanel = new CalendarPanel(MyDate.getMyDate(System.currentTimeMillis() - 86400000L), null);
            specComp = new TRSpecDatePanel(this.ivCalendarPanel);
            TRPeriodPanel tpp = new TRPeriodPanel();
            tpp.setButtonToEnable(this.ivOkButton);
            periodComp = tpp;
        } else if (this.ivMode == 1) {
            TRDatePanelWorkFlow tpp1 = new TRDatePanelWorkFlow();
            tpp1.setButtonToEnable(this.ivOkButton);
            specComp = tpp1;
            TRPeriodPanelWorkFlow tpp = new TRPeriodPanelWorkFlow();
            tpp.setButtonToEnable(this.ivOkButton);
            periodComp = tpp;
        }
        this.ivPeriodComponent = periodComp;
        this.ivDateTabbedPane.add(Babel.get("TASK_SPEC_DATE"), specComp);
        this.ivDateTabbedPane.add(Babel.get("TASK_PERIOD"), periodComp);
        this.ivDateTabbedPane.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                Component comp = TaskRequester.this.ivDateTabbedPane.getSelectedComponent();
                if (comp != null) {
                    if (comp instanceof TRSpecDatePanel) {
                        TaskRequester.this.ivOkButton.setEnabled(true);
                    } else if (comp instanceof TRPeriodPanel) {
                        TRPeriodPanel perPan = (TRPeriodPanel)comp;
                        perPan.check();
                    } else if (comp instanceof TRPeriodPanelWorkFlow) {
                        TRPeriodPanelWorkFlow perPan = (TRPeriodPanelWorkFlow)comp;
                        perPan.check();
                    } else if (comp instanceof TRDatePanelWorkFlow) {
                        TRDatePanelWorkFlow perPan = (TRDatePanelWorkFlow)comp;
                        perPan.check();
                    }
                } else {
                    TaskRequester.this.ivOkButton.setEnabled(false);
                }
            }
        });
        this.addAndApplyBounds(this.ivDateTabbedPane, X_1, y, CalendarPanel.BREITE + UIDef.getScaled(20), CalendarPanel.HOEHE + UIDef.getScaled(40));
        int lbw = (INNER_BREITE - UIDef.INNER_RAND) / 2;
        int rbw = INNER_BREITE - UIDef.INNER_RAND - lbw;
        this.applyBounds(this.ivOkButton, X_1, y += CalendarPanel.HOEHE + UIDef.getScaled(40) + UIDef.RAND, lbw, BUT_HEIGHT);
        this.applyBounds(this.ivNoButton, X_1 + lbw + UIDef.INNER_RAND, y, rbw, BUT_HEIGHT);
        this.adaptToStandardSelection();
        this.toFront();
        this.setVisible(true);
    }

    public void OKPressed() {
        if (this.ivMode == 0) {
            int datum;
            int n = datum = this.ivDateTabbedPane.getSelectedComponent() instanceof TRSpecDatePanel ? (int)(this.ivCalendarPanel.getSelectedDate().getTime() / 86400000L) : Integer.MIN_VALUE;
            if (!PopeAlert.makeTaskScheduleCheck(this.getTaskProc(-1), this.ivCommonGroup, datum, this.ivObjectsForTask, this)) {
                return;
            }
        }
        super.OKPressed();
    }

    public String getDescription() {
        return this.ivDescription.getText().trim();
    }

    public String getDetails() {
        String s = this.ivDetailsField.getText().trim();
        return s.length() == 0 ? null : s;
    }

    public Date getDate() {
        if (this.ivDateTabbedPane != null) {
            Component comp = this.ivDateTabbedPane.getSelectedComponent();
            if (comp != null && comp instanceof TRPeriodPanel) {
                TRPeriodPanel perPan = (TRPeriodPanel)comp;
                return new Date(new MyDate(perPan.getStart()).getTime());
            }
            return this.ivCalendarPanel.getSelectedDate();
        }
        return null;
    }

    public long getFavoritID() {
        int ind;
        if (this.ivFavoriteCombo != null && this.ivFavoriteCombo.isEnabled() && (ind = this.ivFavoriteCombo.getSelectedIndex()) >= 0 && ind < this.ivFavoritenIDs.size()) {
            Long l = (Long)this.ivFavoritenIDs.elementAt(ind);
            return l;
        }
        return -1L;
    }

    public String getFavoritGroup() {
        int ind;
        if (this.ivFavoriteCombo != null && this.ivFavoriteCombo.isEnabled() && (ind = this.ivFavoriteCombo.getSelectedIndex()) >= 0 && ind < this.ivFavoritenGroups.size()) {
            return (String)this.ivFavoritenGroups.elementAt(ind);
        }
        return "";
    }

    public int getTaskProc(int defVal) {
        int sel = this.ivStandardCombo.getSelectedIndex();
        if (sel >= 0 && sel < this.ivStandardTaskIDsAnd0.length) {
            return this.ivStandardTaskIDsAnd0[sel];
        }
        return defVal;
    }

    public int getPeriodEnd(int defVal) {
        Component comp;
        if (this.ivDateTabbedPane != null && (comp = this.ivDateTabbedPane.getSelectedComponent()) != null && comp instanceof TRPeriodPanel) {
            TRPeriodPanel perPan = (TRPeriodPanel)comp;
            return perPan.getEnd();
        }
        return defVal;
    }

    public int getPeriodFrequency(int defVal) {
        Component comp;
        if (this.ivDateTabbedPane != null && (comp = this.ivDateTabbedPane.getSelectedComponent()) != null && comp instanceof TRPeriodPanel) {
            TRPeriodPanel perPan = (TRPeriodPanel)comp;
            return perPan.getFrequenz();
        }
        return defVal;
    }

    private void adaptToStandardSelection() {
        StandardTask st;
        boolean other = true;
        Integer freqI = null;
        Integer endDI = null;
        int sel = this.ivStandardCombo.getSelectedIndex();
        if (sel >= 0 && sel < this.ivStandardTaskIDsAnd0.length && this.ivStandardTaskIDsAnd0[sel] != -1) {
            other = false;
        }
        this.ivDescription.setEnabled(other);
        this.ivDescription.setOpaque(other);
        if (!other) {
            this.ivDescription.setText("");
        }
        boolean anythingGoes = true;
        if (!other && (st = StandardTask.findTask(this.ivCommonGroup, this.ivStandardTaskIDsAnd0[sel])) != null) {
            String dr = st.getDateRestriction();
            if (dr.equals("TASK_DATE_FIX")) {
                this.ivDateTabbedPane.setSelectedIndex(0);
                anythingGoes = false;
            } else if (dr.equals("TASK_DATE_PERIOD")) {
                this.ivDateTabbedPane.setSelectedIndex(1);
                Integer key = new Integer(st.ivID);
                freqI = (Integer)StandardTask.PREF_PER_FREQS_BY_SYSTEM_TASK_ID.get(key);
                endDI = (Integer)StandardTask.PREF_PER_ENDS_BY_SYSTEM_TASK_ID.get(key);
                anythingGoes = false;
            } else {
                anythingGoes = true;
            }
        }
        this.ivDateTabbedPane.setEnabled(anythingGoes);
        if (this.ivPeriodComponent instanceof TRPeriodPanel) {
            TRPeriodPanel tpp = (TRPeriodPanel)this.ivPeriodComponent;
            if (freqI != null) {
                tpp.setFrequenz(freqI != null ? freqI : -1);
            }
            if (endDI != null) {
                tpp.setEndDate(endDI != null ? MyDate.HEUTE + endDI : Integer.MIN_VALUE);
            }
        }
        this.checkOKButton(other);
    }

    private void checkOKButton() {
        boolean other = true;
        int sel = this.ivStandardCombo.getSelectedIndex();
        if (sel >= 0 && sel < this.ivStandardTaskIDsAnd0.length && this.ivStandardTaskIDsAnd0[sel] != -1) {
            other = false;
        }
        this.checkOKButton(other);
    }

    private void checkOKButton(boolean other) {
        Component comp;
        boolean enabled = true;
        if (this.ivDateTabbedPane != null && (comp = this.ivDateTabbedPane.getSelectedComponent()) != null && comp instanceof TRPeriodPanel) {
            TRPeriodPanel perPan = (TRPeriodPanel)comp;
            if (perPan.getStart() == Integer.MIN_VALUE) {
                enabled = false;
            }
            if (perPan.getEnd() == Integer.MIN_VALUE) {
                enabled = false;
            }
        }
        if (enabled && other) {
            enabled = this.ivDescription.getText().trim().length() != 0;
        }
        this.ivOkButton.setEnabled(enabled);
    }

    class TRSpecDatePanel
    extends RequesterPane {
        private static final long serialVersionUID = 12342L;

        public TRSpecDatePanel(CalendarPanel panel) {
            super(new SimpleLayoutManager(){

                public void layoutContainer(Container arg0) {
                    Dimension d = arg0.getSize();
                    Component c = arg0.getComponent(0);
                    if (c != null) {
                        Dimension ps = c.getPreferredSize();
                        int x = (d.width - ps.width) / 2;
                        int y = (d.height - ps.height) / 2;
                        c.setBounds(x, y, ps.width, ps.height);
                    }
                }
            });
            this.add(panel);
        }
    }
}

