/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.requester.user;

import de.hannse.netobjects.user.User;
import de.hannse.netobjects.util.Babel;
import java.awt.Frame;
import java.awt.event.KeyEvent;
import javax.swing.JComboBox;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import mausoleum.alert.Alert;
import mausoleum.inspector.Inspector;
import mausoleum.main.MausoleumClient;
import mausoleum.requester.BasicRequester;
import mausoleum.ui.UIDef;

public class NewUserRequester
extends BasicRequester {
    private static final long serialVersionUID = 1L;
    private static final int BREITE = UIDef.getScaled(350);
    private static final int HOEHE = UIDef.getScaled(150);
    public static final String[] CHOICES_REGULAR = new String[]{"EXTERNAL", "NOVICE", "STUDENT", "MASTER", "CARETAKER", "GURU"};
    public static final String[] CHOICES_HEAD_OF_SERVICE = new String[]{"HEAD OF SERVICE", "SERVICE CARETAKER"};
    public static final String[] CHOICES_HEAD_OF_TGSERVICE = new String[]{"HEAD OF TG-SERVICE", "TG-SERVICE CARETAKER"};
    private JComboBox ivStatusField = null;
    private JTextField ivNameField = new JTextField("", 5){
        private static final long serialVersionUID = 123424L;

        protected void processKeyEvent(KeyEvent e) {
            if (!e.isActionKey()) {
                switch (e.getKeyChar()) {
                    case ' ': {
                        e.consume();
                        return;
                    }
                }
            }
            super.processKeyEvent(e);
        }
    };
    private JPasswordField ivPasswordField = new JPasswordField("", 5){
        private static final long serialVersionUID = 123424L;

        protected void processKeyEvent(KeyEvent e) {
            if (!e.isActionKey()) {
                switch (e.getKeyChar()) {
                    case ' ': {
                        e.consume();
                        return;
                    }
                }
            }
            super.processKeyEvent(e);
        }
    };
    private User ivNewUser = null;

    public static User getNewUser() {
        NewUserRequester nur = new NewUserRequester(Inspector.getInspector());
        nur.setVisible(true);
        if (!nur.ivWarOK) {
            return null;
        }
        return nur.ivNewUser;
    }

    private NewUserRequester(Frame sender) {
        super(sender, BREITE, HOEHE);
        this.setTitle(Babel.get("NEWUSER"));
        this.addScaledPermanentLabel(Babel.get("NAME"), 10, 8, 24);
        this.addAndApplyScaledBounds(this.ivNameField, 120, 8, 210, 24);
        this.addScaledPermanentLabel(Babel.get("PASSWORD"), 10, 38, 24);
        this.addAndApplyScaledBounds(this.ivPasswordField, 120, 38, 210, 24);
        if (MausoleumClient.isRegular()) {
            this.ivStatusField = new JComboBox<String>(CHOICES_REGULAR);
        } else if (MausoleumClient.isHeadOfService()) {
            this.ivStatusField = new JComboBox<String>(CHOICES_HEAD_OF_SERVICE);
        } else if (MausoleumClient.isHeadOfTGService()) {
            this.ivStatusField = new JComboBox<String>(CHOICES_HEAD_OF_TGSERVICE);
        }
        this.addScaledPermanentLabel(Babel.get("STATUS"), 10, 68, 24);
        this.addAndApplyScaledBounds(this.ivStatusField, 120, 68, 210, 24);
        this.applyScaledBounds(this.ivOkButton, 10, 100, 158, 40);
        this.applyScaledBounds(this.ivNoButton, 172, 100, 158, 40);
    }

    public void OKPressed() {
        String name = this.ivNameField.getText();
        if (name.trim().length() == 0) {
            Alert.showAlert(Babel.get("ALERTSPECIFYUSERNAME"), true);
            return;
        }
        char[] passwordChars = this.ivPasswordField.getPassword();
        String password = new String(passwordChars);
        if (password.trim().length() == 0) {
            Alert.showAlert(Babel.get("ALERTSPECIFYPASSWORD"), true);
            return;
        }
        int status = User.getStatusForString((String)this.ivStatusField.getSelectedItem());
        if (status <= 0) {
            Alert.showAlert(Babel.get("ALERTSPECIFYSTATUS"), true);
            return;
        }
        this.ivNewUser = new User();
        this.ivNewUser.set("USR_NAME", name);
        this.ivNewUser.set("USR_PASSWORD", password);
        this.ivNewUser.setInt("USR_MODE", status);
        super.OKPressed();
    }
}

