/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.result;

import de.hannse.netobjects.tools.FileManager;
import de.hannse.netobjects.tools.StringHelper;
import java.io.Serializable;
import mausoleum.helper.BrowserLauncher;

public class GPSCoordinates
implements Serializable {
    private static final long serialVersionUID = 2928699989179217548L;
    private static String DEFAULT_GOOGLE_MAPS_ADDRESS = "http://maps.google.de/maps?saddr=_ADDR_&z=15&t=h";
    private static String cvGoogleMapsAddress = FileManager.getStringFromFile("data/googlemaps.txt");
    public double ivBreite = 0.0;
    public double ivLaenge = 0.0;
    public boolean ivIstNorden = true;
    public boolean ivIstOsten = true;

    public static void main(String[] args) {
        GPSCoordinates untererGrund = new GPSCoordinates(true, 48, 44, 16, true, 9, 6, 51);
        untererGrund.showMap();
        GPSCoordinates akLEO = new GPSCoordinates(true, 48, 46, 29, true, 9, 1, 32);
        akLEO.showMap();
        GPSCoordinates daheim = new GPSCoordinates(true, 48, 51, 44, true, 8, 51, 41);
        daheim.showMap();
    }

    public GPSCoordinates(boolean istNord, int bGrad, int bMinuten, int bSekunden, boolean istOst, int lGrad, int lMinuten, int lSekunden) {
        this.ivIstNorden = istNord;
        this.ivIstOsten = istOst;
        this.ivBreite = (double)bGrad + (double)bMinuten / 60.0 + (double)bSekunden / 3600.0;
        this.ivLaenge = (double)lGrad + (double)lMinuten / 60.0 + (double)lSekunden / 3600.0;
    }

    public GPSCoordinates(double breite, double laenge, boolean istNorden, boolean istOsten) {
        this.ivBreite = breite;
        this.ivLaenge = laenge;
        this.ivIstNorden = istNorden;
        this.ivIstOsten = istOsten;
    }

    public GPSCoordinates(String s) {
        int ind = s.indexOf("+");
        if (ind == -1) {
            throw new IllegalArgumentException();
        }
        String breiteS = s.substring(0, ind).trim();
        String laengeS = s.substring(ind + 1, s.length()).trim();
        if (breiteS.startsWith("N")) {
            this.ivIstNorden = true;
        } else if (breiteS.startsWith("S")) {
            this.ivIstNorden = false;
        } else {
            throw new IllegalArgumentException();
        }
        try {
            this.ivBreite = Double.parseDouble(breiteS.substring(1, breiteS.length()));
        }
        catch (Exception e) {
            throw new IllegalArgumentException();
        }
        if (laengeS.startsWith("E")) {
            this.ivIstOsten = true;
        } else if (laengeS.startsWith("W")) {
            this.ivIstOsten = false;
        } else {
            throw new IllegalArgumentException();
        }
        try {
            this.ivLaenge = Double.parseDouble(laengeS.substring(1, laengeS.length()));
        }
        catch (Exception e) {
            throw new IllegalArgumentException();
        }
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof GPSCoordinates) {
            GPSCoordinates g = (GPSCoordinates)obj;
            return this.ivBreite == g.ivBreite && this.ivLaenge == g.ivLaenge && this.ivIstNorden == g.ivIstNorden && this.ivIstOsten == g.ivIstOsten;
        }
        return false;
    }

    public String getTableString() {
        StringBuffer msb = new StringBuffer();
        if (this.ivIstNorden) {
            msb.append("N");
        } else {
            msb.append("S");
        }
        int[] gms = GPSCoordinates.getGMS(this.ivBreite);
        msb.append(" ").append(gms[0]).append("\u00b0").append(gms[1]).append("'").append(gms[2]).append("'' ");
        msb.append(" ");
        if (this.ivIstOsten) {
            msb.append("E");
        } else {
            msb.append("W");
        }
        gms = GPSCoordinates.getGMS(this.ivLaenge);
        msb.append(" ").append(gms[0]).append("\u00b0").append(gms[1]).append("'").append(gms[2]).append("'' ");
        return msb.toString();
    }

    public String getAddrString() {
        StringBuffer msb = new StringBuffer();
        msb.append(this.ivBreite);
        if (this.ivIstNorden) {
            msb.append("N");
        } else {
            msb.append("S");
        }
        msb.append("+");
        msb.append(this.ivLaenge);
        if (this.ivIstOsten) {
            msb.append("E");
        } else {
            msb.append("W");
        }
        return msb.toString();
    }

    public void showMap() {
        String address = cvGoogleMapsAddress;
        if (address == null) {
            address = DEFAULT_GOOGLE_MAPS_ADDRESS;
        }
        address = address.trim();
        address = StringHelper.gSub(address, "_ADDR_", this.getAddrString());
        try {
            BrowserLauncher.openURL(address);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static int[] getGMS(double val) {
        int[] res = new int[3];
        res[0] = (int)val;
        val = (val - (double)res[0]) * 60.0;
        res[1] = (int)val;
        val = (val - (double)res[1]) * 60.0;
        res[2] = (int)val;
        return res;
    }
}

