/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.result.embryotransfer;

import java.util.Iterator;
import java.util.Vector;
import mausoleum.mouse.Mouse;
import mausoleum.mouse.tierschutz.TierSchutz;
import mausoleum.mouse.transgenics.Transgenics;
import mausoleum.result.MResult;
import mausoleum.util.InstallationType;

public class EmbryoTransfer {
    public static boolean useEmbryoTransfer() {
        return InstallationType.isMouse() && (TierSchutz.hasEmbryoTransfer() || Transgenics.hasEmbryoTransfer());
    }

    public static int getDateOfLastEmbryoTransfer(Mouse maus) {
        int date = Integer.MIN_VALUE;
        Vector v2 = (Vector)maus.get("MOS_MRESULTS");
        if (v2 != null) {
            Iterator iterator = v2.iterator();
            while (iterator.hasNext()) {
                MResult mres = (MResult)iterator.next();
                if (mres.getExperimentID() != -46L) continue;
                if (date == Integer.MIN_VALUE) {
                    date = mres.ivDate;
                    continue;
                }
                if (mres.ivDate <= date) continue;
                date = mres.ivDate;
            }
        }
        return date;
    }

    public static MResult findMatchingEmbryoTransfer(Mouse mouse, int deliveryDate) {
        MResult res = null;
        MResult hilfsres = null;
        Vector v2 = (Vector)mouse.get("MOS_MRESULTS");
        if (v2 != null) {
            Iterator iterator = v2.iterator();
            while (iterator.hasNext()) {
                MResult mres = (MResult)iterator.next();
                if (mres.getExperimentID() != -46L) continue;
                int diff = deliveryDate - mres.ivDate;
                if (res == null && diff <= 28 && diff >= 16) {
                    res = mres;
                    continue;
                }
                if (res != null || hilfsres != null || diff > 34 || diff < 10) continue;
                hilfsres = res;
            }
        }
        return res != null ? res : hilfsres;
    }

    public static boolean hasEmbryoTransferCoveringDate(Mouse mouse, int date) {
        Vector v2 = (Vector)mouse.get("MOS_MRESULTS");
        if (v2 != null) {
            Iterator iterator = v2.iterator();
            while (iterator.hasNext()) {
                MResult mres = (MResult)iterator.next();
                if (mres.getExperimentID() != -46L || date < mres.ivDate || (long)date > (long)mres.ivDate + 28L) continue;
                return true;
            }
        }
        return false;
    }
}

