/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.result.embryotransfer;

import de.hannse.netobjects.objectstore.IDObjectXMLHandler;
import de.hannse.netobjects.objectstore.IndexObject;
import de.hannse.netobjects.objectstore.ObjectStore;
import de.hannse.netobjects.tools.Base64Manager;
import de.hannse.netobjects.tools.StringHelper;
import de.hannse.netobjects.util.Babel;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Vector;
import mausoleum.helper.DatumFormat;
import mausoleum.helper.Zeile;
import mausoleum.line.Line;

public class MResEmbryoTransfer
implements Serializable {
    private static final long serialVersionUID = 29212343279217548L;
    private static final int TYPE_UNKNOWN = 0;
    private static final int TYPE_UTERUS = 1;
    private static final int TYPE_OVIDUCT = 2;
    private static final String TYPEB_UTERUS = "MR_ET_T_UTERUS";
    private static final String TYPEB_OVIDUCT = "MR_ET_T_OVIDUCT";
    public static final int[] TYPE_INTS;
    public static final String[] TYPE_BABELS;
    private static final int STAGE_UNKNOWN = 0;
    private static final int STAGE_1_CELL = 1;
    private static final int STAGE_2_CELL = 2;
    private static final int STAGE_4_CELL = 3;
    private static final int STAGE_MORULA = 4;
    private static final int STAGE_BLASTOCYST = 5;
    private static final String STAGEB_1_CELL = "MR_ET_S_1_CELL";
    private static final String STAGEB_2_CELL = "MR_ET_S_2_CELL";
    private static final String STAGEB_4_CELL = "MR_ET_S_4_CELL";
    private static final String STAGEB_MORULA = "MR_ET_S_MORULA";
    private static final String STAGEB_BLASTOCYST = "MR_ET_S_BLASTOCYST";
    public static final int[] STAGE_INTS;
    public static final String[] STAGE_BABELS;
    private static final int LONG_PERIOD = 21;
    private static final int SHORT_PERIOD = 18;
    public static final String TAG_LINE = "MR_ET_LINE";
    public static final String TAG_STRAIN = "MR_ET_STRAIN";
    public static final String TAG_TRANSFER_TYPE = "MR_ET_TRANSFER_TYPE";
    public static final String TAG_NUM_TRANSFERRED = "MR_ET_NUM_TRANSFERRED";
    public static final String TAG_EMBRYO_STAGE = "MR_ET_EMBRYO_STAGE";
    public static final String TAG_JOB_GROUP = "MR_ET_JOB_GROUP";
    public static final String TAG_JOB_ID = "MR_ET_JOB_ID";
    public static final String TAG_PLUG_DAY = "MR_ET_PLUG_DAY";
    public static final String TAG_CALC_BIRTHDAY = "MR_ET_CALC_BIRTHDAY";
    public long ivLineID = -1L;
    public IndexObject[] ivStrains = null;
    public int ivTransferType = 0;
    public int ivNumTransferred = 0;
    public int ivEmbryoStage = 0;
    public String ivJobGroup = null;
    public long ivJobID = -1L;
    public int ivPlugDayAtTransfer = -1;
    public int ivCalcBirthday = Integer.MIN_VALUE;

    static {
        int[] nArray = new int[3];
        nArray[1] = 1;
        nArray[2] = 2;
        TYPE_INTS = nArray;
        TYPE_BABELS = new String[]{"", TYPEB_UTERUS, TYPEB_OVIDUCT};
        int[] nArray2 = new int[6];
        nArray2[1] = 1;
        nArray2[2] = 2;
        nArray2[3] = 3;
        nArray2[4] = 4;
        nArray2[5] = 5;
        STAGE_INTS = nArray2;
        STAGE_BABELS = new String[]{"", STAGEB_1_CELL, STAGEB_2_CELL, STAGEB_4_CELL, STAGEB_MORULA, STAGEB_BLASTOCYST};
    }

    public static String[] getDisplayValues(boolean transferType) {
        String[] arr = transferType ? TYPE_BABELS : STAGE_BABELS;
        String[] res = new String[arr.length];
        int i = 0;
        while (i < arr.length) {
            res[i] = arr[i].length() == 0 ? "" : Babel.get(arr[i]);
            ++i;
        }
        return res;
    }

    public static int getSelectedValue(int selIndex, boolean transferType) {
        int[] arr;
        int[] nArray = arr = transferType ? TYPE_INTS : STAGE_INTS;
        if (selIndex >= 0 && selIndex < arr.length) {
            return arr[selIndex];
        }
        return transferType ? 0 : 0;
    }

    public MResEmbryoTransfer() {
    }

    public MResEmbryoTransfer(Line line, IndexObject[] strains, int transferType, int numTransferred, int embryoStage, String jobGroup, long jobID, int plugDate, int transferDate) {
        this.ivLineID = line.getID();
        this.ivStrains = strains;
        this.ivTransferType = transferType;
        this.ivNumTransferred = numTransferred;
        this.ivEmbryoStage = embryoStage;
        this.ivJobGroup = jobGroup;
        this.ivJobID = jobID;
        this.calcPlugAndBirthDay(transferDate, plugDate);
    }

    public MResEmbryoTransfer(String initString) {
        Zeile z = new Zeile(initString, '|');
        int col = 0;
        this.ivLineID = z.getLong(col++, -1L);
        this.ivStrains = (IndexObject[])IDObjectXMLHandler.getObject(z.getString(col++, null), null, true);
        this.ivTransferType = z.getInt(col++, 0);
        this.ivNumTransferred = z.getInt(col++, 0);
        this.ivEmbryoStage = z.getInt(col++, 0);
        this.ivJobGroup = z.getStringB64(col++, null);
        this.ivJobID = z.getLong(col++, -1L);
        this.ivPlugDayAtTransfer = z.getInt(col++, Integer.MIN_VALUE);
        this.ivCalcBirthday = z.getInt(col++, Integer.MIN_VALUE);
        z.dispose();
        z = null;
    }

    public Object[] getTableRepresentation(String group, String lang) {
        Line line;
        Vector<String> sammler = new Vector<String>();
        if (this.ivLineID != -1L && (line = (Line)ObjectStore.getObjectDeadOrAlive(7, this.ivLineID, group, null, false)) != null) {
            sammler.add(Babel.get(TAG_LINE, lang));
            sammler.add(line.getBrowseName());
        }
        if (this.ivStrains != null) {
            sammler.add(Babel.get(TAG_STRAIN, lang));
            sammler.add(IndexObject.getDisplayString(this.ivStrains, group, 8, true, false, true));
        }
        if (this.ivTransferType != 0) {
            sammler.add(Babel.get(TAG_TRANSFER_TYPE, lang));
            sammler.add(StringHelper.getStringForInt(this.ivTransferType, TYPE_INTS, TYPE_BABELS, true, lang, "?"));
        }
        if (this.ivNumTransferred > 0) {
            sammler.add(Babel.get(TAG_NUM_TRANSFERRED, lang));
            sammler.add(Integer.toString(this.ivNumTransferred));
        }
        if (this.ivEmbryoStage != 0) {
            sammler.add(Babel.get(TAG_EMBRYO_STAGE, lang));
            sammler.add(StringHelper.getStringForInt(this.ivEmbryoStage, STAGE_INTS, STAGE_BABELS, true, lang, "?"));
        }
        if (this.ivJobGroup != null) {
            sammler.add(Babel.get(TAG_JOB_GROUP, lang));
            sammler.add(this.ivJobGroup);
        }
        if (this.ivJobID != -1L) {
            sammler.add(Babel.get(TAG_JOB_ID, lang));
            sammler.add(Long.toString(this.ivJobID));
        }
        if (this.ivPlugDayAtTransfer != -1) {
            sammler.add(Babel.get(TAG_PLUG_DAY, lang));
            sammler.add(Integer.toString(this.ivPlugDayAtTransfer));
        }
        if (this.ivCalcBirthday != Integer.MIN_VALUE) {
            sammler.add(Babel.get(TAG_CALC_BIRTHDAY, lang));
            sammler.add(DatumFormat.getJustDateString(this.ivCalcBirthday));
        }
        Object[] res = new Object[sammler.size()];
        int i = 0;
        Iterator iterator = sammler.iterator();
        while (iterator.hasNext()) {
            res[i++] = iterator.next();
        }
        sammler.clear();
        sammler = null;
        return res;
    }

    public String getInitString() {
        StringBuilder msb = new StringBuilder();
        msb.append(this.ivLineID).append("|");
        msb.append(IDObjectXMLHandler.getTransport(this.ivStrains, true, true)).append("|");
        msb.append(this.ivTransferType).append("|");
        msb.append(this.ivNumTransferred).append("|");
        msb.append(this.ivEmbryoStage).append("|");
        msb.append(this.ivJobGroup != null ? Base64Manager.encodeBase64(this.ivJobGroup) : "").append("|");
        msb.append(this.ivJobID).append("|");
        msb.append(this.ivPlugDayAtTransfer).append("|");
        msb.append(this.ivCalcBirthday).append("|");
        return msb.toString();
    }

    private void calcPlugAndBirthDay(int transferDate, int plugDate) {
        this.ivPlugDayAtTransfer = -1;
        this.ivCalcBirthday = Integer.MIN_VALUE;
        if (transferDate != Integer.MIN_VALUE && plugDate != Integer.MIN_VALUE && transferDate > plugDate && transferDate - plugDate < 6) {
            this.ivPlugDayAtTransfer = transferDate - plugDate;
            this.ivCalcBirthday = transferDate + (this.ivPlugDayAtTransfer == 0 ? 21 : 18);
        }
    }
}

