/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.room;

import de.hannse.netobjects.objectstore.ObjectManager;
import de.hannse.netobjects.objectstore.ObjectStore;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import mausoleum.main.MausoleumClient;
import mausoleum.main.ProcessDefinition;
import mausoleum.room.Room;

public class RoomManager
extends ObjectManager {
    public static RoomManager cvInstance;

    public static void init() {
        if (cvInstance == null) {
            cvInstance = new RoomManager();
        }
    }

    public static void exit() {
        if (ProcessDefinition.isClient() && cvInstance != null) {
            cvInstance.dispose();
            cvInstance = null;
        }
    }

    public static Room getRoom(long id, String group) {
        return (Room)ObjectStore.getObjectDeadOrAlive(10, id, group, null, false);
    }

    public static Vector getActualObjects(String group) {
        return cvInstance.getActualObjectVector(group);
    }

    public static long getGROUPRoomIDForServiceRoom(String group) {
        return RoomManager.getGROUPRoomIDForServiceRoom(group, MausoleumClient.cvServiceCTRoomID);
    }

    public static long getGROUPRoomIDForServiceRoom(String group, Long serviceRoomID) {
        Vector groupRooms;
        if (serviceRoomID != null && (groupRooms = cvInstance.getActualObjectVector(group)) != null) {
            Iterator iter = groupRooms.iterator();
            while (iter.hasNext()) {
                Room room = (Room)iter.next();
                if (!serviceRoomID.equals(room.get("IDO_SERVID"))) continue;
                return room.getID();
            }
        }
        return -1L;
    }

    public static boolean istEinRaumInGebaeude(long bldgid, String group) {
        Enumeration en = cvInstance.getActualObjectEnumeration(group);
        while (en.hasMoreElements()) {
            Room room = (Room)en.nextElement();
            if (room.getLong("ROM_BUILDING") != bldgid) continue;
            return true;
        }
        return false;
    }

    public static Vector getRoomsInBuilding(long bldgid) {
        Vector<Room> res = new Vector<Room>();
        Vector v = cvInstance.getActualObjectVector("service");
        if (v != null) {
            Iterator iter = v.iterator();
            while (iter.hasNext()) {
                Room room = (Room)iter.next();
                if (room.getLong("ROM_BUILDING") != bldgid) continue;
                res.add(room);
            }
        }
        return res;
    }

    private RoomManager() {
        super(10);
    }

    public static boolean areThereRooms() {
        return cvInstance.hasActualObjectsForAnyGroup();
    }
}

