/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.search;

import de.hannse.netobjects.datalayer.SearchObject;
import de.hannse.netobjects.objectstore.ObjectRequest;
import de.hannse.netobjects.user.UserManager;
import de.hannse.netobjects.util.Babel;
import de.hannse.netobjects.util.RequestManager;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.border.LineBorder;
import mausoleum.gui.MGButton;
import mausoleum.gui.SimpleLayoutManager;
import mausoleum.helper.FontManager;
import mausoleum.inspector.Inspector;
import mausoleum.mouse.Mouse;
import mausoleum.mouse.MouseManager;
import mausoleum.search.SearchResponder;
import mausoleum.tables.MausoleumTable;
import mausoleum.tables.models.MTMouseInXSearch;
import mausoleum.ui.UIDef;

public class SearchAssistant
implements Runnable {
    private static final Color TEMP_COLOR = new Color(220, 220, 220);
    public static final String COM_SEARCH = "SEARCH";
    public static final String COM_CLEAR = "CLEAR";
    public static final String COM_STOP = "STOP";
    private static final int ONE_BUNCH = 100;
    private static final String MOUSE_TABLE = "MOUSE_TABLE";
    private static final String EMPTY_LABEL = "EMPTY_LABEL";
    private static final String PROGRESS_BAR = "PROGESS_BAR";
    private static final String COUNT_RESULT = "COUNT_RESULT";
    private static final String COUNT_PROGRESS = "COUNT_PROGRESS";
    private boolean ivFinished = false;
    private boolean ivStop = false;
    private boolean ivSuccess = false;
    private String ivTicket = null;
    private CardLayout ivChangingLayout = new CardLayout();
    private JPanel ivChangingPanel = new JPanel(this.ivChangingLayout);
    private MausoleumTable ivTable = new MausoleumTable(new MTMouseInXSearch(), false);
    public MGButton ivButton = MGButton.getRequesterButton(Babel.get("START_SEARCH"));
    private final JLabel ivCountResultLabel;
    private final JLabel ivCountProgressLabel;
    private final JLabel ivProgressLabel;
    private final JProgressBar ivProgressBar = new JProgressBar(0);
    public Object ivCommandObject = null;
    private boolean ivCountOnly = false;
    private final SearchResponder ivResponder;
    private boolean ivTableIsVisible = false;
    public WindowAdapter ivWindowAdapter = new WindowAdapter(){

        public void windowClosing(WindowEvent e) {
            Inspector.setToDefault();
            if (SearchAssistant.this.ivTicket != null) {
                RequestManager.createSendAndGetAnswer((byte)14, SearchAssistant.this.ivTicket, null);
                SearchAssistant.this.ivTicket = null;
            }
        }

        public void windowActivated(WindowEvent e) {
            SearchAssistant.this.ivTable.windowActivation(true);
        }
    };

    public SearchAssistant(SearchResponder responder) {
        this.ivResponder = responder;
        JLabel label = new JLabel(Babel.get("NO_SEARCH_RUNNING"));
        label.setFont(FontManager.getFont("SSB30"));
        label.setHorizontalAlignment(0);
        label.setOpaque(true);
        label.setBackground(UIDef.BACKGROUND_SUB);
        label.setBorder(new LineBorder(Color.black));
        this.ivChangingPanel.add((Component)label, EMPTY_LABEL);
        this.ivCountResultLabel = new JLabel();
        this.ivCountResultLabel.setFont(FontManager.getFont("SSB30"));
        this.ivCountResultLabel.setHorizontalAlignment(0);
        this.ivCountResultLabel.setOpaque(true);
        this.ivCountResultLabel.setBackground(UIDef.BACKGROUND_SUB);
        this.ivCountResultLabel.setBorder(new LineBorder(Color.black));
        this.ivChangingPanel.add((Component)this.ivCountResultLabel, COUNT_RESULT);
        this.ivCountProgressLabel = new JLabel();
        this.ivCountProgressLabel.setFont(FontManager.getFont("SSB30"));
        this.ivCountProgressLabel.setHorizontalAlignment(0);
        this.ivCountProgressLabel.setOpaque(true);
        this.ivCountProgressLabel.setBackground(TEMP_COLOR);
        this.ivCountProgressLabel.setBorder(new LineBorder(Color.black));
        this.ivChangingPanel.add((Component)this.ivCountProgressLabel, COUNT_PROGRESS);
        this.ivProgressLabel = new JLabel(Babel.get("WAITFOREXTSEARCH"));
        this.ivProgressLabel.setFont(FontManager.getFont("SSB30"));
        this.ivProgressLabel.setHorizontalAlignment(0);
        this.ivProgressLabel.setOpaque(false);
        this.ivProgressBar.setStringPainted(true);
        this.ivProgressBar.setForeground(Color.darkGray);
        this.ivProgressBar.setFont(FontManager.getFont("SSB28"));
        JPanel progressPanel = new JPanel(new SimpleLayoutManager(){

            public void layoutContainer(Container arg0) {
                Dimension d = arg0.getSize();
                int iwidth = d.width - 2 * UIDef.RAND;
                int pbHeight = 40;
                int labHeight = 40;
                int sumHeight = pbHeight + UIDef.INNER_RAND + labHeight;
                int y = (d.height - sumHeight) / 2;
                SearchAssistant.this.ivProgressLabel.setBounds(UIDef.RAND, y, iwidth, labHeight);
                SearchAssistant.this.ivProgressBar.setBounds(UIDef.RAND, y += labHeight + UIDef.INNER_RAND, iwidth, pbHeight);
            }
        });
        progressPanel.setOpaque(true);
        progressPanel.setBackground(TEMP_COLOR);
        progressPanel.add(this.ivProgressLabel);
        progressPanel.add(this.ivProgressBar);
        progressPanel.setBorder(new LineBorder(Color.black));
        this.ivChangingPanel.add((Component)progressPanel, PROGRESS_BAR);
        this.ivTable.setIsSubdisplay();
        this.ivTable.setHeader(Babel.get("NO_SEARCH_RUNNING"));
        this.ivTable.ivModel.setTable(new Vector());
        this.ivChangingPanel.add((Component)this.ivTable, MOUSE_TABLE);
        this.ivButton.setImage("redButton");
        this.ivButton.setForeground(Color.white);
        this.ivButton.setActionCommand(COM_SEARCH);
        this.ivButton.setFont(FontManager.getFont("SSB16"));
        this.setChanging(EMPTY_LABEL);
    }

    private void setChanging(String tag) {
        this.ivChangingLayout.show(this.ivChangingPanel, tag);
        this.ivTableIsVisible = tag.equals(MOUSE_TABLE);
        if (this.ivTableIsVisible) {
            Inspector.adjustToTable(this.ivTable);
        }
    }

    public JPanel getChangingPanel() {
        return this.ivChangingPanel;
    }

    public MausoleumTable getTableIfVisible() {
        return this.ivTableIsVisible ? this.ivTable : null;
    }

    public void dispose() {
        this.ivFinished = true;
        if (this.ivTicket != null) {
            RequestManager.createSendAndGetAnswer((byte)14, this.ivTicket, null);
        }
    }

    public void performSearch(SearchObject so) {
        so.prepareForSearch(false);
        this.ivCountOnly = so.wantsOnlyCount();
        if (so.wantsOnlyActualObjects()) {
            this.ivResponder.searchWillStart();
            Vector<Mouse> mv = new Vector<Mouse>(1000);
            int total = 0;
            Vector v = MouseManager.getActualObjects(so.getGroup());
            Iterator iter = v.iterator();
            while (iter.hasNext()) {
                Mouse mausi = (Mouse)iter.next();
                if (!mausi.existed() || !so.includeObject(mausi)) continue;
                if (!this.ivCountOnly) {
                    mv.add(mausi);
                }
                ++total;
            }
            if (this.ivCountOnly) {
                this.ivCountResultLabel.setText(String.valueOf(Babel.get("RESULT_OF_SEARCH")) + ": " + total + " " + Babel.get("MICE"));
                this.setChanging(COUNT_RESULT);
            } else {
                this.ivTable.setHeader(String.valueOf(Babel.get("RESULT_OF_SEARCH")) + ": " + total + " " + Babel.get("MICE"));
                this.ivTable.ivModel.setTable(mv);
                this.setChanging(MOUSE_TABLE);
            }
            this.ivButton.setLabel(Babel.get("CLEAR_TABLE"));
            this.ivButton.setActionCommand(COM_CLEAR);
            this.ivResponder.searchWasFinished();
            so.searchFinished(false);
        } else {
            this.ivCommandObject = so;
            this.ivButton.setLabel(Babel.get("STOP_SEARCH"));
            this.ivButton.setActionCommand(COM_STOP);
            this.ivFinished = false;
            this.ivStop = false;
            this.ivResponder.searchWillStart();
            new Thread(this).start();
        }
    }

    public void stopIt() {
        this.ivStop = true;
        this.ivSuccess = false;
        if (this.ivTicket != null) {
            RequestManager.createSendAndGetAnswer((byte)14, this.ivTicket, null);
            this.ivTicket = null;
        }
        this.ivResponder.searchWasStopped();
        this.clearIt();
    }

    public void clearIt() {
        this.ivButton.setLabel(Babel.get("START_SEARCH"));
        this.ivButton.setActionCommand(COM_SEARCH);
        this.setChanging(EMPTY_LABEL);
        this.ivTable.ivModel.setTable(new Vector());
        this.ivResponder.tableWasCleared();
    }

    public void run() {
        String group = UserManager.getFirstGroup();
        this.ivProgressBar.setMinimum(0);
        this.ivProgressBar.setMinimum(100);
        this.ivProgressBar.setValue(0);
        this.ivProgressBar.setString("");
        this.setChanging(this.ivCountOnly ? COUNT_PROGRESS : PROGRESS_BAR);
        if (this.ivCountOnly) {
            this.ivCountProgressLabel.setText(Babel.get("WAITFOREXTSEARCH"));
        }
        ObjectRequest mor = new ObjectRequest(13, this.ivCommandObject, group, null);
        if (!(mor = RequestManager.sendObjectRequestAndGetAnswer(mor)).isFinished()) {
            this.ivTable.setHeader((String)mor.ivObject);
            this.ivFinished = true;
        }
        this.ivTicket = (String)mor.ivObject;
        MouseManager manager = MouseManager.cvInstance;
        Vector tempL = new Vector();
        int total = 0;
        int geholt = 0;
        while (!this.ivFinished) {
            try {
                Thread.sleep(300L);
                if (!this.ivStop) {
                    Boolean booli;
                    mor = RequestManager.sendObjectRequestAndGetAnswer(new ObjectRequest(66, this.ivTicket, group, null));
                    if (!mor.isFinished()) {
                        this.ivFinished = true;
                        continue;
                    }
                    if (!(mor.ivObject instanceof Vector)) continue;
                    Vector v = (Vector)mor.ivObject;
                    total += v.size();
                    if (this.ivCountOnly) {
                        this.ivCountProgressLabel.setText(String.valueOf(Babel.get("WAITFOREXTSEARCH")) + " [" + total + (this.ivFinished ? "" : " ...") + "]");
                    } else {
                        this.ivProgressBar.setMaximum(total);
                        this.holeLadung(group, v, tempL, geholt, total, manager);
                    }
                    if (mor.ivExtraObject == null || !(mor.ivExtraObject instanceof Boolean) || !(booli = (Boolean)mor.ivExtraObject).booleanValue()) continue;
                    this.ivFinished = true;
                    this.ivSuccess = true;
                    continue;
                }
                this.ivFinished = true;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (this.ivSuccess && !this.ivStop) {
            if (this.ivCountOnly) {
                this.ivCountResultLabel.setText(String.valueOf(Babel.get("RESULT_OF_SEARCH")) + ": " + total + " " + Babel.get("MICE"));
                this.setChanging(COUNT_RESULT);
            } else {
                this.ivTable.setHeader(String.valueOf(Babel.get("RESULT_OF_SEARCH")) + ": " + this.ivTable.ivModel.getRowCount() + " " + Babel.get("MICE"));
                this.setChanging(MOUSE_TABLE);
            }
            this.ivButton.setLabel(Babel.get("CLEAR_TABLE"));
            this.ivButton.setActionCommand(COM_CLEAR);
            this.ivResponder.searchWasFinished();
            ((SearchObject)this.ivCommandObject).searchFinished(true);
        }
    }

    private int holeLadung(String group, Vector alleIDVector, Vector tmpIDVector, int geholt, int total, MouseManager manager) {
        if (alleIDVector != null && !alleIDVector.isEmpty()) {
            tmpIDVector.clear();
            int i = 0;
            while (i < alleIDVector.size() && !this.ivStop) {
                tmpIDVector.add(alleIDVector.elementAt(i));
                if (tmpIDVector.size() > 100 && !this.ivStop) {
                    geholt = this.holeNachIDVector(group, tmpIDVector, geholt, total, manager);
                }
                ++i;
            }
            if (!tmpIDVector.isEmpty() && !this.ivStop) {
                geholt = this.holeNachIDVector(group, tmpIDVector, geholt, total, manager);
            }
        }
        return geholt;
    }

    private int holeNachIDVector(String group, Vector tmpIDVector, int geholt, int total, MouseManager manager) {
        this.ivTable.ivModel.addObjectsToTable(manager.getObjects(null, tmpIDVector, group));
        this.ivProgressBar.setValue(geholt += tmpIDVector.size());
        this.ivProgressBar.setString(String.valueOf(geholt) + "/" + total);
        this.ivProgressBar.repaint();
        tmpIDVector.clear();
        return geholt;
    }
}

