/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.search;

import de.hannse.netobjects.objectstore.IDObject;
import de.hannse.netobjects.tools.StringHelper;
import de.hannse.netobjects.user.UserManager;
import de.hannse.netobjects.util.Babel;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import mausoleum.gui.ClosableTabbedPane;
import mausoleum.gui.MGButton;
import mausoleum.gui.RequesterPane;
import mausoleum.gui.SimpleLayoutManager;
import mausoleum.helper.DatumFormat;
import mausoleum.helper.FontManager;
import mausoleum.helper.WindowUtils;
import mausoleum.inspector.Inspector;
import mausoleum.inspector.sensitives.CSMark;
import mausoleum.line.LineManager;
import mausoleum.main.MausoleumClient;
import mausoleum.mouse.Mouse;
import mausoleum.mouse.MouseManager;
import mausoleum.requester.AllgChoiceRequester;
import mausoleum.requester.Requester;
import mausoleum.requester.calendar.CalendarRequester;
import mausoleum.requester.mouse.EartagRequester;
import mausoleum.search.SearchPanel;
import mausoleum.strain.StrainManager;
import mausoleum.tables.MausoleumTable;
import mausoleum.tables.models.MTMouseSimpleSearch;
import mausoleum.ui.UIDef;

public class SimpleMouseSearchPanel
extends RequesterPane
implements ActionListener,
SearchPanel {
    private static final long serialVersionUID = 1L;
    private static final int BUT_BREITE = UIDef.getScaled(180);
    private final ClosableTabbedPane ivTabbedPane = new ClosableTabbedPane(true, true);
    private final Vector ivButtons = new Vector();

    protected SimpleMouseSearchPanel() {
        super(null);
        this.setLayout(new SimpleLayoutManager(){

            public void layoutContainer(Container parent) {
                int x = UIDef.RAND;
                int y = UIDef.RAND;
                Iterator iter = SimpleMouseSearchPanel.this.ivButtons.iterator();
                while (iter.hasNext()) {
                    MGButton but = (MGButton)iter.next();
                    but.setBounds(x, y, BUT_BREITE, UIDef.BUT_HEIGHT);
                    y += UIDef.BUT_HEIGHT + UIDef.INNER_RAND;
                }
                Dimension d = parent.getSize();
                int tbr = d.width - 3 * UIDef.RAND - BUT_BREITE;
                SimpleMouseSearchPanel.this.ivTabbedPane.setBounds(x += BUT_BREITE + UIDef.RAND, UIDef.RAND, tbr, d.height - 2 * UIDef.RAND);
            }
        });
        this.add(this.ivTabbedPane);
        this.makeBut(Babel.get("WITHOUTEARTAG"), "withoutEartag");
        this.makeBut(String.valueOf(Babel.get("WITHEARTAG")) + "...", "withSpecifiedEartag");
        this.makeBut(String.valueOf(Babel.get("WITHTAG")) + "...", "withANTag");
        this.makeBut(String.valueOf(Babel.get("WITHID")) + "...", "withSystemID");
        this.makeBut(String.valueOf(Babel.get("WITHMARK")) + "...", "withMark");
        this.makeBut(String.valueOf(Babel.get("OFSTRAIN")) + "...", "ofStrain");
        this.makeBut(String.valueOf(Babel.get("OFLINE")) + "...", "ofLine");
        this.makeBut(String.valueOf(Babel.get("BORNBEFORE")) + "...", "bornBefore");
        this.makeBut(String.valueOf(Babel.get("BORNAFTER")) + "...", "bornAfter");
        this.makeBut(String.valueOf(Babel.get("CONTCOMM")) + "...", "withComment");
        this.ivTabbedPane.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                SimpleMouseSearchPanel.this.adaptToTab();
            }
        });
    }

    private void makeBut(String text, String ac) {
        MGButton b = new MGButton(text);
        b.addActionListener(this);
        b.setActionCommand(ac);
        b.setFont(FontManager.getFont("SSB14"));
        this.add(b);
        this.ivButtons.add(b);
    }

    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        Vector<Mouse> erg = new Vector<Mouse>();
        if (command.equals("withoutEartag")) {
            Vector v = this.getStartVector();
            int i = 0;
            while (i < v.size()) {
                Mouse mausi = (Mouse)v.elementAt(i);
                if (mausi.getInt("MOS_EARTAG") == 0) {
                    erg.addElement(mausi);
                }
                ++i;
            }
            this.showMice(erg, Babel.get("WITHOUTEARTAG"));
        } else if (command.equals("withSpecifiedEartag")) {
            EartagRequester.BigEarTagInfo beti = EartagRequester.getEartag(new EartagRequester.BigEarTagInfo("", -1), -1, null);
            if (beti != null) {
                Iterator iterator = this.getStartVector().iterator();
                while (iterator.hasNext()) {
                    Mouse mouse = (Mouse)iterator.next();
                    if (!beti.matches(mouse)) continue;
                    erg.addElement(mouse);
                }
                this.showMice(erg, String.valueOf(Babel.get("WITHSPECIFIEDEARTAG")) + ": " + beti.toString());
            }
        } else if (command.equals("withSystemID")) {
            long val = Requester.getLong(Inspector.getInspector(), Babel.get("SYSTEM_ID"), 0L, false, -1L, false);
            if (val > 0L) {
                Enumeration en = UserManager.getGroupsEnumeration();
                while (en.hasMoreElements()) {
                    String group = (String)en.nextElement();
                    Mouse mouse = MouseManager.getMouse(val, group);
                    if (mouse == null) continue;
                    erg.addElement(mouse);
                }
                if (!erg.isEmpty()) {
                    this.showMice(erg, String.valueOf(Babel.get("WITHSPECIFIEDID")) + ": " + val);
                }
            }
        } else if (command.equals("withANTag")) {
            String s = Requester.getString(Inspector.getInspector(), "Tag");
            if (s != null && s.trim().length() != 0) {
                Vector v = this.getStartVector();
                int i = 0;
                while (i < v.size()) {
                    Mouse mausi = (Mouse)v.elementAt(i);
                    if (mausi.getString("MOS_ANTAG", "").equalsIgnoreCase(s)) {
                        erg.addElement(mausi);
                    }
                    ++i;
                }
                this.showMice(erg, String.valueOf(Babel.get("WITHSPECIFIEDTAG")) + ": " + s);
            }
        } else if (command.equals("withComment")) {
            String s = Requester.getString(WindowUtils.getJFrame(this), String.valueOf(Babel.get("SEARCH")) + ":");
            if (s != null && s.trim().length() != 0) {
                Vector v = this.getStartVector();
                String such = s.toLowerCase();
                int i = 0;
                while (i < v.size()) {
                    String comp;
                    Mouse mausi = (Mouse)v.elementAt(i);
                    if (mausi.getString("MOS_COMMENT") != null && (comp = mausi.getString("MOS_COMMENT").toLowerCase()).indexOf(such) != -1) {
                        erg.addElement(mausi);
                    }
                    ++i;
                }
                this.showMice(erg, String.valueOf(Babel.get("WITHSPECIFIEDCOMMENT")) + ": " + s);
            }
        } else if (command.equals("withMark")) {
            char c = CSMark.selectMark(WindowUtils.getJFrame(this), String.valueOf(Babel.get("SEARCH")) + " " + Babel.get("MARK"), '\ufffc');
            if (c != '\ufffc') {
                Vector v = this.getStartVector();
                int i = 0;
                while (i < v.size()) {
                    Mouse mausi = (Mouse)v.elementAt(i);
                    if (mausi.getChar("MOS_FLAG") == c) {
                        erg.addElement(mausi);
                    }
                    ++i;
                }
                String meldung = String.valueOf(Babel.get("WITHSPECIFIEDMARK")) + ": " + c;
                if (c == '\u0001') {
                    meldung = String.valueOf(Babel.get("WITHSPECIFIEDMARK")) + ": Standard";
                }
                this.showMice(erg, meldung);
            }
        } else if (command.equals("bornBefore")) {
            Date d = CalendarRequester.getDate(WindowUtils.getJFrame(this));
            if (d != null) {
                long tmil = d.getTime();
                Vector v = this.getStartVector();
                int i = 0;
                while (i < v.size()) {
                    Mouse mausi = (Mouse)v.elementAt(i);
                    if (mausi.getDate("MOS_BIRTHDAY") != null && mausi.getDate("MOS_BIRTHDAY").getTime() < tmil) {
                        erg.addElement(mausi);
                    }
                    ++i;
                }
                this.showMice(erg, String.valueOf(Babel.get("BORNBEFORE")) + " " + DatumFormat.getJustDateString(d));
            }
        } else if (command.equals("bornAfter")) {
            Date d = CalendarRequester.getDate(WindowUtils.getJFrame(this));
            if (d != null) {
                long tmil = d.getTime();
                Vector v = this.getStartVector();
                int i = 0;
                while (i < v.size()) {
                    Mouse mausi = (Mouse)v.elementAt(i);
                    if (mausi.getDate("MOS_BIRTHDAY") != null && mausi.getDate("MOS_BIRTHDAY").getTime() > tmil) {
                        erg.addElement(mausi);
                    }
                    ++i;
                }
                this.showMice(erg, String.valueOf(Babel.get("BORNAFTER")) + " " + DatumFormat.getJustDateString(d));
            }
        } else if (command.equals("ofStrain")) {
            this.findMiceOfLineOrStrain(false);
        } else if (command.equals("ofLine")) {
            this.findMiceOfLineOrStrain(true);
        }
    }

    private void findMiceOfLineOrStrain(boolean isLine) {
        Vector idObjects = isLine ? LineManager.cvInstance.getActualObjectVectorAllGroups() : StrainManager.cvInstance.getActualObjectVectorAllGroups();
        Vector<String> auswahl = new Vector<String>();
        HashMap<String, IDObject> objectsByDisplay = new HashMap<String, IDObject>();
        if (idObjects != null) {
            Iterator iter = idObjects.iterator();
            while (iter.hasNext()) {
                IDObject ido = (IDObject)iter.next();
                if (!ido.isAliveAndVisible()) continue;
                String display = ido.getBrowseNameInclServicePrefix();
                if (MausoleumClient.isServiceCaretaker()) {
                    display = String.valueOf(display) + " [" + ido.getGroup() + "]";
                }
                auswahl.addElement(display);
                objectsByDisplay.put(display, ido);
            }
            Collections.sort(auswahl, StringHelper.CASE_INSENSITIVE_COMPARER);
        }
        auswahl.insertElementAt(Babel.get(isLine ? "NOLINE" : "NOSTRAIN"), 0);
        int selectedIndex = AllgChoiceRequester.getIndexAnswer((Frame)WindowUtils.getJFrame(this), String.valueOf(Babel.get("SEARCH")) + " " + Babel.get(isLine ? "LINE" : "STRAIN"), auswahl);
        if (selectedIndex != -1) {
            String titel = null;
            long id = -1L;
            Vector mice = null;
            if (selectedIndex != 0) {
                String display = (String)auswahl.elementAt(selectedIndex);
                titel = String.valueOf(Babel.get(isLine ? "OFLINE" : "OFSTRAIN")) + " " + display;
                IDObject ido = (IDObject)objectsByDisplay.get(display);
                mice = MouseManager.getActualObjects(ido.getGroup());
                id = ido.getID();
            } else {
                titel = Babel.get(isLine ? "WITHOUTLINE" : "WITHOUTSTRAIN");
                mice = MouseManager.getActualObjectsOfAllGroups();
            }
            Vector<Mouse> erg = new Vector<Mouse>();
            Iterator iterator = mice.iterator();
            while (iterator.hasNext()) {
                boolean take;
                Mouse mouse = (Mouse)iterator.next();
                boolean bl = id == -1L ? mouse.get(isLine ? "MOS_LINEID" : "MOS_STRAIN") == null : (take = isLine && mouse.ofLine(id) || mouse.ofStrain(id));
                if (!take) continue;
                erg.addElement(mouse);
            }
            this.showMice(erg, titel);
        }
    }

    private Vector getStartVector() {
        Vector v = MouseManager.getActualObjectsOfAllGroups();
        if (v == null) {
            v = new Vector();
        }
        return v;
    }

    private void showMice(Vector erg, String meldung) {
        MausoleumTable mt = new MausoleumTable(new MTMouseSimpleSearch(), false);
        mt.setIsSubdisplay();
        mt.setHeader(meldung);
        mt.ivModel.setTable(erg);
        this.ivTabbedPane.addTab(meldung, mt);
        this.ivTabbedPane.setSelectedComponent(mt);
    }

    public void adaptToTab() {
        Inspector.adjustToTable((MausoleumTable)this.ivTabbedPane.getSelectedComponent());
    }
}

