/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.search.extendedsearch;

import de.hannse.netobjects.util.Babel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import mausoleum.inspector.Inspector;
import mausoleum.locus.LocusAndAlleles;
import mausoleum.locus.SelectLocusAndGenotypesRequester;
import mausoleum.mouse.XSObject;
import mausoleum.search.extendedsearch.XSLine;

public class XSLineGenotype
extends XSLine {
    private static final String DOESNT_MATTER = Babel.get("DOESNTMATTER");
    private static final String SET = Babel.get("SET");
    private static final String NOT_SET = Babel.get("NOTSET");
    private static final String SPECIFIC = Babel.get("SPECIFYGENOTYPE");
    private static String[] ARRAY = new String[]{DOESNT_MATTER, SET, NOT_SET, SPECIFIC};
    private final Vector ivAddedStrings = new Vector();
    private final Vector ivAddedLocusAndAllelArrays = new Vector();
    private final String ivGroup;

    public XSLineGenotype(ActionListener al, JPanel jp, int y, String group) {
        super(Babel.get("GENOTYPE"), al);
        this.ivGroup = group;
        this.ivComboBox = new JComboBox<String>(ARRAY);
        this.ivComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String ds = (String)XSLineGenotype.this.ivComboBox.getSelectedItem();
                if (ds.equals(SPECIFIC)) {
                    LocusAndAlleles[] lalArray = SelectLocusAndGenotypesRequester.selectLocusAndAlleles(Inspector.getInspector(), XSLineGenotype.this.ivGroup, true);
                    if (lalArray != null) {
                        String genString = LocusAndAlleles.getGenotypeString(lalArray, XSLineGenotype.this.ivGroup);
                        if (XSLineGenotype.this.ivAddedStrings.contains(genString)) {
                            XSLineGenotype.this.ivComboBox.setSelectedItem(genString);
                        } else {
                            XSLineGenotype.this.ivAddedStrings.addElement(genString);
                            XSLineGenotype.this.ivAddedLocusAndAllelArrays.addElement(lalArray);
                            XSLineGenotype.this.ivComboBox.insertItemAt(genString, 3);
                            XSLineGenotype.this.ivComboBox.setSelectedIndex(3);
                        }
                    } else {
                        XSLineGenotype.this.ivComboBox.setSelectedIndex(0);
                    }
                }
                XSLineGenotype.this.ivActionListener.actionPerformed(new ActionEvent(this, 0, "SEL"));
            }
        });
        super.arrangeComponents(jp, y);
    }

    public void fillXSObject(XSObject xobj) {
        String sels = (String)this.ivComboBox.getSelectedItem();
        if (sels.equals(DOESNT_MATTER)) {
            xobj.ivGenotype = null;
        } else if (sels.equals(SET)) {
            xobj.ivGenotype = "XXX@set";
        } else if (sels.equals(NOT_SET)) {
            xobj.ivGenotype = "XXX@none";
        } else {
            int ind = this.ivAddedStrings.indexOf(sels);
            if (ind != -1) {
                LocusAndAlleles[] lalArray = (LocusAndAlleles[])this.ivAddedLocusAndAllelArrays.elementAt(ind);
                xobj.ivGenotype = LocusAndAlleles.getTransportString(lalArray);
            }
        }
        xobj.ivGenotypeFlag = this.ivCheckBox.isSelected();
    }
}

