/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.search.profisearch.basic;

import de.hannse.netobjects.tools.StringHelper;
import de.hannse.netobjects.util.XMLNode;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.tree.TreeNode;
import mausoleum.mouse.Mouse;
import mausoleum.search.profisearch.basic.SDNode;

public abstract class SDSearcher
extends SDNode {
    public static final int RES_YES = 1;
    public static final int RES_NO = 2;
    public static final int RES_NOT_DEF = 3;
    public static final int TYPE_UNKNOWN = 0;
    public static final int TYPE_INTEGER = 1;
    public static final int TYPE_LONG = 2;
    public static final int TYPE_INTEGER_SET = 3;
    public static final int TYPE_FLOAT = 4;
    public static final int TYPE_DATE = 5;
    public static final int TYPE_STRING = 6;
    public static final int TYPE_BOOLEAN = 7;
    public static final int TYPE_CHECK = 8;
    public static final int TYPE_OBJECT = 9;
    public static final int TYPE_STRING_SET = 10;
    public static final int QUAL_UNKNOWN = 0;
    public static final int QUAL_SET = 1;
    public static final int QUAL_NOT_SET = 2;
    public static final int QUAL_EQUALS = 3;
    public static final int QUAL_LESS_THAN = 4;
    public static final int QUAL_GREATER_THAN = 5;
    public static final int QUAL_LESS_OR_EQUAL = 6;
    public static final int QUAL_GREATER_OR_EQUAL = 7;
    public static final int QUAL_CONTAINS = 8;
    public static final int QUAL_STARTS_WITH = 9;
    public static final int QUAL_ENDS_WITH = 10;
    public static final int QUAL_BEFORE = 11;
    public static final int QUAL_AFTER = 12;
    public static final int QUAL_BETWEEN = 13;
    public static final int QUAL_NOT_EQUALS = 14;
    public static final int QUAL_CONTAINS_NOT = 15;
    public static final int QUAL_PARTIALLY_SET = 16;
    public static final int QUAL_FULLY_SET = 17;
    public static final int QUAL_PURE_WILDTYPE = 18;
    public static final int QUAL_PURE_NON_WILDTYPE = 19;
    public static final int QUAL_MIXED_WILDTYPE = 20;
    public static final int[] ALL_QUALS;
    public static final String[] ALL_QUAL_BABELS;
    public static final String[] SPECIAL_DATE_QUAL_BABELS;
    public static final int[] NO_OBJECT_QUALS;
    public static final int[] OBJECT_QUALS;
    public static final int[] TWO_OBJECT_QUALS;
    public static final int[] NUMBER_QUALS;
    public static final int[] SET_QUALS;
    public static final int[] ONLY_SET_QUALS;
    public static final int[] STRING_QUALS;
    public static final int[] DATE_QUALS;
    public static final int[] ONLY_EQUALS;
    public static final String TAG_TYPE = "type";
    public static final String TAG_QUAL = "qual";
    public static final String TAG_VAL = "val";
    public static final String TAG_SECOND_VAL = "secondval";
    public static final String TAG_THIRD_VAL = "thirdval";
    private static Vector INSTANCE_NAMES;
    private static HashMap INSTANCES;
    public int ivType = 0;
    public int ivQual = 0;

    static {
        int[] nArray = new int[22];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        nArray[4] = 14;
        nArray[5] = 4;
        nArray[6] = 5;
        nArray[7] = 6;
        nArray[8] = 7;
        nArray[9] = 8;
        nArray[10] = 9;
        nArray[11] = 10;
        nArray[12] = 11;
        nArray[13] = 12;
        nArray[14] = 13;
        nArray[15] = 14;
        nArray[16] = 15;
        nArray[17] = 16;
        nArray[18] = 17;
        nArray[19] = 18;
        nArray[20] = 19;
        nArray[21] = 20;
        ALL_QUALS = nArray;
        ALL_QUAL_BABELS = new String[]{"", "SD_QUAL_SET", "SD_QUAL_NOT_SET", "SD_QUAL_EQUALS", "SD_QUAL_NOT_EQUALS", "SD_QUAL_LESS_THAN", "SD_QUAL_GREATER_THAN", "SD_QUAL_LESS_OR_EQUAL", "SD_QUAL_GREATER_OR_EQUAL", "SD_QUAL_CONTAINS", "SD_QUAL_STARTS_WITH", "SD_QUAL_ENDS_WITH", "SD_QUAL_BEFORE", "SD_QUAL_AFTER", "SD_QUAL_BETWEEN", "SD_QUAL_NOT_EQUALS", "SD_QUAL_CONTAINS_NOT", "SD_QUAL_PARTIALLY_SET", "SD_QUAL_FULLY_SET", "SD_QUAL_PURE_WILDTYPE", "SD_QUAL_PURE_NON_WILDTYPE", "SD_QUAL_MIXED_WILDTYPE"};
        SPECIAL_DATE_QUAL_BABELS = new String[]{"", "SD_QUAL_SET", "SD_QUAL_NOT_SET", "SD_QUAL_DATE_EQUALS", "SD_QUAL_DATE_NOT_EQUALS", "SD_QUAL_LESS_THAN", "SD_QUAL_GREATER_THAN", "SD_QUAL_LESS_OR_EQUAL", "SD_QUAL_GREATER_OR_EQUAL", "SD_QUAL_CONTAINS", "SD_QUAL_STARTS_WITH", "SD_QUAL_ENDS_WITH", "SD_QUAL_DATE_BEFORE", "SD_QUAL_DATE_AFTER", "SD_QUAL_DATE_BETWEEN", "SD_QUAL_NOT_EQUALS", "SD_QUAL_CONTAINS_NOT", "SD_QUAL_PARTIALLY_SET", "SD_QUAL_FULLY_SET", "SD_QUAL_PURE_WILDTYPE", "SD_QUAL_PURE_NON_WILDTYPE", "SD_QUAL_MIXED_WILDTYPE"};
        NO_OBJECT_QUALS = new int[]{1, 2, 16, 17, 18, 19, 20};
        OBJECT_QUALS = new int[]{3, 14, 4, 5, 6, 7, 8, 15, 9, 10, 11, 12, 13};
        TWO_OBJECT_QUALS = new int[]{13};
        NUMBER_QUALS = new int[]{1, 2, 3, 14, 4, 5, 6, 7, 13};
        SET_QUALS = new int[]{1, 2, 3, 14};
        ONLY_SET_QUALS = new int[]{1, 2};
        STRING_QUALS = new int[]{1, 2, 3, 14, 8, 15, 9, 10, 4, 5, 6, 7};
        DATE_QUALS = new int[]{1, 2, 3, 14, 11, 12, 13};
        ONLY_EQUALS = new int[]{3};
        INSTANCE_NAMES = new Vector();
        INSTANCES = new HashMap();
    }

    public static void register(SDSearcher searcher) {
        String title = searcher.getTitle();
        INSTANCES.put(title, searcher);
        if (INSTANCE_NAMES.isEmpty()) {
            INSTANCE_NAMES.add("");
        }
        title.compareToIgnoreCase(searcher.toString());
        INSTANCE_NAMES.add(" " + title + " ");
        Collections.sort(INSTANCE_NAMES, StringHelper.CASE_INSENSITIVE_COMPARER);
    }

    public static Vector getInstanceNames() {
        return INSTANCE_NAMES;
    }

    public static SDSearcher getRegisteredSearcher(String name) {
        return (SDSearcher)INSTANCES.get(name.trim());
    }

    public static String getNameOfSearcher(SDSearcher searcher) {
        String s = searcher.getClass().getName();
        Iterator iter = INSTANCES.keySet().iterator();
        while (iter.hasNext()) {
            String name = (String)iter.next();
            SDSearcher ts = (SDSearcher)INSTANCES.get(name.trim());
            if (!ts.getClass().getName().equals(s)) continue;
            return " " + name + " ";
        }
        return null;
    }

    public String getKidXML(int tab) {
        return null;
    }

    public String getAttributeXML() {
        StringBuilder msb = new StringBuilder();
        msb.append(TAG_TYPE).append("=\"").append(this.ivType).append("\" ");
        msb.append(TAG_QUAL).append("=\"").append(this.ivQual).append("\" ");
        this.getValXML(msb);
        return msb.toString();
    }

    public void init(XMLNode node) {
        this.ivQual = Integer.parseInt(node.getAttributeValue(TAG_QUAL, "0"));
        this.iInit(node);
    }

    public abstract String getTitle();

    public abstract void getValXML(StringBuilder var1);

    public abstract int[] getPossibleQuals();

    public abstract void iInit(XMLNode var1);

    public abstract int iMatch(Object var1, Object var2);

    public abstract Object getComparableObject(Object var1);

    public abstract String getValueDisplay();

    public abstract JComponent[] getDialogComponent();

    public abstract void fillFromComponents(JComponent[] var1);

    public abstract void fillComponents(JComponent[] var1);

    public void fillSubLineTarget(Vector subLineTarget) {
    }

    public String getTableTitle() {
        return this.getTitle();
    }

    public boolean isFullyDefined() {
        if (this.ivQual == 0) {
            return false;
        }
        int i = 0;
        while (i < NO_OBJECT_QUALS.length) {
            if (this.ivQual == NO_OBJECT_QUALS[i]) {
                return true;
            }
            ++i;
        }
        if (this.needsTwoObjects()) {
            return this.getObject() != null && this.getSecondObject() != null;
        }
        if (this.needsObject()) {
            return this.getObject() != null;
        }
        return false;
    }

    public boolean needsObject() {
        int i = 0;
        while (i < OBJECT_QUALS.length) {
            if (this.ivQual == OBJECT_QUALS[i]) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean needsTwoObjects() {
        int i = 0;
        while (i < TWO_OBJECT_QUALS.length) {
            if (this.ivQual == TWO_OBJECT_QUALS[i]) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public Object getObject() {
        return null;
    }

    public Object getSecondObject() {
        return null;
    }

    public boolean match(Object o) {
        return this.makeRes(this.iMatch(this.getComparableObject(o), o));
    }

    public boolean makeRes(int erg) {
        try {
            switch (erg) {
                case 1: {
                    return !this.ivNOT;
                }
                case 2: {
                    return this.ivNOT;
                }
                case 3: {
                    return false;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public String[] getQualComboStrings() {
        int[] possQuals = this.getPossibleQuals();
        String[] res = new String[possQuals.length + 1];
        res[0] = "";
        int i = 0;
        while (i < possQuals.length) {
            res[i + 1] = " " + this.getQualString(possQuals[i]) + " ";
            ++i;
        }
        return res;
    }

    public String getQualString(int qual) {
        return StringHelper.getStringForInt(qual, ALL_QUALS, this.getQualBabels(), true, "");
    }

    public String[] getQualBabels() {
        return ALL_QUAL_BABELS;
    }

    public int getQual(int comboIndex) {
        if (comboIndex == 0) {
            return 2;
        }
        return this.getPossibleQuals()[comboIndex - 1];
    }

    public int getQualComboIndex() {
        int[] arr = this.getPossibleQuals();
        int i = 0;
        while (i < arr.length) {
            if (this.ivQual == arr[i]) {
                return i + 1;
            }
            ++i;
        }
        return 0;
    }

    public String getListString() {
        StringBuffer msb = new StringBuffer();
        msb.append(this.getTitle());
        msb.append(" ").append(this.getQualString(this.ivQual));
        if (this.needsObject()) {
            msb.append(" ").append(this.getValueDisplay());
        }
        return msb.toString();
    }

    public String toString() {
        return " " + this.getTitle() + " ";
    }

    public Object getComparableObject(Object primaryObject, String tag) {
        if (primaryObject != null && tag != null) {
            if (primaryObject instanceof Mouse) {
                Mouse mouse = (Mouse)primaryObject;
                return mouse.get(tag);
            }
            if (primaryObject instanceof HashMap) {
                HashMap hm = (HashMap)primaryObject;
                return hm.get(tag);
            }
        }
        return null;
    }

    public Enumeration children() {
        return null;
    }

    public boolean getAllowsChildren() {
        return false;
    }

    public TreeNode getChildAt(int arg0) {
        return null;
    }

    public int getChildCount() {
        return 0;
    }

    public int getIndex(TreeNode arg0) {
        return 0;
    }

    public boolean isLeaf() {
        return true;
    }
}

