/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.search.profisearch.display;

import java.awt.Color;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import mausoleum.gui.KomfortTextField;
import mausoleum.gui.documents.DoubleDocument;
import mausoleum.gui.documents.IntegerDocument;
import mausoleum.helper.FontManager;
import mausoleum.search.profisearch.display.SDDateSelector;
import mausoleum.search.profisearch.searcher.MausoSearcherDate;
import mausoleum.search.profisearch.searcher.MausoSearcherDateArray;
import mausoleum.search.profisearch.searcher.MausoSearcherIDObject;
import mausoleum.search.profisearch.searcher.MausoSearcherInt;
import mausoleum.search.profisearch.searcher.MausoSearcherIntSet;
import mausoleum.search.profisearch.searcher.MausoSearcherLong;
import mausoleum.search.profisearch.searcher.MausoSearcherObject;
import mausoleum.search.profisearch.searcher.MausoSearcherString;

public abstract class MausoleumSearcher {
    public static final Border FIELD_BORDER = new CompoundBorder(new LineBorder(Color.black, 1), new EmptyBorder(0, 3, 0, 3));
    private static boolean cvInitialized = false;

    public static void init() {
        if (!cvInitialized) {
            MausoSearcherInt.init();
            MausoSearcherIDObject.init();
            MausoSearcherString.init();
            MausoSearcherDate.init();
            MausoSearcherDateArray.init();
            MausoSearcherIntSet.init();
            MausoSearcherObject.init();
            MausoSearcherLong.init();
            cvInitialized = true;
        }
    }

    public static JComponent getDialogComponentDate() {
        return new SDDateSelector(true, false);
    }

    public static JComponent getDialogComponentDouble() {
        KomfortTextField ktf = new KomfortTextField();
        ktf.setDocument(new DoubleDocument(ktf));
        ktf.setFont(FontManager.getFont("SSB11"));
        ktf.setBorder(FIELD_BORDER);
        ktf.setHorizontalAlignment(4);
        return ktf;
    }

    public static JComponent getDialogComponentInt() {
        KomfortTextField ktf = new KomfortTextField();
        ktf.setDocument(new IntegerDocument(ktf));
        ktf.setFont(FontManager.getFont("SSB11"));
        ktf.setBorder(FIELD_BORDER);
        ktf.setHorizontalAlignment(4);
        return ktf;
    }

    public static JComponent getDialogComponentLong() {
        KomfortTextField ktf = new KomfortTextField();
        ktf.setDocument(new IntegerDocument(ktf));
        ktf.setFont(FontManager.getFont("SSB11"));
        ktf.setBorder(FIELD_BORDER);
        ktf.setHorizontalAlignment(4);
        return ktf;
    }

    public static JComponent getDialogComponentString() {
        KomfortTextField ktf = new KomfortTextField();
        ktf.setFont(FontManager.getFont("SSB11"));
        ktf.setBorder(FIELD_BORDER);
        return ktf;
    }

    public static JComponent getDialogComponentStringarr(String[] sarr) {
        return new JComboBox<String>(sarr);
    }
}

