/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.search.profisearch.display;

import de.hannse.netobjects.objectstore.IDObject;
import de.hannse.netobjects.util.Babel;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import mausoleum.locus.Locus;
import mausoleum.locus.LocusAndAlleles;
import mausoleum.locus.LocusManager;
import mausoleum.ui.UIDef;

public class SDGenotypeSelector
extends JPanel {
    private static final long serialVersionUID = 11515L;
    private final JComboBox ivLocusCombo;
    private final JComboBox ivGenotypeCombo = new JComboBox();
    private final Vector ivLoci = new Vector();
    private final Vector ivLocusNames = new Vector();
    private final Vector ivLocusAndAlleles = new Vector();
    private final Vector ivLocusAndAlleleNames = new Vector();

    public SDGenotypeSelector() {
        super(new GridLayout(1, 2, UIDef.INNER_RAND, 0));
        this.ivLoci.addAll(LocusManager.cvInstance.getActualObjectVectorAllGroups());
        Collections.sort(this.ivLoci, IDObject.SORTER_BY_NAME);
        Iterator iter = this.ivLoci.iterator();
        while (iter.hasNext()) {
            Locus locus = (Locus)iter.next();
            this.ivLocusNames.add(locus.getName());
        }
        this.ivLocusCombo = new JComboBox(this.ivLocusNames);
        this.ivLocusCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                SDGenotypeSelector.this.locusSelected();
            }
        });
        this.add(this.ivLocusCombo);
        this.add(this.ivGenotypeCombo);
    }

    public LocusAndAlleles getGenotype() {
        int sel = this.ivGenotypeCombo.getSelectedIndex();
        if (sel != -1) {
            return (LocusAndAlleles)this.ivLocusAndAlleles.elementAt(sel);
        }
        return null;
    }

    public void setGenotype(LocusAndAlleles lal) {
        if (lal != null) {
            int locusIndex = -1;
            int i = 0;
            while (i < this.ivLoci.size()) {
                Locus locus = (Locus)this.ivLoci.elementAt(i);
                if (locus.getID() == lal.ivLocusID) {
                    locusIndex = i;
                }
                ++i;
            }
            if (locusIndex == -1) {
                this.ivLocusCombo.setSelectedIndex(0);
            } else {
                this.ivLocusCombo.setSelectedIndex(locusIndex);
                int allelIndex = -1;
                if (lal.ivAllele == null) {
                    allelIndex = 0;
                } else {
                    int i2 = 1;
                    while (i2 < this.ivLocusAndAlleles.size()) {
                        LocusAndAlleles tlal = (LocusAndAlleles)this.ivLocusAndAlleles.elementAt(i2);
                        if (lal.ivAllele.length == tlal.ivAllele.length) {
                            boolean match = true;
                            int j = 0;
                            while (j < lal.ivAllele.length) {
                                if (!lal.ivAllele[j].equals(tlal.ivAllele[j])) {
                                    match = false;
                                }
                                ++j;
                            }
                            if (match) {
                                allelIndex = i2;
                            }
                        }
                        ++i2;
                    }
                }
                if (allelIndex != -1) {
                    this.ivGenotypeCombo.setSelectedIndex(allelIndex);
                }
            }
        }
    }

    private void locusSelected() {
        int sel = this.ivLocusCombo.getSelectedIndex();
        if (sel != -1) {
            Locus locus = (Locus)this.ivLoci.elementAt(sel);
            this.ivLocusAndAlleles.clear();
            this.ivLocusAndAlleleNames.clear();
            this.ivLocusAndAlleles.addAll(locus.getListOfGenotypes(4, null, false));
            Iterator iter = this.ivLocusAndAlleles.iterator();
            while (iter.hasNext()) {
                LocusAndAlleles laa = (LocusAndAlleles)iter.next();
                this.ivLocusAndAlleleNames.add(locus.getAllelString(laa));
            }
            this.ivLocusAndAlleleNames.insertElementAt(Babel.get("SD_QUAL_JUST_NOT_SET"), 0);
            this.ivLocusAndAlleles.insertElementAt(new LocusAndAlleles(locus.getID(), null), 0);
            this.ivGenotypeCombo.setModel(new DefaultComboBoxModel(this.ivLocusAndAlleleNames));
        }
    }
}

