/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.search.profisearch.display;

import de.hannse.netobjects.util.Babel;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.border.MatteBorder;
import javax.swing.tree.TreeCellRenderer;
import mausoleum.helper.FontManager;
import mausoleum.search.profisearch.basic.SDGrouper;
import mausoleum.search.profisearch.basic.SDNode;
import mausoleum.search.profisearch.basic.SDSearcher;
import mausoleum.ui.UIDef;

public abstract class SDTreeSupply {
    public static final int TREE_ROW_HEIGHT = UIDef.getScaled(25);
    private static final Border RAHMEN = new CompoundBorder(new LineBorder(Color.black), new EmptyBorder(UIDef.getScaled(3), UIDef.getScaled(3), UIDef.getScaled(3), UIDef.getScaled(3)));
    private static final Border RAHMEN_RECHTS_OFFEN = new CompoundBorder(new MatteBorder(1, 1, 1, 0, Color.black), new EmptyBorder(UIDef.getScaled(3), UIDef.getScaled(3), UIDef.getScaled(3), UIDef.getScaled(3)));
    private static final JLabel NOT_LABEL = new JLabel(Babel.get("SD_NOT"));
    private static final JLabel VALUE_LABEL = new JLabel();
    private static final JPanel DISPLAYPANEL = new JPanel(new FlowLayout(3, 0, 0));
    private static boolean cvInitialized = false;
    public static final TreeCellRenderer RENDERER = new TreeCellRenderer(){

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean pSelected, boolean expanded, boolean leaf, int row, boolean pHasFocus) {
            if (!cvInitialized) {
                DISPLAYPANEL.setOpaque(false);
                NOT_LABEL.setFont(FontManager.getFont("SSB11"));
                NOT_LABEL.setBorder(RAHMEN_RECHTS_OFFEN);
                NOT_LABEL.setBackground(UIDef.ALARM_COLOR);
                NOT_LABEL.setForeground(Color.white);
                NOT_LABEL.setOpaque(true);
                VALUE_LABEL.setFont(FontManager.getFont("SSB11"));
                VALUE_LABEL.setBorder(RAHMEN);
                VALUE_LABEL.setForeground(Color.black);
                cvInitialized = true;
            }
            DISPLAYPANEL.removeAll();
            if (value instanceof SDNode) {
                SDNode sds = (SDNode)value;
                if (sds.ivNOT) {
                    DISPLAYPANEL.add(NOT_LABEL);
                }
                if (sds instanceof SDGrouper) {
                    VALUE_LABEL.setText(((SDGrouper)sds).ivType == 0 ? Babel.get("SD_AND") : Babel.get("SD_OR"));
                } else if (sds instanceof SDSearcher) {
                    VALUE_LABEL.setText(((SDSearcher)sds).getListString());
                }
                VALUE_LABEL.setBackground(tree.isEnabled() && pSelected ? UIDef.SELECTED_BACKGROUND : null);
                VALUE_LABEL.setOpaque(tree.isEnabled() && pSelected);
                DISPLAYPANEL.add(VALUE_LABEL);
            }
            return DISPLAYPANEL;
        }
    };
}

