/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.search.profisearch.panels;

import de.hannse.netobjects.util.Babel;
import de.hannse.netobjects.util.XMLNode;
import de.hannse.netobjects.util.XMLParser;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.ListCellRenderer;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreePath;
import mausoleum.gui.MGButton;
import mausoleum.helper.WindowUtils;
import mausoleum.search.extendedsearch.XSLineDatabase;
import mausoleum.search.profisearch.basic.SDGrouper;
import mausoleum.search.profisearch.basic.SDNode;
import mausoleum.search.profisearch.basic.SDSearcher;
import mausoleum.search.profisearch.display.SDSearcherEditDialog;
import mausoleum.search.profisearch.display.SDTreeSupply;
import mausoleum.search.profisearch.panels.ProSearchPanel;
import mausoleum.ui.UIDef;
import mausoleum.util.GeneralSetting;

public class ProComplexSearchPanel
extends ProSearchPanel
implements ListCellRenderer {
    private static final long serialVersionUID = 1482483348L;
    private static final int DEF_TAB_HEIGHT = UIDef.getScaled(285);
    private static final int ANZ_BUTS = 12;
    private SDGrouper ivTopNode = new SDGrouper(true);
    private JTree ivTree = new JTree(this.ivTopNode);
    private JScrollPane ivTreePane = new JScrollPane(this.ivTree);
    private JPanel ivTreePanel = new JPanel(new BorderLayout());
    public MGButton ivNewGroupButton = new MGButton(Babel.get("FST_ADD_GROUP"));
    public MGButton ivSwitchGroupButton = new MGButton(Babel.get("FST_SWITCH_GROUP"));
    public MGButton ivDeleteGroupButton = new MGButton(Babel.get("FST_DELETE_GROUP"));
    public MGButton ivSwitchCritButton = new MGButton(Babel.get("FST_SWITCH_CRIT"));

    public ProComplexSearchPanel() {
        super.setLayout(this);
        this.ivTree.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent arg0) {
                ProComplexSearchPanel.this.checkButtons();
            }
        });
        this.ivTree.setToggleClickCount(0);
        this.ivTree.setCellRenderer(SDTreeSupply.RENDERER);
        this.ivTree.setRowHeight(SDTreeSupply.TREE_ROW_HEIGHT);
        this.ivTree.setBorder(new EmptyBorder(4, 4, 4, 4));
        this.ivTree.addTreeWillExpandListener(new TreeWillExpandListener(){

            public void treeWillCollapse(TreeExpansionEvent arg0) throws ExpandVetoException {
                throw new ExpandVetoException(arg0);
            }

            public void treeWillExpand(TreeExpansionEvent arg0) throws ExpandVetoException {
            }
        });
        this.ivTree.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && ProComplexSearchPanel.this.ivEditCritButton != null && ProComplexSearchPanel.this.ivEditCritButton.isEnabled()) {
                    ProComplexSearchPanel.this.editCrit();
                }
            }
        });
        this.ivTreePanel.add("Center", this.ivTreePane);
        this.ivTreePanel.add("North", this.ivSearchModeCombo);
        this.ivTreePanel.setOpaque(false);
        this.ivTreePanel.setBorder(UIDef.getTitleBorder("FST_ACT_DEFINITION"));
        this.add(this.ivTreePanel);
        this.ivNewGroupButton.setImage("greenButton");
        this.ivSwitchGroupButton.setImage("greenButton");
        this.ivDeleteGroupButton.setImage("greenButton");
        this.ivSwitchCritButton.setImage("yellowButton");
        this.ivSwitchCritButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                SDSearcher searcher = ProComplexSearchPanel.this.getSelectedSearcher();
                if (searcher != null) {
                    searcher.ivNOT = !searcher.ivNOT;
                    ProComplexSearchPanel.this.setTree(searcher);
                }
            }
        });
        this.add(this.ivSwitchCritButton);
        this.ivNewGroupButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                SDGrouper grouper = ProComplexSearchPanel.this.getSelectedGrouper();
                if (grouper != null) {
                    SDGrouper newGrouper = new SDGrouper();
                    grouper.addKid(newGrouper);
                    ProComplexSearchPanel.this.setTree(newGrouper);
                }
            }
        });
        this.add(this.ivNewGroupButton);
        this.ivSwitchGroupButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                SDGrouper grouper = ProComplexSearchPanel.this.getSelectedGrouper();
                if (grouper != null) {
                    grouper.ivType = grouper.isAnd() ? 1 : 0;
                    ProComplexSearchPanel.this.setTree(grouper);
                }
            }
        });
        this.add(this.ivSwitchGroupButton);
        this.ivDeleteGroupButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                SDGrouper grouper = ProComplexSearchPanel.this.getSelectedGrouper();
                if (grouper != null && grouper.ivSuperNode != null && grouper.ivSuperNode instanceof SDGrouper) {
                    ProComplexSearchPanel.this.removeNode((SDGrouper)grouper.ivSuperNode, grouper);
                }
            }
        });
        this.add(this.ivDeleteGroupButton);
        this.ivClearDefButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                ((ProComplexSearchPanel)ProComplexSearchPanel.this).ivTopNode.ivKids.clear();
                ProComplexSearchPanel.this.ivAssistant.clearIt();
                ProComplexSearchPanel.this.setTree(null);
            }
        });
        this.add(this.ivClearDefButton);
        this.checkButtons();
    }

    public void newCrit() {
        SDSearcher searcher;
        SDGrouper grouper = this.getSelectedGrouper();
        if (grouper != null && (searcher = SDSearcherEditDialog.editSearcher(null, WindowUtils.getJFrame(this))) != null) {
            grouper.addKid(searcher);
            this.setTree(searcher);
        }
    }

    public void editCrit() {
        SDSearcher searcher = this.getSelectedSearcher();
        if (searcher != null && searcher.ivSuperNode != null && searcher.ivSuperNode instanceof SDGrouper) {
            SDGrouper grouper = (SDGrouper)searcher.ivSuperNode;
            SDSearcher newsearcher = SDSearcherEditDialog.editSearcher(searcher, WindowUtils.getJFrame(this));
            if (newsearcher != null) {
                newsearcher.ivSuperNode = grouper;
                searcher.ivSuperNode = null;
                int ind = grouper.ivKids.indexOf(searcher);
                grouper.ivKids.setElementAt(newsearcher, ind);
                this.setTree(newsearcher);
            }
        }
    }

    public void deleteCrit() {
        SDSearcher searcher = this.getSelectedSearcher();
        if (searcher != null && searcher.ivSuperNode != null && searcher.ivSuperNode instanceof SDGrouper) {
            this.removeNode((SDGrouper)searcher.ivSuperNode, searcher);
        }
    }

    private void removeNode(SDGrouper superNode, SDNode subNode) {
        superNode.ivKids.remove(subNode);
        subNode.ivSuperNode = null;
        this.setTree(superNode);
    }

    public void loadDefinition() {
        GeneralSetting ss = (GeneralSetting)this.ivSettingsList.getSelectedValue();
        if (ss != null) {
            this.ivAssistant.clearIt();
            XMLNode node = XMLParser.parseXMLString(ss.ivPayload);
            SDNode topNode = SDNode.initFromNode(node);
            if (topNode instanceof SDGrouper) {
                this.ivTopNode = (SDGrouper)topNode;
                int smInd = 0;
                int i = 0;
                while (i < XSLineDatabase.MODE_ARRAY.length) {
                    if (this.ivTopNode.ivMode == XSLineDatabase.MODE_ARRAY[i]) {
                        smInd = i;
                    }
                    ++i;
                }
                this.ivSearchModeCombo.setSelectedIndex(smInd);
                this.setTree(null);
            }
        }
    }

    private SDGrouper getSelectedGrouper() {
        Object ooo = this.ivTree.getLastSelectedPathComponent();
        if (ooo instanceof SDGrouper) {
            return (SDGrouper)ooo;
        }
        return null;
    }

    private SDSearcher getSelectedSearcher() {
        Object ooo = this.ivTree.getLastSelectedPathComponent();
        if (ooo instanceof SDSearcher) {
            return (SDSearcher)ooo;
        }
        return null;
    }

    public SDGrouper getTopNode() {
        this.ivTopNode.ivMode = XSLineDatabase.MODE_ARRAY[this.ivSearchModeCombo.getSelectedIndex()];
        return this.ivTopNode;
    }

    public String getSettingsMode() {
        return "COMPLEX";
    }

    public void checkButtons() {
        SDGrouper grouper = this.getSelectedGrouper();
        SDSearcher searcher = this.getSelectedSearcher();
        this.ivTree.setEnabled(this.ivButtonsActive);
        this.ivNewGroupButton.setEnabled(this.ivButtonsActive && grouper != null);
        this.ivSwitchGroupButton.setEnabled(this.ivButtonsActive && grouper != null);
        this.ivDeleteGroupButton.setEnabled(this.ivButtonsActive && grouper != null && grouper.ivSuperNode != null);
        this.ivNewCritButton.setEnabled(this.ivButtonsActive && grouper != null);
        this.ivClearDefButton.setEnabled(this.ivTree.getRowCount() > 1);
        this.ivEditCritButton.setEnabled(this.ivButtonsActive && searcher != null);
        this.ivDeleteCritButton.setEnabled(this.ivButtonsActive && searcher != null);
        this.ivSwitchCritButton.setEnabled(this.ivButtonsActive && searcher != null);
        boolean fertig = this.ivTopNode.isFullyDefined();
        this.ivSaveDefButton.setEnabled(fertig);
        if (this.ivAssistant.ivButton.getActionCommand().equals("SEARCH")) {
            this.ivAssistant.ivButton.setEnabled(this.ivButtonsActive && fertig);
        } else {
            this.ivAssistant.ivButton.setEnabled(true);
        }
        this.ivSearchModeCombo.setEnabled(this.ivButtonsActive);
    }

    private void setTree(SDNode nodeToSelect) {
        this.ivTree.setModel(new DefaultTreeModel(this.ivTopNode));
        this.expandTree(this.ivTopNode, null);
        this.selectNode(nodeToSelect);
        this.ivTree.repaint();
        this.checkButtons();
    }

    private void selectNode(SDNode node) {
        if (node != null) {
            Vector<SDNode> v = new Vector<SDNode>();
            while (node != null) {
                v.insertElementAt(node, 0);
                node = (SDNode)node.getParent();
            }
            TreePath path = new TreePath(v.elementAt(0));
            if (v.size() > 1) {
                int i = 1;
                while (i < v.size()) {
                    path = path.pathByAddingChild(v.elementAt(i));
                    ++i;
                }
            }
            this.ivTree.setSelectionPath(path);
            this.ivTree.scrollPathToVisible(path);
        }
    }

    private void expandTree(Object oo, TreePath otp) {
        TreePath tp = null;
        tp = otp == null ? new TreePath(oo) : otp.pathByAddingChild(oo);
        if (!this.ivTree.isExpanded(tp)) {
            this.ivTree.expandPath(tp);
        }
        int tns = this.ivTree.getModel().getChildCount(oo);
        int i = 0;
        while (i < tns) {
            this.expandTree(this.ivTree.getModel().getChild(oo, i), tp);
            ++i;
        }
    }

    public void layoutContainer(Container arg0) {
        Dimension d = arg0.getSize();
        int iw = d.width - 2 * UIDef.RAND;
        int ih = d.height - 2 * UIDef.RAND;
        int x = UIDef.RAND;
        int y = UIDef.RAND;
        this.ivSettingsPanel.setBounds(x, y, LIST_WIDTH, DEF_TAB_HEIGHT);
        int lastExtra = 5;
        int obh = (DEF_TAB_HEIGHT - lastExtra - 11 * UIDef.INNER_RAND) / 12;
        int ubh = DEF_TAB_HEIGHT - lastExtra - 11 * (obh + UIDef.INNER_RAND);
        this.ivNewGroupButton.setBounds(x += LIST_WIDTH + UIDef.INNER_RAND, y, BUT_WIDTH, obh);
        this.ivSwitchGroupButton.setBounds(x, y += obh + UIDef.INNER_RAND, BUT_WIDTH, obh);
        this.ivDeleteGroupButton.setBounds(x, y += obh + UIDef.INNER_RAND, BUT_WIDTH, obh);
        this.ivNewCritButton.setBounds(x, y += obh + UIDef.INNER_RAND, BUT_WIDTH, obh);
        this.ivEditCritButton.setBounds(x, y += obh + UIDef.INNER_RAND, BUT_WIDTH, obh);
        this.ivDeleteCritButton.setBounds(x, y += obh + UIDef.INNER_RAND, BUT_WIDTH, obh);
        this.ivSwitchCritButton.setBounds(x, y += obh + UIDef.INNER_RAND, BUT_WIDTH, obh);
        this.ivClearDefButton.setBounds(x, y += obh + UIDef.INNER_RAND, BUT_WIDTH, obh);
        this.ivSaveDefButton.setBounds(x, y += obh + UIDef.INNER_RAND, BUT_WIDTH, obh);
        this.ivLoadDefButton.setBounds(x, y += obh + UIDef.INNER_RAND, BUT_WIDTH, obh);
        this.ivDeletedDefButton.setBounds(x, y += obh + UIDef.INNER_RAND, BUT_WIDTH, obh);
        this.ivAssistant.ivButton.setBounds(x, y += obh + UIDef.INNER_RAND, BUT_WIDTH, ubh + lastExtra);
        y += ubh;
        y = UIDef.RAND;
        int detw = iw - BUT_WIDTH - UIDef.INNER_RAND - LIST_WIDTH - UIDef.INNER_RAND;
        this.ivTreePanel.setBounds(x += BUT_WIDTH + UIDef.INNER_RAND, y, detw, DEF_TAB_HEIGHT);
        x += detw + UIDef.INNER_RAND;
        x = UIDef.RAND;
        y = UIDef.RAND + DEF_TAB_HEIGHT + UIDef.INNER_RAND;
        int uh = ih - DEF_TAB_HEIGHT - UIDef.INNER_RAND;
        this.ivDocPanel.setBounds(x, y, iw, uh);
    }
}

