/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.search.profisearch.panels;

import de.hannse.netobjects.user.UserManager;
import de.hannse.netobjects.util.Babel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import mausoleum.gui.MGButton;
import mausoleum.gui.RequesterPane;
import mausoleum.helper.FontManager;
import mausoleum.helper.WindowUtils;
import mausoleum.search.SearchAssistant;
import mausoleum.search.SearchResponder;
import mausoleum.search.extendedsearch.XSLineDatabase;
import mausoleum.search.profisearch.basic.SDGrouper;
import mausoleum.search.profisearch.panels.ProSearchSettings;
import mausoleum.search.profisearch.searcher.ProfiSearchObject;
import mausoleum.ui.UIDef;
import mausoleum.util.GeneralSetting;

public abstract class ProSearchPanel
extends RequesterPane
implements ActionListener,
LayoutManager,
ListCellRenderer,
SearchResponder {
    private static final long serialVersionUID = 1513L;
    public static final int BUT_WIDTH = UIDef.getScaled(180);
    public static final int LIST_WIDTH = UIDef.getScaled(160);
    public static final Color COL_GROUP = new Color(250, 220, 220);
    public static final Color COL_CRIT = new Color(220, 250, 220);
    public static final Color COL_DEF = new Color(220, 220, 250);
    public static final Color COL_SEARCH = new Color(240, 240, 220);
    public final SearchAssistant ivAssistant;
    public JComboBox ivSearchModeCombo = new JComboBox<String>(XSLineDatabase.getModeComboArray());
    public JPanel ivDocPanel = new JPanel(new BorderLayout());
    public JList ivSettingsList = new JList();
    public JScrollPane ivSettingsPane = new JScrollPane(this.ivSettingsList);
    public JPanel ivSettingsPanel = new JPanel(new BorderLayout());
    public MGButton ivNewCritButton = new MGButton(Babel.get("FST_NEW_CRIT"));
    public MGButton ivEditCritButton = new MGButton(Babel.get("FST_EDIT_CRIT"));
    public MGButton ivDeleteCritButton = new MGButton(Babel.get("FST_DELETE_CRIT"));
    public MGButton ivClearDefButton = new MGButton(Babel.get("FST_CLEAR_DEF"));
    public MGButton ivSaveDefButton = new MGButton(Babel.get("FST_SAVE_DEF"));
    public MGButton ivLoadDefButton = new MGButton(Babel.get("FST_LOAD_DEF"));
    public MGButton ivDeletedDefButton = new MGButton(Babel.get("FST_DELETE_DEF"));
    private JLabel ivListLabel = new JLabel();
    protected boolean ivButtonsActive = true;

    public ProSearchPanel() {
        super(null);
        super.setLayout(this);
        this.ivAssistant = new SearchAssistant(this);
        this.ivListLabel.setBackground(UIDef.SELECTED_BACKGROUND);
        this.ivSettingsList.setSelectionMode(0);
        this.ivSettingsList.setCellRenderer(this);
        this.ivSettingsList.setListData(ProSearchSettings.getSettings(this.getSettingsMode()));
        this.ivSettingsList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent arg0) {
                boolean sel = ProSearchPanel.this.ivSettingsList.getSelectedIndex() != -1;
                ProSearchPanel.this.ivDeletedDefButton.setEnabled(sel);
                ProSearchPanel.this.ivLoadDefButton.setEnabled(sel);
            }
        });
        this.ivSettingsList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && ProSearchPanel.this.ivLoadDefButton != null && ProSearchPanel.this.ivLoadDefButton.isEnabled()) {
                    ProSearchPanel.this.ivAssistant.clearIt();
                    ProSearchPanel.this.loadDefinition();
                }
            }
        });
        this.ivSettingsPanel.setOpaque(false);
        this.ivSettingsPanel.add("Center", this.ivSettingsPane);
        this.ivSettingsPanel.setBorder(UIDef.getTitleBorder("FST_STORED_DEFINITIONS"));
        this.add(this.ivSettingsPanel);
        this.ivNewCritButton.setImage("yellowButton");
        this.ivEditCritButton.setImage("yellowButton");
        this.ivDeleteCritButton.setImage("yellowButton");
        this.ivClearDefButton.setImage("blueButton");
        this.ivSaveDefButton.setImage("blueButton");
        this.ivLoadDefButton.setImage("blueButton");
        this.ivDeletedDefButton.setImage("blueButton");
        this.ivAssistant.ivButton.addActionListener(this);
        this.ivNewCritButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                ProSearchPanel.this.newCrit();
            }
        });
        this.add(this.ivNewCritButton);
        this.ivEditCritButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                ProSearchPanel.this.editCrit();
            }
        });
        this.add(this.ivEditCritButton);
        this.ivDeleteCritButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                ProSearchPanel.this.deleteCrit();
            }
        });
        this.add(this.ivDeleteCritButton);
        this.ivSaveDefButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                ProSearchPanel.this.saveIt();
            }
        });
        this.add(this.ivSaveDefButton);
        this.ivLoadDefButton.setEnabled(false);
        this.ivLoadDefButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                ProSearchPanel.this.ivAssistant.clearIt();
                ProSearchPanel.this.loadDefinition();
            }
        });
        this.add(this.ivLoadDefButton);
        this.ivDeletedDefButton.setEnabled(false);
        this.ivDeletedDefButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                ProSearchPanel.this.removeIt();
            }
        });
        this.add(this.ivDeletedDefButton);
        this.add(this.ivAssistant.ivButton);
        this.ivDocPanel.add("Center", this.ivAssistant.getChangingPanel());
        this.ivDocPanel.setOpaque(false);
        this.ivDocPanel.setBorder(UIDef.getTitleBorder("FST_LAST_SEARCH_RESULT"));
        this.add(this.ivDocPanel);
    }

    public abstract SDGrouper getTopNode();

    public abstract void newCrit();

    public abstract void editCrit();

    public abstract void deleteCrit();

    public abstract void checkButtons();

    public abstract void loadDefinition();

    public abstract String getSettingsMode();

    public void removeIt() {
        GeneralSetting ss = (GeneralSetting)this.ivSettingsList.getSelectedValue();
        if (ss != null) {
            ProSearchSettings.deleteSetting(this.getSettingsMode(), ss);
            this.ivSettingsList.setListData(ProSearchSettings.getSettings(this.getSettingsMode()));
            this.ivSettingsList.repaint();
        }
    }

    public void saveIt() {
        SDGrouper topNode = this.getTopNode();
        if (topNode != null) {
            ProSearchSettings.saveAktSetting(this.getSettingsMode(), WindowUtils.getJFrame(this), topNode.getXML(0));
            this.ivSettingsList.setListData(ProSearchSettings.getSettings(this.getSettingsMode()));
            this.ivSettingsList.repaint();
        }
    }

    public void actionPerformed(ActionEvent e) {
        String comm = e.getActionCommand();
        if (comm.equals("STOP")) {
            this.ivAssistant.stopIt();
        } else if (comm.equals("SEARCH")) {
            ProfiSearchObject pso = new ProfiSearchObject();
            pso.ivGroup = UserManager.getFirstGroup();
            SDGrouper topNode = this.getTopNode();
            pso.ivMode = topNode.ivMode;
            if (pso.wantsOnlyActualObjects()) {
                pso.ivRoot = topNode;
            } else {
                pso.ivXML = topNode.getXML(0);
            }
            this.ivAssistant.performSearch(pso);
        } else if (comm.equals("CLEAR")) {
            this.ivAssistant.clearIt();
        }
    }

    public Component getListCellRendererComponent(JList list, Object value, int row, boolean isSelected, boolean hasFocus) {
        Font font = FontManager.getTableFont(true, true, 1.0);
        GeneralSetting ss = (GeneralSetting)value;
        this.ivListLabel.setText(" " + ss.ivName + " ");
        this.ivListLabel.setFont(font);
        this.ivListLabel.setOpaque(isSelected);
        return this.ivListLabel;
    }

    public void addLayoutComponent(String arg0, Component arg1) {
    }

    public Dimension minimumLayoutSize(Container arg0) {
        return UIDef.MINI_DIM;
    }

    public Dimension preferredLayoutSize(Container arg0) {
        return UIDef.MINI_DIM;
    }

    public void removeLayoutComponent(Component arg0) {
    }

    public void searchWillStart() {
        this.ivButtonsActive = false;
        this.checkButtons();
    }

    public void searchWasStopped() {
        this.checkButtons();
    }

    public void searchWasFinished() {
        this.checkButtons();
    }

    public void tableWasCleared() {
        this.ivButtonsActive = true;
        this.checkButtons();
    }
}

