/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.search.profisearch.panels;

import de.hannse.netobjects.util.Babel;
import de.hannse.netobjects.util.XMLNode;
import de.hannse.netobjects.util.XMLParser;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import mausoleum.helper.WindowUtils;
import mausoleum.search.extendedsearch.XSLineDatabase;
import mausoleum.search.profisearch.basic.SDGrouper;
import mausoleum.search.profisearch.basic.SDNode;
import mausoleum.search.profisearch.basic.SDSearcher;
import mausoleum.search.profisearch.display.SDSearcherEditDialog;
import mausoleum.search.profisearch.panels.ProSearchPanel;
import mausoleum.search.profisearch.panels.ProSimpleSearchTable;
import mausoleum.ui.UIDef;
import mausoleum.util.GeneralSetting;

public class ProSimpleSearchPanel
extends ProSearchPanel
implements ListCellRenderer {
    private static final long serialVersionUID = 1482483348L;
    private static final int DEF_TAB_HEIGHT = UIDef.getScaled(210);
    private static final int ANZ_BUTS = 8;
    private static final String[] AND_OR = new String[]{Babel.get("FTS_ALL_AND"), Babel.get("FTS_ALL_OR")};
    private static DefaultComboBoxModel LEER_COMBO = new DefaultComboBoxModel();
    private static DefaultComboBoxModel VOLL_COMBO = new DefaultComboBoxModel<String>(AND_OR);
    private static final int AND_IND = 0;
    private static final int OR_IND = 1;
    private ProSimpleSearchTable ivDefTable = new ProSimpleSearchTable();
    private JScrollPane ivDefPane = new JScrollPane(this.ivDefTable);
    private JPanel ivDefPanel = new JPanel(new BorderLayout());
    private JComboBox ivAndOrCombo = new JComboBox(LEER_COMBO);

    public ProSimpleSearchPanel() {
        this.ivDefTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent arg0) {
                if (!arg0.getValueIsAdjusting()) {
                    ProSimpleSearchPanel.this.checkButtons();
                }
            }
        });
        this.ivDefTable.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && ProSimpleSearchPanel.this.ivEditCritButton != null && ProSimpleSearchPanel.this.ivEditCritButton.isEnabled()) {
                    ProSimpleSearchPanel.this.editCrit();
                }
            }
        });
        this.ivDefPanel.add("Center", this.ivDefPane);
        this.ivAndOrCombo.setEnabled(false);
        this.ivDefPanel.add("South", this.ivAndOrCombo);
        this.ivDefPanel.add("North", this.ivSearchModeCombo);
        this.ivDefPanel.setOpaque(false);
        this.ivDefPanel.setBorder(UIDef.getTitleBorder("FST_ACT_DEFINITION"));
        this.add(this.ivDefPanel);
        this.ivClearDefButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                ProSimpleSearchPanel.this.ivAssistant.clearIt();
                ProSimpleSearchPanel.this.ivDefTable.setObjects(new Vector());
                ProSimpleSearchPanel.this.checkButtons();
            }
        });
        this.add(this.ivClearDefButton);
        this.checkButtons();
    }

    public void newCrit() {
        SDSearcher searcher = SDSearcherEditDialog.editSearcher(null, WindowUtils.getJFrame(this));
        if (searcher != null) {
            Vector<SDSearcher> v = new Vector<SDSearcher>();
            v.addAll(this.ivDefTable.ivObjects);
            v.add(searcher);
            this.ivDefTable.setObjects(v);
            this.checkButtons();
        }
    }

    public void editCrit() {
        int selRow = this.ivDefTable.getSelectedRow();
        if (selRow >= 0 && selRow < this.ivDefTable.ivObjects.size()) {
            SDSearcher searcher = (SDSearcher)this.ivDefTable.getObjectAtRow(selRow);
            if ((searcher = SDSearcherEditDialog.editSearcher(searcher, WindowUtils.getJFrame(this))) != null) {
                Vector<SDSearcher> v = new Vector<SDSearcher>();
                v.addAll(this.ivDefTable.ivObjects);
                v.setElementAt(searcher, selRow);
                this.ivDefTable.setObjects(v);
                this.checkButtons();
            }
        }
    }

    public void deleteCrit() {
        int selRow = this.ivDefTable.getSelectedRow();
        if (selRow >= 0 && selRow < this.ivDefTable.ivObjects.size()) {
            Vector v = new Vector();
            v.addAll(this.ivDefTable.ivObjects);
            v.removeElementAt(selRow);
            this.ivDefTable.setObjects(v);
            this.checkButtons();
        }
    }

    public void loadDefinition() {
        XMLNode node;
        SDNode topNode;
        GeneralSetting ss = (GeneralSetting)this.ivSettingsList.getSelectedValue();
        if (ss != null && (topNode = SDNode.initFromNode(node = XMLParser.parseXMLString(ss.ivPayload))) instanceof SDGrouper) {
            this.ivAssistant.clearIt();
            SDGrouper grouper = (SDGrouper)topNode;
            this.ivAndOrCombo.setModel(VOLL_COMBO);
            this.ivAndOrCombo.setSelectedIndex(grouper.isAnd() ? 0 : 1);
            int smInd = 0;
            int i = 0;
            while (i < XSLineDatabase.MODE_ARRAY.length) {
                if (grouper.ivMode == XSLineDatabase.MODE_ARRAY[i]) {
                    smInd = i;
                }
                ++i;
            }
            this.ivSearchModeCombo.setSelectedIndex(smInd);
            Vector subs = new Vector(topNode.getChildCount());
            if (topNode.getChildCount() > 0) {
                Enumeration en = topNode.children();
                while (en.hasMoreElements()) {
                    subs.add(en.nextElement());
                }
            }
            this.ivDefTable.setObjects(subs);
            this.checkButtons(true);
        }
    }

    public SDGrouper getTopNode() {
        SDGrouper topNode = null;
        if (!this.ivAndOrCombo.isEnabled() || this.ivAndOrCombo.getSelectedIndex() == 0) {
            topNode = new SDGrouper(true);
        } else if (this.ivAndOrCombo.getSelectedIndex() == 1) {
            topNode = new SDGrouper(false);
        }
        if (topNode != null) {
            Iterator iterator = this.ivDefTable.ivObjects.iterator();
            while (iterator.hasNext()) {
                SDSearcher searcher = (SDSearcher)iterator.next();
                topNode.addKid(searcher);
            }
            topNode.ivMode = XSLineDatabase.MODE_ARRAY[this.ivSearchModeCombo.getSelectedIndex()];
        }
        return topNode;
    }

    public String getSettingsMode() {
        return "SIMPLE";
    }

    public void checkButtons() {
        this.checkButtons(false);
    }

    private void checkButtons(boolean forceCombo) {
        this.ivDefTable.setEnabled(this.ivButtonsActive);
        this.ivNewCritButton.setEnabled(this.ivButtonsActive);
        this.ivClearDefButton.setEnabled(this.ivDefTable.getRowCount() != 0);
        int selRow = this.ivDefTable.getSelectedRow();
        this.ivEditCritButton.setEnabled(this.ivButtonsActive && selRow != -1);
        this.ivDeleteCritButton.setEnabled(this.ivButtonsActive && selRow != -1);
        boolean fertig = false;
        if (this.ivDefTable.ivObjects != null && !this.ivDefTable.ivObjects.isEmpty()) {
            fertig = true;
            Iterator iterator = this.ivDefTable.ivObjects.iterator();
            while (iterator.hasNext()) {
                SDSearcher searcher = (SDSearcher)iterator.next();
                if (searcher.isFullyDefined()) continue;
                fertig = false;
            }
        }
        this.ivSaveDefButton.setEnabled(fertig);
        if (this.ivAssistant.ivButton.getActionCommand().equals("SEARCH")) {
            this.ivAssistant.ivButton.setEnabled(this.ivButtonsActive && fertig);
        } else {
            this.ivAssistant.ivButton.setEnabled(true);
        }
        if (this.ivButtonsActive) {
            boolean combodrin;
            boolean bl = combodrin = fertig && this.ivDefTable.ivObjects != null && this.ivDefTable.ivObjects.size() > 1;
            if (forceCombo || combodrin != this.ivAndOrCombo.isEnabled()) {
                this.ivAndOrCombo.setModel(combodrin ? VOLL_COMBO : LEER_COMBO);
                this.ivAndOrCombo.setEnabled(combodrin);
            }
        } else {
            this.ivAndOrCombo.setEnabled(false);
        }
        this.ivSearchModeCombo.setEnabled(this.ivButtonsActive);
    }

    public void layoutContainer(Container arg0) {
        Dimension d = arg0.getSize();
        int iw = d.width - 2 * UIDef.RAND;
        int ih = d.height - 2 * UIDef.RAND;
        int x = UIDef.RAND;
        int y = UIDef.RAND;
        this.ivSettingsPanel.setBounds(x, y, LIST_WIDTH, DEF_TAB_HEIGHT);
        int obh = (DEF_TAB_HEIGHT - 7 * UIDef.INNER_RAND) / 8;
        int ubh = DEF_TAB_HEIGHT - 7 * (obh + UIDef.INNER_RAND);
        this.ivNewCritButton.setBounds(x += LIST_WIDTH + UIDef.INNER_RAND, y, BUT_WIDTH, obh);
        this.ivEditCritButton.setBounds(x, y += obh + UIDef.INNER_RAND, BUT_WIDTH, obh);
        this.ivDeleteCritButton.setBounds(x, y += obh + UIDef.INNER_RAND, BUT_WIDTH, obh);
        this.ivClearDefButton.setBounds(x, y += obh + UIDef.INNER_RAND, BUT_WIDTH, obh);
        this.ivSaveDefButton.setBounds(x, y += obh + UIDef.INNER_RAND, BUT_WIDTH, obh);
        this.ivLoadDefButton.setBounds(x, y += obh + UIDef.INNER_RAND, BUT_WIDTH, obh);
        this.ivDeletedDefButton.setBounds(x, y += obh + UIDef.INNER_RAND, BUT_WIDTH, obh);
        this.ivAssistant.ivButton.setBounds(x, y += obh + UIDef.INNER_RAND, BUT_WIDTH, ubh);
        y += ubh;
        y = UIDef.RAND;
        int detw = iw - BUT_WIDTH - UIDef.INNER_RAND - LIST_WIDTH - UIDef.INNER_RAND;
        this.ivDefPanel.setBounds(x += BUT_WIDTH + UIDef.INNER_RAND, y, detw, DEF_TAB_HEIGHT);
        x += detw + UIDef.INNER_RAND;
        x = UIDef.RAND;
        y = UIDef.RAND + DEF_TAB_HEIGHT + UIDef.INNER_RAND;
        int uh = ih - DEF_TAB_HEIGHT - UIDef.INNER_RAND;
        this.ivDocPanel.setBounds(x, y, iw, uh);
    }
}

