/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.search.profisearch.searcher;

import de.hannse.netobjects.tools.StringHelper;
import de.hannse.netobjects.util.Babel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.LineBorder;
import mausoleum.experiment.Experiment;
import mausoleum.gui.KomfortTextField;
import mausoleum.gui.MGButton;
import mausoleum.gui.documents.DoubleDocument;
import mausoleum.gui.documents.IntegerDocument;
import mausoleum.helper.FontManager;
import mausoleum.requester.std.MausoOptionPane;
import mausoleum.ui.UIDef;

public class ExpSearchPanel
extends JPanel {
    private static final long serialVersionUID = 32341L;
    private static final int MODE_NUR_NAME = 1;
    private static final int MODE_NAME_UND_COMBO = 2;
    private static final int MODE_ALLES = 3;
    private static final int BUT_WIDTH = UIDef.LINE_HEIGHT;
    private static final String[] SPEC_BABELS = new String[]{Babel.get("SD_QUAL_SET"), Babel.get("SD_SPECIFIC")};
    private static final Dimension DIM = new Dimension(UIDef.getScaled(200), 3 * UIDef.LINE_HEIGHT + 2 * UIDef.INNER_RAND);
    private Vector ivIDObjects = null;
    private int ivDisplayMode = 1;
    private JComboBox ivNameCombo = null;
    private JComboBox ivSpecCombo = new JComboBox<String>(SPEC_BABELS);
    private JLabel ivSpecField = new JLabel();
    private MGButton ivSpecButton = new MGButton("...");
    private Experiment ivExperiment = null;
    private Object ivSpecObject = null;
    private String ivSpecString = null;

    public ExpSearchPanel(JComboBox nameCombo, Vector idObjects) {
        this.setLayout(new LayoutManager(){

            public void removeLayoutComponent(Component arg0) {
            }

            public Dimension preferredLayoutSize(Container arg0) {
                return DIM;
            }

            public Dimension minimumLayoutSize(Container arg0) {
                return DIM;
            }

            public void layoutContainer(Container arg0) {
                Dimension d = arg0.getSize();
                if (ExpSearchPanel.this.ivDisplayMode == 1) {
                    ExpSearchPanel.this.ivNameCombo.setBounds(0, 0, d.width, UIDef.LINE_HEIGHT);
                } else if (ExpSearchPanel.this.ivDisplayMode == 2) {
                    int y = 0;
                    ExpSearchPanel.this.ivNameCombo.setBounds(0, y, d.width, UIDef.LINE_HEIGHT);
                    ExpSearchPanel.this.ivSpecCombo.setBounds(0, y += UIDef.LINE_HEIGHT + UIDef.INNER_RAND, d.width, UIDef.LINE_HEIGHT);
                } else {
                    int y = 0;
                    ExpSearchPanel.this.ivNameCombo.setBounds(0, y, d.width, UIDef.LINE_HEIGHT);
                    ExpSearchPanel.this.ivSpecCombo.setBounds(0, y += UIDef.LINE_HEIGHT + UIDef.INNER_RAND, d.width, UIDef.LINE_HEIGHT);
                    ExpSearchPanel.this.ivSpecField.setBounds(0, y += UIDef.LINE_HEIGHT + UIDef.INNER_RAND, d.width - BUT_WIDTH, UIDef.LINE_HEIGHT);
                    ExpSearchPanel.this.ivSpecButton.setBounds(d.width - BUT_WIDTH, y, BUT_WIDTH, UIDef.LINE_HEIGHT);
                }
            }

            public void addLayoutComponent(String arg0, Component arg1) {
            }
        });
        this.ivIDObjects = idObjects;
        this.ivNameCombo = nameCombo;
        this.add(this.ivNameCombo);
        this.ivNameCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                ExpSearchPanel.this.ivExperiment = null;
                int ind = ExpSearchPanel.this.ivNameCombo.getSelectedIndex();
                if (ind != -1 && ExpSearchPanel.this.ivIDObjects != null && ind < ExpSearchPanel.this.ivIDObjects.size()) {
                    ExpSearchPanel.this.ivExperiment = (Experiment)ExpSearchPanel.this.ivIDObjects.elementAt(ind);
                }
                ExpSearchPanel.this.ivSpecCombo.setSelectedIndex(0);
                ExpSearchPanel.this.setToMode(ExpSearchPanel.hasSpecifiables(ExpSearchPanel.this.ivExperiment) ? 2 : 1);
            }
        });
        this.ivSpecCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                ExpSearchPanel.this.setToMode(ExpSearchPanel.this.ivSpecCombo.getSelectedIndex() > 0 ? 3 : 2);
            }
        });
        this.ivSpecButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                if (ExpSearchPanel.this.ivExperiment != null) {
                    String s;
                    int type = ExpSearchPanel.this.ivExperiment.getInt("EXP_TYPE", -1);
                    if (type == 1) {
                        JComboBox<String> boolCombo = new JComboBox<String>(new String[]{ExpSearchPanel.getBoolRep(true), ExpSearchPanel.getBoolRep(false)});
                        boolCombo.setPreferredSize(new Dimension(UIDef.getScaled(150), UIDef.LINE_HEIGHT));
                        if (ExpSearchPanel.this.ivSpecObject != null && ExpSearchPanel.this.ivSpecObject instanceof Boolean) {
                            Boolean booli = (Boolean)ExpSearchPanel.this.ivSpecObject;
                            boolCombo.setSelectedIndex(booli != false ? 0 : 1);
                        }
                        if (MausoOptionPane.showOptionPane(ExpSearchPanel.this.ivSpecButton, boolCombo, MausoOptionPane.MODE_OK_AND_NO, Babel.get("ENTERVALUE"))) {
                            ExpSearchPanel.this.ivSpecObject = new Boolean(boolCombo.getSelectedIndex() == 0);
                            ExpSearchPanel.this.createTexts();
                        }
                    } else if (type == 2) {
                        JPanel pan = new JPanel(new GridLayout(2, 2, UIDef.INNER_RAND, UIDef.INNER_RAND));
                        pan.setOpaque(false);
                        pan.add(new JLabel(Babel.get("SD_TITEL_LOWER")));
                        KomfortTextField ltf = new KomfortTextField();
                        ltf.setDocument(new IntegerDocument(ltf));
                        ltf.setFont(FontManager.getFont("SSB12"));
                        pan.add(ltf);
                        pan.add(new JLabel(Babel.get("SD_TITEL_UPPER")));
                        KomfortTextField utf = new KomfortTextField();
                        utf.setDocument(new IntegerDocument(ltf));
                        utf.setFont(FontManager.getFont("SSB12"));
                        pan.add(utf);
                        if (ExpSearchPanel.this.ivSpecObject != null) {
                            if (ExpSearchPanel.this.ivSpecObject instanceof Integer) {
                                ltf.setText(ExpSearchPanel.getRepresentation(ExpSearchPanel.this.ivSpecObject));
                            } else if (ExpSearchPanel.this.ivSpecObject instanceof int[]) {
                                int[] arr = (int[])ExpSearchPanel.this.ivSpecObject;
                                ltf.setText(ExpSearchPanel.getRepresentation(new Integer(arr[0])));
                                utf.setText(ExpSearchPanel.getRepresentation(new Integer(arr[1])));
                            }
                        }
                        if (MausoOptionPane.showOptionPane(ExpSearchPanel.this.ivSpecButton, pan, MausoOptionPane.MODE_OK_AND_NO, Babel.get("ENTERVALUE"), utf, null, null)) {
                            String ls = ltf.getText();
                            String us = utf.getText();
                            if (ls.length() != 0) {
                                if (us.length() == 0 || ls.equals(us)) {
                                    ExpSearchPanel.this.ivSpecObject = new Integer(ls);
                                } else {
                                    int ud;
                                    int ld = Integer.parseInt(ls);
                                    if (ld > (ud = Integer.parseInt(us))) {
                                        int t = ld;
                                        ld = ud;
                                        ud = t;
                                    }
                                    ExpSearchPanel.this.ivSpecObject = new int[]{ld, ud};
                                }
                                ExpSearchPanel.this.createTexts();
                            }
                        }
                    } else if (type == 3) {
                        JPanel pan = new JPanel(new GridLayout(2, 2, UIDef.INNER_RAND, UIDef.INNER_RAND));
                        pan.setOpaque(false);
                        pan.add(new JLabel(Babel.get("SD_TITEL_LOWER")));
                        KomfortTextField ltf = new KomfortTextField();
                        ltf.setDocument(new DoubleDocument(ltf));
                        ltf.setFont(FontManager.getFont("SSB12"));
                        pan.add(ltf);
                        pan.add(new JLabel(Babel.get("SD_TITEL_UPPER")));
                        KomfortTextField utf = new KomfortTextField();
                        utf.setDocument(new DoubleDocument(ltf));
                        utf.setFont(FontManager.getFont("SSB12"));
                        pan.add(utf);
                        if (ExpSearchPanel.this.ivSpecObject != null) {
                            if (ExpSearchPanel.this.ivSpecObject instanceof Double) {
                                ltf.setText(ExpSearchPanel.getRepresentation(ExpSearchPanel.this.ivSpecObject));
                            } else if (ExpSearchPanel.this.ivSpecObject instanceof double[]) {
                                double[] arr = (double[])ExpSearchPanel.this.ivSpecObject;
                                ltf.setText(ExpSearchPanel.getRepresentation(new Double(arr[0])));
                                utf.setText(ExpSearchPanel.getRepresentation(new Double(arr[1])));
                            }
                        }
                        if (MausoOptionPane.showOptionPane(ExpSearchPanel.this.ivSpecButton, pan, MausoOptionPane.MODE_OK_AND_NO, Babel.get("ENTERVALUE"), utf, null, null)) {
                            String ls = ltf.getText();
                            String us = utf.getText();
                            if (ls.length() != 0) {
                                if (us.length() == 0 || ls.equals(us)) {
                                    ExpSearchPanel.this.ivSpecObject = new Double(StringHelper.gSub(ls, ",", "."));
                                } else {
                                    double ud;
                                    double ld = Double.parseDouble(StringHelper.gSub(ls, ",", "."));
                                    if (ld > (ud = Double.parseDouble(StringHelper.gSub(us, ",", ".")))) {
                                        double t = ld;
                                        ld = ud;
                                        ud = t;
                                    }
                                    ExpSearchPanel.this.ivSpecObject = new double[]{ld, ud};
                                }
                                ExpSearchPanel.this.createTexts();
                            }
                        }
                    } else if (type == 4) {
                        Object[] oarr = (Object[])ExpSearchPanel.this.ivExperiment.get("EXP_POSV");
                        if (oarr != null && oarr.length != 0) {
                            String[] sarr = new String[oarr.length];
                            int i = 0;
                            while (i < sarr.length) {
                                sarr[i] = (String)oarr[i];
                                ++i;
                            }
                            String s2 = MausoOptionPane.select(sarr, ExpSearchPanel.this.ivSpecObject, ExpSearchPanel.this.ivSpecButton, Babel.get("ENTERVALUE"), null);
                            if (s2 != null) {
                                ExpSearchPanel.this.ivSpecObject = s2;
                                ExpSearchPanel.this.createTexts();
                            }
                        }
                    } else if (type == 5 && (s = MausoOptionPane.typeIn(ExpSearchPanel.this.ivSpecString, ExpSearchPanel.this.ivSpecButton, Babel.get("ENTERVALUE"), null)) != null) {
                        ExpSearchPanel.this.ivSpecObject = s;
                        ExpSearchPanel.this.createTexts();
                    }
                }
            }
        });
        this.ivSpecField.setBorder(new LineBorder(Color.black));
        this.ivNameCombo.setSelectedIndex(0);
        this.setOpaque(false);
    }

    public Object getExpID() {
        return this.ivExperiment != null ? this.ivExperiment.get("IDO_ID") : null;
    }

    public Object getSpecificator() {
        return this.ivSpecObject;
    }

    public void adapt(int expInd, Object specificator) {
        this.ivNameCombo.setSelectedIndex(expInd);
        this.ivSpecCombo.setSelectedIndex(specificator != null ? 1 : 0);
        this.ivSpecObject = specificator;
        this.createTexts();
    }

    private void setToMode(int mode) {
        boolean changed = false;
        if (mode == 1) {
            if (this.ivDisplayMode == 2) {
                this.remove(this.ivSpecCombo);
                changed = true;
            } else if (this.ivDisplayMode == 3) {
                this.remove(this.ivSpecCombo);
                this.remove(this.ivSpecField);
                this.ivSpecField.setText("");
                this.remove(this.ivSpecButton);
                changed = true;
            }
        } else if (mode == 2) {
            if (this.ivDisplayMode == 1) {
                this.add(this.ivSpecCombo);
                changed = true;
            } else if (this.ivDisplayMode == 3) {
                this.remove(this.ivSpecField);
                this.ivSpecField.setText("");
                this.remove(this.ivSpecButton);
                changed = true;
            }
        } else if (mode == 3) {
            if (this.ivDisplayMode == 1) {
                this.add(this.ivSpecCombo);
                this.add(this.ivSpecField);
                this.ivSpecField.setText("");
                this.add(this.ivSpecButton);
                changed = true;
            } else if (this.ivDisplayMode == 2) {
                this.add(this.ivSpecField);
                this.ivSpecField.setText("");
                this.add(this.ivSpecButton);
                changed = true;
            }
        }
        if (changed) {
            this.ivDisplayMode = mode;
            this.validate();
            this.repaint();
            this.ivSpecObject = null;
            this.ivSpecString = null;
        }
    }

    private static final boolean hasSpecifiables(Experiment exp) {
        if (exp != null) {
            switch (exp.getInt("EXP_TYPE", -1)) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    return true;
                }
            }
        }
        return false;
    }

    public static String getRepresentation(Object specObject) {
        if (specObject != null) {
            if (specObject instanceof Boolean) {
                Boolean booli = (Boolean)specObject;
                return ExpSearchPanel.getBoolRep(booli);
            }
            if (specObject instanceof Integer) {
                Integer inti = (Integer)specObject;
                return inti.toString();
            }
            if (specObject instanceof int[]) {
                int[] arr = (int[])specObject;
                return String.valueOf(arr[0]) + " - " + arr[1];
            }
            if (specObject instanceof Double) {
                Double doubli = (Double)specObject;
                return StringHelper.gSub(doubli.toString(), ".", KomfortTextField.cvDecTrennerString);
            }
            if (specObject instanceof double[]) {
                double[] arr = (double[])specObject;
                return String.valueOf(StringHelper.gSub(Double.toString(arr[0]), ".", KomfortTextField.cvDecTrennerString)) + " - " + StringHelper.gSub(Double.toString(arr[1]), ".", KomfortTextField.cvDecTrennerString);
            }
            if (specObject instanceof String) {
                return (String)specObject;
            }
        }
        return "";
    }

    private void createTexts() {
        this.ivSpecString = ExpSearchPanel.getRepresentation(this.ivSpecObject);
        this.ivSpecField.setText(" " + this.ivSpecString.trim() + " ");
    }

    private static String getBoolRep(boolean val) {
        return val ? " \"" + Babel.get("TRUE") + "\" " : " \"" + Babel.get("FALSE") + "\" ";
    }
}

