/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.search.profisearch.searcher;

import de.hannse.netobjects.datalayer.DataLayer;
import de.hannse.netobjects.datalayer.dfa.IntermediaerHelfer;
import de.hannse.netobjects.objectstore.IDObject;
import de.hannse.netobjects.objectstore.IDObjectXMLHandler;
import de.hannse.netobjects.objectstore.IndexObject;
import de.hannse.netobjects.objectstore.NULLObject;
import de.hannse.netobjects.objectstore.ObjectStore;
import de.hannse.netobjects.user.UserManager;
import de.hannse.netobjects.util.ArrayHelper;
import de.hannse.netobjects.util.Babel;
import de.hannse.netobjects.util.XMLNode;
import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import mausoleum.experiment.Experiment;
import mausoleum.experiment.ExperimentManager;
import mausoleum.gui.MGButton;
import mausoleum.helper.ZeileAbstr;
import mausoleum.idobjectgroup.IDObjectGroupManager;
import mausoleum.license.LicenseManager;
import mausoleum.line.Line;
import mausoleum.line.LineManager;
import mausoleum.main.ProcessDefinition;
import mausoleum.mouse.Mouse;
import mausoleum.mouse.tierschutz.TierSchutz;
import mausoleum.requester.SelectIDObjectRequester;
import mausoleum.result.MResult;
import mausoleum.result.embryotransfer.EmbryoTransfer;
import mausoleum.result.embryotransfer.MResEmbryoTransfer;
import mausoleum.search.profisearch.basic.SDSearcher;
import mausoleum.search.profisearch.basic.SDSearcherOBJECT;
import mausoleum.search.profisearch.searcher.ExpSearchPanel;
import mausoleum.search.profisearch.searcher.MausoSearcherDate;
import mausoleum.strain.StrainManager;
import mausoleum.ui.UIDef;

public abstract class MausoSearcherIDObject
extends SDSearcherOBJECT {
    public Vector ivNames = null;
    public Vector ivValues = null;
    public Vector ivIDObjects = null;
    public JComponent[] ivCompArr = null;

    public static void init() {
        SDSearcher.register(new SearcherLine());
        SDSearcher.register(new SearcherStrain());
        SDSearcher.register(new SearcherLicense());
        SDSearcher.register(new SearcherOwner());
        SDSearcher.register(new SearcherCohort());
        SDSearcher.register(new SearcherResult());
        SDSearcher.register(new SearcherSymptomList());
        if (TierSchutz.isLineEvaluationPossible()) {
            SDSearcher.register(new SearcherWurfBeurteilung());
            SDSearcher.register(new SearcherAbsetzBeurteilung());
            SDSearcher.register(new SearcherEinzeltierBeurteilung());
        }
        if (EmbryoTransfer.useEmbryoTransfer()) {
            SDSearcher.register(new SearcherEmbryoTransfer());
        }
    }

    public void fillComponents(JComponent[] carr) {
        int sel;
        if (carr != null && carr.length >= 1 && carr[0] instanceof JComboBox && this.ivVal != null && (sel = this.ivValues.indexOf(this.ivVal)) != -1) {
            ((JComboBox)carr[0]).setSelectedIndex(sel);
        }
    }

    public void fillFromComponents(JComponent[] carr) {
        this.ivVal = null;
        if (carr != null && carr.length >= 1 && carr[0] instanceof JComboBox) {
            try {
                this.ivVal = this.ivValues.elementAt(((JComboBox)carr[0]).getSelectedIndex());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public JComponent[] getDialogComponent() {
        return this.needsObject() ? this.ivCompArr : null;
    }

    public void getValXML(StringBuilder msb) {
        if (this.needsObject() && this.ivVal != null) {
            msb.append(" ").append("val").append("=\"").append(this.ivVal).append("\"");
        }
    }

    public String getValueDisplay() {
        int sel;
        if (this.needsObject() && this.ivVal != null && (sel = this.ivValues.indexOf(this.ivVal)) != -1) {
            return "\"" + ((String)this.ivNames.elementAt(sel)).trim() + "\"";
        }
        return "";
    }

    public void iInit(XMLNode node) {
        String val = node.getAttributeValue("val", null);
        if (val != null) {
            this.ivVal = new Long(val);
        }
    }

    public void init(Vector idv, boolean withSelectBox) {
        if (idv != null && !idv.isEmpty()) {
            this.ivNames = new Vector();
            this.ivValues = new Vector();
            this.ivIDObjects = new Vector();
            Iterator iter = idv.iterator();
            while (iter.hasNext()) {
                IDObject ido = (IDObject)iter.next();
                this.ivNames.add(" " + ido.getBrowseNameInclServicePrefix() + " ");
                this.ivValues.add(ido.get("IDO_ID"));
                this.ivIDObjects.add(ido);
            }
            if (withSelectBox) {
                MGButton but = new MGButton("...");
                but.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        int ind;
                        IDObject ido = SelectIDObjectRequester.getSelectedIDObject(null, MausoSearcherIDObject.this.ivIDObjects, true);
                        if (ido != null && (ind = MausoSearcherIDObject.this.ivIDObjects.indexOf(ido)) != -1 && MausoSearcherIDObject.this.ivCompArr != null && MausoSearcherIDObject.this.ivCompArr[0] instanceof JComboBox) {
                            ((JComboBox)MausoSearcherIDObject.this.ivCompArr[0]).setSelectedIndex(ind);
                        }
                    }
                });
                this.ivCompArr = new JComponent[]{new JComboBox(this.ivNames), but};
            } else {
                this.ivCompArr = new JComponent[]{new JComboBox(this.ivNames)};
            }
        }
    }

    public boolean iiMatch(long[] arr) {
        long cval = (Long)this.ivVal;
        int i = 0;
        while (i < arr.length) {
            if (arr[i] == cval) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected int indexIMatch(String cont, String fs, String vs, String hs, String ms) {
        if (this.ivQual == 2) {
            return cont == null ? 1 : 2;
        }
        if (this.ivQual == 1) {
            return cont != null ? 1 : 2;
        }
        if (this.ivVal == null || cont == null) {
            return 3;
        }
        boolean res = false;
        if (cont != null) {
            boolean bl = res = cont.equals(fs) || cont.startsWith(vs) || cont.endsWith(hs) || cont.contains(ms);
        }
        if (this.ivQual == 3) {
            return res ? 1 : 2;
        }
        if (this.ivQual == 14) {
            return !res ? 1 : 2;
        }
        return 3;
    }

    public static class SearcherAbsetzBeurteilung
    extends SearcherSymptomList {
        protected long getExpID() {
            return -44L;
        }

        protected String getBabel() {
            return "TASK_TS_EVAL_D1_ABSETZBEURTEILUNG";
        }
    }

    public static class SearcherCohort
    extends MausoSearcherIDObject {
        public SearcherCohort() {
            if (ProcessDefinition.isClient()) {
                this.init(IDObjectGroupManager.cvInstance.getAllCohorts(), false);
            }
        }

        public void addWheres(Vector target, Vector columns) {
            String col = "MOS_COHORTS";
            if (this.ivQual == 2) {
                target.add(String.valueOf(this.ivNOT ? " NOT " : "") + col + " = \"\"");
            } else if (this.ivQual == 1) {
                target.add(String.valueOf(this.ivNOT ? " NOT " : "") + col + " != \"\"");
            } else if (this.ivQual == 3 && this.ivVal != null) {
                target.add(String.valueOf(this.ivNOT ? " NOT " : "") + col + " LIKE '%|" + this.ivVal + "|%'");
            } else if (this.ivQual == 14 && this.ivVal != null) {
                target.add(String.valueOf(this.ivNOT ? "" : " NOT ") + col + " LIKE '%|" + this.ivVal + "|%'");
            }
        }

        public boolean checkWithIndex(Long id, String index) {
            return !DataLayer.USE_DB;
        }

        public boolean afterIndexCheckNecessary() {
            return !DataLayer.USE_DB;
        }

        public boolean iiMatch(Object co) {
            return this.iiMatch((long[])co);
        }

        public Object getComparableObject(Object primaryObject) {
            return this.getComparableObject(primaryObject, "MOS_COHORTS");
        }

        public String getTitle() {
            return Babel.get("FS_M_COHORT");
        }

        public String getDescription() {
            return Babel.get("FS_M_COHORT");
        }
    }

    public static class SearcherEinzeltierBeurteilung
    extends SearcherSymptomList {
        protected long getExpID() {
            return -45L;
        }

        protected String getBabel() {
            return "TASK_TS_EVAL_D1_BEURTEILUNG_EINZELTIER";
        }
    }

    public static class SearcherEmbryoTransfer
    extends MausoSearcherDate {
        private String[] ivIDArr = SearcherSymptomList.getIDArr(-46L);
        private static Vector cvNames = null;
        private static Vector cvValues = null;
        private static Vector cvIDObjects = null;
        private static JPanel cvSubLinePanel = null;
        private static JComboBox cvLinesCombo = null;
        public long ivLineID = -1L;

        public SearcherEmbryoTransfer() {
            if (ProcessDefinition.isClient() && cvNames == null) {
                cvIDObjects = ObjectStore.getActualObjects(7, UserManager.getFirstGroup());
                Collections.sort(cvIDObjects);
                cvNames = new Vector();
                cvValues = new Vector();
                Iterator iter = cvIDObjects.iterator();
                while (iter.hasNext()) {
                    IDObject ido = (IDObject)iter.next();
                    cvNames.add(" " + ido.getBrowseNameInclServicePrefix() + " ");
                    cvValues.add(ido.getLongID());
                }
                cvIDObjects.insertElementAt(NULLObject.INSTANCE, 0);
                cvNames.insertElementAt("", 0);
                cvValues.insertElementAt(new Long(-1L), 0);
                cvSubLinePanel = new JPanel(new BorderLayout(UIDef.INNER_RAND, UIDef.INNER_RAND));
                cvSubLinePanel.setOpaque(false);
                cvSubLinePanel.add("West", new JLabel(Babel.get("FS_M_LINE")));
                cvLinesCombo = new JComboBox(cvNames);
                cvSubLinePanel.add("Center", cvLinesCombo);
            }
        }

        public int[] getPossibleQuals() {
            return DATE_QUALS;
        }

        public void getValXML(StringBuilder msb) {
            super.getValXML(msb);
            if (this.ivLineID != -1L) {
                msb.append(" ").append("thirdval").append("=\"").append(this.ivLineID).append("\"");
            }
        }

        public void iInit(XMLNode node) {
            super.iInit(node);
            String thirdVal = node.getAttributeValue("thirdval", null);
            if (thirdVal != null) {
                this.ivLineID = Long.parseLong(thirdVal);
            }
        }

        public JComponent[] getDialogComponent() {
            JComponent[] carr = null;
            if (this.needsTwoObjects()) {
                carr = new JComponent[]{MausoSearcherDate.cvFirstSelector, MausoSearcherDate.cvSecondSelector};
            } else if (this.needsObject()) {
                carr = new JComponent[]{MausoSearcherDate.cvFirstSelector};
            }
            return carr;
        }

        public void fillComponents(JComponent[] carr) {
            super.fillComponents(carr);
            int selInd = 0;
            if (this.ivLineID != -1L && cvIDObjects.size() > 1) {
                int i = 1;
                while (i < cvIDObjects.size() && selInd == 0) {
                    Line line = (Line)cvIDObjects.elementAt(i);
                    if (line.getID() == this.ivLineID) {
                        selInd = i;
                    }
                    ++i;
                }
            }
            cvLinesCombo.setSelectedIndex(selInd);
        }

        public void fillSubLineTarget(Vector subLineTarget) {
            if (this.ivQual != 0 && this.ivQual != 2) {
                subLineTarget.add(cvSubLinePanel);
            }
        }

        public void fillFromComponents(JComponent[] carr) {
            Line line;
            super.fillFromComponents(carr);
            this.ivLineID = -1L;
            if (this.ivQual != 0 && this.ivQual != 2 && cvLinesCombo != null && cvLinesCombo.getSelectedIndex() > 0 && (line = (Line)cvIDObjects.elementAt(cvLinesCombo.getSelectedIndex())) != null) {
                this.ivLineID = line.getID();
            }
        }

        public String getTableTitle() {
            if (this.ivLineID != -1L) {
                StringBuilder msb = new StringBuilder();
                msb.append(Babel.get("EMBRYO_TRANSFER")).append(" (");
                Line line = (Line)ObjectStore.getClientObject(7, this.ivLineID, UserManager.getFirstGroup());
                if (line != null) {
                    msb.append(line.getBrowseNameInclServicePrefix());
                } else {
                    msb.append("?");
                }
                msb.append(")");
                return msb.toString();
            }
            return this.getTitle();
        }

        public String getTitle() {
            return Babel.get("EMBRYO_TRANSFER");
        }

        public String[] getQualBabels() {
            return SPECIAL_DATE_QUAL_BABELS;
        }

        public Object getComparableObject(Object primaryObject) {
            if (primaryObject instanceof Mouse) {
                Mouse mouse = (Mouse)primaryObject;
                return mouse.get("MOS_MRESULTS");
            }
            if (primaryObject instanceof HashMap) {
                HashMap hm = (HashMap)primaryObject;
                return hm.get("MOS_MRESULTS");
            }
            return null;
        }

        public int iMatch(Object comparableObject, Object originalObject) {
            if (comparableObject == null) {
                return this.ivQual == 2 ? 1 : 2;
            }
            Vector v = (Vector)comparableObject;
            Iterator iter = v.iterator();
            while (iter.hasNext()) {
                MResult mresult = (MResult)iter.next();
                if (-46L != mresult.getExperimentID() || !this.passtLinie(mresult)) continue;
                if (this.ivQual == 1) {
                    return 1;
                }
                if (this.ivVal == null) {
                    return 3;
                }
                if (this.needsTwoObjects() && this.ivSecondVal == null) {
                    return 3;
                }
                if (this.iiMatch(mresult.ivDate) != 1) continue;
                return 1;
            }
            return 2;
        }

        private boolean passtLinie(MResult mresult) {
            if (this.ivLineID == -1L) {
                return true;
            }
            String rep = (String)mresult.ivResult;
            if (rep != null && rep.length() != 0) {
                MResEmbryoTransfer embTr = new MResEmbryoTransfer(rep);
                if (embTr.ivLineID == this.ivLineID) {
                    return true;
                }
            }
            return false;
        }

        public String getDescription() {
            return null;
        }

        public void addWheres(Vector target, Vector columns) {
            String col = "IDX_RESULTS";
            if (this.ivQual == 2 && this.ivVal != null) {
                target.add(String.valueOf(this.ivNOT ? "" : " NOT ") + col + " LIKE '%|" + -46L + "|%'");
            } else if (this.ivQual == 1 && this.ivVal != null) {
                target.add(String.valueOf(this.ivNOT ? " NOT " : "") + col + " LIKE '%|" + -46L + "|%'");
            }
            if (ArrayHelper.findIndexInArray(this.ivQual, ONLY_SET_QUALS) == -1 || this.ivLineID != -1L) {
                columns.add("MOS_MRESULTS");
                columns.add("MOS_LINEID");
            }
        }

        public boolean checkWithIndex(Long id, String index) {
            return this.makeRes(this.indexIMatch(ZeileAbstr.getStringNONEmpty(index, IntermediaerHelfer.getIndexSeparator(), IntermediaerHelfer.getResultsCol(), null)));
        }

        private int indexIMatch(String cont) {
            if (this.ivQual == 2) {
                boolean tres = cont == null || !SearcherSymptomList.matchArr(cont, this.ivIDArr);
                return tres ? 1 : 2;
            }
            if (this.ivQual == 1 || ArrayHelper.findIndexInArray(this.ivQual, this.getPossibleQuals()) != -1) {
                boolean tres = cont != null && SearcherSymptomList.matchArr(cont, this.ivIDArr);
                return tres ? 1 : 2;
            }
            return 3;
        }

        public boolean afterIndexCheckNecessary() {
            return ArrayHelper.findIndexInArray(this.ivQual, ONLY_SET_QUALS) == -1 || this.ivLineID != -1L;
        }
    }

    public static class SearcherLicense
    extends MausoSearcherIDObject {
        private transient String ivLicenseString = null;
        private transient String ivLicenseVString = null;
        private transient String ivLicenseHString = null;
        private transient String ivLicenseMString = null;

        public SearcherLicense() {
            if (ProcessDefinition.isClient()) {
                this.init(LicenseManager.cvInstance.getActualObjectVector(UserManager.getFirstGroup(), false, true), false);
            }
        }

        public void addWheres(Vector target, Vector columns) {
        }

        public boolean checkWithIndex(Long id, String index) {
            if (this.ivLicenseString == null) {
                this.ivLicenseString = "" + this.ivVal;
                this.ivLicenseVString = this.ivVal + "|";
                this.ivLicenseMString = "|" + this.ivVal + "|";
                this.ivLicenseHString = "|" + this.ivVal;
            }
            return this.makeRes(this.indexIMatch(ZeileAbstr.getStringNONEmpty(index, IntermediaerHelfer.getIndexSeparator(), IntermediaerHelfer.getLicenseCol(), null), this.ivLicenseString, this.ivLicenseVString, this.ivLicenseMString, this.ivLicenseHString));
        }

        public boolean afterIndexCheckNecessary() {
            return false;
        }

        public boolean iiMatch(Object co) {
            if (co != null && this.ivVal instanceof Long) {
                long myVal = (Long)this.ivVal;
                long[] arr = (long[])co;
                int i = 0;
                while (i < arr.length) {
                    if (arr[i] == myVal) {
                        return true;
                    }
                    ++i;
                }
            }
            return false;
        }

        public Object getComparableObject(Object primaryObject) {
            Long lic1 = (Long)this.getComparableObject(primaryObject, "MOS_LICID");
            Long lic2 = (Long)this.getComparableObject(primaryObject, "MOS_LICID2");
            Long lic3 = (Long)this.getComparableObject(primaryObject, "MOS_LINLICID");
            if (lic1 != null && lic2 != null && lic2 != null) {
                return new long[]{lic1, lic2, lic3};
            }
            if (lic1 != null && lic2 != null) {
                return new long[]{lic1, lic2};
            }
            if (lic1 != null && lic3 != null) {
                return new long[]{lic1, lic3};
            }
            if (lic2 != null && lic3 != null) {
                return new long[]{lic2, lic3};
            }
            if (lic1 != null) {
                return new long[]{lic1};
            }
            if (lic2 != null) {
                return new long[]{lic2};
            }
            if (lic2 != null) {
                return new long[]{lic3};
            }
            return null;
        }

        public String getTitle() {
            return Babel.get("FS_M_LICENSE");
        }

        public String getDescription() {
            return Babel.get("FS_M_LICENSE");
        }
    }

    public static class SearcherLine
    extends MausoSearcherIDObject {
        public SearcherLine() {
            if (ProcessDefinition.isClient()) {
                this.init(LineManager.cvInstance.getActualObjectVector(UserManager.getFirstGroup(), false, true), true);
            }
        }

        public boolean checkWithIndex(Long id, String index) {
            long lineID = ZeileAbstr.getLong(index, IntermediaerHelfer.getIndexSeparator(), IntermediaerHelfer.getLineCol(), -1L, -1L);
            return this.makeRes(this.iMatch(lineID == -1L ? null : new Long(lineID), null));
        }

        public void addWheres(Vector target, Vector columns) {
            String col = "MOS_LINEID";
            if (this.ivQual == 2) {
                target.add(String.valueOf(this.ivNOT ? " NOT " : "") + col + " = \"\"");
            } else if (this.ivQual == 1) {
                target.add(String.valueOf(this.ivNOT ? " NOT " : "") + col + " != \"\"");
            } else if (this.ivQual == 3 && this.ivVal != null) {
                target.add(String.valueOf(this.ivNOT ? " NOT " : "") + col + " = " + this.ivVal);
            } else if (this.ivQual == 14 && this.ivVal != null) {
                target.add(String.valueOf(this.ivNOT ? "" : " NOT ") + col + " = " + this.ivVal);
            }
        }

        public boolean afterIndexCheckNecessary() {
            return false;
        }

        public boolean iiMatch(Object co) {
            return co.equals(this.ivVal);
        }

        public Object getComparableObject(Object primaryObject) {
            return this.getComparableObject(primaryObject, "MOS_LINEID");
        }

        public String getTitle() {
            return Babel.get("FS_M_LINE");
        }

        public String getDescription() {
            return Babel.get("FS_M_LINE");
        }
    }

    public static class SearcherOwner
    extends MausoSearcherIDObject {
        public SearcherOwner() {
            if (ProcessDefinition.isClient()) {
                this.init(UserManager.cvInstance.getActualObjectVector(UserManager.getFirstGroup(), false, true), true);
            }
        }

        public void addWheres(Vector target, Vector columns) {
            String col = "MOS_OWNER";
            if (this.ivQual == 2) {
                target.add(String.valueOf(this.ivNOT ? " NOT " : "") + col + " = \"\"");
            } else if (this.ivQual == 1) {
                target.add(String.valueOf(this.ivNOT ? " NOT " : "") + col + " != \"\"");
            } else if (this.ivQual == 3 && this.ivVal != null) {
                target.add(String.valueOf(this.ivNOT ? " NOT " : "") + col + " LIKE '%|" + this.ivVal + "|%'");
            } else if (this.ivQual == 14 && this.ivVal != null) {
                target.add(String.valueOf(this.ivNOT ? "" : " NOT ") + col + " LIKE '%|" + this.ivVal + "|%'");
            }
        }

        public boolean checkWithIndex(Long id, String index) {
            return true;
        }

        public boolean afterIndexCheckNecessary() {
            return !DataLayer.USE_DB;
        }

        public boolean iiMatch(Object co) {
            return this.iiMatch((long[])co);
        }

        public Object getComparableObject(Object primaryObject) {
            return this.getComparableObject(primaryObject, "MOS_OWNER");
        }

        public String getTitle() {
            return Babel.get("FS_M_OWNER");
        }

        public String getDescription() {
            return Babel.get("FS_M_OWNER");
        }
    }

    public static class SearcherResult
    extends MausoSearcherIDObject {
        private transient Object ivSpecificator = null;
        private transient Experiment ivExperiment = null;
        private transient String ivExpString = null;
        private transient String ivExpVString = null;
        private transient String ivExpMString = null;
        private transient String ivExpHString = null;

        public SearcherResult() {
            if (ProcessDefinition.isClient()) {
                Vector v = new Vector();
                ExperimentManager.cvInstance.addActualObjectVector(v, UserManager.getFirstGroup(), false, true);
                if (!UserManager.getFirstGroup().equals("service")) {
                    ExperimentManager.cvInstance.addActualObjectVector(v, "service", false, true);
                }
                this.init(v, false);
                if (this.ivCompArr != null && this.ivCompArr[0] != null) {
                    this.ivCompArr[0] = new ExpSearchPanel((JComboBox)this.ivCompArr[0], this.ivIDObjects);
                }
            }
        }

        public void addWheres(Vector target, Vector columns) {
            String col = "IDX_RESULTS";
            if (this.ivQual == 2) {
                target.add(String.valueOf(this.ivNOT ? " NOT " : "") + col + " = \"\"");
            } else if (this.ivQual == 1) {
                target.add(String.valueOf(this.ivNOT ? " NOT " : "") + col + " != \"\"");
            } else if (this.ivQual == 3 && this.ivVal != null) {
                target.add(String.valueOf(this.ivNOT ? " NOT " : "") + col + " LIKE '%|" + this.ivVal + "|%'");
            } else if (this.ivQual == 14 && this.ivVal != null) {
                target.add(String.valueOf(this.ivNOT ? "" : " NOT ") + col + " LIKE '%|" + this.ivVal + "|%'");
            }
        }

        public boolean checkWithIndex(Long id, String index) {
            if (this.ivExpString == null) {
                this.ivExpString = "" + this.ivVal;
                this.ivExpVString = this.ivVal + "|";
                this.ivExpMString = "|" + this.ivVal + "|";
                this.ivExpHString = "|" + this.ivVal;
            }
            return this.makeRes(this.indexIMatch(ZeileAbstr.getStringNONEmpty(index, IntermediaerHelfer.getIndexSeparator(), IntermediaerHelfer.getResultsCol(), null)));
        }

        private int indexIMatch(String cont) {
            if (this.ivQual == 2) {
                return cont == null ? 1 : 2;
            }
            if (this.ivQual == 1) {
                return cont != null ? 1 : 2;
            }
            if (this.ivVal == null || cont == null) {
                return 3;
            }
            boolean res = false;
            if (cont != null) {
                boolean bl = res = cont.equals(this.ivExpString) || cont.startsWith(this.ivExpVString) || cont.endsWith(this.ivExpHString) || cont.contains(this.ivExpMString);
            }
            if (this.ivQual == 3) {
                return res ? 1 : 2;
            }
            if (this.ivQual == 14) {
                return !res ? 1 : 2;
            }
            if (this.ivSpecificator != null) {
                return 1;
            }
            return 3;
        }

        public boolean afterIndexCheckNecessary() {
            return !DataLayer.USE_DB && this.ivSpecificator != null;
        }

        public void getValXML(StringBuilder msb) {
            super.getValXML(msb);
            if (this.ivSpecificator != null) {
                msb.append(" ").append("secondval").append("=\"").append(IDObjectXMLHandler.getTransport(this.ivSpecificator, true, true)).append("\"");
            }
        }

        public void iInit(XMLNode node) {
            super.iInit(node);
            String val = node.getAttributeValue("secondval", null);
            if (val != null) {
                this.ivSpecificator = IDObjectXMLHandler.getObject(val, null, true);
            }
        }

        public int[] getPossibleQuals() {
            return ONLY_EQUALS;
        }

        public int iMatch(Object comparableObject, Object originalObject) {
            if (this.ivQual == 3 && comparableObject instanceof Boolean) {
                Boolean booli = (Boolean)comparableObject;
                return booli != false ? 1 : 2;
            }
            return 3;
        }

        public boolean iiMatch(Object co) {
            return false;
        }

        public String getQualString(int qual) {
            if (qual == 3) {
                return Babel.get("SD_QUAL_FOR_EXPERIMENT");
            }
            return super.getQualString(qual);
        }

        public Object getComparableObject(Object primaryObject) {
            if (primaryObject instanceof Mouse) {
                Mouse mouse = (Mouse)primaryObject;
                long expID = (Long)this.ivVal;
                if (ProcessDefinition.isClient()) {
                    Vector v;
                    if (this.ivSpecificator != null && this.ivExperiment == null) {
                        this.ivExperiment = Experiment.getExperiment(expID, mouse.getGroup());
                        if (this.ivSpecificator instanceof String && this.ivExperiment != null && this.ivExperiment.getInt("EXP_TYPE", -1) != 4) {
                            this.ivSpecificator = ((String)this.ivSpecificator).toLowerCase().trim();
                        }
                    }
                    if ((v = (Vector)mouse.get("MOS_MRESULTS")) != null) {
                        Iterator iter = v.iterator();
                        while (iter.hasNext()) {
                            MResult mresult = (MResult)iter.next();
                            if (expID != mresult.getExperimentID()) continue;
                            if (this.ivSpecificator != null) {
                                if (!mresult.searchMatch(this.ivSpecificator, this.ivExperiment != null ? this.ivExperiment.getInt("EXP_TYPE", -1) : -1)) continue;
                                return true;
                            }
                            return true;
                        }
                    }
                    return false;
                }
                if (this.ivVal != null) {
                    Vector v;
                    if (this.ivSpecificator != null && this.ivExperiment == null) {
                        this.ivExperiment = Experiment.getExperiment(expID, mouse.getGroup());
                        if (this.ivSpecificator instanceof String && this.ivExperiment != null && this.ivExperiment.getInt("EXP_TYPE", -1) != 4) {
                            this.ivSpecificator = ((String)this.ivSpecificator).toLowerCase().trim();
                        }
                    }
                    if ((v = (Vector)mouse.get("MOS_MRESULTS")) != null) {
                        Iterator iter = v.iterator();
                        while (iter.hasNext()) {
                            MResult mresult = (MResult)iter.next();
                            if (expID != mresult.getExperimentID()) continue;
                            if (this.ivSpecificator != null) {
                                if (!mresult.searchMatch(this.ivSpecificator, this.ivExperiment != null ? this.ivExperiment.getInt("EXP_TYPE", -1) : -1)) continue;
                                return true;
                            }
                            return true;
                        }
                    }
                }
            }
            return null;
        }

        public String getTitle() {
            return Babel.get("SD_RESULT");
        }

        public String getDescription() {
            return Babel.get("SD_RESULT");
        }

        public void fillFromComponents(JComponent[] carr) {
            this.ivVal = null;
            this.ivSpecificator = null;
            if (carr != null && carr.length >= 1 && carr[0] instanceof ExpSearchPanel) {
                ExpSearchPanel esp = (ExpSearchPanel)carr[0];
                this.ivVal = esp.getExpID();
                this.ivSpecificator = esp.getSpecificator();
            }
        }

        public void fillComponents(JComponent[] carr) {
            int sel;
            if (carr != null && carr.length >= 1 && carr[0] instanceof ExpSearchPanel && this.ivVal != null && (sel = this.ivValues.indexOf(this.ivVal)) != -1) {
                ExpSearchPanel esp = (ExpSearchPanel)carr[0];
                esp.adapt(sel, this.ivSpecificator);
            }
        }

        public String getValueDisplay() {
            if (this.needsObject() && this.ivVal != null) {
                String name = "";
                int sel = this.ivValues.indexOf(this.ivVal);
                if (sel != -1) {
                    name = "\"" + ((String)this.ivNames.elementAt(sel)).trim() + "\"";
                    if (this.ivSpecificator != null) {
                        return String.valueOf(name) + " " + Babel.get("SD_IS") + " [" + ExpSearchPanel.getRepresentation(this.ivSpecificator) + "]";
                    }
                    return name;
                }
            }
            return "";
        }
    }

    public static class SearcherStrain
    extends MausoSearcherIDObject {
        private transient String ivStrainString = null;
        private transient String ivStrainVString = null;
        private transient String ivStrainHString = null;
        private transient String ivStrainMString = null;

        public SearcherStrain() {
            if (ProcessDefinition.isClient()) {
                this.init(StrainManager.cvInstance.getActualObjectVector(UserManager.getFirstGroup(), false, true), true);
            }
        }

        public void addWheres(Vector target, Vector columns) {
            String col = "IDX_STRAINS";
            if (this.ivQual == 2) {
                target.add(String.valueOf(this.ivNOT ? " NOT " : "") + col + " = \"\"");
            } else if (this.ivQual == 1) {
                target.add(String.valueOf(this.ivNOT ? " NOT " : "") + col + " != \"\"");
            } else if (this.ivQual == 3 && this.ivVal != null) {
                target.add(String.valueOf(this.ivNOT ? " NOT " : "") + col + " LIKE '%|" + this.ivVal + "|%'");
            } else if (this.ivQual == 14 && this.ivVal != null) {
                target.add(String.valueOf(this.ivNOT ? "" : " NOT ") + col + " LIKE '%|" + this.ivVal + "|%'");
            }
        }

        public boolean checkWithIndex(Long id, String index) {
            if (this.ivStrainString == null) {
                this.ivStrainString = "" + this.ivVal;
                this.ivStrainVString = this.ivVal + "|";
                this.ivStrainMString = "|" + this.ivVal + "|";
                this.ivStrainHString = "|" + this.ivVal;
            }
            return this.makeRes(this.indexIMatch(ZeileAbstr.getStringNONEmpty(index, IntermediaerHelfer.getIndexSeparator(), IntermediaerHelfer.getStrainsCol(), null), this.ivStrainString, this.ivStrainVString, this.ivStrainMString, this.ivStrainHString));
        }

        public boolean afterIndexCheckNecessary() {
            return false;
        }

        public boolean iiMatch(Object co) {
            long cval = (Long)this.ivVal;
            IndexObject[] arr = (IndexObject[])co;
            int i = 0;
            while (i < arr.length) {
                if (arr[i].ivObjectID == cval) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        public Object getComparableObject(Object primaryObject) {
            return this.getComparableObject(primaryObject, "MOS_STRAIN");
        }

        public String getTitle() {
            return Babel.get("FS_M_STRAIN");
        }

        public String getDescription() {
            return Babel.get("FS_M_STRAIN");
        }
    }

    public static class SearcherSymptomList
    extends MausoSearcherIDObject {
        private String[] ivIDArr = SearcherSymptomList.getIDArr(this.getExpID());

        protected static String[] getIDArr(long l) {
            return new String[]{String.valueOf(l), String.valueOf(l) + "|", "|" + l + "|", "|" + l};
        }

        protected static boolean matchArr(String cont, String[] arr) {
            return cont.equals(arr[0]) || cont.startsWith(arr[1]) || cont.contains(arr[2]) || cont.endsWith(arr[3]);
        }

        public SearcherSymptomList() {
            ProcessDefinition.isClient();
        }

        public void addWheres(Vector target, Vector columns) {
            String col = "IDX_RESULTS";
            if (this.ivQual == 1) {
                target.add(String.valueOf(this.ivNOT ? " NOT " : "") + col + " LIKE '%|" + -42L + "|%'");
            } else if (this.ivQual == 2) {
                target.add(String.valueOf(this.ivNOT ? "" : " NOT ") + col + " LIKE '%|" + -42L + "|%'");
            }
        }

        public boolean checkWithIndex(Long id, String index) {
            return this.makeRes(this.indexIMatch(ZeileAbstr.getStringNONEmpty(index, IntermediaerHelfer.getIndexSeparator(), IntermediaerHelfer.getResultsCol(), null), this.ivIDArr));
        }

        protected long getExpID() {
            return -42L;
        }

        private int indexIMatch(String cont, String[] idarr) {
            if (this.ivQual == 2) {
                boolean tres = cont == null || !SearcherSymptomList.matchArr(cont, idarr);
                return tres ? 1 : 2;
            }
            if (this.ivQual == 1) {
                boolean tres = cont != null && SearcherSymptomList.matchArr(cont, idarr);
                return tres ? 1 : 2;
            }
            return 3;
        }

        public boolean afterIndexCheckNecessary() {
            return false;
        }

        public int[] getPossibleQuals() {
            return ONLY_SET_QUALS;
        }

        public Object getComparableObject(Object primaryObject) {
            if (primaryObject instanceof Mouse) {
                Mouse mouse = (Mouse)primaryObject;
                long expID = this.getExpID();
                if (ProcessDefinition.isClient()) {
                    Vector v = (Vector)mouse.get("MOS_MRESULTS");
                    if (v != null) {
                        Iterator iter = v.iterator();
                        while (iter.hasNext()) {
                            MResult mresult = (MResult)iter.next();
                            if (expID != mresult.getExperimentID()) continue;
                            return true;
                        }
                    }
                    return false;
                }
            } else if (primaryObject instanceof HashMap) {
                HashMap mouse = (HashMap)primaryObject;
                long expID = this.getExpID();
                if (ProcessDefinition.isClient()) {
                    Vector v = (Vector)mouse.get("MOS_MRESULTS");
                    if (v != null) {
                        Iterator iter = v.iterator();
                        while (iter.hasNext()) {
                            MResult mresult = (MResult)iter.next();
                            if (expID != mresult.getExperimentID()) continue;
                            return true;
                        }
                    }
                    return false;
                }
            }
            return null;
        }

        protected String getBabel() {
            return "CAG_COL_MODE_SYMPTOM";
        }

        public String getTitle() {
            return Babel.get(this.getBabel());
        }

        public String getDescription() {
            return Babel.get(this.getBabel());
        }

        public void fillFromComponents(JComponent[] carr) {
            this.ivVal = null;
        }

        public int iMatch(Object comparableObject, Object originalObject) {
            if (this.ivQual == 2) {
                return !Boolean.valueOf(true).equals(comparableObject) ? 1 : 2;
            }
            if (this.ivQual == 1) {
                return Boolean.valueOf(true).equals(comparableObject) ? 1 : 2;
            }
            return 3;
        }

        public boolean iiMatch(Object co) {
            return false;
        }

        public void fillComponents(JComponent[] carr) {
        }

        public String getValueDisplay() {
            return "";
        }
    }

    public static class SearcherWurfBeurteilung
    extends SearcherSymptomList {
        protected long getExpID() {
            return -43L;
        }

        protected String getBabel() {
            return "TASK_TS_EVAL_D1_WURFBEURTEILUNG";
        }
    }
}

