/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.search.profisearch.searcher;

import de.hannse.netobjects.datalayer.DataLayer;
import de.hannse.netobjects.util.Babel;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import mausoleum.inspector.sensitives.CSMark;
import mausoleum.search.profisearch.basic.SDSearcher;
import mausoleum.search.profisearch.basic.SDSearcherSTRING;
import mausoleum.search.profisearch.display.MausoleumSearcher;

public abstract class MausoSearcherString
extends SDSearcherSTRING {
    public static void init() {
        SDSearcher.register(new SearcherComment());
        SDSearcher.register(new SearcherANTag());
        SDSearcher.register(new SearcherMark());
        SDSearcher.register(new SearcherEarTagPrefix());
    }

    public void fillComponents(JComponent[] carr) {
        if (carr != null && carr.length != 0 && carr[0] instanceof JTextComponent) {
            JTextComponent tf = (JTextComponent)carr[0];
            if (this.ivVal != null) {
                tf.setText(this.ivVal.toString());
            }
        }
    }

    public void fillFromComponents(JComponent[] carr) {
        this.ivVal = null;
        if (carr != null && carr.length >= 1) {
            this.ivVal = ((JTextComponent)carr[0]).getText().trim();
            if (this.ivVal.length() == 0) {
                this.ivVal = null;
            }
        }
    }

    public JComponent[] getDialogComponent() {
        if (this.needsObject()) {
            JComponent[] carr = new JComponent[]{MausoleumSearcher.getDialogComponentString()};
            if (this.ivVal != null) {
                ((JTextField)carr[0]).setText(this.ivVal);
            }
            return carr;
        }
        return null;
    }

    public String getValueDisplay() {
        if (this.ivVal != null) {
            return "\"" + this.ivVal + "\"";
        }
        return "";
    }

    public static class SearcherANTag
    extends MausoSearcherString {
        public boolean checkWithIndex(Long id, String index) {
            return true;
        }

        public boolean afterIndexCheckNecessary() {
            return !DataLayer.USE_DB;
        }

        public void addWheres(Vector target, Vector columns) {
            this.addWheres(target, "MOS_ANTAG");
        }

        public Object getComparableObject(Object primaryObject) {
            return this.getComparableObject(primaryObject, "MOS_ANTAG");
        }

        public String getTitle() {
            return Babel.get("FS_AN_TAG");
        }

        public String getDescription() {
            return Babel.get("FS_AN_TAG");
        }
    }

    public static class SearcherComment
    extends MausoSearcherString {
        public boolean checkWithIndex(Long id, String index) {
            return true;
        }

        public boolean afterIndexCheckNecessary() {
            return !DataLayer.USE_DB;
        }

        public void addWheres(Vector target, Vector columns) {
            this.addWheres(target, "MOS_COMMENT");
        }

        public Object getComparableObject(Object primaryObject) {
            return this.getComparableObject(primaryObject, "MOS_COMMENT");
        }

        public String getTitle() {
            return Babel.get("FS_COMMENT");
        }

        public String getDescription() {
            return Babel.get("FS_COMMENT");
        }
    }

    public static class SearcherEarTagPrefix
    extends MausoSearcherString {
        public boolean checkWithIndex(Long id, String index) {
            return true;
        }

        public boolean afterIndexCheckNecessary() {
            return !DataLayer.USE_DB;
        }

        public void addWheres(Vector target, Vector columns) {
            this.addWheres(target, "MOS_ETPF");
        }

        public Object getComparableObject(Object primaryObject) {
            return this.getComparableObject(primaryObject, "MOS_ETPF");
        }

        public String getTitle() {
            return Babel.get("ETR_EARTAG_PREFIX");
        }

        public String getDescription() {
            return Babel.get("ETR_EARTAG_PREFIX");
        }
    }

    public static class SearcherMark
    extends MausoSearcherString {
        public boolean checkWithIndex(Long id, String index) {
            return true;
        }

        public boolean afterIndexCheckNecessary() {
            return !DataLayer.USE_DB;
        }

        public void addWheres(Vector target, Vector columns) {
            this.addWheres(target, "MOS_FLAG");
        }

        public Object getComparableObject(Object primaryObject) {
            Character c = (Character)this.getComparableObject(primaryObject, "MOS_FLAG");
            if (c != null) {
                if (c.charValue() == '\u0001') {
                    return CSMark.MARK_STANDARD_STRING;
                }
                if (c.charValue() == '\u0000') {
                    return this.ivQual == 3 || this.ivQual == 14 ? CSMark.MARK_NOMARK_STRING : null;
                }
                return c.toString();
            }
            return this.ivQual == 3 || this.ivQual == 14 ? CSMark.MARK_NOMARK_STRING : null;
        }

        public JComponent[] getDialogComponent() {
            if (this.needsObject()) {
                JComponent[] carr = new JComponent[]{new JComboBox<String>(CSMark.MARK_CHOICES)};
                return carr;
            }
            return null;
        }

        public void fillComponents(JComponent[] carr) {
            if (carr != null && carr.length != 0 && carr[0] instanceof JComboBox) {
                JComboBox tf = (JComboBox)carr[0];
                int sel = 1;
                if (this.ivVal != null) {
                    if (this.ivVal.equals(CSMark.MARK_NOMARK_STRING)) {
                        sel = 0;
                    } else if (this.ivVal.equals(CSMark.MARK_STANDARD_STRING)) {
                        sel = 1;
                    } else {
                        int i = 0;
                        while (i < CSMark.MARK_CHOICES.length) {
                            if (this.ivVal.equals(CSMark.MARK_CHOICES[i])) {
                                sel = i;
                            }
                            ++i;
                        }
                    }
                }
                tf.setSelectedIndex(sel);
            }
        }

        public void fillFromComponents(JComponent[] carr) {
            this.ivVal = null;
            if (carr != null && carr.length >= 1) {
                JComboBox cb = (JComboBox)carr[0];
                int i = cb.getSelectedIndex();
                switch (i) {
                    case 0: {
                        this.ivVal = CSMark.MARK_NOMARK_STRING;
                        break;
                    }
                    case 1: {
                        this.ivVal = CSMark.MARK_STANDARD_STRING;
                        break;
                    }
                    default: {
                        this.ivVal = CSMark.MARK_CHOICES[i];
                    }
                }
            }
        }

        public String getValueDisplay() {
            if (this.ivVal != null) {
                String s = this.ivVal;
                if (s.length() != 1) {
                    return Babel.get(s);
                }
                return "\u201e" + s + "\u201c";
            }
            return "";
        }

        public String getTitle() {
            return Babel.get("FS_MARK");
        }

        public String getDescription() {
            return Babel.get("FS_MARK");
        }
    }
}

