/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.sonderreports;

import de.hannse.netobjects.objectstore.ObjectRequest;
import de.hannse.netobjects.tools.Base64Manager;
import de.hannse.netobjects.util.Babel;
import de.hannse.netobjects.util.MyDate;
import de.hannse.netobjects.util.RequestManager;
import java.awt.Point;
import java.io.BufferedReader;
import java.io.StringReader;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.TreeSet;
import mausoleum.alert.Alert;
import mausoleum.helper.ClipboardObject;
import mausoleum.helper.DatumFormat;
import mausoleum.helper.NumberFormatter;
import mausoleum.helper.Zeile;
import mausoleum.sonderreports.SonderReportCecad;
import mausoleum.sonderreports.SonderReportCecad2Dialog;

public class SonderReportCecad2 {
    public static int MODE_RACK = 1;
    public static int MODE_ROOM = 2;
    public static int MODE_BUILDING = 3;
    public static int MODE_DAY = 1;
    public static int MODE_WEEK = 2;
    public static int MODE_MONTH = 3;
    public static int MODE_ALL = 1;
    public static int MODE_FILLED = 2;
    public static int MODE_STICHTAG = 1;
    public static int MODE_DURCHSCHNITT = 2;

    public static String getBabel() {
        return "SR_CECAD2";
    }

    public static boolean needsStartAndEnd() {
        return true;
    }

    public static void modeAndDatesSelected(int[] modeAndDates) {
        Integer dateKey = null;
        int[] kwYear = new int[2];
        MyDate md = null;
        TreeSet<String> allGroups = new TreeSet<String>();
        int[] modi = SonderReportCecad2Dialog.getModi();
        if (modi != null) {
            int entityMode = modi[0];
            int timeMode = modi[1];
            int cageMode = modi[2];
            int calcMode = modi[3];
            String res = (String)RequestManager.createSendAndGetObjectIfFinished((byte)84, modeAndDates, "service");
            if (res != null && res.length() != 0) {
                int[] arr1 = null;
                int[] arr2 = null;
                TreeMap valuesByEntity = new TreeMap();
                try {
                    BufferedReader br = new BufferedReader(new StringReader(res));
                    String line = br.readLine();
                    while (line != null) {
                        int day;
                        if (line.length() != 0 && (day = Zeile.getInt(line, arr1 = Zeile.getTrenner(line, '|', '\u0000', arr1), '\u0000', 0, Integer.MIN_VALUE)) != Integer.MIN_VALUE) {
                            if (timeMode == MODE_DAY) {
                                dateKey = new Integer(day);
                            } else if (timeMode == MODE_WEEK) {
                                MyDate.fillKWInfo(day, kwYear);
                                dateKey = new Integer(kwYear[0] * 10000 + kwYear[1]);
                            } else if (timeMode == MODE_MONTH) {
                                md = new MyDate(day);
                                dateKey = new Integer(md.ivMonat * 10000 + md.ivJahr);
                            }
                            int i = 1;
                            while (i < arr1.length) {
                                int ind;
                                String part = Zeile.getString(line, i, null, arr1, '\u0000');
                                if (part != null && part.length() != 0 && (ind = part.indexOf(";")) != -1) {
                                    Point p;
                                    TreeMap<String, Point> groupValuesByRack;
                                    TreeMap dateValuesByGroup;
                                    String qual = part.substring(0, ind);
                                    String zahlen = part.substring(ind + 1, part.length());
                                    int voll = 0;
                                    int leer = 0;
                                    int zind = zahlen.indexOf(",");
                                    if (zind != -1) {
                                        try {
                                            voll = Integer.parseInt(zahlen.substring(0, zind));
                                            leer = Integer.parseInt(zahlen.substring(zind + 1, zahlen.length()));
                                        }
                                        catch (Exception exception) {
                                            // empty catch block
                                        }
                                    }
                                    int anzahl = voll;
                                    if (cageMode == MODE_ALL) {
                                        anzahl += leer;
                                    }
                                    arr2 = Zeile.getTrenner(qual, ' ', '\u0000', arr2);
                                    String group = Zeile.getString(qual, 0, "", arr2, '\u0000');
                                    group = Base64Manager.getDecodedString(group);
                                    allGroups.add(group);
                                    String entity = Zeile.getString(qual, entityMode, "", arr2, '\u0000');
                                    entity = Base64Manager.getDecodedString(entity);
                                    String rack = Zeile.getString(qual, 1, "", arr2, '\u0000');
                                    rack = Base64Manager.getDecodedString(rack);
                                    TreeMap entityValuesByDate = (TreeMap)valuesByEntity.get(entity);
                                    if (entityValuesByDate == null) {
                                        entityValuesByDate = new TreeMap();
                                        valuesByEntity.put(entity, entityValuesByDate);
                                    }
                                    if ((dateValuesByGroup = (TreeMap)entityValuesByDate.get(dateKey)) == null) {
                                        dateValuesByGroup = new TreeMap();
                                        entityValuesByDate.put(dateKey, dateValuesByGroup);
                                    }
                                    if ((groupValuesByRack = (TreeMap<String, Point>)dateValuesByGroup.get(group)) == null) {
                                        groupValuesByRack = new TreeMap<String, Point>();
                                        dateValuesByGroup.put(group, groupValuesByRack);
                                    }
                                    if ((p = (Point)groupValuesByRack.get(rack)) == null) {
                                        p = new Point();
                                        groupValuesByRack.put(rack, p);
                                    }
                                    if (calcMode == MODE_STICHTAG) {
                                        p.x = anzahl;
                                        p.y = 1;
                                    } else if (calcMode == MODE_DURCHSCHNITT) {
                                        p.x += anzahl;
                                        ++p.y;
                                    }
                                }
                                ++i;
                            }
                        }
                        line = br.readLine();
                    }
                }
                catch (Exception br) {
                    // empty catch block
                }
                StringBuilder msb = new StringBuilder();
                Iterator<Object> iterator = valuesByEntity.keySet().iterator();
                while (iterator.hasNext()) {
                    String entityKey = (String)iterator.next();
                    if (entityMode == MODE_RACK) {
                        msb.append(Babel.get("RACK"));
                    } else if (entityMode == MODE_ROOM) {
                        msb.append(Babel.get("ROOM"));
                    } else if (entityMode == MODE_BUILDING) {
                        msb.append(Babel.get("BUILDING"));
                    }
                    msb.append("\t").append(entityKey);
                    Iterator iterator3 = allGroups.iterator();
                    while (iterator3.hasNext()) {
                        String group = (String)iterator3.next();
                        msb.append("\t").append(group);
                    }
                    msb.append("\n");
                    TreeMap entityValuesByDate = (TreeMap)valuesByEntity.get(entityKey);
                    if (entityValuesByDate != null) {
                        Iterator iterator2 = entityValuesByDate.keySet().iterator();
                        while (iterator2.hasNext()) {
                            Integer dateInt = (Integer)iterator2.next();
                            int date = dateInt;
                            TreeMap dateValuesByGroup = (TreeMap)entityValuesByDate.get(dateInt);
                            if (timeMode == MODE_DAY) {
                                msb.append(DatumFormat.getVeryShortDateString(date)).append("\t");
                                msb.append(DatumFormat.weekday(MyDate.getWochentag(date)));
                            } else if (timeMode == MODE_WEEK) {
                                int kw = date / 10000;
                                int year = date - 10000 * kw;
                                msb.append("KW ").append(kw).append("\t");
                                msb.append(year);
                            } else if (timeMode == MODE_MONTH) {
                                int month = date / 10000;
                                int year = date - 10000 * month;
                                msb.append(DatumFormat.monthBig(month - 1)).append("\t");
                                msb.append(year);
                            }
                            Iterator iterator32 = allGroups.iterator();
                            while (iterator32.hasNext()) {
                                String group = (String)iterator32.next();
                                msb.append("\t");
                                double sum = 0.0;
                                TreeMap groupValuesByRack = (TreeMap)dateValuesByGroup.get(group);
                                if (groupValuesByRack != null) {
                                    Iterator iterator4 = groupValuesByRack.values().iterator();
                                    while (iterator4.hasNext()) {
                                        Point p = (Point)iterator4.next();
                                        sum += (double)p.x / (double)p.y;
                                    }
                                }
                                if (sum == 0.0) continue;
                                msb.append(NumberFormatter.formatNumberString(sum, 2));
                            }
                            msb.append("\n");
                        }
                    }
                    msb.append("\n\n");
                }
                iterator = valuesByEntity.values().iterator();
                while (iterator.hasNext()) {
                    TreeMap entityValuesByDate = (TreeMap)iterator.next();
                    Iterator iterator2 = entityValuesByDate.values().iterator();
                    while (iterator2.hasNext()) {
                        TreeMap dateValuesByGroup = (TreeMap)iterator2.next();
                        Iterator iterator3 = dateValuesByGroup.values().iterator();
                        while (iterator3.hasNext()) {
                            TreeMap groupValuesByRack = (TreeMap)iterator3.next();
                            groupValuesByRack.clear();
                        }
                        dateValuesByGroup.clear();
                    }
                    entityValuesByDate.clear();
                }
                valuesByEntity.clear();
                valuesByEntity = null;
                ClipboardObject.manageCopy(null, msb.toString());
                Alert.showAlert(Babel.get("DATAINCLIPBOARD"), true);
            } else {
                Alert.showAlert(Babel.get("NO_DATA_AVAILABLE"), true);
            }
        }
    }

    public static boolean handleRequest(ObjectRequest or) {
        return SonderReportCecad.handleRequest(or, "src2_");
    }
}

