/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.strain;

import de.hannse.netobjects.objectstore.ObjectManager;
import de.hannse.netobjects.objectstore.ObjectRequest;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Vector;
import mausoleum.main.MausoleumClient;
import mausoleum.main.ProcessDefinition;
import mausoleum.mouse.Mouse;
import mausoleum.mouse.MouseManager;
import mausoleum.objectstore.AftermathObject;
import mausoleum.strain.Strain;

public class StrainManager
extends ObjectManager {
    public static StrainManager cvInstance;
    private static final HashMap MATURITYLIMIT_BY_STRAIN_ID;

    static {
        MATURITYLIMIT_BY_STRAIN_ID = new HashMap();
    }

    public static void init() {
        if (ProcessDefinition.isClient()) {
            if (cvInstance == null) {
                cvInstance = new StrainManager();
            }
            Enumeration en = cvInstance.getActualObjectEnumerationAllGroups();
            while (en.hasMoreElements()) {
                Strain strain = (Strain)en.nextElement();
                StrainManager.enterMaturityLimit(strain, MATURITYLIMIT_BY_STRAIN_ID, "STR_MATLIM");
            }
        }
    }

    public static void exit() {
        if (ProcessDefinition.isClient() && cvInstance != null) {
            cvInstance.dispose();
            cvInstance = null;
        }
    }

    public static Integer getMatlimit(Long id, String group) {
        return StrainManager.getMatlimit(id, group, MATURITYLIMIT_BY_STRAIN_ID);
    }

    public static Integer getMatlimit(long id, String group) {
        return id > 0L ? StrainManager.getMatlimit(new Long(id), group, MATURITYLIMIT_BY_STRAIN_ID) : null;
    }

    private StrainManager() {
        super(8);
    }

    public void performObjectInsertionAftermath(ObjectRequest or, Vector sentObjects, AftermathObject aftermathObject) {
        super.performObjectInsertionAftermath(or, sentObjects, aftermathObject);
        if (ProcessDefinition.isClient() && MausoleumClient.cvManagerInitialized && sentObjects != null && !sentObjects.isEmpty() && !MausoleumClient.isHeadOfService()) {
            if (!sentObjects.isEmpty()) {
                long[] ids = new long[sentObjects.size()];
                int i = 0;
                while (i < sentObjects.size()) {
                    Strain strain = (Strain)sentObjects.elementAt(i);
                    ids[i] = strain.getID();
                    StrainManager.enterMaturityLimit(strain, MATURITYLIMIT_BY_STRAIN_ID, "STR_MATLIM");
                    ++i;
                }
                Vector mice = MouseManager.getActualMiceOfStrains(sentObjects);
                int i2 = 0;
                while (i2 < mice.size()) {
                    aftermathObject.addCage(((Mouse)mice.elementAt(i2)).getActCage());
                    ++i2;
                }
            }
            aftermathObject.redrawRackFrame();
        }
    }
}

